#!/bin/bash
#                                                                                       #
# SCRIPT: memcached_service.sh		                                                #
# DATE:   27-Oct-2016                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems								#
# PURPOSE: Contains all the utility functions for memcached Installation                #
# PLATFORM: Ubuntu                                                                      #

PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh
source $PARABLU_COMPONENT_SCRIPT_PATH

#installing memcached
function install_memcached ()
{
	if [ ! -e /etc/memcached.conf ]
	then
		apt-get -y install memcached
		mkdir -p $LOG_PATH/memcache
		mkdir -p $ARCHIVE_PATH/memcache
		mkdir -p $DATA_PATH/memcache

		mkdir -p $LOGROTATEROOTPATH/parablusys
		mkdir -p $LOGROTATEROOTPATH/parablusys
		mkdir -p $LOGROTATEROOTPATH/parablusys/bin

		cp -r  $DEFAULT_FILE_PATH/logrotate/rotate_memcache.sh  $LOGROTATEROOTPATH/parablusys/bin/
		cp -r  $DEFAULT_FILE_PATH/logrotate/memcache.logrotate $LOGROTATE_D_PATH/memcache

		chown -R root:root $LOGROTATEROOTPATH/parablusys/bin/*
		chmod -R 777 $LOGROTATEROOTPATH/parablusys/bin/*
	fi
}

#configure memcached
function configure_memcached ()
{
	sed -i 's|-p 11211|-p 13582|' /etc/memcached.conf
	sed -i "s|/var/log/memcached.log|$LOG_PATH/memcache/memcached.log|" /etc/memcached.conf
}


# check whether memcached is installed in the system
function verify_memcached ()
{

	if [ ! -e /etc/memcached.conf ] 
	then
		echo "memcached Installation failed. Try again after some time"
		exit 0
	else
		echo "memcached Successfully installed"
	fi

}

function uninstall_memcached()
{
	apt-get -y purge memcached
	rm -rf /etc/memcached.conf
	rm -rf $LOG_PATH/memcache
	rm -rf $ARCHIVE_PATH/memcache
	rm -rf $DATA_PATH/memcache
	rm -rf $LOGROTATEROOTPATH/parablusys
        rm -rf $LOGROTATEROOTPATH/parablusys/bin
}


# external function which deploys the tomcat
function release_memcached ()
{
	install_memcached
	configure_memcached
	verify_memcached
}
