#!/bin/bash
#                                                                                       #
# SCRIPT: blukrypt_service.sh		                                                #
# DATE:   27-Oct-2016                                                                   #
# REV:    1.0                                                                           #
# DEVELOPED BY: Parablu Systems								#
# PURPOSE: Contains all the utility functions for blukrypt Installation                 #
# PLATFORM: Ubuntu                                                                      #

TOMCAT_SERVICE_SCRIPT_PATH=./tomcat_service.sh
APACHE_SERVICE_SCRIPT_PATH=./apache_service.sh
#COUCHDB_SERVICE_SCRIPT_PATH=./couch_service.sh
ACTIVEMQ_SERVICE_SCRIPT_PATH=./activemq_service.sh
UBUNTU_SERVICE_SCRIPT_PATH=./ubuntu_service.sh
PARABLU_COMPONENT_SCRIPT_PATH=../config/parablu_component_config.sh
PARABLU_CONFIG_SCRIPT_PATH=../config/parablu_config.sh
source $PARABLU_CONFIG_SCRIPT_PATH
source $PARABLU_COMPONENT_SCRIPT_PATH
source $UBUNTU_SERVICE_SCRIPT_PATH
source $TOMCAT_SERVICE_SCRIPT_PATH
#source $COUCHDB_SERVICE_SCRIPT_PATH
source $APACHE_SERVICE_SCRIPT_PATH
source $ACTIVEMQ_SERVICE_SCRIPT_PATH

# Deploy repo to tomcat
function deploy_blukrypt_repo_to_tomcat () 
{	
	#copy the config file for the path
	if [ ! -e $TOMCAT_PG1_PATH/conf/server.xml ] 
	then
		cp $TOMCAT_PATH/conf/server.xml $TOMCAT_PG1_PATH/conf/
	fi

	if [ ! -e $TOMCAT_PG1_PATH/conf/web.xml ] 
	then
		cp $TOMCAT_PATH/conf/web.xml $TOMCAT_PG1_PATH/conf/
	fi

	if [ ! -e $TOMCAT_PG1_PATH/solr ] 
	then
		cp -r $DEFAULT_FILE_PATH/solr $TOMCAT_PG1_PATH/
	fi
	
	if [[ $FILE_LOCATION == "jenkins" ]]; then
        	wget -P $TOMCAT_PG1_PATH/$PG_REPO_NAME/ $JENKINS_URL/$PG_JAR_URL_PATH
        elif [[ $FILE_LOCATION == "dns" ]]; then
                wget --user $DNS_USERNAME --password $DNS_PASS -O $TOMCAT_PG1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME $DNS_URL/$JOB_JAR_NAME
        elif [[ $FILE_LOCATION == "local" ]]; then
                #will be included in file path once repo is part of patch, so currently downloading from DNS
                 cp $FILE_PATH/$JOB_JAR_NAME $TOMCAT_PG1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME
               # wget --user $DNS_USERNAME --password $DNS_PASS -O $TOMCAT_PG1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME $DNS_URL/$JOB_JAR_NAME
		
	fi

	if [ -e $TOMCAT_PG1_PATH/$PG_REPO_NAME ]; then
	        mkdir -p $BACKUP_OLD/REPO_PCB
       		cp -r $TOMCAT_PG1_PATH/$PG_REPO_NAME  $BACKUP_OLD/REPO_PCB
	fi

	if [ ! -e $TOMCAT_PG1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME ] 
	then
		echo "Invalid PG Repo Jar Name"
		
	fi
	unzip -oqq $TOMCAT_PG1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME -d $TOMCAT_PG1_PATH/$PG_REPO_NAME/
	
	if [[ -d $TOMCAT_PG1_PATH/$PG_REPO_NAME/$PG_REPO_FOLDER_NAME ]]; then
        	mv $TOMCAT_PG1_PATH/$PG_REPO_NAME/$PG_REPO_FOLDER_NAME/* $TOMCAT_PG1_PATH/$PG_REPO_NAME/
        	rm -rf $TOMCAT_PG1_PATH/$PG_REPO_NAME/$PG_REPO_FOLDER_NAME 
        	rm -rf $TOMCAT_PG1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME
	fi

	chown -R tomcat:tomcat $TOMCAT_PG1_PATH
	chmod a+x $TOMCAT_PG1_PATH/conf/server.xml 
	chmod a+x $TOMCAT_PG1_PATH/conf/web.xml

	sed -i "s/port=\"8005\"/port=\"$PORT1\"/" $TOMCAT_PG1_PATH/conf/server.xml
	sed -i "s/port=\"8080\"/port=\"$PORT2\"/" $TOMCAT_PG1_PATH/conf/server.xml
	if [ "`grep -o 'disableUploadTimeout="false" autodeploy="false"' $TOMCAT_PG1_PATH/conf/server.xml | wc -l`" -le 0 ]
        then
	        sed -i "s/connectionTimeout=\"20000\"/connectionTimeout=\"20000\" disableUploadTimeout=\"false\" autodeploy=\"false\"/g" $TOMCAT_PG1_PATH/conf/server.xml
        fi
 	sed -i "s/pathname=\"conf/tomcat-users.xml\"/removeAbandoned=\"true\" logAbandoned=\"true\" removeAbandonedTimeout=\"420\"/" $TOMCAT_PG1_PATH/conf/server.xml
	sed -i "s/port=\"8009\"/port=\"$PORT3\"/" $TOMCAT_PG1_PATH/conf/server.xml
}

#deploy job to tomcat
function deploy_blukrypt_job_repo_to_tomcat ()
{

	#copy the config file for the path

	if [ ! -e $TOMCAT_JOB1_PATH/conf/server.xml ] 
	then
		cp $TOMCAT_PATH/conf/server.xml $TOMCAT_JOB1_PATH/conf/
	fi
	
	if [ ! -e $TOMCAT_JOB1_PATH/conf/web.xml ] 
	then
		cp $TOMCAT_PATH/conf/web.xml $TOMCAT_JOB1_PATH/conf/
	fi

	if [[ $FILE_LOCATION == "jenkins" ]]; then
                wget -P $TOMCAT_JOB1_PATH/$PG_REPO_NAME/ $JENKINS_URL/$PG_JAR_URL_PATH
	elif [[ $FILE_LOCATION == "dns" ]]; then
                wget -O --user $DNS_USERNAME --password $DNS_PASS -O $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME $DNS_URL/$JOB_JAR_NAME
    	elif [[ $FILE_LOCATION == "local" ]]; then
                #will be included in file path once repo is part of patch, so currently downloading from DNS
                cp $FILE_PATH/$JOB_JAR_NAME $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME
               # wget --user $DNS_USERNAME --password $DNS_PASS -O $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME $DNS_URL/$JOB_JAR_NAME
		sleep 5
	fi
	
	if [ -e $TOMCAT_JOB1_PATH/$PG_REPO_NAME ]; then
	        mkdir -p $BACKUP_OLD/REPO_PCB_JOB
       		cp $TOMCAT_JOB1_PATH/$PG_REPO_NAME  $BACKUP_OLD/REPO_PCB_JOB
	fi

	if [ ! -e $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME ]
	then
		echo "Invalid PG Job Repo Jar Name"
		
	fi
	unzip -oqq $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME -d $TOMCAT_JOB1_PATH/$PG_REPO_NAME/

	mv $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$PG_REPO_FOLDER_NAME/* $TOMCAT_JOB1_PATH/$PG_REPO_NAME/
	rm -rf  $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$PG_REPO_FOLDER_NAME
	rm -rf  $TOMCAT_JOB1_PATH/$PG_REPO_NAME/$JOB_JAR_NAME

	chown -R tomcat:tomcat $TOMCAT_JOB1_PATH
	chmod a+x $TOMCAT_JOB1_PATH/conf/server.xml 
	chmod a+x $TOMCAT_JOB1_PATH/conf/web.xml

	sed -i "s/port=\"8005\"/port=\"$JOB_PORT1\"/" $TOMCAT_JOB1_PATH/conf/server.xml
	sed -i "s/port=\"8080\"/port=\"$JOB_PORT2\"/" $TOMCAT_JOB1_PATH/conf/server.xml

	if [ "`grep -o 'disableUploadTimeout="false" autodeploy="false"' $TOMCAT_PG1_PATH/conf/server.xml | wc -l`" -le 0 ]
        then
	        sed -i "s/connectionTimeout=\"20000\"/connectionTimeout=\"20000\" disableUploadTimeout=\"false\" autodeploy=\"false\"/g" $TOMCAT_JOB1_PATH/conf/server.xml
        fi
	sed -i "s/pathname=\"conf/tomcat-users.xml\"/removeAbandoned=\"true\" logAbandoned=\"true\" removeAbandonedTimeout=\"420\"/" $TOMCAT_JOB1_PATH/conf/server.xml
	sed -i "s/port=\"8009\"/port=\"$JOB_PORT3\"/" $TOMCAT_JOB1_PATH/conf/server.xml
}

#blukrypt war to tomcat
function deploy_blukrypt_war_to_tomcat ()
{
	if [[ $FILE_LOCATION == "jenkins" ]]; then
                wget -P $FILE_PATH/ $JENKINS_URL/$BLUKRYPT_BUILDER_WAR_URL
	        wget -P $FILE_PATH/ $JENKINS_URL/$PARACLOUD_SEARCH_WAR_URL
        elif [[ $FILE_LOCATION == "dns" ]]; then
                wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$BLUKRYPT_BUILDER_WAR $DNS_URL/$BLUKRYPT_BUILDER_WAR
		wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$PARACLOUD_SEARCH_WAR $DNS_URL/$PARACLOUD_SEARCH_WAR
        elif [[ $FILE_LOCATION == "local" ]]; then
                echo "Files already extracted from patch"
        fi

	#backing-up old deploy
	if [ -e $TOMCAT_PG1_PATH/webapps/$BLUKRYPT ] && [ -e $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH ]; then
       		cp -r $TOMCAT_PG1_PATH/webapps/$BLUKRYPT  $BACKUP_OLD
		cp -r $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH  $BACKUP_OLD
	fi
	
	# copy download war
	if [ ! -e $FILE_PATH/$BLUKRYPT_BUILDER_WAR ] || [ ! -e $FILE_PATH/$PARACLOUD_SEARCH_WAR ] 
	then
		echo "Builder war or paracloud search war not found"
		
	fi
	echo "file path"$FILE_PATH
	unzip -oqq $FILE_PATH/$BLUKRYPT_BUILDER_WAR -d $TOMCAT_PG1_PATH/webapps/$BLUKRYPT
	unzip -oqq $FILE_PATH/$PARACLOUD_SEARCH_WAR -d $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH
	chown -R tomcat:tomcat $TOMCAT_PG1_PATH/webapps/$BLUKRYPT
	chown -R tomcat:tomcat $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH

}

function deploy_blukrypt_job_war_to_tomcat ()
{

	#backing-up old deploy
#	mkdir -p $BACKUP_OLD
	if [ -e $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB ]; then
       		cp -r $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB  $BACKUP_OLD
	fi 

	if [[ $FILE_LOCATION == "jenkins" ]]; then
               wget -P $FILE_PATH/ $JENKINS_URL/$BLUKRYPT_JOB_WAR_URL
        elif [[ $FILE_LOCATION == "dns" ]]; then
                wget --user $DNS_USERNAME --password $DNS_PASS -O $FILE_PATH/$BLUKRYPT_JOB_WAR $DNS_URL/$BLUKRYPT_JOB_WAR
        elif [[ $FILE_LOCATION == "local" ]]; then
                echo "Files already extracted from patch"
        fi
	
	# copy download war
	if [ ! -e $FILE_PATH/$BLUKRYPT_JOB_WAR ]
	then
		echo "Blukrypt Job war not found"
		
	fi
	unzip -oqq $FILE_PATH/$BLUKRYPT_JOB_WAR -d $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB

}

function set_blukrypt_properties_values ()
{
	
	echo "Executing PG property files value changes....,"
	PROPERTIES_FILE=WEB-INF/classes/privacygateway.properties
	PROPERTIES_FILE_PCB=WEB-INF/classes/pb-credential.properties
	CLOUD_PROPERTY_FILE=WEB-INF/classes/pb-cloudproperty.properties

	chmod -R 777 $TOMCAT_PG1_PATH/webapps/$BLUKRYPT
        chmod -R 777 $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH

	sed -i 's|/mnt|/parablu|' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$CLOUD_PROPERTY_FILE
	sed -i 's|/mnt|/parablu|' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	sed -i "/db_port/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	sed -i "/db_host/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	sed -i "/db_port1/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	sed -i "/db_host1/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	sed -i "/db_port2/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	sed -i "/db_host2/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	sed -i "/db_port3/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	sed -i "/db_host3/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE

	if [ "`grep -o 'db_port' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
		echo "db_port=$MONGODB_PORT" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	fi

	if [ "`grep -o 'db_host' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
      	  	echo "db_host=$DB_IP" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	fi

        #DB1 and PORT1
	if [ "`grep -o 'db_port1' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
        	echo "db_port1=$MONGODB1_PORT" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	fi

	if [ "`grep -o 'db_host1' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
       	 	echo "db_host1=$DB1_IP" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	fi

        #DB2 and PORT2
	if [ "`grep -o 'db_port2' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
       	 	echo "db_port2=$MONGODB2_PORT" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	fi

	if [ "`grep -o 'db_host2' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
        	echo "db_host2=$DB2_IP" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	fi

        #DB3 and PORT3
	if [ "`grep -o 'db_port3' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
        	echo "db_port3=$MONGODB3_PORT" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	fi
	if [ "`grep -o 'db_host3' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
	        echo "db_host3=$DB3_IP" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	fi
	sed -i "/localdbhost=/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	sed -i "/paracloudUrl=/d"  $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	sed -i "/solrUrl=/d"  $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	if [ "`grep -o 'paracloudUrl' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
		echo "paracloudUrl=https://$BLUVAULT_IP" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	fi

	if [ "`grep -o 'localdbhost' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
        	echo "localdbhost=$BLUKRYPT_IP" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	fi

	if [ "`grep -o 'solrUrl' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE | wc -l`" -le 0 ]
        then
        	echo "solrUrl=http://$SOLR_URL/ParacloudSearch/search/" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE	
	fi

	####SOLR
	sed -i "/db_port/d" $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
	sed -i "/db_host/d" $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
	if [ "`grep -o 'db_port' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB | wc -l`" -le 0 ]
        then
		echo "db_port=$MONGODB_PORT" >> $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
	fi

	if [ "`grep -o 'db_host' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB | wc -l`" -le 0 ]
        then
	        echo "db_host=$DB_IP" >> $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$PROPERTIES_FILE_PCB
	fi

	sed -i "/solrUrl/d" $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$CLOUD_PROPERTY_FILE
	echo "solrUrl=$TOMCAT_PG1_PATH/solr" >> $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$CLOUD_PROPERTY_FILE

	if [[ $ENVIRON_MODE = 'Local_B' ]] || [[ $ENVIRON_MODE = 'Local_S' ]] || [[ $ENVIRON_MODE = 'Local_BS' ]] || [[ $ENVIRON_MODE = 'Local_SR' ]]; then
		sed -i "/localStorageEnabled/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		echo "localStorageEnabled=true" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	fi

	if [[ $PROXY_ENABLED = 'y' ]]; then
		sed -i "/proxyHost/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		sed -i "/proxyPort/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		sed -i "/proxyUserName/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		sed -i "/proxyPassword/d" $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		echo "proxyHost=$PROXY_HOSTNAME" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		echo "proxyPort=$PROXY_PORT" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		echo "proxyUserName=$PROXY_A_USERNAME" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
		echo "proxyPassword=$PROXY_A_PASSWD" >> $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$PROPERTIES_FILE
	fi
}


function set_blukrypt_job_property_values ()
{

	echo -e " \n Executing PG-Job_property values  changes....,"
	chmod -R 777 $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB

	######### paths 
	PROPERTIES_FILE=WEB-INF/classes/privacygateway.properties
	SCHEDULER_CONTEXT=WEB-INF/classes/spring-config/scheduler-context.xml

	###### NOTE : Uncomment scheduler context only if it is Sync Enabled setup #########
	#### Pre-Changes

	#remove the tomcat.war before change do the changes
	rm -rf $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB_WAR

	#### StaRt-changes

	sed -i 's|/mnt|/parablu|' $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	sed -i "/db_port/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	sed -i "/db_host/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	sed -i "/db_port1/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	sed -i "/db_host1/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	sed -i "/db_port2/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	sed -i "/db_host2/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	sed -i "/db_port3/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	sed -i "/paracloudUrl=/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	sed -i "/localdbhost=/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	sed -i "/maindbhost=/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE

	echo "db_port=$MONGODB_PORT" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	echo "db_host=$DB_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	#DB1 and PORT1
	echo "db_port1=$MONGODB1_PORT" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	echo "db_host1=$DB1_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	#DB2 and PORT2
	echo "db_port2=$MONGODB2_PORT" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	echo "db_host2=$DB2_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	#DB3 and PORT3
	echo "db_port3=$MONGODB3_PORT" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	echo "db_host3=$DB3_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	echo "paracloudUrl=https://$BLUVAULT_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	echo "localdbhost=$BLUKRYPT_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE

	echo "maindbhost=$DB_IP" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE

	if [[ $ENVIRON_MODE = 'Local_B' ]] || [[ $ENVIRON_MODE = 'Local_S' ]] || [[ $ENVIRON_MODE = 'Local_BS' ]] || [[ $ENVIRON_MODE = 'Local_SR' ]]; then
		sed -i "/localStorageEnabled/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		echo "localStorageEnabled=true" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	fi

	if [[ $PROXY_ENABLED = 'y' ]]; then
		sed -i "/proxyHost/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/proxyPort/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/proxyUserName/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		sed -i "/proxyPassword/d" $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		echo "proxyHost=$PROXY_HOSTNAME" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		echo "proxyPort=$PROXY_PORT" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		echo "proxyUserName=$PROXY_A_USERNAME" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
		echo "proxyPassword=$PROXY_A_PASSWD" >> $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$PROPERTIES_FILE
	fi

}

# Configure to run tomcat as service
function configure_blukrypt_tomcat_service()
{
	#copy the tomcat-blukrypt1 service script into /etc/init.d
	if [ ! -e /etc/init.d/tomcat-pcb1 ] 
	then
		cp $DEFAULT_FILE_PATH/tomcat-pcb1 /etc/init.d/
		chmod a+x /etc/init.d/tomcat-pcb1
		sed -i -e 's/\r//g' /etc/init.d/tomcat-pcb1
	fi

	#copy the tomcat-job1 service script into /etc/init.d
	if [ ! -e /etc/init.d/tomcat-job1 ] 
	then
		cp $DEFAULT_FILE_PATH/tomcat-job1 /etc/init.d/
		chmod a+x /etc/init.d/tomcat-job1
		sed -i -e 's/\r//g' /etc/init.d/tomcat-job1
	fi
}


function verify_blukrypt_components ()
{
	if [ ! -e /etc/logrotate.d/tomcat-job1 ] || [ ! -e /etc/logrotate.d/tomcat-pcb1  ] 
	then
		echo "Blukrypt Installation failed. Try again after some time"
		exit 0
	else
		echo "Blukrypt Successfully installed"
	fi	
}


#create required folder structure
function create_bluklypt_folder_structure ()
{
	mkdir -p $TOMCAT_PG1_PATH
	mkdir -p $TOMCAT_PG1_PATH/conf 
	mkdir -p $TOMCAT_PG1_PATH/logs 
	mkdir -p $TOMCAT_PG1_PATH/temp 
	mkdir -p $TOMCAT_PG1_PATH/webapps 
	mkdir -p $TOMCAT_PG1_PATH/work
	mkdir -p $TOMCAT_PG1_PATH/$PG_REPO_NAME


	mkdir -p $TOMCAT_JOB1_PATH
	mkdir -p $TOMCAT_JOB1_PATH/conf
	mkdir -p $TOMCAT_JOB1_PATH/logs
	mkdir -p $TOMCAT_JOB1_PATH/temp
	mkdir -p $TOMCAT_JOB1_PATH/webapps
	mkdir -p $TOMCAT_JOB1_PATH/work
	mkdir -p $TOMCAT_JOB1_PATH/$PG_REPO_NAME

	mkdir -p $ROOT_PATH/$CLOUD_NAME
	mkdir -p $ROOT_PATH/$CLOUD_NAME/upload
	mkdir -p $ROOT_PATH/$CLOUD_NAME/f
	mkdir -p $ROOT_PATH/$CLOUD_NAME/t
	mkdir -p $ROOT_PATH/$CLOUD_NAME/backup
	mkdir -p $ROOT_PATH/$CLOUD_NAME/sync-upload
	mkdir -p $ROOT_PATH/support
	mkdir -p $ROOT_PATH/backup
	mkdir -p $ROOT_PATH/sync
	mkdir -p $ROOT_PATH/bkpOverview
        mkdir -p $LOG_PATH/tomcat-job1
        mkdir -p $LOG_PATH/tomcat-pcb1
        mkdir -p $ARCHIVE_PATH/tomcat-job1
        mkdir -p $ARCHIVE_PATH/tomcat-pcb1
	mkdir -p $PORTAL_LOG_FOLDER
	mkdir -p $LOGROTATEROOTPATH/parablusys
	mkdir -p $LOGROTATEROOTPATH/parablusys/bin
	mkdir -p $ROOT_PATH/tmp-chunk

	cp $DEFAULT_FILE_PATH/logrotate/rotate_job1.sh  $LOGROTATEROOTPATH/parablusys/bin/
	cp $DEFAULT_FILE_PATH/logrotate/rotate_pcb1.sh $LOGROTATEROOTPATH/parablusys/bin/
	cp $DEFAULT_FILE_PATH/logrotate/tomcat-pcb1.logrotate $LOGROTATE_D_PATH/tomcat-pcb1
	cp $DEFAULT_FILE_PATH/logrotate/tomcat-job1.logrotate $LOGROTATE_D_PATH/tomcat-job1

	chmod -R 775 $ROOT_PATH/support
	chown -R tomcat:parablu $ROOT_PATH/support
	chmod -R 775 $ROOT_PATH/$CLOUD_NAME
	chown -R tomcat:parablu $ROOT_PATH/$CLOUD_NAME
	chmod -R 775 $ROOT_PATH/bkpOverview
	chown -R tomcat:parablu $ROOT_PATH/bkpOverview
	chmod -R 777 $PORTAL_LOG_FOLDER
	chown -R tomcat:parablu $ROOT_PATH/sync
	chown -R tomcat:parablu $ROOT_PATH/backup
	chown -R root:root $LOGROTATEROOTPATH/parablusys/bin/*
	chmod -R 777 $LOGROTATEROOTPATH/parablusys/bin/*
 	chown -R tomcat:parablu $ROOT_PATH/tmp-chunk/
	chmod -R 775 $LOG_PATH
	chown -R tomcat:tomcat $LOG_PATH/tomcat-job1
	chown -R tomcat:tomcat $LOG_PATH/tomcat-pcb1

	mkdir -p $CLIENT_ROOT_PATH/parablusys
	mkdir -p $CLIENT_ROOT_PATH/parablusys/bin
	mkdir -p $CLIENT_ROOT_PATH/parablusys/upgrade
	mkdir -p $CLIENT_ROOT_PATH/parablusys/clients
	mkdir -p $CLIENT_ROOT_PATH/parablusys/conf
	mkdir -p $CLIENT_ROOT_PATH/parablusys/private
	touch $CLIENT_ROOT_PATH/parablusys/conf/google.config.php
	touch $CLIENT_ROOT_PATH/parablusys/conf/mail.config.php
	touch $CLIENT_ROOT_PATH/parablusys/conf/odb.config.php
	touch $CLIENT_ROOT_PATH/parablusys/conf/odc.config.php

	chmod 777 $CLIENT_ROOT_PATH/parablusys/conf/*
}

function configure_blukrypt_in_apache()
{
	sed -i "/$BLUKRYPT/d" /etc/apache2/mods-enabled/jk.conf
	sed -i "85iJkMount /$BLUKRYPT/* balancer" /etc/apache2/mods-enabled/jk.conf
}

#configuring blukrypt
function configure_blukrypt_odb_config ()
{
	if [ ! -e /var/lib/parablusys/conf/odb.config.php ] 
	then
		cp $FILE_PATH/odb.config.php /var/lib/parablusys/conf/odb.config.php
	fi
}

# restarting blukrypt
function stop_blukrypt_components ()
{
	#service couchdb stop
	service activemq stop
	service tomcat-pcb1 stop
	service tomcat-job1 stop
	service apache2 stop
}

# restarting blukrypt
function start_blukrypt_components ()
{
	#service couchdb start
	service activemq start
	service memcached start
	service tomcat-pcb1 start
	service tomcat-job1 start
	service apache2 start
}

# Restarting all the components into init.d
function configure_blukrypt_components_start_service ()
{
	echo " service activmq restart
		service tomcat-pcb1 restart
		service tomcat-job1 restart
		service apache2 restart" > /etc/init.d/PB_autorun.sh

	chmod a+x /etc/init.d/PB_autorun.sh

	sudo update-rc.d PB_autorun.sh defaults
}

function configure_blukrypt_log4j ()
{
        LOG_PROPERTIES_FILE=WEB-INF/classes/log4j.properties
        sed -i 's|DEBUG|INFO|' $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$LOG_PROPERTIES_FILE
        sed -i 's|/mnt|/parablu|' $TOMCAT_JOB1_PATH/webapps/$BLUKRYPT_JOB/$LOG_PROPERTIES_FILE
        sed -i 's|DEBUG|INFO|' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$LOG_PROPERTIES_FILE
        sed -i 's|/mnt|/parablu|' $TOMCAT_PG1_PATH/webapps/$BLUKRYPT/$LOG_PROPERTIES_FILE
	sed -i 's|DEBUG|INFO|' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$LOG_PROPERTIES_FILE
        sed -i 's|/mnt|/parablu|' $TOMCAT_PG1_PATH/webapps/$PARACLOUD_SEARCH/$LOG_PROPERTIES_FILE

}

#deploy components
function deploy_blukrypt_components ()
{
	release_activemq
	release_tomcat
	release_apache
	#release_couchdb
	configure_blukrypt_tomcat_service
	create_bluklypt_folder_structure
	stop_blukrypt_components
	deploy_blukrypt_repo_to_tomcat
	deploy_blukrypt_job_repo_to_tomcat
	deploy_blukrypt_war_to_tomcat
	deploy_blukrypt_job_war_to_tomcat
}

#Config components
function config_blukrypt_components ()
{
	set_blukrypt_properties_values
        set_blukrypt_job_property_values
	configure_blukrypt_in_apache
	configure_blukrypt_odb_config
	configure_blukrypt_components_start_service
	configure_blukrypt_log4j
}

# external function to install blukrypt components
function release_blukrypt () 
{
	deploy_blukrypt_components 2>&1 >> install.log
	config_blukrypt_components 2>&1 >> install.log
	verify_blukrypt_components 2>&1 >> install.log
	start_blukrypt_components 2>&1 >> install.log
}

function rollback_blukrypt ()
{
        rm -rf $ROOT_PATH/$CLOUD_NAME
	rm -rf $ROOT_PATH/support
	rm -rf $ROOT_PATH/backup
	rm -rf $ROOT_PATH/sync
	rm -rf $ROOT_PATH/bkpOverview
        rm -rf $ROOT_PATH/tmp-chunk
	rm -rf /var/lib/tomcat-pcb1
        rm -rf /var/lib/tomcat-job1
	rm -rf $LOG_PATH/tomcat-job1
        rm -rf $LOG_PATH/tomcat-pcb1
        rm -rf $ARCHIVE_PATH/tomcat-job1
        rm -rf $ARCHIVE_PATH/tomcat-pcb1
        
        uninstall_activemq
        uninstall_tomcat
        uninstall_apache

}
