/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.BlocklistedFolders;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.Cloud;
import com.pg.element.FileStatusElement;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.DeleteExternalStorageDataService;
import com.pg.service.UtilService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class LatestChunkDeleteJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(LatestChunkDeleteJob.class);
    private UtilService utilService;
    private List<BlocklistedFolders> blockListFolders = new ArrayList<BlocklistedFolders>();
    private List<ObjectId> failedChunkIds = new ArrayList<ObjectId>();
    private DeleteExternalStorageDataService deleteExternalStorageDataService;
    public static final String CHUNK_DETAIL = "CHUNK_DETAIL";

    public DeleteExternalStorageDataService getDeleteExternalStorageDataService() {
        return this.deleteExternalStorageDataService;
    }

    public void setDeleteExternalStorageDataService(DeleteExternalStorageDataService deleteExternalStorageDataService) {
        this.deleteExternalStorageDataService = deleteExternalStorageDataService;
    }

    public UtilService getUtilService() {
        return this.utilService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"backupUploadLatestJobTrigger")) {
            logger.debug("LatestChunkDeleteJob ............. disabled");
            return;
        }
        try {
            boolean isJobsShouldStop = PCHelperConstant.isJobsStopEnabled();
            if (isJobsShouldStop) {
                logger.debug("stopJobsEnabled in privacygateway.properties so return");
                return;
            }
            logger.debug("LatestChunkDeleteJob  started .....");
            Cloud cloud = this.utilService.getCloud(1);
            List chunksToDelete = new ArrayList();
            chunksToDelete = this.deleteExternalStorageDataService.getUnreferencedChunks(cloud.getCloudId(), this.failedChunkIds, 10);
            logger.debug("..chunks to delete size ... " + chunksToDelete.size());
            if (!CollectionUtils.isEmpty(chunksToDelete)) {
                chunksToDelete.parallelStream().forEach(chunkDetail -> {
                    logger.debug("... started deleting chunk ....." + chunkDetail.getCloudChunkName());
                    this.processMessage((ChunkDetail)chunkDetail, cloud);
                    logger.debug("... finished deleting chunk ....." + chunkDetail.getCloudChunkName());
                });
            }
            this.failedChunkIds = new ArrayList<ObjectId>();
            logger.debug(" exited  chunk deletion ..........");
        }
        catch (Exception e) {
            logger.error(" exception in LatestChunkDeleteJob......." + e.getMessage());
            logger.trace("exception in LatestChunkDeleteJob ......." + e);
        }
    }

    public void processMessage(ChunkDetail chunkDetail, Cloud cloud) {
        try {
            logger.debug("Processing " + chunkDetail.getCloudChunkName());
            this.deleteExternalStorageDataService.updateChunkAsDeleteStarted(cloud.getCloudId(), chunkDetail, true);
            boolean isFileUploaded = this.deleteChunk(chunkDetail, cloud);
            logger.debug(" message status.............. " + isFileUploaded);
            if (!isFileUploaded) {
                this.failedChunkIds.add(chunkDetail.getId());
                this.deleteExternalStorageDataService.updateChunkAsDeleteStarted(cloud.getCloudId(), chunkDetail, false);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside BackupUploadJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }

    private boolean deleteChunk(ChunkDetail chunkDetail, Cloud cloud) {
        FileStatusElement isFileUploaded = new FileStatusElement();
        try {
            isFileUploaded = this.deleteExternalStorageDataService.deleteChunkFromCloud(cloud, chunkDetail, this.blockListFolders);
        }
        catch (Exception e) {
            logger.debug("" + e);
        }
        return isFileUploaded.isDeleteStatus();
    }
}

