/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.UpdateResult;
import com.parablu.pcbd.domain.Device;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class PathLowercaseUpdater {
    public static Date convertToDateFrom(String objectId) {
        return new Date(PathLowercaseUpdater.convertToTimestampFrom(objectId));
    }

    public static long convertToTimestampFrom(String objectId) {
        return Long.parseLong(objectId.substring(0, 8), 16) * 1000L;
    }

    private static String getDateInFormat(Long deviceCreatedDate) {
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        Date dateD = new Date(deviceCreatedDate);
        return df2.format(dateD);
    }

    public static void main(String[] args) throws ConfigurationException {
        try {
            PropertiesConfiguration config = null;
            config = new PropertiesConfiguration(args[0]);
            String mongoIP = config.getProperty("mongoIP").toString();
            String mongoPort = config.getProperty("mongoPort").toString();
            String deviceUUIDList = config.getProperty("deviceUUID").toString();
            if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
                System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
                throw new ArrayIndexOutOfBoundsException();
            }
            System.out.println("mongo IP:" + mongoIP);
            MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
            MongoClient client = new MongoClient(uri);
            MongoDatabase db = client.getDatabase(uri.getDatabase());
            System.out.println("connectivity success  ");
            MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
            String startDate = PathLowercaseUpdater.getDateInFormat(System.currentTimeMillis());
            FindIterable<Document> devices = null;
            if (StringUtils.isEmpty(deviceUUIDList)) {
                devices = deviceColl.find();
            } else {
                String[] deviceUUIDs = deviceUUIDList.split(",");
                ArrayList<String> uuids = new ArrayList<String>();
                String[] stringArray = deviceUUIDs;
                int n = deviceUUIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    String uuid = stringArray[n2];
                    uuid = uuid.replace("[", "");
                    uuid = uuid.replace("]", "");
                    uuid = uuid.trim();
                    uuids.add(uuid);
                    ++n2;
                }
                System.out.println("uuids ..." + uuids);
                BasicDBObject inQuery = new BasicDBObject();
                inQuery.append("deviceUUID", new BasicDBObject("$in", uuids));
                devices = deviceColl.find(inQuery);
            }
            System.out.println("Converting device Db object to list of  device ..." + deviceUUIDList + "...folder..376000..");
            ArrayList<Device> devList = new ArrayList<Device>();
            for (Document dev : devices) {
                Device device = new Device();
                device.setDeviceUUID(dev.getString("deviceUUID"));
                device.setDestCollection(dev.getString("destCollection"));
                device.setUserName(dev.getString("userName"));
                devList.add(device);
            }
            System.out.println("total device size is...." + devList.size());
            for (Device device : devList) {
                UpdateResult updateMany;
                BasicDBObject updateQuery;
                BasicDBObject updateFields;
                ArrayList<BasicDBObject> whereQuery1;
                Object andQuery1;
                Date date = Calendar.getInstance().getTime();
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss");
                String strDate = dateFormat.format(date);
                System.out.println("....STARTDEVICE......" + strDate);
                MongoCollection<Document> bkpColl = db.getCollection(device.getDestCollection());
                String deviceUUID = device.getDeviceUUID();
                BasicDBObject andQuery = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                whereQuery.add(new BasicDBObject("folder", true));
                andQuery.put("$and", whereQuery);
                List<Document> allFoldersList = PathLowercaseUpdater.getAllFolders(bkpColl, andQuery);
                System.out.println("Done folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
                HashMap updatemap = new HashMap();
                HashMap<ObjectId, Document> documentMap = new HashMap<ObjectId, Document>();
                HashMap<String, ObjectId> folderIdAndPathMap = new HashMap<String, ObjectId>();
                for (Document folder : allFoldersList) {
                    String folderName = "";
                    folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
                    ObjectId val = (ObjectId)folder.get("_id");
                    System.out.println("....folder...." + folderName);
                    folderIdAndPathMap.put(folderName, val);
                    documentMap.put(val, folder);
                }
                System.out.println(String.valueOf(updatemap.size()) + "......." + folderIdAndPathMap.size());
                int totalModifiedCount = 0;
                int count = 0;
                HashSet alreadyUpdatedSet = new HashSet();
                TreeMap treeMap = new TreeMap(folderIdAndPathMap);
                for (Map.Entry entry : treeMap.entrySet()) {
                    String pathVal = (String)entry.getKey();
                    String modifiedPath = String.valueOf(pathVal.substring(0, 1).toUpperCase()) + pathVal.substring(1).toLowerCase();
                    if (modifiedPath.endsWith("/")) {
                        modifiedPath = modifiedPath.substring(0, modifiedPath.length() - 1);
                    }
                    System.out.println("remaining...." + ++count + "/" + treeMap.size());
                    if (((String)entry.getKey()).equals(modifiedPath)) continue;
                    System.out.println("....update...." + (String)entry.getKey() + ".....value... with ...." + entry.getValue());
                    andQuery1 = new BasicDBObject();
                    whereQuery1 = new ArrayList();
                    whereQuery1.add(new BasicDBObject("deviceUUID", deviceUUID).append("devicePath", entry.getKey()));
                    ((HashMap)andQuery1).put("$and", whereQuery1);
                    updateFields = new BasicDBObject();
                    updateQuery = new BasicDBObject();
                    updateFields.append("devicePath", modifiedPath);
                    updateQuery.append("$set", updateFields);
                    updateMany = bkpColl.updateMany((Bson)andQuery1, updateQuery);
                    totalModifiedCount += (int)updateMany.getModifiedCount();
                    System.out.println(String.valueOf(updateMany.getMatchedCount()) + "....modified count ...." + updateMany.getModifiedCount());
                }
                TreeMap uniqueMap = new TreeMap();
                TreeMap deleteMap = new TreeMap();
                HashSet alreadyAddedSet = new HashSet();
                for (Document folder : allFoldersList) {
                    String folderName = "";
                    String devicePath = "";
                    String fileName = "";
                    if (StringUtils.isEmpty(folder.getString("devicePath"))) {
                        fileName = folder.getString("fileName");
                        fileName = String.valueOf(fileName.substring(0, 1).toUpperCase()) + fileName.substring(1).toLowerCase();
                    } else {
                        devicePath = folder.getString("devicePath");
                        devicePath = String.valueOf(devicePath.substring(0, 1).toUpperCase()) + devicePath.substring(1).toLowerCase();
                        fileName = folder.getString("fileName").toLowerCase();
                    }
                    ObjectId id = (ObjectId)folder.get("_id");
                    BasicDBObject andQuery12 = new BasicDBObject();
                    ArrayList<BasicDBObject> whereQuery12 = new ArrayList<BasicDBObject>();
                    andQuery12 = new BasicDBObject();
                    whereQuery12 = new ArrayList();
                    whereQuery12.add(new BasicDBObject("deviceUUID", deviceUUID));
                    whereQuery12.add(new BasicDBObject("_id", id));
                    andQuery12.put("$and", whereQuery12);
                    BasicDBObject updateFields2 = new BasicDBObject();
                    BasicDBObject updateQuery2 = new BasicDBObject();
                    if (!StringUtils.isEmpty(devicePath)) {
                        updateFields2.append("devicePath", devicePath);
                    }
                    updateFields2.append("fileName", fileName);
                    updateQuery2.append("$set", updateFields2);
                    UpdateResult updateMany2 = bkpColl.updateMany(andQuery12, updateQuery2);
                    System.out.println("..updating folders.." + devicePath + ".." + fileName);
                }
                allFoldersList = PathLowercaseUpdater.getAllFolders(bkpColl, andQuery);
                HashSet<String> modifiedFolders = new HashSet<String>();
                PathLowercaseUpdater.cleanFolders(bkpColl, deviceUUID, allFoldersList, modifiedFolders);
                andQuery1 = new BasicDBObject();
                whereQuery1 = new ArrayList<BasicDBObject>();
                whereQuery1.add(new BasicDBObject("deviceUUID", deviceUUID));
                ((HashMap)andQuery1).put("$and", whereQuery1);
                updateFields = new BasicDBObject();
                updateQuery = new BasicDBObject();
                updateFields.append("lowercasePathConversionEnabled", true);
                updateQuery.append("$set", updateFields);
                updateMany = deviceColl.updateMany((Bson)andQuery1, updateQuery);
                System.out.println("-----updated device with isLowercasePathConversionEnabled....");
                System.out.println(String.valueOf(totalModifiedCount) + "...completed...." + updatemap.size());
                String endDate = PathLowercaseUpdater.getDateInFormat(System.currentTimeMillis());
                System.out.println(String.valueOf(startDate) + "....completed..." + endDate);
            }
        }
        catch (Exception e) {
            System.out.println("Exception..." + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void cleanFolders(MongoCollection bkpColl, String deviceUUID, List<Document> allFoldersList, Set<String> modifiedFolders) {
        for (Document folder : allFoldersList) {
            String folderName = "";
            folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
            ObjectId val = (ObjectId)folder.get("_id");
            if (modifiedFolders.contains(folderName)) {
                BasicDBObject andQuery1 = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery1 = new ArrayList<BasicDBObject>();
                andQuery1 = new BasicDBObject();
                whereQuery1 = new ArrayList();
                whereQuery1.add(new BasicDBObject("deviceUUID", deviceUUID));
                whereQuery1.add(new BasicDBObject("_id", val));
                andQuery1.put("$and", whereQuery1);
                bkpColl.findOneAndDelete(andQuery1);
                System.out.println("....cleaning folder...." + folderName);
                continue;
            }
            modifiedFolders.add(folderName);
        }
    }

    private static List<Document> getAllFolders(MongoCollection bkpColl, BasicDBObject andQuery) {
        FindIterable folders;
        ArrayList<Document> allFoldersList = new ArrayList<Document>();
        int skip = 0;
        System.out.println("getting folders................");
        String stDate = PathLowercaseUpdater.getDateInFormat(System.currentTimeMillis());
        while ((folders = bkpColl.find(andQuery).skip(skip * 500).limit(500)).first() != null) {
            for (Document document : folders) {
                allFoldersList.add(document);
            }
            System.out.println(String.valueOf(++skip) + "......folderslist..." + allFoldersList.size());
            System.out.println(String.valueOf(stDate) + "..." + PathLowercaseUpdater.getDateInFormat(System.currentTimeMillis()));
        }
        return allFoldersList;
    }
}

