/*
 * Decompiled with CFR 0.152.
 */
package Utility.com.parablu;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.Device;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;

public class GetTotalSizeandRestorableSize {
    public static void main(String[] args) throws ConfigurationException {
        try {
            PropertiesConfiguration config = null;
            config = new PropertiesConfiguration(args[0]);
            String mongoIP = config.getProperty("mongoIP").toString();
            String mongoPort = config.getProperty("mongoPort").toString();
            String deviceUUIDList = config.getProperty("deviceUUID").toString();
            if (StringUtils.isEmpty(mongoIP) || StringUtils.isEmpty(mongoPort)) {
                System.out.println("mongoIP or port cannot be empty in config file...Please configure and run again :)");
                throw new ArrayIndexOutOfBoundsException();
            }
            System.out.println("mongo IP:" + mongoIP);
            MongoClientURI uri = new MongoClientURI("mongodb://neil:parablu@" + mongoIP + ":" + mongoPort + "/parablu001");
            MongoClient client = new MongoClient(uri);
            MongoDatabase db = client.getDatabase(uri.getDatabase());
            System.out.println("connectivity success  ");
            MongoCollection<Document> deviceColl = db.getCollection("DEVICE");
            FindIterable<Document> devices = null;
            if (StringUtils.isEmpty(deviceUUIDList)) {
                devices = deviceColl.find();
            } else {
                String[] deviceUUIDs = deviceUUIDList.split(",");
                ArrayList<String> uuids = new ArrayList<String>();
                String[] stringArray = deviceUUIDs;
                int n = deviceUUIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    String uuid = stringArray[n2];
                    uuid = uuid.replace("[", "");
                    uuid = uuid.replace("]", "");
                    uuid = uuid.trim();
                    uuids.add(uuid);
                    ++n2;
                }
                System.out.println("uuids ..." + uuids);
                BasicDBObject inQuery = new BasicDBObject();
                inQuery.append("deviceUUID", new BasicDBObject("$in", uuids));
                devices = deviceColl.find(inQuery);
            }
            System.out.println("Converting device Db object to list of  device ...");
            ArrayList<Device> devList = new ArrayList<Device>();
            for (Document dev : devices) {
                Device device = new Device();
                device.setDeviceUUID(dev.getString("deviceUUID"));
                device.setDestCollection(dev.getString("destCollection"));
                devList.add(device);
            }
            System.out.println("total device size is...." + devList.size());
            for (Device device : devList) {
                FindIterable<Document> folders;
                Date date = Calendar.getInstance().getTime();
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy hh:mm:ss");
                String strDate = dateFormat.format(date);
                System.out.println("....STARTDEVICE......" + strDate);
                MongoCollection<Document> bkpColl = db.getCollection(device.getDestCollection());
                String deviceUUID = device.getDeviceUUID();
                BasicDBObject andQuery = new BasicDBObject();
                ArrayList<BasicDBObject> whereQuery = new ArrayList<BasicDBObject>();
                whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                whereQuery.add(new BasicDBObject("folder", true));
                whereQuery.add(new BasicDBObject("present", true));
                whereQuery.add(new BasicDBObject("devicePath", "e:/x64/sources"));
                andQuery.put("$and", whereQuery);
                HashSet<Document> allFoldersList = new HashSet<Document>();
                ArrayList<String> checkedFolders = new ArrayList<String>();
                int skip = 0;
                int duplicateFoldersCount = 0;
                System.out.println("getting folders................");
                while ((folders = bkpColl.find(andQuery).skip(skip * 500).limit(500)).first() != null) {
                    for (Document document : folders) {
                        allFoldersList.add(document);
                    }
                    ++skip;
                    System.out.println("  folders count in progress......" + allFoldersList.size());
                }
                System.out.println("Done folders   " + allFoldersList.size() + " for deviceUUID " + deviceUUID);
                long allFilesSizes = 0L;
                long latestFileSizes = 0L;
                long allFilesSizesInbytes = 0L;
                long latestFileSizesInbytes = 0L;
                for (Document folder : allFoldersList) {
                    String folderName = "";
                    folderName = StringUtils.isEmpty(folder.getString("devicePath")) ? folder.getString("fileName") : String.valueOf(folder.getString("devicePath")) + "/" + folder.getString("fileName");
                    if (checkedFolders.contains(folderName)) {
                        System.out.println("...already exist.." + folderName);
                        ++duplicateFoldersCount;
                        continue;
                    }
                    System.out.println("....get all files for folder..." + folderName);
                    andQuery = new BasicDBObject();
                    whereQuery = new ArrayList();
                    whereQuery.add(new BasicDBObject("deviceUUID", deviceUUID));
                    whereQuery.add(new BasicDBObject("folder", false));
                    whereQuery.add(new BasicDBObject("present", true));
                    whereQuery.add(new BasicDBObject("devicePath", folderName));
                    andQuery.put("$and", whereQuery);
                    FindIterable<Document> files = bkpColl.find(andQuery);
                    for (Document document : files) {
                        long size = 0L;
                        long sizeInBytes = 0L;
                        size = document.getLong("size");
                        if (document.getLong("sizeInBytes") != null) {
                            sizeInBytes = document.getLong("sizeInBytes");
                        } else {
                            System.out.println("size in byte is not there...devicePath: " + document.get("devicePath") + "|" + document.get("fileName") + "  id::: " + document.get("_id"));
                            sizeInBytes = size * 1024L;
                        }
                        allFilesSizes += size;
                        allFilesSizesInbytes += sizeInBytes;
                    }
                    ArrayList<BackUpImage> allFilesList = new ArrayList<BackUpImage>();
                    for (Document document : files) {
                        BackUpImage backUpImage = new BackUpImage();
                        backUpImage.setDevicePath(document.getString("devicePath"));
                        backUpImage.setFileName(document.getString("fileName"));
                        backUpImage.setLastServerModifiedTime(document.getLong("lastServerModifiedTime"));
                        if (StringUtils.isEmpty(backUpImage.getDevicePath()) || StringUtils.isEmpty(backUpImage.getFileName())) continue;
                        backUpImage.setSize(document.getLong("size"));
                        if (document.getLong("sizeInBytes") != null) {
                            backUpImage.setSizeInBytes(document.getLong("sizeInBytes"));
                        } else {
                            backUpImage.setSizeInBytes(backUpImage.getSize() * 1024L);
                        }
                        allFilesList.add(backUpImage);
                    }
                    System.out.println(".... allFilesList size ...." + allFilesList.size());
                    List<BackUpImage> list = GetTotalSizeandRestorableSize.getFilteredBackupImageList(allFilesList);
                    for (BackUpImage image : list) {
                        latestFileSizes += image.getSize();
                        latestFileSizesInbytes += image.getSizeInBytes();
                    }
                    checkedFolders.add(folderName);
                }
                System.out.println("Duplicate folders count:" + duplicateFoldersCount + " |Total size:" + allFilesSizes + " |Total size in bytes:" + allFilesSizesInbytes + " |latestFileSizes:" + latestFileSizes + " |latestFileSizesInbytes:" + latestFileSizesInbytes + " |for deviceUUID:" + deviceUUID);
                date = Calendar.getInstance().getTime();
                strDate = dateFormat.format(date);
                System.out.println("....ENDDEVICE......" + strDate);
            }
        }
        catch (Exception e) {
            System.out.println("Exception..." + e.getMessage());
            e.printStackTrace();
        }
    }

    private static List<BackUpImage> getFilteredBackupImageList(List<BackUpImage> backUpImages) {
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }
}

