/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.parablu.pcbd.dao.MSUtilDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.Components;
import com.parablu.pcbd.domain.CrawlDeltaFileInfo;
import com.parablu.pcbd.domain.DeltaPath;
import com.parablu.pcbd.domain.EWSAppSetting;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.FolderFileInfo;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.MSAppBluKrypt;
import com.parablu.pcbd.domain.MSAppSetting;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OPWS;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.Schedule;
import com.pg.domain.DriveFileInfo;
import com.pg.factory.BlukryptMongoFactoryUtils;
import com.pg.helper.constant.PCHelperConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class MSUtilDaoImpl
implements MSUtilDao {
    private static Logger logger = LogManager.getLogger(MSUtilDaoImpl.class);
    private static final String ACTION = "action";
    private static final String ACTION_TO_DEVICEUUID = "actionToDeviceUUID";
    private MongoOperations msgMongoTemplate;
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;
    private MongoTemplate localO365Template;
    private static final String DEVICE = "device";
    private static final String FILE_NAME = "fileName";
    private static final String DEVICE_PATH = "devicePath";
    private static final String LAST_SERVER_MODIFIED_TIME = "lastServerModifiedTime";
    private static final String PRESENT = "present";
    private static final String DEVICE_UUID = "deviceUUID";

    public MongoOperations getMongoTemplate() {
        return this.msgMongoTemplate;
    }

    public void setMsgMongoTemplate(MongoOperations msgMongoTemplate) {
        this.msgMongoTemplate = msgMongoTemplate;
    }

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    public MongoTemplate getLocalO365Template() {
        if (this.localO365Template == null) {
            this.localO365Template = this.mongoTemplate();
        }
        return this.localO365Template;
    }

    @Override
    public List<OfficeBackupPolicy> getAllOfficeBackupPolicies(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"isBlocked").is((Object)false));
        return mongoTemplate.find(query, OfficeBackupPolicy.class);
    }

    @Override
    public void saveDriveItem(int cloudId, DriveFileInfo driveFileInfo, CrawlDeltaFileInfo crawlDeltaFileInfo) {
        this.getLocalO365Template().save((Object)driveFileInfo);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)crawlDeltaFileInfo);
    }

    @Override
    public void saveBulkDriveItem(int cloudId, List<DriveFileInfo> driveFileInfoList, List<CrawlDeltaFileInfo> crawlDeltaFileInfoList) {
        if (!CollectionUtils.isEmpty(driveFileInfoList)) {
            BulkOperations localbulkOps = this.getLocalO365Template().bulkOps(BulkOperations.BulkMode.UNORDERED, DriveFileInfo.class);
            localbulkOps.insert(driveFileInfoList);
            localbulkOps.execute();
        }
        if (!CollectionUtils.isEmpty(crawlDeltaFileInfoList)) {
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            BulkOperations bulkOps = mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, CrawlDeltaFileInfo.class);
            bulkOps.insert(driveFileInfoList);
            bulkOps.execute();
        }
    }

    @Override
    public void saveDeletedDriveItem(int cloudId, String deletedItemId) {
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoList() {
        Query query = new Query().limit(PCHelperConstant.getQueryLimit());
        return this.getLocalO365Template().find(query, DriveFileInfo.class);
    }

    @Override
    public void deleteDriveInfo(String driveFileInfoId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)driveFileInfoId));
        this.getLocalO365Template().findAndRemove(query, DriveFileInfo.class);
    }

    @Override
    public String saveBatchDetails(int cloudId, ODBBackupBatch backupBatch, String policyName, long batchStartTime) {
        backupBatch.setBatchStartTimestamp(batchStartTime);
        this.getLocalO365Template().save((Object)backupBatch, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug("...dao... " + backupBatch);
        logger.debug("...dao1... " + backupBatch.getId());
        return backupBatch.getId().toString();
    }

    @Override
    public void deleteBatchFromOdServer(ObjectId id, String policyName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        this.getLocalO365Template().findAndRemove(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    public Components getComponents(String componentName, int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"gatewayName").is((Object)componentName);
        Query query = new Query((CriteriaDefinition)criteria);
        PrivacyGateway privacyGateway = (PrivacyGateway)mongoTemplate.findOne(query, PrivacyGateway.class);
        Components components = new Components();
        if (privacyGateway != null) {
            components.setComponentName(componentName);
            components.setComponentsProperties(privacyGateway.getComponentsProperties());
            components.setNoOfThreadsUsed(privacyGateway.getNoOfThreadsUsed());
        }
        return components;
    }

    @Override
    public List<ODBBackupBatch> getBatchList(String policyName) {
        if (PCHelperConstant.getPGOverloadLimit() == 0) {
            Properties props = null;
            try {
                long threadSize;
                String threadstr;
                ClassPathResource resource = new ClassPathResource("privacygateway.properties");
                props = PropertiesLoaderUtils.loadProperties((Resource)resource);
                logger.debug(".....componentn name ..... " + props.getProperty("componentName"));
                Components components = this.getComponents(props.getProperty("componentName"), 1);
                logger.debug("getting components properties from db of" + components.getComponentName());
                Map<String, String> componentProperties = components.getComponentsProperties();
                if (componentProperties.containsKey("pgOverloadLimit") && !StringUtils.isEmpty((String)(threadstr = componentProperties.get("pgOverloadLimit")))) {
                    threadSize = Integer.parseInt(threadstr);
                    logger.debug("...threads from collection ...." + threadSize);
                    PCHelperConstant.setPGOverloadLimit((String)("" + threadSize));
                }
                if (componentProperties.containsKey("officeDownloadThreads")) {
                    threadstr = componentProperties.get("officeDownloadThreads");
                    if (!StringUtils.isEmpty((String)threadstr)) {
                        threadSize = Integer.parseInt(threadstr);
                        logger.debug("...threads from db for offfice ...." + threadSize);
                        PCHelperConstant.setOfficeThreadsValue((String)("" + threadSize));
                    }
                } else {
                    PCHelperConstant.setOfficeThreadsValue((String)"2");
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                logger.error("...error trying to get threads..." + ee.getMessage());
            }
        }
        if (PCHelperConstant.getPGOverloadLimit() > 0) {
            Criteria criteria = Criteria.where((String)"status").is((Object)"DEFERRED");
            Query query = new Query((CriteriaDefinition)criteria);
            Update update = new Update();
            update.set("status", (Object)"COMPLETED");
            UpdateResult updateResult = this.getLocalO365Template().updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"status").is((Object)"COMPLETED"));
        return this.getLocalO365Template().find(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    @Override
    public List<DriveFileInfo> getDriveFileInfoFromListForBatchId(String batchId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"backupBatchId").is((Object)batchId));
        query.limit(5);
        return this.getLocalO365Template().find(query, DriveFileInfo.class);
    }

    @Override
    public void updateBatchDetails(int cloudId, ODBBackupBatch backupBatch, String policyName, long batchStartTime) {
        Criteria criteria = Criteria.where((String)"id").is((Object)backupBatch.getId());
        Query query = new Query((CriteriaDefinition)criteria);
        List find = this.getLocalO365Template().find(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        if (find != null) {
            logger.debug("....find list ... " + find.size());
        }
        Update update = new Update();
        update.set("status", (Object)backupBatch.getStatus());
        update.set("noOfFiles", (Object)backupBatch.getNoOfFiles());
        update.set("batchStartTimestamp", (Object)batchStartTime);
        UpdateResult updateFirst = this.getLocalO365Template().updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getModifiedCount() + "...updated successfully.... " + policyName + "..." + backupBatch.getId());
    }

    @Override
    public List<EventHub> getStartBackupEventHubList(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria odStatusCriteria = Criteria.where((String)"odStatus").is((Object)"STARTED");
        andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria});
        Query query = new Query((CriteriaDefinition)andCriteria);
        return mongoTemplate.find(query, EventHub.class);
    }

    @Override
    public void deleteActionBasedOnBackupBatchStatus(int cloudId, String deviceUUID, String action) {
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria devUUIDCriteria = Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)deviceUUID);
        andCriteria.andOperator(new Criteria[]{devUUIDCriteria, criteria});
        Query query = new Query((CriteriaDefinition)andCriteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DeleteResult remove = mongoTemplate.remove(query, EventHub.class);
        logger.debug("...removed eventhub.... " + action + "....." + deviceUUID + "......" + remove.getDeletedCount());
    }

    @Override
    public List<EventHub> getEventHubForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_TO_DEVICEUUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, EventHub.class);
    }

    @Override
    public BackUpImage getBackupImageForItemId(int cloudId, String itemId, String deviceDestCollection, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)"odItemId").is((Object)itemId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
        BackUpImage backUpImage = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            if (list.size() > 1) {
                for (BackUpImage image : list) {
                    if (!image.getStatus().equals(PCHelperConstant.REVISION_STATUS.DELETED)) continue;
                    logger.debug("...item id already deleted...." + image.getOdItemId());
                    return null;
                }
                backUpImage = (BackUpImage)list.get(0);
            } else {
                backUpImage = (BackUpImage)list.get(0);
                logger.debug(backUpImage.getUserName() + "..path..." + backUpImage.getDevicePath() + "..... item to be deleted .... " + backUpImage.getOdItemId() + "...." + backUpImage.getId());
            }
        }
        return backUpImage;
    }

    @Override
    public void saveDeletedBackupImage(int cloudId, BackUpImage deletedBkpImage, String deviceDestCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)deletedBkpImage, deviceDestCollection);
    }

    @Override
    public void updateEventHubOdStatus(int cloudId, ObjectId eventHubId) {
        Criteria criteria = Criteria.where((String)"id").is((Object)eventHubId);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List find = mongoTemplate.find(query, EventHub.class);
        if (find != null) {
            logger.debug("....find list ... " + find.size());
        }
        Update update = new Update();
        update.set("odStatus", (Object)EventHub.ODSTATUS.PROCESSED.toString());
        UpdateResult updateFirst = mongoTemplate.updateFirst(query, update, EventHub.class);
        logger.debug(updateFirst.getModifiedCount() + "...event hub updated successfully.... " + eventHubId);
    }

    @Override
    public void updateBatchStatusInOdServer(ObjectId id, String policyName) {
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("status", (Object)"PAUSED");
        UpdateResult updateFirst = this.getLocalO365Template().updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getModifiedCount() + "... paused successfully.... " + policyName + "..." + id);
    }

    @Override
    public boolean isPrevBkpPaused(String actionToDeviceUUID, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)actionToDeviceUUID), Criteria.where((String)"status").is((Object)"PAUSED")});
        Query query = new Query((CriteriaDefinition)criteria);
        ODBBackupBatch bkpBatch = (ODBBackupBatch)this.getLocalO365Template().findOne(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        boolean isPrevBkpPaused = false;
        if (bkpBatch != null && "PAUSED".equalsIgnoreCase(bkpBatch.getStatus())) {
            isPrevBkpPaused = true;
        }
        return isPrevBkpPaused;
    }

    @Override
    public void updatePauseBkp(String actionToDeviceUUID, String policyName) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)actionToDeviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("status", (Object)"COMPLETED");
        UpdateResult updateFirst = this.getLocalO365Template().updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getMatchedCount() + "... unpaused successfully.... " + policyName + "..." + actionToDeviceUUID);
    }

    @Override
    public long getThreadSize(int cloudId, String cloudName) {
        Query query;
        OPWS opws;
        String tableName = "opws_" + cloudName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        if ((opws = (OPWS)mongoTemplate.findOne(query = new Query(), OPWS.class, tableName)) != null) {
            return opws.getThreadSize();
        }
        return 0L;
    }

    @Override
    public List<BackUpImage> getChildrenByFolder(int cloudId, String folderPath, String deviceUUID, String destCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List<ObjectId> listOfBackupIds = this.getAggregatedBackupIds(cloudId, mongoTemplate, folderPath, deviceUUID, destCollection);
        ArrayList<String> bkpCollectionList = new ArrayList<String>();
        bkpCollectionList.add(destCollection);
        List<BackUpImage> backupImageList = new ArrayList<BackUpImage>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(listOfBackupIds)});
        Query query1 = new Query((CriteriaDefinition)criteria);
        query1.with(new Sort(Sort.Direction.DESC, new String[]{LAST_SERVER_MODIFIED_TIME}));
        List list = mongoTemplate.find(query1, BackUpImage.class, destCollection);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            backupImageList.addAll(list);
        }
        backupImageList = this.getFilteredBackupImageListByGrouping(backupImageList);
        return backupImageList;
    }

    private List<ObjectId> getAggregatedBackupIds(int cloudId, MongoTemplate mongoTemplate, String folderPath, String deviceUUID, String destCollection) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true)});
        TypedAggregation aggregation = Aggregation.newAggregation(BackUpImage.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{FILE_NAME, DEVICE_PATH}).max(LAST_SERVER_MODIFIED_TIME).as(LAST_SERVER_MODIFIED_TIME), Aggregation.project((String[])new String[]{FILE_NAME, DEVICE_PATH, LAST_SERVER_MODIFIED_TIME})});
        ArrayList<String> bkpCollectionList = new ArrayList<String>();
        bkpCollectionList.add(destCollection);
        ArrayList stateStatsList = new ArrayList();
        for (String dest : bkpCollectionList) {
            AggregationResults result = mongoTemplate.aggregate(aggregation, dest, Document.class);
            List list = result.getMappedResults();
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            stateStatsList.addAll(list);
        }
        ArrayList<ObjectId> listOfObjectIds = new ArrayList<ObjectId>();
        for (Document dbObject : stateStatsList) {
            Long lastServerModifiedTime;
            String devicePath;
            String fileName;
            BackUpImage backUpImage;
            if (dbObject == null || dbObject.get((Object)FILE_NAME) == null || dbObject.get((Object)DEVICE_PATH) == null || (backUpImage = this.getBackUpImageForFile(cloudId, deviceUUID, destCollection, mongoTemplate, fileName = dbObject.get((Object)FILE_NAME).toString(), devicePath = dbObject.get((Object)DEVICE_PATH).toString(), lastServerModifiedTime = (Long)dbObject.get((Object)LAST_SERVER_MODIFIED_TIME))) == null) continue;
            listOfObjectIds.add(backUpImage.getId());
        }
        return listOfObjectIds;
    }

    private BackUpImage getBackUpImageForFile(int cloudId, String deviceUUID, String destCollection, MongoTemplate mongoTemplate, String fileName, String devicePath, Long serverModifiedTime) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)LAST_SERVER_MODIFIED_TIME).is((Object)serverModifiedTime)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        ArrayList backUpImageList = new ArrayList();
        ArrayList<String> bkpCollectionList = new ArrayList<String>();
        bkpCollectionList.add(destCollection);
        for (String dest : bkpCollectionList) {
            List list = mongoTemplate.find(query, BackUpImage.class, dest);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            backUpImageList.addAll(list);
        }
        if (!CollectionUtils.isEmpty(backUpImageList)) {
            return (BackUpImage)backUpImageList.get(0);
        }
        return null;
    }

    private List<BackUpImage> getFilteredBackupImageListByGrouping(List<BackUpImage> backUpImages) {
        logger.debug("Inside grouping backup images");
        ArrayList<BackUpImage> filteredBackUpImages = new ArrayList<BackUpImage>();
        backUpImages.stream().filter(p -> p.getDevicePath() == null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(BackUpImage::getFileName)).entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        Map<String, Map<String, List<BackUpImage>>> map = backUpImages.stream().filter(p -> p.getDevicePath() != null).collect(Collectors.groupingBy(BackUpImage::getDevicePath, Collectors.groupingBy(BackUpImage::getFileName)));
        for (Map.Entry<String, Map<String, List<BackUpImage>>> entry : map.entrySet()) {
            entry.getValue().entrySet().stream().forEach(p -> filteredBackUpImages.add(((List)p.getValue()).stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).findFirst().get()));
        }
        return filteredBackUpImages;
    }

    @Override
    public void saveOfficeBackupPolicy(int cloudId, OfficeBackupPolicy officeBackupPolicy) {
        Query query12;
        MongoTemplate template = this.getLocalO365Template();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)officeBackupPolicy.getId()));
        template.findAndRemove(query, OfficeBackupPolicy.class);
        template.save((Object)officeBackupPolicy);
        if (!CollectionUtils.isEmpty(officeBackupPolicy.getMailBackupFolders())) {
            officeBackupPolicy.getMailBackupFolders().forEach(folders -> {
                if (folders != null) {
                    logger.debug("... MailBackupFolders..... " + folders.getFolderPath());
                    try {
                        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)folders.getId()));
                        template.findAndRemove(query1, BackupFolders.class);
                        template.save(folders);
                    }
                    catch (MongoException mongoException) {
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(officeBackupPolicy.getOdBackupFolders())) {
            officeBackupPolicy.getOdBackupFolders().forEach(folders -> {
                if (folders != null) {
                    try {
                        logger.debug("... OdBackupFolders..... " + folders.getFolderPath());
                        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)folders.getId()));
                        template.findAndRemove(query1, BackupFolders.class);
                        template.save(folders);
                    }
                    catch (MongoException mongoException) {
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(officeBackupPolicy.getMailSchedules())) {
            officeBackupPolicy.getMailSchedules().forEach(schedules -> {
                if (schedules != null) {
                    try {
                        logger.debug("... MailSchedules..... " + schedules.getTime());
                        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)schedules.getId()));
                        template.findAndRemove(query1, Schedule.class);
                        template.save(schedules);
                    }
                    catch (MongoException mongoException) {
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(officeBackupPolicy.getOdSchedules())) {
            officeBackupPolicy.getOdSchedules().forEach(schedules -> {
                if (schedules != null) {
                    try {
                        logger.debug("... OdSchedules..... " + schedules.getTime());
                        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)schedules.getId()));
                        template.findAndRemove(query1, Schedule.class);
                        template.save(schedules);
                    }
                    catch (MongoException mongoException) {
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(officeBackupPolicy.getMailExcludedFolders())) {
            officeBackupPolicy.getMailExcludedFolders().forEach(excludedFolders -> {
                if (excludedFolders != null) {
                    try {
                        logger.debug("... MailExcludedFolders..... " + excludedFolders.getFolderPath());
                        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)excludedFolders.getId()));
                        template.findAndRemove(query1, ExcludedFolders.class);
                        template.save(excludedFolders);
                    }
                    catch (MongoException mongoException) {
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            });
        }
        if (!CollectionUtils.isEmpty(officeBackupPolicy.getOdExcludedFolders())) {
            officeBackupPolicy.getOdExcludedFolders().forEach(excludedFolders -> {
                if (excludedFolders != null) {
                    try {
                        logger.debug("... OdExcludedFolders..... " + excludedFolders.getFolderPath());
                        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)excludedFolders.getId()));
                        template.findAndRemove(query1, ExcludedFolders.class);
                        template.save(excludedFolders);
                    }
                    catch (MongoException mongoException) {
                    }
                    catch (DuplicateKeyException duplicateKeyException) {
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                }
            });
        }
        if (officeBackupPolicy.getMailInclusionFilter() != null) {
            for (InclusionFilter inclusionFilter : officeBackupPolicy.getMailInclusionFilter()) {
                try {
                    query12 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)inclusionFilter.getId()));
                    template.findAndRemove(query12, InclusionFilter.class);
                    template.save((Object)inclusionFilter);
                }
                catch (MongoException query12) {
                }
                catch (DuplicateKeyException query12) {
                }
                catch (Exception query12) {
                }
                catch (Error query12) {}
            }
        }
        if (officeBackupPolicy.getOdInclusionFilter() != null) {
            for (InclusionFilter inclusionFilter : officeBackupPolicy.getOdInclusionFilter()) {
                try {
                    query12 = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)inclusionFilter.getId()));
                    template.findAndRemove(query12, InclusionFilter.class);
                    template.save((Object)inclusionFilter);
                }
                catch (MongoException mongoException) {
                }
                catch (DuplicateKeyException duplicateKeyException) {
                }
                catch (Exception exception) {
                }
                catch (Error error) {}
            }
        }
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicyFromLocal(int cloudId, String policyName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"policyName").is((Object)policyName));
        return (OfficeBackupPolicy)this.getLocalO365Template().findOne(query, OfficeBackupPolicy.class);
    }

    @Override
    public BackUpImage getBackupImageFolderForItemId(int cloudId, String itemId, String deviceDestCollection) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"odItemId").is((Object)itemId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, BackUpImage.class, deviceDestCollection);
        logger.debug("..... for item id vla ..... " + itemId + "... " + deviceDestCollection);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            logger.debug("..... for list size ..... " + list.size());
        } else {
            logger.debug("... no files.... " + itemId);
        }
        BackUpImage backUpImage = null;
        if (!CollectionUtils.isEmpty((Collection)list)) {
            if (list.size() > 1) {
                logger.debug(".... folder filter..... ");
                List bkpImageList = list.stream().sorted(Comparator.comparing(BackUpImage::getLastServerModifiedTime).reversed()).collect(Collectors.toList());
                backUpImage = (BackUpImage)bkpImageList.get(0);
                logger.debug(".... folder filter. after .... " + backUpImage.getDevicePath() + "/" + backUpImage.getFileName());
            } else {
                backUpImage = (BackUpImage)list.get(0);
                logger.debug("..... item to be deleted .... " + backUpImage.getOdItemId() + "...." + backUpImage.getId());
            }
        }
        return backUpImage;
    }

    @Override
    public void saveFolderItem(FolderFileInfo folderFileInfo) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"itemPath").is((Object)folderFileInfo.getItemPath()), Criteria.where((String)DEVICE_UUID).is((Object)folderFileInfo.getDeviceUUID())});
        Query query = new Query((CriteriaDefinition)criteria);
        this.getLocalO365Template().findAndRemove(query, FolderFileInfo.class);
        this.getLocalO365Template().save((Object)folderFileInfo);
    }

    @Override
    public String getFolderItemId(String path, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"itemPath").is((Object)path), Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        FolderFileInfo folderFileInfo = (FolderFileInfo)this.getLocalO365Template().findOne(query, FolderFileInfo.class);
        String folderItemId = "";
        if (folderFileInfo != null) {
            folderItemId = folderFileInfo.getItemId();
        }
        logger.debug(".... item path .... " + path + "...id from table..." + folderItemId);
        return folderItemId;
    }

    @Override
    public List<ODBBackupBatch> getCurrentBatch(String policyName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"status").is((Object)"COMPLETED"), Criteria.where((String)"userName").is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.getLocalO365Template().find(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    public String getDatabaseName() {
        return "parablumsg";
    }

    public MongoClient mongoClient(MSAppBluKrypt appBluKrypt) {
        ServerAddress address = new ServerAddress(appBluKrypt.getHost().trim(), Integer.parseInt(appBluKrypt.getPort().trim()));
        MongoCredential credential = MongoCredential.createCredential((String)"neil", (String)this.getDatabaseName(), (char[])"parablu".toCharArray());
        MongoClientOptions options = new MongoClientOptions.Builder().build();
        MongoClient client = new MongoClient(address, credential, options);
        return client;
    }

    public MongoDbFactory mongoDbFactory(MSAppBluKrypt appBluKrypt) {
        return new SimpleMongoDbFactory(this.mongoClient(appBluKrypt), this.getDatabaseName());
    }

    public MongoTemplate mongoTemplate() {
        MSAppBluKrypt appBluKrypt = this.getMsAppBluKrypt();
        return new MongoTemplate(this.mongoDbFactory(appBluKrypt));
    }

    public MSAppBluKrypt getMsAppBluKrypt() {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(1);
        List findAllOdPolicies = mongoTemplate.findAll(OfficeBackupPolicy.class);
        String msAppBluKrypt = this.getMsAppBlukrypt(findAllOdPolicies);
        logger.debug("...msapp blukrypt ... " + msAppBluKrypt);
        MSAppBluKrypt msBluKrypt = null;
        if (!StringUtils.isEmpty((String)msAppBluKrypt)) {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"host").is((Object)msAppBluKrypt));
            msBluKrypt = (MSAppBluKrypt)mongoTemplate.findOne(query, MSAppBluKrypt.class);
        }
        return msBluKrypt;
    }

    private String getMsAppBlukrypt(List<OfficeBackupPolicy> findAllOdPolicies) {
        String msAppBluKrypt = "";
        for (OfficeBackupPolicy oneDriveBackupPolicy : findAllOdPolicies) {
            logger.debug(PCHelperConstant.getComponentName() + "....policy ...." + oneDriveBackupPolicy.getPolicyName());
            logger.debug(oneDriveBackupPolicy.getOdMsAppBluKrypt() + "....od and mail ...." + oneDriveBackupPolicy.getMailMsAppBluKrypt());
            if (oneDriveBackupPolicy == null) continue;
            if (!StringUtils.isEmpty((String)oneDriveBackupPolicy.getOdMsAppBluKrypt()) && oneDriveBackupPolicy.getOdMsAppBluKrypt().equalsIgnoreCase(PCHelperConstant.getComponentName())) {
                msAppBluKrypt = oneDriveBackupPolicy.getOdMsAppBluKrypt();
                break;
            }
            if (StringUtils.isEmpty((String)oneDriveBackupPolicy.getMailMsAppBluKrypt()) || !oneDriveBackupPolicy.getMailMsAppBluKrypt().equalsIgnoreCase(PCHelperConstant.getComponentName())) continue;
            msAppBluKrypt = oneDriveBackupPolicy.getMailMsAppBluKrypt();
            break;
        }
        return msAppBluKrypt;
    }

    @Override
    public String getDeltaLinkForPathAndUser(String path, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"path").is((Object)path), Criteria.where((String)"userName").is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        DeltaPath deltaPath = (DeltaPath)this.getLocalO365Template().findOne(query, DeltaPath.class);
        String delta = "";
        if (deltaPath != null) {
            delta = deltaPath.getDeltaLink();
        }
        return delta;
    }

    @Override
    public List<DeltaPath> getAllDeltaLinkUser(String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.getLocalO365Template().find(query, DeltaPath.class);
    }

    @Override
    public void updateDeltaForPathAndUser(String path, String userName, String messDeltaLink) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"path").is((Object)path), Criteria.where((String)"userName").is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        DeltaPath existPath = (DeltaPath)this.getLocalO365Template().findOne(query, DeltaPath.class);
        logger.debug("...deltapath .." + userName + ".." + path + "..." + messDeltaLink);
        if (existPath == null) {
            existPath = new DeltaPath();
            existPath.setPath(path);
            existPath.setUserName(userName);
            existPath.setDeltaLink(messDeltaLink);
            this.getLocalO365Template().save((Object)existPath);
        } else {
            Update update = new Update();
            update.set("deltaLink", (Object)messDeltaLink);
            UpdateResult updateFirst = this.getLocalO365Template().updateFirst(query, update, DeltaPath.class);
            logger.debug(updateFirst.getModifiedCount() + "...updated successfully.... " + path + "..." + userName);
        }
    }

    @Override
    public ObjectId saveEventHubAction(int cloudId, EventHub eventHub) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        EventHub save = (EventHub)mongoTemplate.save((Object)eventHub);
        return save.getId();
    }

    @Override
    public void saveStatisticToDatabase(int cloudId, AuditHistory auditHistory) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)auditHistory);
    }

    @Override
    public void saveEwsAppSetting(int cloudId, EWSAppSetting appSetting) {
        Query query;
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        MSAppSetting msAppSetting = (MSAppSetting)mongoTemplate.findOne(query = new Query(), MSAppSetting.class);
        if (msAppSetting != null) {
            appSetting.setTenantId(msAppSetting.getTenantId());
        }
        mongoTemplate.remove(EWSAppSetting.class);
        mongoTemplate.save((Object)appSetting);
    }

    @Override
    public EWSAppSetting getEwsAppSettingDetail(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query();
        return (EWSAppSetting)mongoTemplate.findOne(query, EWSAppSetting.class);
    }

    @Override
    public List<CrawlDeltaFileInfo> getCrawlDeltaList(int cloudId, String folderPath) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"itemPath").is((Object)folderPath)});
        Query query = new Query((CriteriaDefinition)andCriteria);
        query.limit(500);
        return mongoTemplate.find(query, CrawlDeltaFileInfo.class);
    }

    @Override
    public void deleteCrawlInfo(int cloudId, ObjectId id) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)andCriteria);
        mongoTemplate.findAndRemove(query, CrawlDeltaFileInfo.class);
    }

    @Override
    public List<CrawlDeltaFileInfo> getExistingTasksList(int cloudId, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName), Criteria.where((String)"itemPath").is((Object)"Tasks")});
        Query query = new Query((CriteriaDefinition)andCriteria);
        return mongoTemplate.find(query, CrawlDeltaFileInfo.class);
    }

    @Override
    public List<CrawlDeltaFileInfo> getExistingContactsList(int cloudId, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"userName").is((Object)userName), Criteria.where((String)"itemPath").is((Object)"Contacts")});
        Query query = new Query((CriteriaDefinition)andCriteria);
        return mongoTemplate.find(query, CrawlDeltaFileInfo.class);
    }

    @Override
    public void deleteBackupImageForItemId(int cloudId, String itemId, String deviceDestCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"odItemId").is((Object)itemId)});
        Query query = new Query((CriteriaDefinition)andCriteria);
        mongoTemplate.findAndRemove(query, BackUpImage.class, deviceDestCollection);
    }

    @Override
    public long getTotalFilesCountByBatchId(String batchId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"backupBatchId").is((Object)batchId));
        return this.getLocalO365Template().count(query, DriveFileInfo.class);
    }

    @Override
    public long getTotalFilesCountByPrevDelta(String userName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"userName").is((Object)userName));
        query.limit(50);
        logger.debug("getPrevItemsForMailBkp count...");
        return this.getLocalO365Template().count(query, DriveFileInfo.class, "PREV_DELTA_ITEMS");
    }

    @Override
    public List<DriveFileInfo> getOneDriveFileInfoFromListForBatchId(int cloudId, String batchId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"backupBatchId").is((Object)batchId));
        query.limit(1);
        return this.getLocalO365Template().find(query, DriveFileInfo.class);
    }

    @Override
    public void savePrevItemsForMailBackup(DriveFileInfo item) {
        item.setPrevDeltaItem(true);
        this.getLocalO365Template().save((Object)item, "PREV_DELTA_ITEMS");
    }

    @Override
    public List<DriveFileInfo> getPrevItemsForMailBkp(String userName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"userName").is((Object)userName));
        query.limit(50);
        logger.debug("getPrevItemsForMailBkp");
        return this.getLocalO365Template().find(query, DriveFileInfo.class, "PREV_DELTA_ITEMS");
    }

    @Override
    public void updateDeferedBatchStatusInOdServer(ObjectId id, String policyName) {
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("status", (Object)"DEFERRED");
        UpdateResult updateFirst = this.getLocalO365Template().updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getModifiedCount() + "... DEFERRED successfully.... " + policyName + "..." + id);
    }

    @Override
    public boolean isPrevBkpDeferred(String actionToDeviceUUID, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)actionToDeviceUUID), Criteria.where((String)"status").is((Object)"DEFERRED")});
        Query query = new Query((CriteriaDefinition)criteria);
        ODBBackupBatch bkpBatch = (ODBBackupBatch)this.getLocalO365Template().findOne(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        boolean isPrevBkpPaused = false;
        if (bkpBatch != null && "DEFERRED".equalsIgnoreCase(bkpBatch.getStatus())) {
            isPrevBkpPaused = true;
        }
        return isPrevBkpPaused;
    }

    @Override
    public void updateDeferredBkp(String actionToDeviceUUID, String policyName) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)actionToDeviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("status", (Object)"COMPLETED");
        UpdateResult updateFirst = this.getLocalO365Template().updateFirst(query, update, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
        logger.debug(updateFirst.getMatchedCount() + "... un deferred successfully.... " + policyName + "..." + actionToDeviceUUID);
    }

    @Override
    public long getTotaFailedlFilesFromPrevBackup(String deviceUUID) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID));
        query.limit(50);
        logger.debug("getTotaFailedlFilesFromPrevBackup count...");
        return this.getLocalO365Template().count(query, DriveFileInfo.class, "RETRY_FAILED_FILES");
    }

    @Override
    public void removeFailedFile(String itemId) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)itemId));
        this.getLocalO365Template().findAndRemove(query, DriveFileInfo.class, "RETRY_FAILED_FILES");
    }

    @Override
    public List<ODBBackupBatch> getBatchList(String policyName, int limit) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"status").is((Object)"COMPLETED"));
        query.limit(limit);
        return this.getLocalO365Template().find(query, ODBBackupBatch.class, "BACKUP_BATCH_" + policyName.toUpperCase());
    }

    @Override
    public long getTotalSizeByBatchId(String batchId) {
        MongoTemplate mongoTemplate = this.getLocalO365Template();
        long totalSize = 0L;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"backupBatchId").is((Object)batchId)});
        TypedAggregation aggregation = Aggregation.newAggregation(DriveFileInfo.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"id"}).sum("size").as("size"), Aggregation.project((String[])new String[]{"size"})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, Document.class);
        List overViewList = result.getMappedResults();
        for (Document dbObject : overViewList) {
            totalSize += ((Long)dbObject.get((Object)"size")).longValue();
        }
        return totalSize;
    }

    @Override
    public void saveDriveFileInfo(DriveFileInfo driveFileInfo) {
        this.getLocalO365Template().save((Object)driveFileInfo);
        this.removeFailedFile(driveFileInfo.getId().toString());
    }

    @Override
    public List<DriveFileInfo> getPrevBatchFailedFiles(String deviceUUID) {
        Criteria criteria = new Criteria();
        logger.debug("......getPrevBatchFailedFiles....." + deviceUUID);
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.getLocalO365Template().find(query, DriveFileInfo.class);
    }

    @Override
    public List<EventHub> getStartBackupEventHubListForBlukrypt(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria odStatusCriteria = new Criteria();
        odStatusCriteria.orOperator(new Criteria[]{Criteria.where((String)"odStatus").is((Object)"STARTED"), Criteria.where((String)"odStatus").is((Object)"PROCESSED")});
        andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria, Criteria.where((String)"blukryptName").is((Object)PCHelperConstant.getComponentName())});
        Query query = new Query((CriteriaDefinition)andCriteria);
        List list = mongoTemplate.find(query, EventHub.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            logger.debug("...empty events so try if any orphaned events lastUpdatedTime...");
            andCriteria = new Criteria();
            query = new Query((CriteriaDefinition)andCriteria);
            andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria, Criteria.where((String)"lastUpdatedTime").is((Object)0)});
            List oldlist = mongoTemplate.find(query, EventHub.class);
            if (!CollectionUtils.isEmpty((Collection)oldlist)) {
                logger.debug("....overall old list ..lastUpdatedTime.." + oldlist.size());
            }
        }
        return list;
    }

    @Override
    public void removeOldEventHub(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)ACTION).is((Object)"FULL_BACKUP"), Criteria.where((String)ACTION).is((Object)"START_BACKUP")});
        Criteria odStatusCriteria = new Criteria();
        odStatusCriteria.orOperator(new Criteria[]{Criteria.where((String)"odStatus").is((Object)"STARTED"), Criteria.where((String)"odStatus").is((Object)"PROCESSED")});
        andCriteria.andOperator(new Criteria[]{odStatusCriteria, criteria, Criteria.where((String)"blukryptName").is((Object)PCHelperConstant.getComponentName())});
        Query query = new Query((CriteriaDefinition)andCriteria);
        logger.debug("...remove all old eventhub..... ");
        mongoTemplate.findAllAndRemove(query, EventHub.class);
    }

    @Override
    public void deleteEventHub(int cloudId, ObjectId eventHubId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria andCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)eventHubId)});
        Query query = new Query((CriteriaDefinition)andCriteria);
        logger.debug("...remove eventhub..... " + eventHubId);
        mongoTemplate.findAllAndRemove(query, EventHub.class);
    }

    @Override
    public void updateEventHubTime(int cloudId, String eventHubId) {
        Criteria criteria = Criteria.where((String)"id").is((Object)eventHubId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("lastUpdatedTime", (Object)System.currentTimeMillis());
        update.set("blukryptName", (Object)PCHelperConstant.getComponentName());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UpdateResult updateFirst = mongoTemplate.updateFirst(query, update, EventHub.class);
    }

    @Override
    public BackUpImage getBackupImageFolder(int cloudId, String parentpath, String child, String deviceDestCollection, String deviceUUID) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)child)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)FILE_NAME).is((Object)parentpath), Criteria.where((String)PRESENT).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)parentpath), Criteria.where((String)FILE_NAME).is((Object)child), Criteria.where((String)PRESENT).is((Object)true)});
        }
        Query query1 = new Query((CriteriaDefinition)criteria);
        BackUpImage backupImage = null;
        logger.debug(parentpath + "...before query..." + child);
        List list = mongoTemplate.find(query1, BackUpImage.class, deviceDestCollection);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            backupImage = (BackUpImage)list.get(0);
        }
        logger.debug("...after query...");
        return backupImage;
    }

    @Override
    public List<BackUpImage> getChildrenByFolderForDeletePath(int cloudId, String newPathVal, String deviceUUID, String destCollection) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        ArrayList<BackUpImage> backupImageList = new ArrayList<BackUpImage>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)DEVICE_PATH).is((Object)newPathVal)});
        Query query1 = new Query((CriteriaDefinition)criteria);
        List list = mongoTemplate.find(query1, BackUpImage.class, destCollection);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            backupImageList.addAll(list);
        }
        return backupImageList;
    }
}

