/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.client.DistinctIterable;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.O365BlackListUser;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDefinedFolders;
import com.pg.factory.BlukryptMongoFactoryUtils;
import com.pg.helper.constant.PCHelperConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class DeviceDaoImpl
implements DeviceDao {
    Logger logger = LogManager.getLogger(DeviceDaoImpl.class);
    private static final String FOLDER_TYPE = "folderType";
    private static final String STORAGEUTILIZED = "storageUtilized";
    private static final String NOOFSUCCESSFULRESTORES = "noOfSuccessfulRestores";
    private static final String NOOFSUCCESSFULBACKUPS = "noOfSuccessfulBackups";
    private static final String DEVICE_UUID = "deviceUUID";
    private static final String USER_NAME = "userName";
    BlukryptMongoFactoryUtils blukryptMongoFactoryUtils;

    private void logMessage(String logMessage) {
        this.logger.trace(logMessage);
    }

    public BlukryptMongoFactoryUtils getBlukryptMongoFactoryUtils() {
        return this.blukryptMongoFactoryUtils;
    }

    public void setBlukryptMongoFactoryUtils(BlukryptMongoFactoryUtils blukryptMongoFactoryUtils) {
        this.blukryptMongoFactoryUtils = blukryptMongoFactoryUtils;
    }

    @Override
    public List<Device> getAll(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(Device.class);
    }

    @Override
    public Device register(int cloudId, String cloudName, Device device) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)device);
        return device;
    }

    @Override
    public Device blockUnblockDevice(int cloudId, String cloudName, Device device, boolean isBlocked) {
        device.setBlocked(isBlocked);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)device);
        return device;
    }

    @Override
    public Device updateDeviceInfo(int cloudId, String cloudName, Device device) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)device);
        return device;
    }

    @Override
    public Device saveUUID(int cloudId, String cloudName, Device device) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)device);
        return device;
    }

    @Override
    public Device getDeviceInfoByUUID(int cloudId, String cloudName, String deviceUUID) {
        this.logMessage("$$$$ Before getting device Info by UUID $$$$");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logMessage("$$$$ After getting device Info by UUID $$$$");
        query.limit(1);
        List list = mongoTemplate.find(query, Device.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (Device)list.get(0);
        }
        return null;
    }

    @Override
    public List<Device> getAllDevicesByUUID(int cloudId, String cloudName, String deviceUUID) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, Device.class);
    }

    @Override
    public long getDeviceCount(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"blocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, Device.class);
    }

    @Override
    public List<Device> getAllSinceTimeStamp(int cloudId, String cloudName, long timeStamp) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"lastModifiedTimestamp").gt((Object)timeStamp)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, Device.class);
    }

    @Override
    public long getDeviceCount(int cloudId, String cloudName, boolean blocked) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"blocked").is((Object)blocked)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, Device.class);
    }

    @Override
    public void deleteAllDeviceByUser(int cloudId, String cloudName, User user) {
        this.deleteAllDeviceOverViewByUser(cloudId, user);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, Device.class);
    }

    @Override
    public List<Device> getAllDeviceByUser(int cloudId, String cloudName, User user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, Device.class);
    }

    @Override
    public List<Device> getAllDeviceByUserName(int cloudId, String userName) {
        List<Device> list = new ArrayList<Device>();
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (StringUtils.isNotEmpty((String)userName)) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
            Query query = new Query((CriteriaDefinition)criteria);
            list = mongoTemplate.find(query, Device.class);
        }
        return list;
    }

    @Override
    public Map<String, List<Device>> getAllDeviceByUser(int cloudId, List<User> users) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        HashMap<String, List<Device>> userAndDevices = new HashMap<String, List<Device>>();
        ArrayList<String> userNameList = new ArrayList<String>();
        for (User user : users) {
            if (user == null) continue;
            userNameList.add(user.getUserName());
        }
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"blocked").is((Object)false), Criteria.where((String)USER_NAME).in(userNameList)});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = mongoTemplate.find(query, Device.class);
        for (Device device : list) {
            if (device == null || StringUtils.isEmpty((String)device.getUserName())) continue;
            DeviceDaoImpl.addValues(device.getUserName(), device, userAndDevices);
        }
        return userAndDevices;
    }

    @Override
    public Map<String, List<Device>> getAllDevicesByUser(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        HashMap<String, List<Device>> userAndDevices = new HashMap<String, List<Device>>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"blocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = mongoTemplate.find(query, Device.class);
        if (list != null) {
            this.logger.debug(" getAllDevicesByUser ........ " + list.size());
        }
        for (Device device : list) {
            if (device == null || StringUtils.isEmpty((String)device.getUserName())) continue;
            DeviceDaoImpl.addValues(device.getUserName(), device, userAndDevices);
        }
        return userAndDevices;
    }

    private static void addValues(String key, Device device, Map<String, List<Device>> hashMap) {
        List<Object> tempList;
        if (hashMap.containsKey(key)) {
            tempList = hashMap.get(key);
            if (tempList == null) {
                tempList = new ArrayList();
            }
            tempList.add(device);
        } else {
            tempList = new ArrayList();
            tempList.add(device);
        }
        hashMap.put(key, tempList);
    }

    @Override
    public Device getDeviceByName(int cloudId, String cloudName, String deviceName, String userName, String deviceUUID) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceName").is((Object)deviceName), Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        List list = mongoTemplate.find(query, Device.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (Device)list.get(0);
        }
        return null;
    }

    @Override
    public Device getDeviceByNameForUserId(int cloudId, String cloudName, String deviceName, ObjectId userId, String deviceUUID) {
        Query query1 = new Query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId));
        MongoTemplate mongoTemplate1 = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)mongoTemplate1.findOne(query1, User.class);
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)deviceUUID)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceName").is((Object)deviceName), Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, Device.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (Device)list.get(0);
        }
        return null;
    }

    @Override
    public List<Device> getDeviceByNameForBackup(int cloudId, String cloudName, String deviceName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceName").is((Object)deviceName), Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, Device.class);
    }

    @Override
    public long getDeviceCountOfUser(int cloudId, String cloudName, User user) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)user.getUserName());
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, Device.class);
    }

    @Override
    public List<Device> getActiveDeviceByName(int cloudId, String cloudName, String deviceName, String userName) {
        return Collections.emptyList();
    }

    @Override
    public List<Device> getActiveDeviceByNameAndUser(int cloudId, String cloudName, String deviceName, String userName) {
        return Collections.emptyList();
    }

    @Override
    public void updateDeviceDecoupled(int cloudId, String cloudName, String deviceUUID) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("decoupled", (Object)true);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, Device.class);
    }

    @Override
    public List<Device> getActiveDevicesForNoBackup(int cloudId, String cloudName, int skipValue) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DistinctIterable distStr = mongoTemplate.getCollection("BACKUP_BATCH").distinct("device.$id", ObjectId.class);
        List listofDeviceIds = IteratorUtils.toList((Iterator)distStr.iterator());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").nin((Collection)listofDeviceIds), Criteria.where((String)"blocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return mongoTemplate.find(query, Device.class);
    }

    @Override
    public Device getDeviceByName(int cloudId, String cloudName, String deviceName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceName").is((Object)deviceName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, Device.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (Device)list.get(0);
        }
        return null;
    }

    @Override
    public Device getDeviceByNameAndUser(int cloudId, String cloudName, String deviceName, String userName) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (StringUtils.isNotEmpty((String)userName)) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceName").is((Object)deviceName), Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"blocked").is((Object)false)});
            Query query = new Query((CriteriaDefinition)criteria);
            query.limit(1);
            List list1 = mongoTemplate.find(query, Device.class);
            if (!CollectionUtils.isEmpty((Collection)list1)) {
                return (Device)list1.get(0);
            }
        }
        return null;
    }

    @Override
    public void blockUnblockDevice(int cloudId, String cloudName, String deviceUUID, boolean toBlock) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("blocked", (Object)toBlock);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, Device.class);
    }

    @Override
    public List<Device> getAllWithPagination(int cloudId, int skipValue) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).ne((Object)"test")});
        Query query = new Query((CriteriaDefinition)criteria);
        this.logger.debug(" No of records ... " + PCHelperConstant.getReportDisplayRecords());
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return mongoTemplate.find(query, Device.class);
    }

    @Override
    public List<Device> findDeviceByNames(int cloudId, List<String> list) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Device> devList = new ArrayList<Device>();
        for (String deviceName : list) {
            String devName = deviceName.trim();
            List devicelist = mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"deviceName").regex(Pattern.compile("^" + devName, 2))), Device.class);
            if (devicelist == null) continue;
            for (Device deviceObj : devicelist) {
                devList.add(deviceObj);
            }
        }
        return devList;
    }

    @Override
    public List<Device> getAllDeviceByUserName(int cloudId, String userName, List<String> list) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Device> devList = new ArrayList<Device>();
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"));
        User user = (User)mongoTemplate.findOne(query, User.class);
        if (user != null) {
            this.getDeviceForUser(list, mongoTemplate, devList);
        }
        return devList;
    }

    private void getDeviceForUser(List<String> list, MongoTemplate mongoTemplate, List<Device> devList) {
        for (String deviceName : list) {
            String devName = deviceName.trim();
            this.logger.debug(deviceName + " dev name in dao ... " + devName);
            Criteria criteria = Criteria.where((String)"deviceName").regex("^" + devName + "$", "i");
            Query query = new Query((CriteriaDefinition)criteria);
            List devicelist = mongoTemplate.find(query, Device.class);
            if (devicelist == null) continue;
            for (Device deviceObj : devicelist) {
                devList.add(deviceObj);
            }
        }
    }

    @Override
    public void updateDevice(int cloudId, Device device) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)device);
    }

    @Override
    public Map<String, List<Device>> getAllDevicesByUser(int cloudId, int skipValue) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        HashMap<String, List<Device>> userAndDevices = new HashMap<String, List<Device>>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"blocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        List list = mongoTemplate.find(query, Device.class);
        for (Device device : list) {
            if (device == null || StringUtils.isEmpty((String)device.getUserName())) continue;
            DeviceDaoImpl.addValues(device.getUserName(), device, userAndDevices);
        }
        return userAndDevices;
    }

    @Override
    public Object[] getCloudOverView(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long noOfRestoresDone = 0L;
        long noOfBackupsDone = 0L;
        long totalDiskSpaceUsed = 0L;
        Object[] arr = new Object[4];
        TypedAggregation aggregation = Aggregation.newAggregation(DeviceBackupOverView.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"id"}).sum(STORAGEUTILIZED).as(STORAGEUTILIZED).sum(NOOFSUCCESSFULRESTORES).as(NOOFSUCCESSFULRESTORES).sum(NOOFSUCCESSFULBACKUPS).as(NOOFSUCCESSFULBACKUPS), Aggregation.project((String[])new String[]{STORAGEUTILIZED, NOOFSUCCESSFULRESTORES, NOOFSUCCESSFULBACKUPS})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List overViewList = result.getMappedResults();
        for (BasicDBObject dbObject : overViewList) {
            totalDiskSpaceUsed += ((Long)dbObject.get(STORAGEUTILIZED)).longValue();
            noOfBackupsDone += Long.valueOf(dbObject.get(NOOFSUCCESSFULBACKUPS).toString()).longValue();
            noOfRestoresDone += Long.valueOf(dbObject.get(NOOFSUCCESSFULRESTORES).toString()).longValue();
        }
        if (!CollectionUtils.isEmpty((Collection)overViewList)) {
            arr[0] = totalDiskSpaceUsed;
            arr[1] = noOfBackupsDone;
            arr[2] = noOfRestoresDone;
            arr[3] = overViewList.size();
        } else {
            arr[0] = 0;
            arr[1] = 0;
            arr[2] = 0;
            arr[3] = 0;
        }
        return arr;
    }

    public Object[] getBackupRestoreCount(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Object[] arr = new Object[2];
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"status").is((Object)"COMPLETED")});
        TypedAggregation aggregation = Aggregation.newAggregation(BackupBatch.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"jobType"}).count().as("count"), Aggregation.project((String[])new String[]{"count", "jobType"})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List countDetailList = result.getMappedResults();
        if (!CollectionUtils.isEmpty((Collection)countDetailList)) {
            for (BasicDBObject dbObject : countDetailList) {
                String jobType = (String)dbObject.get("_id");
                if ("RESTORE".equalsIgnoreCase(jobType)) {
                    arr[0] = Long.valueOf(dbObject.get("count").toString());
                }
                if (!"BACKUP".equalsIgnoreCase(jobType)) continue;
                arr[1] = Long.valueOf(dbObject.get("count").toString());
            }
        } else {
            arr[0] = 0;
            arr[1] = 0;
        }
        return arr;
    }

    @Override
    public List<Device> getAllActiveDevices(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"blocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, Device.class);
    }

    public List<Device> getDevices(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        TypedAggregation aggregation = Aggregation.newAggregation(Device.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"blocked").is((Object)false)), Aggregation.group((String[])new String[]{"blocked", "user"}), Aggregation.project((String[])new String[]{"blocked", "user"})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List overViewList = result.getMappedResults();
        int i = 0;
        for (BasicDBObject dbObject : overViewList) {
            DBRef dbRef = (DBRef)dbObject.get("user");
            if (dbRef != null) continue;
            ++i;
        }
        return new ArrayList<Device>();
    }

    @Override
    public void updateClientVersion(int cloudId, String productVersion, String deviceUUID) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("clientVersion", (Object)productVersion);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.upsert(query, update, Device.class);
    }

    @Override
    public List<Device> getAllDevicesByName(int cloudId, String deviceName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"deviceName").is((Object)deviceName));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, Device.class);
        return list;
    }

    @Override
    public List<Device> getAllActiveDevices(int cloudId, int skipValue) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"blocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.logger.debug("   Skip value in getDevicesElement ...... " + skipValue);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return mongoTemplate.find(query, Device.class);
    }

    public void deleteAllDeviceOverViewByUser(int cloudId, User user) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria1 = new Criteria();
        criteria1.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
        Query query1 = new Query((CriteriaDefinition)criteria1);
        mongoTemplate.findAllAndRemove(query1, DeviceBackupOverView.class);
    }

    @Override
    public Map<String, List<Device>> getAllDevicesByUserName(int cloudId) {
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        HashMap<String, List<Device>> userAndDevices = new HashMap<String, List<Device>>();
        List list = mongoTemplate.findAll(Device.class);
        if (list != null) {
            this.logger.debug(" getAllDevicesByUserName ........ " + list.size());
        }
        for (Device device : list) {
            if (device == null || StringUtils.isEmpty((String)device.getUserName())) continue;
            DeviceDaoImpl.addValues(device.getUserName(), device, userAndDevices);
        }
        return userAndDevices;
    }

    @Override
    public void markAllDevicesAsInActiveForUser(int cloudId, String cloudName, User user) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)user.getUserName());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("blocked", (Object)true);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateMulti(query, update, Device.class);
    }

    @Override
    public void deleteAllDeviceByUserName(int cloudId, String cloudName, String userName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)mongoTemplate.findOne(query, User.class);
        this.deleteAllDeviceOverViewByUser(cloudId, user);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query1 = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query1, Device.class);
    }

    @Override
    public Device getDeviceById(int cloudId, ObjectId deviceId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)deviceId)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, Device.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (Device)list.get(0);
        }
        return null;
    }

    @Override
    public DeviceBackupOverView getDeviceBkpOverviewForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (DeviceBackupOverView)mongoTemplate.findOne(query, DeviceBackupOverView.class);
    }

    @Override
    public void updateUplodedFilesInBackupOverView(int cloudId, String deviceUUID, int uploadedFiles, long totalSize, long totalSizeToUpload) {
        try {
            Criteria criteria;
            Query query;
            DeviceBackupOverView deviceBackupOverView;
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            if (uploadedFiles > 0 && (deviceBackupOverView = (DeviceBackupOverView)mongoTemplate.findOne(query = new Query((CriteriaDefinition)(criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID))), DeviceBackupOverView.class)) != null) {
                Update update = new Update();
                if (!StringUtils.isEmpty((String)deviceBackupOverView.getNoOfFilesRemaining())) {
                    int filesRemaining = Integer.parseInt(deviceBackupOverView.getNoOfFilesRemaining());
                    if ((filesRemaining -= uploadedFiles) <= 0) {
                        filesRemaining = 0;
                    }
                    update.set("noOfFilesRemaining", (Object)filesRemaining);
                }
                update.inc("currentlyRunningBkpNoOfFiles", (Number)uploadedFiles);
                update.inc("currentlyRunningBkpTotalSizeOfFiles", (Number)(totalSize / 1024L));
                mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
            }
        }
        catch (NumberFormatException e) {
            this.logger.debug("NumberFormatException" + e);
            this.logger.error("NumberFormatException" + e.getMessage());
        }
    }

    @Override
    public void updateDeviceDeltaToken(int cloudId, String deviceUUID, String deltaToken) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("deltaToken", (Object)deltaToken);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, Device.class);
    }

    @Override
    public void updatePolicyNameInDeviceBkpOverview(int cloudId, String userName, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set("policyName", (Object)policyName);
        mongoTemplate.updateMulti(query, update, DeviceBackupOverView.class);
    }

    @Override
    public Device getODDeviceForUserName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"osType").is((Object)"ONEDRIVE")});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (Device)mongoTemplate.findOne(query, Device.class);
    }

    @Override
    public void updateDeviceDeltaToken(int cloudId, String deviceUUID, String deltaToken, String prevDeltaToken) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("deltaToken", (Object)deltaToken);
        update.set("prevDeltaToken", (Object)prevDeltaToken);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, Device.class);
    }

    @Override
    public List<Device> getDeviceByUserNameWithRegex(int cloudId, String userName) {
        List<Device> list = new ArrayList<Device>();
        if (StringUtils.isNotEmpty((String)userName)) {
            MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName, 2))});
            Query query = new Query((CriteriaDefinition)criteria);
            list = mongoTemplate.find(query, Device.class);
        }
        return list;
    }

    @Override
    public List<UserDefinedFolders> getAllUserDefinedInclusionFolders(int cloudId, String deviceUUID, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)FOLDER_TYPE).is((Object)FOLDER_TYPE_ENUM.INCLUSION.toString())});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, UserDefinedFolders.class);
    }

    @Override
    public List<UserDefinedFolders> getAllUserDefinedExclusionFolders(int cloudId, String deviceUUID, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)FOLDER_TYPE).is((Object)FOLDER_TYPE_ENUM.EXCLUSION.toString())});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, UserDefinedFolders.class);
    }

    @Override
    public Device getOutlookDeviceForUserName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"osType").is((Object)"OUTLOOK")});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (Device)mongoTemplate.findOne(query, Device.class);
    }

    @Override
    public Device getMailDeviceForUserName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"osType").is((Object)"OUTLOOK")});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (Device)mongoTemplate.findOne(query, Device.class);
    }

    @Override
    public RestoreEvents getRestoreEventsByUUID(int cloudId, String deviceUUID) {
        MongoTemplate paracloudMongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"destinationDeviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        return (RestoreEvents)paracloudMongoTemplate.findOne(query, RestoreEvents.class);
    }

    @Override
    public void saveO365BlackListUser(int cloudId, O365BlackListUser o365BlackListUser) {
        this.removeO365BlackListUser(cloudId, o365BlackListUser.getUserName());
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)o365BlackListUser);
    }

    public void removeO365BlackListUser(int cloudId, String userName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)USER_NAME).is((Object)userName));
        MongoTemplate mongoTemplate = this.blukryptMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndRemove(query, O365BlackListUser.class);
    }

    public static enum FOLDER_TYPE_ENUM {
        INCLUSION,
        EXCLUSION;

    }
}

