/*
 * Decompiled with CFR 0.152.
 */
package com.pg.controller;

import com.google.api.client.repackaged.org.apache.commons.codec.binary.Base64;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.RestoreEvents;
import com.parablu.pcbd.domain.RestoreProgressEvents;
import com.pg.domain.FileInfo;
import com.pg.element.PciAuthorizationTokenElement;
import com.pg.element.RestoreElement;
import com.pg.element.SharedFileImageElement;
import com.pg.exception.BlukryptClientAbortException;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.httpclient.util.HttpClientUtil;
import com.pg.paracloud.to.DownloadTO;
import com.pg.service.DownloadService;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.RestTemplate;

@Controller
public class DownloadController {
    private static Logger logger = LogManager.getLogger(DownloadController.class);
    private static final String FILE_NOT_FOUND = " file not found  ...........";
    @Autowired
    private DownloadService downloadService;
    @Autowired
    private UploadService uploadService;
    @Autowired
    private UtilService utilService;
    private static final String STOP_BACKUP_ERROR_CODE = "1207";

    @RequestMapping(value={"/download/externalFile/"}, method={RequestMethod.GET})
    public ResponseEntity<SharedFileImageElement> downloadExternalFile(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("  DOWNLOAD ExternalFile  STARTED ....");
        SharedFileImageElement element = new SharedFileImageElement();
        try {
            String fileName = request.getHeader("file-name");
            String folderPath = request.getHeader("file-path");
            String deviceUUID = request.getHeader("deviceUUID");
            String cloudName = request.getHeader("cloudName");
            String userName = request.getHeader("userName");
            String backupId = request.getHeader("backupId");
            String gatewayName = "db-001.parablu.com";
            PciAuthorizationTokenElement pciAuthorizationTokenElement = this.getPciAuthorizationTokenElement(cloudName, userName);
            String saltKey = this.getEncryptedKey(cloudName);
            logger.debug("  SALT KEY ..................... " + saltKey);
            DownloadTO downloadTO = this.downloadService.restoreFileForExternalStorage(pciAuthorizationTokenElement, fileName, folderPath, saltKey, deviceUUID, backupId, gatewayName, true);
            response.addHeader("file-size", String.valueOf(downloadTO.getSize()));
            response.setStatus(200);
            response.addHeader("fileMD5", downloadTO.getMd5());
            element.setFileName(fileName);
            element.setCloudName(cloudName);
            element.setUserName(userName);
            element.setSharedForDownload(true);
            element.setSharedTimeStamp(System.currentTimeMillis());
            element.setDevicePath("download/filename");
            logger.debug(fileName + "  DOWNLOAD ExternalFile  Completed ...." + userName);
            response.setStatus(200);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("  UNALBE TO DOWNLOAD FILE " + e.getMessage());
            response.setStatus(500);
        }
        logger.debug("  DOWNLOAD ExternalFile  Completed ....");
        return new ResponseEntity((Object)element, HttpStatus.OK);
    }

    private PciAuthorizationTokenElement getPciAuthorizationTokenElement(String cloudName, String userName) {
        HttpComponentsClientHttpRequestFactory reqFactory = HttpClientUtil.getHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)reqFactory);
        ArrayList<MappingJackson2HttpMessageConverter> messageConverters = new ArrayList<MappingJackson2HttpMessageConverter>();
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        HttpHeaders headers = new HttpHeaders();
        headers.add("userName", userName);
        org.springframework.http.HttpEntity entity = new org.springframework.http.HttpEntity((Object)"parameters", (MultiValueMap)headers);
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/pcitoken";
        ResponseEntity result = restTemplate.exchange(url, HttpMethod.GET, entity, PciAuthorizationTokenElement.class, new Object[0]);
        PciAuthorizationTokenElement pciAuthorizationTokenElement = (PciAuthorizationTokenElement)result.getBody();
        pciAuthorizationTokenElement.setUserName(userName);
        pciAuthorizationTokenElement.setCloudName(cloudName);
        try {
            reqFactory.destroy();
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Getting PCI Authorization Token Element :" + e.getMessage());
        }
        return pciAuthorizationTokenElement;
    }

    @RequestMapping(value={"/ping1"}, method={RequestMethod.GET})
    public ResponseEntity<SharedFileImageElement> testping() {
        logger.debug(" Inside privacy gateway ....");
        SharedFileImageElement element = new SharedFileImageElement();
        logger.debug(" end of privacy gateway ....");
        return new ResponseEntity((Object)element, HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEncryptedKey(String cloudName) {
        logger.debug(" getEncryptedKey ..... ");
        HttpClient httpclient = HttpClientUtil.getSSlConnection();
        HttpPost httpPost = null;
        String saltKey = null;
        String url = PCHelperConstant.getPropertyFileValueForParacloudUrl() + "/paracloud/cloud/" + cloudName + "/load/encryptionKey/";
        httpPost = new HttpPost(url);
        HttpResponse response = null;
        try {
            Header[] headerarr;
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
            httpPost.setEntity((HttpEntity)entity);
            response = httpclient.execute((HttpUriRequest)httpPost);
            for (Header header : headerarr = response.getAllHeaders()) {
                if (!"saltKey".equals(header.getName())) continue;
                saltKey = header.getValue();
                logger.debug("Recieved backup Id for file ..... " + saltKey);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception While Getting Encyption Key :" + e.getMessage());
        }
        finally {
            httpPost.releaseConnection();
            httpclient.getConnectionManager().closeIdleConnections(1L, TimeUnit.MICROSECONDS);
            httpclient.getConnectionManager().shutdown();
        }
        return saltKey;
    }

    @RequestMapping(value={"/download/files/"}, method={RequestMethod.GET})
    public void downloadAllFilesForDevicePath(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling ..../download/files/");
        this.downloadFiles(request, response, false);
    }

    @RequestMapping(value={"versions/{versionNumber}/cloud/{cloudName}/download/files"}, method={RequestMethod.GET})
    public void downloadAllFilesForDevicePathForFLS(HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling  new API..../download/files/");
        this.downloadFiles(request, response, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFiles(HttpServletRequest request, HttpServletResponse response, boolean isEncodeEnable) {
        String restorePath = "";
        String deviceMntPath = "";
        boolean isrestoreDeletedFile = true;
        int skipValue = 0;
        long count = 0L;
        long downloadedCount = 0L;
        long restoredFoldersCount = 0L;
        long foldersToRestoreCount = 0L;
        long restoredSize = 0L;
        try {
            BackupBatch lastRestoreBatch;
            RestoreElement restoreElement = this.getRestoreElementFromRequesttoFLS(request);
            String sourceDeviceUUID = request.getHeader("sourceDeviceUUID");
            logger.debug("................." + request.getHeader("sourceDeviceUUID"));
            String isChunkLevelRestore = request.getHeader("restore-by-chunks");
            String skipValueStr = request.getHeader("skip-value");
            String countStr = request.getHeader("count");
            String serverModifiedTime = "";
            if (!StringUtils.isEmpty((String)request.getHeader("pointIntimeRestoreTimeStamp"))) {
                serverModifiedTime = request.getHeader("pointIntimeRestoreTimeStamp");
            }
            String isImmediateFolderLevel = request.getHeader("immediate-folder-level");
            if (!StringUtils.isEmpty((String)skipValueStr)) {
                skipValue = Integer.valueOf(skipValueStr);
            }
            if (!StringUtils.isEmpty((String)countStr)) {
                downloadedCount = Long.valueOf(countStr);
            }
            String restoredFoldersCountStr = request.getHeader("restored-folders-count");
            String foldersToRestoreCountStr = request.getHeader("folders-to-restore-count");
            String restoredSizeStr = request.getHeader("restored-size");
            String restoreDeletedFileStr = request.getHeader("restoreDeletedFile");
            if (!StringUtils.isEmpty((String)restoreDeletedFileStr)) {
                isrestoreDeletedFile = Boolean.valueOf(restoreDeletedFileStr);
            }
            logger.debug("...isrestoreDeletedFile..." + isrestoreDeletedFile);
            logger.debug("...restoredFoldersCountStr..." + restoredFoldersCountStr);
            logger.debug("...foldersToRestoreCountStr..." + foldersToRestoreCountStr);
            logger.debug("...restoredSizeStr..." + restoredSizeStr);
            logger.debug("......devicePath......." + restoreElement.getDevicePath());
            if (!StringUtils.isEmpty((String)restoredFoldersCountStr)) {
                restoredFoldersCount = Long.valueOf(restoredFoldersCountStr);
            }
            if (!StringUtils.isEmpty((String)foldersToRestoreCountStr)) {
                foldersToRestoreCount = Long.valueOf(foldersToRestoreCountStr);
            }
            if (!StringUtils.isEmpty((String)restoredSizeStr)) {
                restoredSize = Long.valueOf(restoredSizeStr);
            }
            if (StringUtils.isNotEmpty((String)sourceDeviceUUID) && (lastRestoreBatch = this.utilService.getLastRestoreBatch(1, sourceDeviceUUID)) != null && StringUtils.isNotEmpty((String)lastRestoreBatch.getErrorCode())) {
                logger.debug("............batch......." + lastRestoreBatch.getErrorCode());
                if (lastRestoreBatch.getErrorCode().equalsIgnoreCase(STOP_BACKUP_ERROR_CODE)) {
                    response.setStatus(429);
                    return;
                }
            }
            this.updateRestoreProgress(restoredFoldersCount, foldersToRestoreCount, restoredSize, restoreElement, sourceDeviceUUID);
            String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)restoreElement.getCloudName()) + restoreElement.getDeviceUUID() + GeneralHelperConstant.CLOUD_PATH_SEPARATOR;
            restorePath = path + restoreElement.getRestoreBatchId() + "/";
            deviceMntPath = path;
            int cloudId = 1;
            Cloud cloud = this.utilService.getCloud(cloudId);
            String userName = this.utilService.getUserNameFromDevice(cloudId, restoreElement.getDeviceUUID());
            logger.debug("##Start of full restore of device .... " + userName + " ... device .... " + restoreElement.getDeviceUUID());
            logger.error(count + " RESTORE-total count new ........ " + restoreElement.getDevicePath());
            try {
                response.setContentType("text/html; charset=UTF-8");
                response.getOutputStream().println("Content-Type: multipart/form-data;boundary=--PARABLUEOF");
            }
            catch (IOException e2) {
                logger.trace("" + e2);
                logger.error("Exception While Downloading All Files For Device Path :" + e2.getMessage());
            }
            boolean downloadCompleted = false;
            HashMap<String, Long> fileVersionMap = new HashMap<String, Long>();
            while (!downloadCompleted) {
                BackupBatch lastRestoreBatch2;
                downloadedCount = StringUtils.isEmpty((String)isChunkLevelRestore) ? this.downloadService.restoreFilesFromCloud(cloud, restoreElement, userName, response, skipValue, count, downloadedCount, fileVersionMap, isEncodeEnable, serverModifiedTime) : this.downloadService.restoreFilesFromCloudNew(cloud, restoreElement, userName, response, skipValue, count, downloadedCount, fileVersionMap, isImmediateFolderLevel, isEncodeEnable, serverModifiedTime, isrestoreDeletedFile);
                ++skipValue;
                if (!StringUtils.isEmpty((String)restoreElement.getBackupId())) {
                    downloadedCount = -1L;
                }
                if (downloadedCount == -1L) {
                    response.setHeader("isDownloadComplete", Boolean.TRUE.toString());
                    downloadCompleted = true;
                    logger.error("Download completed .... ");
                } else {
                    response.setHeader("isDownloadComplete", Boolean.FALSE.toString());
                    logger.error(downloadedCount + " ... Download not completed .... " + skipValue);
                }
                if (!StringUtils.isNotEmpty((String)sourceDeviceUUID) || (lastRestoreBatch2 = this.utilService.getLastRestoreBatch(1, sourceDeviceUUID)) == null || !StringUtils.isNotEmpty((String)lastRestoreBatch2.getErrorCode())) continue;
                logger.debug("............batch......." + lastRestoreBatch2.getErrorCode());
                if (!lastRestoreBatch2.getErrorCode().equalsIgnoreCase(STOP_BACKUP_ERROR_CODE)) continue;
                response.setStatus(429);
                break;
            }
            response.getOutputStream().println();
            response.getOutputStream().write("----PARABLUEOF--\r\n".getBytes());
            response.getOutputStream().close();
        }
        catch (BlukryptClientAbortException e) {
            logger.trace("" + (Object)((Object)e));
            logger.error("Client aborted ........" + e.getErrMsg());
            response.setStatus(500);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("  UNALBE TO DOWNLOAD FILE " + e.getMessage());
            response.setStatus(500);
        }
        finally {
            try {
                logger.debug(restorePath + " inside finally block ..... " + deviceMntPath);
                response.getOutputStream().close();
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error("Client abort exception ......" + e.getMessage());
            }
        }
        logger.debug(" download completed .... ");
    }

    private void updateRestoreProgress(long restoredFoldersCount, long foldersToRestoreCount, long restoredSize, RestoreElement restoreElement, String sourceDeviceUUID) {
        if (foldersToRestoreCount != 0L && !StringUtils.isEmpty((String)sourceDeviceUUID)) {
            logger.debug("......saving.....");
            RestoreEvents restoreEventByUUID = this.utilService.getRestoreEventByUUID(1, sourceDeviceUUID);
            if (restoreEventByUUID != null) {
                RestoreProgressEvents events = new RestoreProgressEvents();
                events.setId(restoreEventByUUID.getId());
                events.setDeviceUUID(sourceDeviceUUID);
                events.setTotalsize(restoredSize);
                events.setTotalNoOfFilesForRestore(foldersToRestoreCount);
                events.setTotalNoOfRestoreFilesForFolder(restoredFoldersCount);
                this.utilService.saveOrUpdateRestoreForEndPoint(1, events);
            }
        }
    }

    private void deleteDirs(String restorePath, String deviceMntPath) {
        File restoreDir;
        if (!StringUtils.isEmpty((String)restorePath) && (restoreDir = new File(restorePath)).exists()) {
            try {
                FileUtils.forceDelete((File)restoreDir);
            }
            catch (IOException e1) {
                logger.debug(" Unable to delete ... " + e1);
                logger.error(" Unable to delete ... " + e1.getMessage());
                logger.error(" unable to delete ... " + restoreDir);
            }
        }
    }

    private RestoreElement getRestoreElementFromRequesttoFLS(HttpServletRequest request) {
        RestoreElement restoreElement = new RestoreElement();
        String deviceUUID = request.getHeader("deviceUUID");
        String cloudName = request.getHeader("cloudName");
        String restoreId = request.getHeader("restoreBatchId");
        String headerEncoding = request.getHeader("header-encoding");
        String devicePath = request.getHeader("devicePath");
        String fileName = request.getHeader("fileName");
        if (StringUtils.isNotEmpty((String)headerEncoding)) {
            if ("base64".equalsIgnoreCase(headerEncoding) && StringUtils.isNotEmpty((String)devicePath)) {
                devicePath = this.decodeBase64UTFString(request.getHeader("devicePath"));
            }
            if ("base64".equalsIgnoreCase(headerEncoding) && StringUtils.isNotEmpty((String)fileName)) {
                fileName = this.decodeBase64UTFString(request.getHeader("fileName"));
            }
        }
        String downloadAllVersions = request.getHeader("downloadAllVersions");
        String backupId = request.getHeader("backupId");
        boolean isDownloadAllVersions = false;
        if (!StringUtils.isEmpty((String)downloadAllVersions)) {
            isDownloadAllVersions = Boolean.parseBoolean(request.getHeader("downloadAllVersions"));
        }
        restoreElement.setDeviceUUID(deviceUUID);
        restoreElement.setCloudName(cloudName);
        restoreElement.setRestoreBatchId(restoreId);
        restoreElement.setDevicePath(devicePath);
        restoreElement.setFileName(fileName);
        restoreElement.setDownloadAllVersions(isDownloadAllVersions);
        restoreElement.setBackupId(backupId);
        return restoreElement;
    }

    @RequestMapping(value={"download/frompg/"}, method={RequestMethod.GET})
    public ResponseEntity<byte[]> downloadFromPG(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filePath = request.getHeader("filePath");
        logger.error("start download/frompg/ path .........." + filePath);
        File file = new File(filePath);
        if (!file.exists()) {
            logger.debug(FILE_NOT_FOUND + filePath);
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        byte[] array = Files.readAllBytes(file.toPath());
        ResponseEntity entity = new ResponseEntity((Object)array, HttpStatus.OK);
        logger.error("end of  download/frompg/ ... ...........");
        return entity;
    }

    @RequestMapping(value={"get/fileInfo/"}, method={RequestMethod.GET})
    public ResponseEntity<FileInfo> getFileInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String cloudName = request.getHeader("cloudName");
        String backupId = request.getHeader("backupId");
        logger.error(backupId + " get/fileInfo/  ..........." + cloudName);
        FileInfo fileInfo = this.uploadService.getBackupFileInfo(cloudName, "", "", backupId);
        if (fileInfo == null) {
            logger.debug(cloudName + FILE_NOT_FOUND + backupId);
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        ResponseEntity entity = new ResponseEntity((Object)fileInfo, HttpStatus.OK);
        logger.error(" end of get/fileInfo/  ... ...........");
        return entity;
    }

    @RequestMapping(value={"get/user/fileInfo/"}, method={RequestMethod.GET})
    public ResponseEntity<FileInfo> getUserFileInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String cloudName = request.getHeader("cloudName");
        String userName = request.getHeader("userName");
        String backupId = request.getHeader("backupId");
        logger.error(backupId + " get/fileInfo/  ..........." + cloudName + "...userName.." + userName);
        logger.debug(cloudName + FILE_NOT_FOUND + backupId);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    protected String decodeBase64UTFString(String encodedString) {
        String decodedString = encodedString;
        try {
            decodedString = new String(Base64.decodeBase64((String)encodedString), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("" + e);
            logger.error("" + e.getMessage());
            logger.debug("UnsupportedEncodingException", (Throwable)e);
        }
        return decodedString;
    }
}

