/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.util;

import com.sibvisions.util.log.ILogger;
import com.sibvisions.util.log.LoggerFactory;
import java.lang.reflect.Method;

public class UIInvoker {
    private static ILogger log = LoggerFactory.getInstance(UIInvoker.class);
    private Object oThreadFactory = null;

    public UIInvoker() {
        try {
            Class<?> clazz = Class.forName("javax.rad.genui.UIFactoryManager");
            try {
                Method method = clazz.getMethod("getFactory", new Class[0]);
                this.oThreadFactory = method.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                log.error("'UIFactoryManager.getFactory()' threw an exception. Invoke direct!", exception);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug("'UIFactoryManager' is not available. Invoke direct!");
        }
    }

    public void invokeLater(Runnable runnable) {
        boolean bl = false;
        if (this.oThreadFactory != null) {
            try {
                Method method = this.oThreadFactory.getClass().getMethod("invokeLater", Runnable.class);
                method.invoke(this.oThreadFactory, runnable);
                log.debug("invokeLater() of '", this.oThreadFactory.getClass().getName(), "' successful called!");
            }
            catch (Exception exception) {
                log.info("An UI factory is available: '", this.oThreadFactory.getClass().getName(), "', but it's not possible to call invokeLater(). Invoke direct!");
                bl = true;
            }
        } else {
            log.info("UI factory is NOT available. Invoke direct!");
            bl = true;
        }
        if (bl) {
            runnable.run();
        }
    }
}

