/*
 * Decompiled with CFR 0.152.
 */
package javax.rad.genui.component;

import com.sibvisions.util.type.StringUtil;
import java.util.regex.Pattern;
import javax.rad.genui.UIInsets;
import javax.rad.genui.component.AbstractUILabeledIcon;
import javax.rad.ui.IInsets;
import javax.rad.ui.component.IActionComponent;
import javax.rad.ui.event.ActionHandler;
import javax.rad.ui.event.IActionListener;
import javax.rad.ui.event.Key;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUIActionComponent<C extends IActionComponent>
extends AbstractUILabeledIcon<C>
implements IActionComponent {
    private static final Pattern FULLY_QUALIFIED_CLASSNAME_PATTERN = Pattern.compile("^[a-zA-Z]+(\\.[a-zA-Z]+)+$");

    protected AbstractUIActionComponent(C c) {
        super(c);
    }

    @Override
    public void setAccelerator(Key key) {
        ((IActionComponent)this.uiResource).setAccelerator(key);
    }

    @Override
    public Key getAccelerator() {
        return ((IActionComponent)this.uiResource).getAccelerator();
    }

    @Override
    public String getActionCommand() {
        return ((IActionComponent)this.uiResource).getActionCommand();
    }

    @Override
    public void setActionCommand(String string) {
        ((IActionComponent)this.uiResource).setActionCommand(string);
    }

    @Override
    public ActionHandler eventAction() {
        return ((IActionComponent)this.uiResource).eventAction();
    }

    @Override
    public IInsets getMargins() {
        return ((IActionComponent)this.uiResource).getMargins();
    }

    @Override
    public void setMargins(IInsets iInsets) {
        if (iInsets instanceof UIInsets) {
            ((IActionComponent)this.uiResource).setMargins((IInsets)((UIInsets)iInsets).getUIResource());
        } else {
            ((IActionComponent)this.uiResource).setMargins(iInsets);
        }
    }

    @Override
    protected String createComponentName() {
        String string = this.getNameFromActionListeners();
        String string2 = this.getActionCommand();
        if (!StringUtil.isEmpty(string2)) {
            if (FULLY_QUALIFIED_CLASSNAME_PATTERN.matcher(string2).matches()) {
                string2 = StringUtil.getShortenedWords(string2, 3);
                string2 = string2.replace('.', '-');
            }
            string = !StringUtil.isEmpty(string) ? string + "_" + string2 : string2;
        }
        if (!StringUtil.isEmpty(string)) {
            String string3 = "";
            if (this.getRootName() != null) {
                string3 = this.getRootName() + "_";
            }
            return AbstractUIActionComponent.incrementNameIfExists(string3 + this.createSimplifiedClassName() + "_" + string.toUpperCase(), this.getExistingNames(), false);
        }
        return super.createComponentName();
    }

    public void setMargins(int n, int n2, int n3, int n4) {
        ((IActionComponent)this.uiResource).setMargins(this.getFactory().createInsets(n, n2, n3, n4));
    }

    private String getNameFromActionListeners() {
        for (IActionListener iActionListener : (IActionListener[])this.eventAction().getListeners()) {
            String[] stringArray;
            String[] stringArray2;
            String string;
            String string2 = iActionListener.toString();
            if (string2 == null || string2.contains("@")) continue;
            int n = string2.indexOf(" -> ");
            if (n >= 0) {
                string2 = string2.substring(n + 4);
            }
            if ((string = (stringArray2 = (stringArray = string2.split("\\("))[0].split("[\\. ]"))[stringArray2.length - 1]).contains(" ") || string.contains(".")) continue;
            return string;
        }
        return null;
    }
}

