/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import java.io.IOException;
import java.util.ArrayList;

public class StringParser {
    private final char chSeparator;
    private final char chQuote;
    private final char chEscape;
    private String sPending;
    private boolean bMustQuote;
    private boolean bIgnoreLeadingWhiteSpace;
    private boolean bInField = false;
    private boolean bRemoveQuotes = true;

    public StringParser(char c) {
        this(c, '\"', '\\');
    }

    public StringParser(char c, char c2) {
        this(c, c2, '\\');
    }

    public StringParser(char c, char c2, char c3) {
        this.chSeparator = c;
        this.chQuote = c2;
        this.chEscape = c3;
    }

    public String[] parse(String string) throws IOException {
        return this.parse(string, true);
    }

    public String[] parse(String string, boolean bl) throws IOException {
        this.sPending = null;
        this.bInField = false;
        return this.parseText(string, bl);
    }

    private String[] parseText(String string, boolean bl) throws IOException {
        if (!bl && this.sPending != null) {
            this.sPending = null;
        }
        if (string == null) {
            if (this.sPending != null) {
                String string2 = this.sPending;
                this.sPending = null;
                return new String[]{string2};
            }
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl2 = false;
        if (this.sPending != null) {
            stringBuilder.append(this.sPending);
            this.sPending = null;
            bl2 = true;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == this.chEscape) {
                if (!this.isNextCharacterEscapable(string, bl2 || this.bInField, i)) continue;
                if (!this.bRemoveQuotes) {
                    stringBuilder.append(string.charAt(i));
                }
                stringBuilder.append(string.charAt(i + 1));
                ++i;
                continue;
            }
            if (c == this.chQuote) {
                if (this.isNextCharacterEscapedQuote(string, bl2 || this.bInField, i)) {
                    stringBuilder.append(string.charAt(i + 1));
                    ++i;
                } else {
                    if (!this.bMustQuote) {
                        if (i > 2 && string.charAt(i - 1) != this.chSeparator && string.length() > i + 1 && string.charAt(i + 1) != this.chSeparator) {
                            if (this.bIgnoreLeadingWhiteSpace && stringBuilder.length() > 0 && this.isAllWhiteSpace(stringBuilder)) {
                                stringBuilder.setLength(0);
                            } else {
                                stringBuilder.append(c);
                            }
                        } else if (!this.bRemoveQuotes) {
                            stringBuilder.append(c);
                        }
                    }
                    bl2 = !bl2;
                }
                this.bInField = !this.bInField;
                continue;
            }
            if (c == this.chSeparator && !bl2) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                this.bInField = false;
                continue;
            }
            if (this.bMustQuote && !bl2) continue;
            stringBuilder.append(c);
            this.bInField = true;
        }
        if (bl2) {
            if (bl) {
                stringBuilder.append("\n");
                this.sPending = stringBuilder.toString();
                stringBuilder = null;
            } else {
                throw new IOException("Un-terminated quoted field at end of text");
            }
        }
        if (stringBuilder != null) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean isPending() {
        return this.sPending != null;
    }

    private boolean isNextCharacterEscapedQuote(String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && string.charAt(n + 1) == this.chQuote;
    }

    protected boolean isNextCharacterEscapable(String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && (string.charAt(n + 1) == this.chQuote || string.charAt(n + 1) == this.chEscape);
    }

    protected boolean isAllWhiteSpace(CharSequence charSequence) {
        boolean bl = true;
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(charSequence.charAt(i))) continue;
            return false;
        }
        return bl;
    }

    public void setRemoveQuotes(boolean bl) {
        this.bRemoveQuotes = bl;
    }

    public boolean isRemoveQuotes() {
        return this.bRemoveQuotes;
    }

    public void setMustQuote(boolean bl) {
        this.bMustQuote = bl;
    }

    public boolean isMustQuote() {
        return this.bMustQuote;
    }

    public void setIgnoreLeadingWhiteSpace(boolean bl) {
        this.bIgnoreLeadingWhiteSpace = bl;
    }

    public boolean isIgnoreLeadingWhiteSpace() {
        return this.bIgnoreLeadingWhiteSpace;
    }
}

