/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util.type;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.FileSearch;
import com.sibvisions.util.type.CommonUtil;
import com.sibvisions.util.type.DateUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.util.Calendar;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtil {
    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equals(File file, File file2) {
        boolean bl;
        FileInputStream fileInputStream;
        FileInputStream fileInputStream2;
        block9: {
            if (file == null) return false;
            if (file2 == null) return false;
            if (!file.exists()) return false;
            if (!file2.exists()) return false;
            if (file.length() != file2.length()) return false;
            if (file.equals(file2)) return true;
            fileInputStream2 = null;
            fileInputStream = null;
            try {
                fileInputStream2 = new FileInputStream(file);
                fileInputStream = new FileInputStream(file2);
                byte[] byArray = new byte[4096];
                byte[] byArray2 = new byte[4096];
                block5: while (true) {
                    int n;
                    if ((n = ((InputStream)fileInputStream2).read(byArray)) < 0) {
                        CommonUtil.close(fileInputStream2, fileInputStream);
                        return true;
                    }
                    ((InputStream)fileInputStream).read(byArray2);
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block5;
                        if (byArray[n2] != byArray2[n2]) {
                            bl = false;
                            break block9;
                        }
                        ++n2;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                boolean bl2;
                try {
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    CommonUtil.close(fileInputStream2, fileInputStream);
                    throw throwable;
                }
                CommonUtil.close(fileInputStream2, fileInputStream);
                return bl2;
            }
        }
        CommonUtil.close(fileInputStream2, fileInputStream);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream inputStream, File file) throws IOException {
        long l;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            long l2 = 0L;
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                bufferedOutputStream.write(byArray, 0, n);
                l2 += (long)n;
            }
            bufferedOutputStream.flush();
            l = l2;
        }
        catch (Throwable throwable) {
            CommonUtil.close(bufferedOutputStream);
            throw throwable;
        }
        CommonUtil.close(bufferedOutputStream);
        return l;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return FileUtil.copy(inputStream, false, outputStream, false);
    }

    public static long copy(InputStream inputStream, boolean bl, OutputStream outputStream, boolean bl2) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        outputStream.flush();
        if (bl) {
            CommonUtil.close(inputStream);
        }
        if (bl2) {
            CommonUtil.close(outputStream);
        }
        return l;
    }

    public static void copy(File file, File file2, String ... stringArray) throws IOException {
        FileUtil.copy(file, file2, CopyMode.Overwrite, stringArray);
    }

    public static void copy(File file, File file2, CopyMode copyMode, String ... stringArray) throws IOException {
        if (file.isFile()) {
            FileUtil.copyFile(file, file2, copyMode);
        } else if (file.isDirectory()) {
            FileUtil.copyDirectory(file, file2, copyMode, stringArray);
        } else {
            throw new IOException("File or directory is required: '" + file.getAbsolutePath() + "'!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2, CopyMode copyMode) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (file2.exists()) {
            if (copyMode == CopyMode.Keep) {
                return;
            }
            if (copyMode == CopyMode.Backup) {
                object3 = DateUtil.format(Calendar.getInstance().getTime(), "dd_MM_yyyy_HH_mm_ss");
                object2 = FileUtil.getExtension(file2.getName());
                object = new File(file2.getParent(), FileUtil.removeExtension(file2.getName()) + "_" + (String)object3 + (object2 != null ? "." + (String)object2 : ""));
                if (!file2.renameTo((File)object)) {
                    throw new IOException("Can't rename file '" + file2.getAbsolutePath() + "' to '" + ((File)object).getAbsolutePath() + "'!");
                }
            }
        }
        object3 = null;
        object2 = null;
        object = null;
        FileChannel fileChannel = null;
        try {
            if (!file2.exists()) {
                File file3 = file2.getParentFile();
                if (file3 != null) {
                    file3.mkdirs();
                }
            } else if (file2.isDirectory()) {
                file2 = new File(file2, file.getName());
            }
            object3 = new FileInputStream(file);
            object2 = new FileOutputStream(file2);
            object = ((FileInputStream)object3).getChannel();
            fileChannel = ((FileOutputStream)object2).getChannel();
            long l = ((FileChannel)object).size();
            ((FileChannel)object).transferTo(0L, l, fileChannel);
        }
        catch (Throwable throwable) {
            CommonUtil.close(object, object3, fileChannel, object2);
            throw throwable;
        }
        CommonUtil.close(object, object3, fileChannel, object2);
    }

    private static void copyDirectory(File file, File file2, CopyMode copyMode, String ... stringArray) throws IOException {
        File file3;
        FileSearch fileSearch = new FileSearch();
        fileSearch.search(file, true, stringArray);
        int n = file.getAbsolutePath().length();
        for (Map.Entry<String, List<String>> object : fileSearch.getFilesPerDirectory().entrySet()) {
            File file4 = new File(object.getKey());
            file3 = new File(file2, object.getKey().substring(n));
            if (!file3.exists() && !file3.mkdirs()) {
                throw new IOException("Can't create directory '" + file3.getAbsolutePath() + "'!");
            }
            for (String string : object.getValue()) {
                FileUtil.copyFile(new File(file4, string), new File(file3, string), copyMode);
            }
        }
        if (file.exists() && fileSearch.getFoundFiles().isEmpty() && fileSearch.getFoundDirectories().isEmpty()) {
            file2.mkdirs();
        }
        for (String string : fileSearch.getFoundDirectories()) {
            file3 = new File(file2, string.substring(n));
            if (file3.exists()) continue;
            file3.mkdirs();
        }
    }

    public static void move(File file, File file2) throws IOException {
        FileUtil.move(file, file2, CopyMode.Overwrite);
    }

    public static void move(File file, File file2, CopyMode copyMode) throws IOException {
        if (file.equals(file2)) {
            return;
        }
        if (file.isFile()) {
            FileUtil.moveFile(file, file2, copyMode);
        } else if (file.isDirectory()) {
            FileUtil.moveDirectory(file, file2, copyMode);
        } else {
            throw new IOException("File or directory is required: '" + file.getAbsolutePath() + "'!");
        }
    }

    private static void moveFile(File file, File file2, CopyMode copyMode) throws IOException {
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        if (file2.exists()) {
            if (file2.isDirectory()) {
                throw new IOException("Can't move '" + file.getAbsolutePath() + "' to directory '" + file2.getAbsolutePath() + "'!");
            }
            if (copyMode == null || copyMode == CopyMode.Overwrite) {
                if (!file2.delete()) {
                    throw new IOException("Can't overwrite '" + file2.getAbsolutePath() + "'!");
                }
            } else {
                if (copyMode == CopyMode.Keep) {
                    return;
                }
                String string = DateUtil.format(Calendar.getInstance().getTime(), "dd_MM_yyyy_HH_mm_ss");
                String string2 = FileUtil.getExtension(file2.getName());
                File file3 = new File(file2.getParent(), FileUtil.removeExtension(file2.getName()) + "_" + string + (string2 != null ? "." + string2 : ""));
                if (!file2.renameTo(file3)) {
                    throw new IOException("Can't rename file '" + file2.getAbsolutePath() + "' to '" + file3.getAbsolutePath() + "'!");
                }
            }
        } else {
            File file4 = file2.getParentFile();
            if (file4 != null) {
                file4.mkdirs();
            }
        }
        if (!file.renameTo(file2)) {
            throw new IOException("Can't move '" + file.getAbsolutePath() + "' to '" + file2.getAbsolutePath() + "'!");
        }
    }

    private static void moveDirectory(File file, File file2, CopyMode copyMode) throws IOException {
        if (file2.exists()) {
            if (file2.isFile()) {
                throw new IOException("Can't move '" + file.getAbsolutePath() + "' to file '" + file2.getAbsolutePath() + "'!");
            }
            if (copyMode == null || copyMode == CopyMode.Overwrite || copyMode == CopyMode.Keep) {
                FileUtil.copyDirectory(file, file2, copyMode, new String[0]);
                FileUtil.delete(file, new String[0]);
                return;
            }
            String string = DateUtil.format(Calendar.getInstance().getTime(), "dd_MM_yyyy_HH_mm_ss");
            File file3 = new File(file2.getAbsolutePath() + "_" + string);
            if (!file2.renameTo(file3)) {
                throw new IOException("Can't rename file '" + file2.getAbsolutePath() + "' to '" + file3.getAbsolutePath() + "'!");
            }
        } else {
            file2.getParentFile().mkdirs();
        }
        if (!file.renameTo(file2)) {
            if (!file2.mkdirs()) {
                throw new IOException("Can't move '" + file.getAbsolutePath() + "' to '" + file2.getAbsolutePath() + "' because create target directory failed!");
            }
            FileUtil.copyDirectory(file, file2, CopyMode.Overwrite, new String[0]);
            if (file.exists() && !file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    public static byte[] getContent(InputStream inputStream) {
        return FileUtil.getContent(inputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(InputStream inputStream, boolean bl) {
        if (inputStream != null) {
            byte[] byArray;
            block7: {
                BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray2 = new byte[8192];
                try {
                    int n;
                    while ((n = bufferedInputStream.read(byArray2)) >= 0) {
                        byteArrayOutputStream.write(byArray2, 0, n);
                    }
                    byteArrayOutputStream.close();
                    byArray = byteArrayOutputStream.toByteArray();
                    if (!bl) break block7;
                }
                catch (IOException iOException) {
                    byte[] byArray3;
                    block8: {
                        try {
                            byArray3 = null;
                            if (!bl) break block8;
                        }
                        catch (Throwable throwable) {
                            if (bl) {
                                CommonUtil.close(bufferedInputStream);
                            }
                            throw throwable;
                        }
                        CommonUtil.close(bufferedInputStream);
                    }
                    return byArray3;
                }
                CommonUtil.close(bufferedInputStream);
            }
            return byArray;
        }
        return null;
    }

    public static byte[] getContent(File file) throws IOException {
        if (file == null) {
            throw new IOException("File not found: null");
        }
        return FileUtil.getContent(file.getAbsolutePath());
    }

    public static byte[] getContent(String string) throws IOException {
        if (string == null) {
            throw new IOException("File not found: null");
        }
        return FileUtil.getContent(new FileInputStream(string), true);
    }

    public static byte[] getContent(InputStreamReader inputStreamReader) {
        return FileUtil.getContent(inputStreamReader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(InputStreamReader inputStreamReader, boolean bl) {
        if (inputStreamReader != null) {
            byte[] byArray;
            block9: {
                OutputStreamWriter outputStreamWriter;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, inputStreamReader.getEncoding());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    return null;
                }
                char[] cArray = new char[8192];
                try {
                    int n;
                    while ((n = inputStreamReader.read(cArray)) >= 0) {
                        outputStreamWriter.write(cArray, 0, n);
                    }
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                    byteArrayOutputStream.close();
                    byArray = byteArrayOutputStream.toByteArray();
                    if (!bl) break block9;
                }
                catch (IOException iOException) {
                    byte[] byArray2;
                    block10: {
                        try {
                            byArray2 = null;
                            if (!bl) break block10;
                        }
                        catch (Throwable throwable) {
                            if (bl) {
                                CommonUtil.close(inputStreamReader);
                            }
                            throw throwable;
                        }
                        CommonUtil.close(inputStreamReader);
                    }
                    return byArray2;
                }
                CommonUtil.close(inputStreamReader);
            }
            return byArray;
        }
        return null;
    }

    public static String removeExtension(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    public static File getNotExistingFile(File file) {
        return FileUtil.getNotExistingFile(file, "[", "]");
    }

    public static File getNotExistingFile(File file, String string, String string2) {
        String string3 = FileUtil.getExtension(file.getName());
        String string4 = FileUtil.removeExtension(file.getName());
        int n = 1;
        while (file.exists()) {
            file = new File(file.getParent(), string4 + string + n + string2 + "." + string3);
            ++n;
        }
        return file;
    }

    public static String getName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n < 0) {
            n = string.lastIndexOf(92);
        }
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getDirectory(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n < 0) {
            n = string.lastIndexOf(92);
        }
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public static String formatAsDirectory(String string) {
        if (string == null) {
            return null;
        }
        char c = string.charAt(string.length() - 1);
        if (c == '\\' || c == '/') {
            return string;
        }
        return string + "/";
    }

    public static boolean deleteSub(File file, String ... stringArray) {
        return FileUtil.deleteSub(file, true, stringArray);
    }

    public static boolean deleteSub(File file, boolean bl, String ... stringArray) {
        boolean bl2 = true;
        FileSearch fileSearch = new FileSearch();
        fileSearch.search(file, true, stringArray);
        for (String string : fileSearch.getFoundFiles()) {
            if (new File(string).delete()) continue;
            if (bl) {
                return false;
            }
            bl2 = false;
        }
        List<String> list = fileSearch.getFoundDirectories();
        for (int i = list.size() - 1; i >= 0; --i) {
            if (new File((String)list.get(i)).delete()) continue;
            if (bl) {
                return false;
            }
            bl2 = false;
        }
        return bl2;
    }

    public static boolean delete(File file, String ... stringArray) {
        return FileUtil.delete(file, true, stringArray);
    }

    public static boolean delete(File file, boolean bl, String ... stringArray) {
        if (FileUtil.deleteSub(file, bl, stringArray)) {
            return stringArray != null && stringArray.length != 0 || !file.exists() || file.delete();
        }
        return false;
    }

    public static boolean deleteEmpty(File file, String ... stringArray) {
        FileSearch fileSearch = new FileSearch();
        fileSearch.search(file, true, stringArray);
        List<String> list = fileSearch.getFoundDirectories();
        for (int i = list.size() - 1; i >= 0; --i) {
            File file2 = new File(list.get(i));
            String[] stringArray2 = file2.list();
            if (stringArray2 == null || stringArray2.length != 0 || file2.delete()) continue;
            return false;
        }
        return true;
    }

    public static boolean deleteIfEmpty(File ... fileArray) {
        for (File file : fileArray) {
            String[] stringArray = file.list();
            if (stringArray == null || stringArray.length != 0 || file.delete()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(OutputStream outputStream, int n, String[] stringArray, String ... stringArray2) throws IOException {
        Object object;
        int n2;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        ArrayUtil<String> arrayUtil = new ArrayUtil<String>();
        Object object2 = stringArray;
        int n3 = ((String[])object2).length;
        for (n2 = 0; n2 < n3; ++n2) {
            object = object2[n2];
            if (((String)(object = ((String)object).replace("\\", "/"))).endsWith("/")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            arrayUtil.add((String)object);
        }
        Collections.sort(arrayUtil);
        for (n3 = arrayUtil.size() - 1; n3 >= 0; --n3) {
            object2 = (String)arrayUtil.get(n3);
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                if (!((String)object2).startsWith((String)arrayUtil.get(n2))) continue;
                arrayUtil.remove(n3);
                n2 = -1;
            }
        }
        FileInputStream fileInputStream = null;
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        object = new BufferedOutputStream(zipOutputStream);
        CRC32 cRC32 = null;
        FileSearch fileSearch = new FileSearch();
        byte[] byArray = new byte[4096];
        zipOutputStream.setMethod(n);
        if (n == 8) {
            zipOutputStream.setLevel(9);
        }
        try {
            for (String arrayUtil22 : arrayUtil) {
                if (fileSearch.getFoundDirectories().contains(arrayUtil22)) continue;
                fileSearch.search(arrayUtil22, true, stringArray2);
            }
            List<String> list = fileSearch.getFoundDirectories();
            for (Map.Entry<String, List<String>> entry : fileSearch.getFilesPerDirectory().entrySet()) {
                if (list.contains(entry.getKey())) continue;
                list.add(entry.getKey());
            }
            Collections.sort(list);
            ArrayUtil<String> arrayUtil2 = new ArrayUtil<String>();
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ZipEntry zipEntry;
                String string = (String)iterator.next();
                String string2 = string.replace("\\", "/");
                int n4 = -1;
                int n5 = arrayUtil.size();
                for (int i = 0; i < n5 && n4 == -1; ++i) {
                    if (!string2.startsWith((String)arrayUtil.get(i))) continue;
                    n4 = ((String)arrayUtil.get(i)).length() + 1;
                }
                List<String> list2 = fileSearch.getFilesPerDirectory().get(string);
                if (list2 == null) continue;
                stringBuilder.setLength(0);
                if (n4 < string2.length()) {
                    for (String string3 : StringUtil.separateList(string2.substring(n4), "/", false)) {
                        stringBuilder.append(string3);
                        stringBuilder.append("/");
                        string2 = stringBuilder.toString();
                        if (arrayUtil2.indexOf(string2) >= 0) continue;
                        zipEntry = new ZipEntry(string2);
                        if (n == 0) {
                            zipEntry.setSize(0L);
                            zipEntry.setCrc(0L);
                        }
                        zipOutputStream.putNextEntry(zipEntry);
                        arrayUtil2.add(string2);
                    }
                }
                for (String string4 : list2) {
                    int n6;
                    File file = new File(string, string4);
                    if (n == 0) {
                        cRC32 = new CRC32();
                        try {
                            fileInputStream = new FileInputStream(file);
                            while ((n6 = fileInputStream.read(byArray)) >= 0) {
                                cRC32.update(byArray, 0, n6);
                            }
                        }
                        catch (Throwable throwable) {
                            CommonUtil.close(fileInputStream);
                            throw throwable;
                        }
                        CommonUtil.close(fileInputStream);
                    }
                    zipEntry = new ZipEntry(file.getAbsolutePath().substring(n4).replace('\\', '/'));
                    if (n == 0) {
                        zipEntry.setSize(file.length());
                        zipEntry.setTime(file.lastModified());
                        zipEntry.setCrc(cRC32.getValue());
                    }
                    zipOutputStream.putNextEntry(zipEntry);
                    try {
                        fileInputStream = new FileInputStream(file);
                        while ((n6 = fileInputStream.read(byArray)) >= 0) {
                            ((BufferedOutputStream)object).write(byArray, 0, n6);
                        }
                    }
                    catch (Throwable throwable) {
                        CommonUtil.close(fileInputStream);
                        throw throwable;
                    }
                    CommonUtil.close(fileInputStream);
                    ((BufferedOutputStream)object).flush();
                    zipOutputStream.closeEntry();
                }
            }
        }
        catch (Throwable throwable) {
            CommonUtil.close(object);
            throw throwable;
        }
        CommonUtil.close(object);
        byArray = null;
        zipOutputStream = null;
        object = null;
        fileInputStream = null;
        fileSearch = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(OutputStream outputStream, int n, File ... fileArray) throws IOException {
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        FileInputStream fileInputStream = null;
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(zipOutputStream);
        CRC32 cRC32 = null;
        byte[] byArray = new byte[4096];
        zipOutputStream.setMethod(n);
        if (n == 8) {
            zipOutputStream.setLevel(9);
        }
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                int n2;
                if (!fileArray[i].isFile()) continue;
                if (n == 0) {
                    cRC32 = new CRC32();
                    try {
                        fileInputStream = new FileInputStream(fileArray[i]);
                        while ((n2 = fileInputStream.read(byArray)) >= 0) {
                            cRC32.update(byArray, 0, n2);
                        }
                    }
                    catch (Throwable throwable) {
                        CommonUtil.close(fileInputStream);
                        throw throwable;
                    }
                    CommonUtil.close(fileInputStream);
                }
                ZipEntry zipEntry = new ZipEntry(fileArray[i].getName());
                if (n == 0) {
                    zipEntry.setSize(fileArray[i].length());
                    zipEntry.setTime(fileArray[i].lastModified());
                    zipEntry.setCrc(cRC32.getValue());
                }
                zipOutputStream.putNextEntry(zipEntry);
                try {
                    fileInputStream = new FileInputStream(fileArray[i]);
                    while ((n2 = fileInputStream.read(byArray)) >= 0) {
                        bufferedOutputStream.write(byArray, 0, n2);
                    }
                }
                catch (Throwable throwable) {
                    CommonUtil.close(fileInputStream);
                    throw throwable;
                }
                CommonUtil.close(fileInputStream);
                bufferedOutputStream.flush();
                zipOutputStream.closeEntry();
            }
        }
        catch (Throwable throwable) {
            CommonUtil.close(bufferedOutputStream);
            throw throwable;
        }
        CommonUtil.close(bufferedOutputStream);
        byArray = null;
        zipOutputStream = null;
        bufferedOutputStream = null;
        fileInputStream = null;
    }

    public static void unzip(String string, String string2) throws IOException {
        FileUtil.unzip(new File(string), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileUtil.unzip((InputStream)fileInputStream, string);
        }
        catch (Throwable throwable) {
            CommonUtil.close(fileInputStream);
            throw throwable;
        }
        CommonUtil.close(fileInputStream);
    }

    public static void unzip(InputStream inputStream, String string) throws IOException {
        FileUtil.unzip(inputStream, new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unzip(InputStream inputStream, File file) throws IOException {
        byte[] byArray = new byte[4096];
        File file2 = file;
        if (!file2.exists()) {
            if (!file2.mkdirs()) throw new IOException("Can not create target directory: " + file.getAbsolutePath());
        }
        BufferedOutputStream bufferedOutputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = inputStream instanceof ZipInputStream ? (ZipInputStream)inputStream : new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string = zipEntry.getName();
                file2 = new File(file, string);
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                String string2 = FileUtil.getDirectory(file2.getAbsolutePath());
                if (string2 != null) {
                    new File(string2).mkdirs();
                }
                try {
                    int n;
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    while ((n = zipInputStream.read(byArray)) != -1) {
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                }
                catch (Throwable throwable) {
                    bufferedOutputStream = (BufferedOutputStream)CommonUtil.close(bufferedOutputStream);
                    throw throwable;
                }
                bufferedOutputStream = (BufferedOutputStream)CommonUtil.close(bufferedOutputStream);
            }
        }
        catch (Throwable throwable) {
            CommonUtil.close(zipInputStream);
            throw throwable;
        }
        CommonUtil.close(zipInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> listZipEntries(InputStream inputStream) throws IOException {
        ArrayUtil<String> arrayUtil;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = inputStream instanceof ZipInputStream ? (ZipInputStream)inputStream : new ZipInputStream(inputStream);
            ArrayUtil<String> arrayUtil2 = new ArrayUtil<String>();
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                arrayUtil2.add(zipEntry.getName());
            }
            arrayUtil = arrayUtil2;
        }
        catch (Throwable throwable) {
            CommonUtil.close(zipInputStream);
            throw throwable;
        }
        CommonUtil.close(zipInputStream);
        return arrayUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            FileUtil.save(file, byteArrayInputStream);
        }
        catch (Throwable throwable) {
            CommonUtil.close(byteArrayInputStream);
            throw throwable;
        }
        CommonUtil.close(byteArrayInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(File file, InputStream inputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int n;
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) >= 0) {
                bufferedOutputStream.write(byArray, 0, n);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            bufferedOutputStream = null;
        }
        catch (Throwable throwable) {
            CommonUtil.close(bufferedOutputStream);
            throw throwable;
        }
        CommonUtil.close(bufferedOutputStream);
    }

    public static void replace(File file, File file2, Hashtable<String, String> hashtable, String string) throws IOException {
        FileUtil.replace(file, file2, hashtable, string, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replace(File file, File file2, Hashtable<String, String> hashtable, String string, String string2) throws IOException {
        File file3;
        OutputStream outputStream;
        FileInputStream fileInputStream;
        block12: {
            fileInputStream = null;
            outputStream = null;
            file3 = null;
            try {
                boolean bl;
                fileInputStream = new FileInputStream(file);
                if (file == file2 || file.equals(file2)) {
                    bl = true;
                    if (file.length() <= 1024000L) {
                        outputStream = new ByteArrayOutputStream();
                    } else {
                        file3 = File.createTempFile(FileUtil.class.getName(), "jvx");
                        outputStream = new FileOutputStream(file3);
                    }
                } else {
                    bl = false;
                    outputStream = new FileOutputStream(file2);
                }
                FileUtil.replace(fileInputStream, outputStream, hashtable, string, string2);
                fileInputStream.close();
                fileInputStream = null;
                if (!bl) break block12;
                if (file3 != null && file.delete() && file3.renameTo(file)) {
                    bl = false;
                }
                if (!bl) break block12;
                if (outputStream instanceof ByteArrayOutputStream) {
                    BufferedOutputStream bufferedOutputStream = null;
                    try {
                        bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                        bufferedOutputStream.write(((ByteArrayOutputStream)outputStream).toByteArray());
                    }
                    catch (Throwable throwable) {
                        CommonUtil.close(bufferedOutputStream);
                        throw throwable;
                    }
                    CommonUtil.close(bufferedOutputStream);
                    break block12;
                }
                FileUtil.copy(file3, file2, new String[0]);
            }
            catch (Throwable throwable) {
                CommonUtil.close(fileInputStream, outputStream);
                if (file3 != null && !file3.delete()) {
                    file3.deleteOnExit();
                }
                throw throwable;
            }
        }
        CommonUtil.close(fileInputStream, outputStream);
        if (file3 != null && !file3.delete()) {
            file3.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replace(InputStream inputStream, OutputStream outputStream, Hashtable<String, String> hashtable, String string, String string2) throws IOException {
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            InputStreamReader inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            OutputStreamWriter outputStreamWriter = string2 != null ? new OutputStreamWriter(outputStream, string2) : new OutputStreamWriter(outputStream);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            String string3 = System.getProperty("line.separator");
            String string4 = bufferedReader.readLine();
            while (string4 != null) {
                for (Map.Entry<String, String> entry : hashtable.entrySet()) {
                    string4 = StringUtil.replace(string4, entry.getKey(), entry.getValue());
                }
                bufferedWriter.write(string4);
                string4 = bufferedReader.readLine();
                if (string4 == null) continue;
                bufferedWriter.write(string3);
            }
            bufferedWriter.write(string3);
        }
        catch (Throwable throwable) {
            CommonUtil.close(bufferedReader, bufferedWriter);
            throw throwable;
        }
        CommonUtil.close(bufferedReader, bufferedWriter);
    }

    public static boolean hasGZIPHeader(byte[] byArray) {
        return byArray != null && byArray.length >= 10 && byArray[0] == 31 && byArray[1] == -117 && byArray[2] == 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasGZIPHeader(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return false;
        }
        if (!inputStream.markSupported()) {
            throw new IOException("The InputStream has no mark support!");
        }
        inputStream.mark(10);
        try {
            byte[] byArray = new byte[10];
            boolean bl = inputStream.read(byArray) >= 10 && FileUtil.hasGZIPHeader(byArray);
            return bl;
        }
        finally {
            inputStream.reset();
        }
    }

    public static boolean like(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return FileUtil.like(string, 0, string.length(), string2, 0, string2.length());
    }

    private static boolean like(String string, int n, int n2, String string2, int n3, int n4) {
        int n5 = n;
        for (int i = n3; i < n4; ++i) {
            char c = string2.charAt(i);
            if (c == '*') {
                if (i + 1 < n4 && string2.charAt(i + 1) == '*') {
                    if (i + 1 == n4 - 1) {
                        return true;
                    }
                    int n6 = i + 2;
                    while (n5 < n2) {
                        if (FileUtil.like(string, n5, n2, string2, n6, n4)) {
                            return true;
                        }
                        ++n5;
                    }
                    return false;
                }
                int n7 = i + 1;
                int n8 = string.indexOf(47, n5);
                if (n8 < 0) {
                    n8 = string.indexOf(92, n5);
                }
                if (n8 < 0) {
                    if (i == n4 - 1) {
                        return true;
                    }
                    n8 = n2;
                } else {
                    ++n8;
                }
                int n9 = string2.indexOf(47, n7);
                if (n9 < 0) {
                    n9 = string2.indexOf(92, n7);
                }
                n9 = n9 < 0 ? n4 : ++n9;
                while (n5 < n8) {
                    if (FileUtil.like(string, n5, n8, string2, n7, n9) && FileUtil.like(string, n8, n2, string2, n9, n4)) {
                        return true;
                    }
                    ++n5;
                }
                return false;
            }
            if (n5 == n2) {
                return false;
            }
            if (c != '?' && c != string.charAt(n5)) {
                return false;
            }
            ++n5;
        }
        return n5 == n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CopyMode {
        Backup,
        Overwrite,
        Keep;

    }
}

