/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedHashtable<K, V>
extends Hashtable<K, V> {
    private Vector<K> vOrderedKeys;

    public OrderedHashtable() {
        this.vOrderedKeys = new Vector(11);
    }

    public OrderedHashtable(int n) {
        super(n);
        this.vOrderedKeys = new Vector(n);
    }

    public OrderedHashtable(int n, float f) {
        super(n, f);
        this.vOrderedKeys = new Vector(n);
    }

    public OrderedHashtable(Map<? extends K, ? extends V> map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.vOrderedKeys = new Vector(Math.max(2 * map.size(), 11));
        this.putAll(map);
    }

    @Override
    public synchronized V put(K k, V v) {
        V v2 = super.put(k, v);
        if (v2 == null) {
            this.vOrderedKeys.add(k);
        }
        return v2;
    }

    @Override
    public synchronized V remove(Object object) {
        Object v = super.remove(object);
        if (v != null) {
            this.vOrderedKeys.removeElement(object);
        }
        return v;
    }

    @Override
    public synchronized Object clone() {
        OrderedHashtable orderedHashtable = (OrderedHashtable)super.clone();
        orderedHashtable.vOrderedKeys = (Vector)this.vOrderedKeys.clone();
        return orderedHashtable;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.vOrderedKeys.removeAllElements();
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return ((Vector)this.vOrderedKeys.clone()).elements();
    }

    @Override
    public synchronized Set<K> keySet() {
        HashSet hashSet = new HashSet((Vector)this.vOrderedKeys.clone());
        return hashSet;
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return new Enumeration<V>(){
            Enumeration en;
            {
                this.en = ((Vector)OrderedHashtable.this.vOrderedKeys.clone()).elements();
            }

            @Override
            public boolean hasMoreElements() {
                return this.en.hasMoreElements();
            }

            @Override
            public V nextElement() {
                return OrderedHashtable.this.get(this.en.nextElement());
            }
        };
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> linkedHashSet = new LinkedHashSet<Map.Entry<K, V>>();
        int n = this.vOrderedKeys.size();
        for (int i = 0; i < n; ++i) {
            K k = this.vOrderedKeys.get(i);
            linkedHashSet.add(new Entry(k, this.get(k)));
        }
        return linkedHashSet;
    }

    public synchronized K getKey(int n) {
        return this.vOrderedKeys.get(n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        protected Entry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        protected Object clone() {
            return new Entry<K, V>(this.key, this.value);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return 0xD ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key.toString() + "=" + this.value.toString();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            if (this.value == null) {
                throw new NullPointerException();
            }
            V v2 = this.value;
            this.value = v;
            return v2;
        }
    }
}

