/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.IValidatable;
import com.sibvisions.util.ThreadHandler;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;

public class ObjectCacheInstance {
    private static final long CHECK_DELAY = 30000L;
    private Hashtable<Object, Element> htStore = new Hashtable();
    private Thread thCheckTimeout = null;

    public static Object createKey() {
        return UUID.randomUUID().toString();
    }

    public Object put(Object object, long l) {
        if (object == null) {
            throw new NullPointerException("Object is null!");
        }
        Object object2 = ObjectCacheInstance.createKey();
        this.put(object2, object, l);
        return object2;
    }

    public Object put(IValidatable iValidatable) {
        if (iValidatable == null) {
            throw new NullPointerException("Object is null!");
        }
        Object object = ObjectCacheInstance.createKey();
        this.put(object, iValidatable);
        return object;
    }

    public Object put(Object object, Object object2, long l) {
        if (object2 == null) {
            return this.htStore.remove(object);
        }
        return this.put(object, new Element(object2, l));
    }

    public Object put(Object object, IValidatable iValidatable) {
        if (iValidatable == null) {
            return this.htStore.remove(object);
        }
        return this.put(object, new Element(iValidatable));
    }

    public Object get(Object object) {
        if (object == null) {
            return null;
        }
        Element element = this.htStore.get(object);
        if (element == null) {
            return null;
        }
        if (element.isValid()) {
            return element.object;
        }
        this.htStore.remove(object);
        return null;
    }

    public Object remove(Object object) {
        Element element = this.htStore.remove(object);
        if (element != null && element.isValid()) {
            return element.object;
        }
        return null;
    }

    private Object put(Object object, Element element) {
        Element element2 = this.htStore.put(object, element);
        this.startTimeoutCheck();
        if (element2 != null && element2.isValid()) {
            return element2.object;
        }
        return null;
    }

    private void startTimeoutCheck() {
        if (ThreadHandler.isStopped(this.thCheckTimeout)) {
            this.thCheckTimeout = ThreadHandler.start(new Check());
        }
    }

    private class Check
    implements Runnable {
        private Check() {
        }

        public void run() {
            try {
                while (!ThreadHandler.isStopped(ObjectCacheInstance.this.thCheckTimeout)) {
                    Thread.sleep(30000L);
                    Hashtable hashtable = (Hashtable)ObjectCacheInstance.this.htStore.clone();
                    for (Map.Entry entry : hashtable.entrySet()) {
                        if (((Element)entry.getValue()).isValid()) continue;
                        ObjectCacheInstance.this.htStore.remove(entry.getKey());
                    }
                    hashtable = null;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static final class Element {
        private long creation = System.currentTimeMillis();
        private long timeout;
        private Object object;
        private boolean isValidatable;

        private Element(Object object, long l) {
            this.object = object;
            this.timeout = l;
        }

        private Element(IValidatable iValidatable) {
            this.object = iValidatable;
            this.isValidatable = true;
        }

        public boolean isValid() {
            if (this.isValidatable) {
                return ((IValidatable)this.object).isValid();
            }
            return this.timeout <= 0L || this.creation + this.timeout >= System.currentTimeMillis();
        }
    }
}

