/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntHashMap<T> {
    private static final int MIN_SIZE = 31;
    private T[] values = new Object[31];
    private int[] keys = new int[31];
    private int size = 0;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (int i = 0; i < this.keys.length; ++i) {
            T t = this.values[i];
            if (t == null) continue;
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keys[i]);
            stringBuilder.append('=');
            stringBuilder.append(t);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public void clear() {
        this.keys = new int[31];
        this.values = new Object[31];
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    private final int hashCode(int n) {
        long l = n < 0 ? (long)(-n) : (long)n;
        int n2 = (int)((long)((int)(l >>> 32) * 31) + (l & 0xFFFFFFFFL));
        return (31 * (n < 0 ? -n2 : n2) & Integer.MAX_VALUE) % this.values.length;
    }

    public T put(int n, T t) {
        int n2 = this.hashCode(n);
        T t2 = this.values[n2];
        while (n != this.keys[n2] && t2 != null) {
            if (++n2 == this.keys.length) {
                n2 = 0;
            }
            t2 = this.values[n2];
        }
        this.keys[n2] = n;
        this.values[n2] = t;
        if (t2 == null) {
            ++this.size;
            if (this.size > this.values.length / 2) {
                this.rehashAll(this.values.length * 2);
            }
        }
        return t2;
    }

    public T get(int n) {
        int n2 = this.hashCode(n);
        T t = this.values[n2];
        while (n != this.keys[n2] && t != null) {
            if (++n2 == this.keys.length) {
                n2 = 0;
            }
            t = this.values[n2];
        }
        return t;
    }

    public T remove(int n) {
        int n2 = this.hashCode(n);
        T t = this.values[n2];
        while (n != this.keys[n2] && t != null) {
            if (++n2 == this.keys.length) {
                n2 = 0;
            }
            t = this.values[n2];
        }
        this.keys[n2] = 0;
        this.values[n2] = null;
        if (t != null) {
            --this.size;
            if (this.values.length > 31 && this.size < this.values.length / 4) {
                this.rehashAll(this.values.length / 2);
            } else {
                if (++n2 == this.keys.length) {
                    n2 = 0;
                }
                T t2 = this.values[n2];
                while (t2 != null) {
                    int n3 = this.keys[n2];
                    if (this.hashCode(n3) != n2) {
                        this.keys[n2] = 0;
                        this.values[n2] = null;
                        --this.size;
                        this.put(n3, t2);
                    }
                    if (++n2 == this.keys.length) {
                        n2 = 0;
                    }
                    t2 = this.values[n2];
                }
            }
        }
        return t;
    }

    private void rehashAll(int n) {
        int[] nArray = this.keys;
        T[] TArray = this.values;
        this.keys = new int[n];
        this.values = new Object[n];
        this.size = 0;
        for (int i = 0; i < nArray.length; ++i) {
            T t = TArray[i];
            if (t == null) continue;
            this.put(nArray[i], t);
        }
    }
}

