/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.ArrayUtil;
import com.sibvisions.util.type.StringUtil;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityKeyValueList<K, V> {
    private IdentityHashMap<K, List<V>> hmpValues = new IdentityHashMap();

    public String toString() {
        return StringUtil.toString(this.hmpValues);
    }

    public boolean equals(Object object) {
        return this.hmpValues.equals(object);
    }

    public int hashCode() {
        return this.hmpValues.hashCode();
    }

    public synchronized void put(K k, V v) {
        this.put(k, v, false);
    }

    public synchronized void putAll(K k, Collection<V> collection) {
        for (V v : collection) {
            this.put(k, v, false);
        }
    }

    public synchronized void put(K k, V v, boolean bl) {
        List<V> list = this.hmpValues.get(k);
        if (list == null) {
            list = new ArrayUtil<V>();
            this.hmpValues.put(k, list);
            list.add(v);
        } else if (!bl || list.indexOf(v) < 0) {
            list.add(v);
        }
    }

    public synchronized List<V> get(K k) {
        return this.hmpValues.get(k);
    }

    public synchronized void remove(K k, V v) {
        List<V> list = this.hmpValues.get(k);
        if (list != null) {
            list.remove(v);
            if (list.size() == 0) {
                this.hmpValues.remove(k);
            }
        }
    }

    public synchronized void clear() {
        this.hmpValues.clear();
    }

    public synchronized List<V> remove(K k) {
        return this.hmpValues.remove(k);
    }

    public synchronized boolean containsKey(K k) {
        return this.hmpValues.containsKey(k);
    }

    public synchronized boolean containsValue(V v) {
        for (List<V> list : this.hmpValues.values()) {
            for (Object e : list) {
                if (!e.equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean contains(K k, V v) {
        List<V> list = this.hmpValues.get(k);
        if (list == null) {
            return false;
        }
        return list.contains(v);
    }

    public synchronized int size() {
        return this.hmpValues.size();
    }

    public synchronized boolean isEmpty() {
        return this.hmpValues.isEmpty();
    }

    public Collection<List<V>> values() {
        return this.hmpValues.values();
    }

    public Set<K> keySet() {
        return this.hmpValues.keySet();
    }

    public Set<Map.Entry<K, List<V>>> entrySet() {
        return this.hmpValues.entrySet();
    }
}

