/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.util;

import com.sibvisions.util.type.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;

public final class ByteArrayDataSource
implements DataSource {
    private String name;
    private byte[] content;
    private FileTypeMap fileTypeMap = null;

    public ByteArrayDataSource(String string, byte[] byArray) {
        this.name = string;
        this.content = byArray;
    }

    public ByteArrayDataSource(String string, InputStream inputStream) {
        this.name = string;
        this.content = FileUtil.getContent(inputStream);
    }

    public String getContentType() {
        if (this.fileTypeMap == null) {
            return FileTypeMap.getDefaultFileTypeMap().getContentType(this.getName());
        }
        return this.fileTypeMap.getContentType(this.getName());
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("FileHandle may not be changed!");
    }

    public FileTypeMap getFileTypeMap() {
        return this.fileTypeMap;
    }

    public void setFileTypeMap(FileTypeMap fileTypeMap) {
        this.fileTypeMap = fileTypeMap;
    }

    public void setName(String string) {
        this.name = string;
    }
}

