/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.swing.ext.JVxToolBar;
import com.sibvisions.rad.ui.swing.ext.layout.JVxBorderLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class JVxToolBarPanel
extends JPanel {
    private JPanel panContent;
    private JVxToolBar toolbar = new JVxToolBar();
    private String sTempConstraint;
    private String sAreaConstraint = "North";
    private boolean bCheckSeparatorVisibility = true;

    public JVxToolBarPanel() {
        super.setLayout(new JVxBorderLayout());
        this.panContent = new JPanel();
        this.panContent.setName("toolBarPanel.contentPane");
        this.panContent.setLayout(new BorderLayout());
        this.panContent.setBackground(null);
        this.panContent.setForeground(null);
        this.panContent.setFont(null);
        this.panContent.setCursor(null);
        super.addImpl(this.panContent, "Center", 0);
    }

    public void updateUI() {
        super.updateUI();
        if (this.toolbar != null) {
            this.toolbar.updateUI();
        }
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.panContent != null) {
            this.panContent.setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    public void setOpaque(boolean bl) {
        if (this.panContent != null) {
            this.panContent.setOpaque(bl);
        }
        if (this.toolbar != null) {
            this.toolbar.setOpaque(bl);
        }
        super.setOpaque(bl);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component == this.toolbar) {
            super.addImpl(component, object, n);
        } else {
            this.panContent.add(component, object, n);
        }
    }

    public void remove(Component component) {
        if (component == this.toolbar) {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                if (this.getComponent(i) != this.toolbar) continue;
                super.remove(i);
                this.validate();
                this.repaint();
                return;
            }
            super.remove(component);
        } else {
            this.panContent.remove(component);
        }
    }

    public void remove(int n) {
        this.panContent.remove(n);
    }

    public void removeAll() {
        this.panContent.removeAll();
    }

    public void addNotify() {
        this.checkSeparatorVisibility();
        super.addNotify();
    }

    public void paintComponent(Graphics graphics) {
        this.checkSeparatorVisibility();
        super.paintComponent(graphics);
    }

    public void addToolBar(JToolBar jToolBar) {
        this.addToolBar(jToolBar, -1);
    }

    public void addToolBar(JToolBar jToolBar, int n) {
        int n2 = n;
        int n3 = this.toolbar.getComponentCount();
        if (n2 < 0) {
            n2 = n3 - 1;
        }
        if (n3 > 0) {
            if (n2 < n3 - 1) {
                Component component = this.toolbar.getComponent(n2);
                if (component instanceof Container && !(((Container)component).getComponent(0) instanceof JToolBar.Separator)) {
                    ((Container)component).add(new JToolBar.Separator(), null, 0);
                }
            } else {
                jToolBar.add(new JToolBar.Separator(), null, 0);
            }
        }
        this.toolbar.add((Component)jToolBar, n);
        if (this.toolbar.getParent() == null) {
            super.addImpl(this.toolbar, this.sTempConstraint != null ? this.sTempConstraint : this.sAreaConstraint, 0);
            this.sTempConstraint = null;
        }
        if (n3 == 0) {
            this.toolbar.validate();
        }
        this.bCheckSeparatorVisibility = true;
        this.validate();
        this.repaint();
    }

    public void removeToolBar(JToolBar jToolBar) {
        Container container = jToolBar.getParent();
        if (container == this.toolbar) {
            Object object;
            int n;
            if (jToolBar.getComponentCount() > 0 && jToolBar.getComponent(0) instanceof JToolBar.Separator) {
                jToolBar.remove(0);
            }
            if ((n = this.toolbar.getComponentIndex(jToolBar)) + 1 < this.toolbar.getComponentCount() && (object = this.toolbar.getComponent(n + 1)) instanceof Container && ((Container)object).getComponent(0) instanceof JToolBar.Separator) {
                ((Container)object).remove(0);
            }
            this.toolbar.remove(jToolBar);
            this.toolbar.repaint();
            if (this.toolbar.getComponentCount() == 0) {
                Container container2;
                object = (String)((JVxBorderLayout)this.getLayout()).getConstraints(this.toolbar);
                if (object != null) {
                    this.sAreaConstraint = object;
                }
                if ((container2 = this.toolbar.getParent()) != null) {
                    container2.remove(this.toolbar);
                    if (container2 != this) {
                        for (Container container3 = container2; container3 != null; container3 = container3.getParent()) {
                            if (!(container3 instanceof JDialog)) continue;
                            ((JDialog)container3).dispose();
                        }
                    }
                    container2.validate();
                    container2.repaint();
                }
            }
            this.bCheckSeparatorVisibility = true;
        }
    }

    public int getToolBarCount() {
        int n;
        return n - ((n = this.toolbar.getComponentCount()) > 1 ? n - 1 : 0);
    }

    public JToolBar getToolBar(int n) {
        if (n < 0 || n >= this.toolbar.getComponentCount() - 1) {
            throw new ArrayIndexOutOfBoundsException("No such child: " + n);
        }
        int n2 = this.toolbar.getComponentCount();
        return (JToolBar)this.toolbar.getComponent(n + (n2 > 1 ? n2 - 1 : 0));
    }

    public void setArea(ToolBarArea toolBarArea) {
        int n;
        String string;
        String string2 = (String)((JVxBorderLayout)this.getLayout()).getConstraints(this.toolbar);
        switch (toolBarArea) {
            case TOP: {
                string = "North";
                n = 0;
                break;
            }
            case LEFT: {
                string = "West";
                n = 1;
                break;
            }
            case BOTTOM: {
                string = "South";
                n = 0;
                break;
            }
            case RIGHT: {
                string = "East";
                n = 1;
                break;
            }
            default: {
                string = "North";
                n = 0;
            }
        }
        if (!string.equals(string2)) {
            if (this.toolbar.getParent() != null) {
                this.sTempConstraint = null;
                super.addImpl(this.toolbar, string, 0);
            } else {
                this.sTempConstraint = string;
            }
            this.toolbar.setOrientation(n);
        }
        this.sAreaConstraint = string;
        this.bCheckSeparatorVisibility = true;
    }

    public ToolBarArea getArea() {
        String string = (String)((JVxBorderLayout)this.getLayout()).getConstraints(this.toolbar);
        if (string == null) {
            string = this.sAreaConstraint;
        }
        if ("North".equals(string)) {
            return ToolBarArea.TOP;
        }
        if ("West".equals(string)) {
            return ToolBarArea.LEFT;
        }
        if ("East".equals(string)) {
            return ToolBarArea.RIGHT;
        }
        if ("South".equals(string)) {
            return ToolBarArea.BOTTOM;
        }
        return ToolBarArea.NONE;
    }

    protected JToolBar getToolBar() {
        return this.toolbar;
    }

    private void checkSeparatorVisibility() {
        if (this.bCheckSeparatorVisibility) {
            int n = 0;
            int n2 = 0;
            int n3 = this.toolbar.getComponentCount();
            for (int i = 0; i < n3; ++i) {
                Component component;
                Component component2 = this.toolbar.getComponent(i);
                if (!(component2 instanceof Container)) continue;
                if (i > 0 && ((Container)component2).getComponentCount() > 0 && (component = ((Container)component2).getComponent(0)) instanceof JToolBar.Separator) {
                    component.setVisible(n > 0);
                }
                n2 = 0;
                if (component2.isVisible()) {
                    int n4 = ((Container)component2).getComponentCount();
                    for (int j = 0; j < n4 && n2 == 0; ++j) {
                        component = ((Container)component2).getComponent(j);
                        if (!component.isVisible()) continue;
                        ++n2;
                    }
                }
                if (n2 == 0) continue;
                n = n2;
            }
            this.bCheckSeparatorVisibility = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToolBarArea {
        TOP,
        LEFT,
        BOTTOM,
        RIGHT,
        NONE;

    }
}

