/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui.swing.ext;

import com.sibvisions.rad.ui.swing.ext.JVxDesktopManager;
import com.sibvisions.rad.ui.swing.ext.JVxInternalFrame;
import com.sibvisions.rad.ui.swing.ext.JVxTabbedPane;
import com.sibvisions.rad.ui.swing.ext.event.ITabListener;
import com.sibvisions.rad.ui.swing.ext.event.TabEvent;
import com.sibvisions.rad.ui.swing.ext.layout.JVxBorderLayout;
import com.sibvisions.rad.ui.swing.ext.layout.JVxFormLayout;
import com.sibvisions.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameListener;

public class JVxDesktopPane
extends JDesktopPane
implements ITabListener {
    private static final Integer TAB_LAYER = FRAME_CONTENT_LAYER + 1;
    private InternalContentPanel icpContent;
    private InternalContentLayout layout;
    private JVxTabbedPane tabs = null;
    private ArrayUtil<WeakReference<JInternalFrame>> auFrameCache = null;
    private Hashtable<JVxInternalFrame, Component> htFrameContent = null;
    private Hashtable<Component, JVxInternalFrame> htContentFrame = null;
    private Hashtable<JVxInternalFrame, JFrame> htFrames = null;
    private DisplayMode displayMode = DisplayMode.InternalFrame;
    private boolean bDragableTabs = false;
    private int iIgnoreFrameCalls = 0;
    private int iIgnoreToFront = 0;
    private boolean bSetFocusOnlyOnce = false;
    private boolean bIgnoreTabSelection = false;
    private boolean bIgnoreTabFocus = false;
    private long lAltWhen;
    private long lCtrlWhen;
    private boolean bFrameSwitchAllowed;
    private boolean bNavigationKeyEnabled = false;

    public JVxDesktopPane() {
        if (this.getLayout() != null) {
            this.setLayout(new BorderLayout());
        }
        this.setDesktopManager(new JVxDesktopManager());
    }

    public void closeTab(TabEvent tabEvent) throws Exception {
        Component component;
        JVxInternalFrame jVxInternalFrame;
        if (this.isTabMode() && (jVxInternalFrame = this.htContentFrame.get(component = this.tabs.getComponentAt(tabEvent.getOldTabIndex()))) != null) {
            jVxInternalFrame.doDefaultCloseAction();
            if (!jVxInternalFrame.isClosed()) {
                throw new Exception("Frame '" + jVxInternalFrame.getTitle() + "' is not closable!");
            }
            this.htContentFrame.remove(component);
            this.htFrameContent.remove(jVxInternalFrame);
            if (this.htFrameContent.size() == 0) {
                this.tabs.setVisible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deselectTab(TabEvent tabEvent) {
        JVxInternalFrame jVxInternalFrame;
        int n;
        if (!this.bIgnoreTabSelection && (n = tabEvent.getOldTabIndex()) >= 0 && (jVxInternalFrame = this.htContentFrame.get(this.tabs.getComponentAt(n))) != null) {
            if (!this.bIgnoreTabFocus) {
                jVxInternalFrame.storeFocus();
            }
            ++this.iIgnoreFrameCalls;
            try {
                jVxInternalFrame.setVisible(true);
                jVxInternalFrame.setSelected(false);
                jVxInternalFrame.setVisible(false);
            }
            catch (PropertyVetoException propertyVetoException) {
            }
            finally {
                --this.iIgnoreFrameCalls;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectTab(TabEvent tabEvent) {
        JVxInternalFrame jVxInternalFrame;
        int n;
        if (!this.bIgnoreTabSelection && (n = tabEvent.getNewTabIndex()) >= 0 && (jVxInternalFrame = this.htContentFrame.get(this.tabs.getComponentAt(n))) != null) {
            ++this.iIgnoreFrameCalls;
            try {
                jVxInternalFrame.setVisible(true);
                jVxInternalFrame.setSelected(true);
                jVxInternalFrame.setVisible(false);
            }
            catch (PropertyVetoException propertyVetoException) {
            }
            finally {
                --this.iIgnoreFrameCalls;
            }
            if (!this.bSetFocusOnlyOnce) {
                if (!this.bIgnoreTabFocus && jVxInternalFrame.isFocusStored()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JVxDesktopPane.this.bSetFocusOnlyOnce = false;
                            jVxInternalFrame.restoreFocus();
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JVxDesktopPane.this.bSetFocusOnlyOnce = false;
                            KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(JVxDesktopPane.this.tabs);
                        }
                    });
                }
            }
        }
    }

    public void moveTab(TabEvent tabEvent) {
    }

    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager != null || this.icpContent != null) {
            this.attachContentPane();
            this.icpContent.setLayout(layoutManager);
        }
        if (this.layout == null) {
            this.layout = new InternalContentLayout();
            super.setLayout(this.layout);
        }
    }

    public LayoutManager getLayout() {
        if (this.icpContent != null) {
            return this.icpContent.getLayout();
        }
        return null;
    }

    public void requestFocus() {
        super.requestFocusInWindow();
    }

    protected void addImpl(Component component, Object object, int n) {
        JInternalFrame jInternalFrame = null;
        if (component instanceof JInternalFrame.JDesktopIcon) {
            jInternalFrame = ((JInternalFrame.JDesktopIcon)component).getInternalFrame();
        } else if (component instanceof JInternalFrame) {
            jInternalFrame = (JInternalFrame)component;
        }
        if (jInternalFrame != null) {
            String string;
            Integer n2;
            if (this.auFrameCache == null) {
                this.auFrameCache = new ArrayUtil();
            }
            if ((n2 = (Integer)jInternalFrame.getClientProperty(string = "" + System.identityHashCode(this))) != null) {
                this.auFrameCache.add(Math.min(this.auFrameCache.size(), n2), new WeakReference<JInternalFrame>(jInternalFrame));
                jInternalFrame.putClientProperty(string, null);
            } else {
                this.auFrameCache.add(new WeakReference<JInternalFrame>(jInternalFrame));
            }
        }
        if (object != null && object instanceof Integer || component instanceof JInternalFrame || component instanceof JInternalFrame.JDesktopIcon) {
            super.addImpl(component, object, n);
            if (component instanceof JVxInternalFrame && component.isVisible() && !((JVxInternalFrame)component).isModal()) {
                if (this.isTabMode()) {
                    this.addTab((JVxInternalFrame)component);
                } else if (this.displayMode == DisplayMode.Frame) {
                    this.addFrame((JVxInternalFrame)component);
                }
            }
        } else {
            this.attachContentPane();
            this.icpContent.add(component, object, n);
            this.icpContent.validate();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.setSelectedFrame(null);
    }

    public void removeAll() {
        super.removeAll();
        if (this.icpContent != null) {
            this.icpContent.removeAll();
        }
        this.htContentFrame = null;
        this.htFrameContent = null;
        this.auFrameCache = null;
    }

    public void remove(Component component) {
        int n;
        Container container;
        if (this.auFrameCache != null) {
            container = null;
            if (component instanceof JInternalFrame) {
                container = (JInternalFrame)component;
            } else if (component instanceof JInternalFrame.JDesktopIcon) {
                container = ((JInternalFrame.JDesktopIcon)component).getInternalFrame();
            }
            if (container != null && (n = this.auFrameCache.indexOf(container)) >= 0) {
                this.auFrameCache.remove(n);
                ((JComponent)container).putClientProperty("" + System.identityHashCode(this), n);
                if (this.auFrameCache.size() == 0) {
                    this.auFrameCache = null;
                }
            }
        }
        if ((container = component.getParent()) == null) {
            return;
        }
        if (container == this) {
            n = 0;
            if (component instanceof JVxInternalFrame && this.isTabMode() && this.isVisible((JVxInternalFrame)component)) {
                n = 1;
            }
            super.remove(component);
            JInternalFrame jInternalFrame = null;
            if (this.auFrameCache != null) {
                int n2 = this.auFrameCache.size();
                for (int i = 0; i < n2 && jInternalFrame == null; ++i) {
                    JInternalFrame jInternalFrame2 = (JInternalFrame)this.auFrameCache.get(i).get();
                    if (jInternalFrame2 == null || !jInternalFrame2.isVisible() || jInternalFrame2.isIcon()) continue;
                    jInternalFrame = jInternalFrame2;
                }
            }
            if (jInternalFrame == null) {
                Container container2;
                Component component2 = null;
                if (component instanceof JVxInternalFrame && (component2 = ((JVxInternalFrame)component).getPreviousFocusOwner()) != null && !component2.isShowing()) {
                    component2 = null;
                }
                if (component2 == null && (container2 = this.getFocusCycleRootAncestor()) != null && container2.getFocusTraversalPolicy() != null && (component2 = container2.getFocusTraversalPolicy().getFirstComponent(this)) == null) {
                    component2 = container2.getFocusTraversalPolicy().getFirstComponent(container2);
                }
                if (component2 == null) {
                    component2 = this;
                }
                component2.requestFocusInWindow();
            } else {
                jInternalFrame.restoreSubcomponentFocus();
            }
            if (n != 0) {
                ((JVxInternalFrame)component).setVisibleIntern(true);
            }
        } else if (container == this.tabs) {
            this.tabs.remove(component);
            JInternalFrame jInternalFrame = this.htContentFrame.remove(component);
            this.htFrameContent.remove(jInternalFrame);
            if (this.htContentFrame.size() == 0) {
                this.htFrameContent = null;
                this.htContentFrame = null;
            }
        } else if (container == this.icpContent) {
            this.icpContent.remove(component);
        }
        if (this.getAllFrames().length == 0) {
            this.setSelectedFrame(null);
        }
    }

    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (!this.bNavigationKeyEnabled || JVxInternalFrame.isModalLayerPanelVisible(this)) {
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
        if (bl) {
            if (keyEvent.isAltDown() && keyEvent.isControlDown()) {
                this.bFrameSwitchAllowed = this.lCtrlWhen != keyEvent.getWhen() && this.lAltWhen == 0L || this.lAltWhen != keyEvent.getWhen() && this.lCtrlWhen == 0L;
            } else if (keyEvent.getKeyCode() == 18) {
                this.lAltWhen = keyEvent.getWhen();
                this.bFrameSwitchAllowed = true;
            } else if (keyEvent.getKeyCode() == 17) {
                this.lCtrlWhen = keyEvent.getWhen();
                this.bFrameSwitchAllowed = true;
            }
        } else {
            if (keyEvent.getKeyCode() == 18) {
                this.bFrameSwitchAllowed = true;
                this.lAltWhen = 0L;
            } else if (keyEvent.getKeyCode() == 17) {
                this.bFrameSwitchAllowed = true;
                this.lCtrlWhen = 0L;
            }
            boolean bl2 = this.bFrameSwitchAllowed = !keyEvent.isAltDown() && !keyEvent.isControlDown();
        }
        if (this.auFrameCache != null && bl && keyEvent.getKeyCode() == 18 && keyEvent.isControlDown() && this.bFrameSwitchAllowed) {
            int n2 = keyEvent.isShiftDown() ? -1 : 1;
            if (this.isTabMode()) {
                int n3 = this.tabs.getSelectedIndex();
                if (n3 >= 0) {
                    if ((n3 += n2) < 0) {
                        n3 = this.tabs.getTabCount() - 1;
                    } else if (n3 >= this.tabs.getTabCount()) {
                        n3 = 0;
                    }
                    this.tabs.setSelectedIndex(n3);
                }
            } else {
                int n4;
                int n5 = n4 = this.auFrameCache.indexOf(this.getSelectedFrame());
                int n6 = this.auFrameCache.size();
                int n7 = 0;
                if (n4 != -1) {
                    JInternalFrame jInternalFrame;
                    do {
                        ++n7;
                        if ((n5 += n2) < 0) {
                            n5 = this.auFrameCache.size() - 1;
                        } else if (n5 >= this.auFrameCache.size()) {
                            n5 = 0;
                        }
                        jInternalFrame = (JInternalFrame)this.auFrameCache.get(n5).get();
                        if (jInternalFrame == null) {
                            this.auFrameCache.remove(n5);
                            continue;
                        }
                        if (jInternalFrame.isVisible() || jInternalFrame.isIcon()) continue;
                        jInternalFrame = null;
                    } while (jInternalFrame == null && n5 != n4 && n7 <= n6);
                    if (jInternalFrame != null) {
                        try {
                            if (jInternalFrame.isIcon()) {
                                jInternalFrame.setIcon(false);
                            }
                            jInternalFrame.toFront();
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            }
            return true;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    private void attachContentPane() {
        if (this.icpContent == null) {
            this.icpContent = new InternalContentPanel();
            super.addImpl(this.icpContent, JLayeredPane.FRAME_CONTENT_LAYER, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayMode(DisplayMode displayMode) {
        if (displayMode != this.displayMode) {
            if (displayMode == DisplayMode.Tabset) {
                this.tabs = new JVxTabbedPane();
                this.tabs.setTabLayoutPolicy(1);
                this.tabs.setDragable(this.bDragableTabs);
                this.tabs.addTabListener(this);
                this.htFrameContent = new Hashtable();
                this.htContentFrame = new Hashtable();
                JInternalFrame[] jInternalFrameArray = super.getAllFrames();
                int n = -1;
                int n2 = jInternalFrameArray.length;
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (!(jInternalFrameArray[i] instanceof JVxInternalFrame) || !jInternalFrameArray[i].isVisible() || ((JVxInternalFrame)jInternalFrameArray[i]).isModal()) continue;
                    if (jInternalFrameArray[i].isSelected()) {
                        n = n3;
                    }
                    this.addTab((JVxInternalFrame)jInternalFrameArray[i]);
                    ++n3;
                }
                this.tabs.setSize(this.getSize());
                this.tabs.setVisible(false);
                super.add(this.tabs, TAB_LAYER, 0);
                this.bIgnoreTabFocus = true;
                try {
                    this.tabs.setVisible(this.tabs.getTabCount() > 0);
                    this.tabs.setSelectedIndex(n < 0 ? this.tabs.getTabCount() - 1 : n);
                }
                finally {
                    this.bIgnoreTabFocus = false;
                }
                this.tabs.requestFocusInWindow();
            } else if (displayMode == DisplayMode.InternalFrame) {
                if (this.displayMode == DisplayMode.Tabset) {
                    JVxInternalFrame jVxInternalFrame;
                    Component component = this.tabs.getSelectedComponent();
                    super.remove(this.tabs);
                    this.repaint();
                    this.tabs = null;
                    for (Map.Entry<JVxInternalFrame, Component> entry : this.htFrameContent.entrySet()) {
                        jVxInternalFrame = entry.getKey();
                        JRootPane jRootPane = (JRootPane)((Container)entry.getValue()).getComponent(0);
                        jRootPane.setPreferredSize(null);
                        jVxInternalFrame.setRootPane(jRootPane);
                        jVxInternalFrame.setVisible(true);
                    }
                    if (component != null && (jVxInternalFrame = this.htContentFrame.get(component)) != null) {
                        try {
                            jVxInternalFrame.setSelected(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                    this.htFrameContent = null;
                    this.htContentFrame = null;
                } else if (this.displayMode == DisplayMode.Frame) {
                    Component component;
                    HashMap<JVxInternalFrame, JFrame> hashMap = new HashMap<JVxInternalFrame, JFrame>(this.htFrames);
                    for (Map.Entry<JVxInternalFrame, JFrame> object2 : hashMap.entrySet()) {
                        JVxInternalFrame jVxInternalFrame = object2.getKey();
                        JFrame jFrame = object2.getValue();
                        JRootPane jRootPane = (JRootPane)jFrame.getComponent(0);
                        jRootPane.setPreferredSize(new Dimension(0, 0));
                        jVxInternalFrame.setRootPane(jRootPane);
                        this.htFrames.remove(jVxInternalFrame);
                        component = this.htFrameContent.remove(jVxInternalFrame);
                        this.htContentFrame.remove(component);
                        jVxInternalFrame.setVisible(true);
                        jFrame.dispose();
                    }
                    this.htFrameContent = null;
                    this.htContentFrame = null;
                    this.htFrames = null;
                    component = this;
                    Object object = null;
                    while ((component = component.getParent()) != null) {
                        if (!(component instanceof JFrame)) continue;
                        object = (JFrame)component;
                    }
                    if (object != null) {
                        Iterator<Map.Entry<JVxInternalFrame, JFrame>> iterator = object;
                        SwingUtilities.invokeLater(new Runnable((JFrame)((Object)iterator)){
                            final /* synthetic */ JFrame val$frTopFinal;
                            {
                                this.val$frTopFinal = jFrame;
                            }

                            public void run() {
                                this.val$frTopFinal.toFront();
                                JVxDesktopPane.this.requestFocus();
                            }
                        });
                    }
                }
            } else if (displayMode == DisplayMode.Frame) {
                JFrame jFrame;
                this.htFrameContent = new Hashtable();
                this.htContentFrame = new Hashtable();
                JInternalFrame[] jInternalFrameArray = super.getAllFrames();
                JInternalFrame jInternalFrame = null;
                int n = jInternalFrameArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!(jInternalFrameArray[i] instanceof JVxInternalFrame) || !jInternalFrameArray[i].isVisible() || ((JVxInternalFrame)jInternalFrameArray[i]).isModal()) continue;
                    if (jInternalFrameArray[i].isSelected()) {
                        jInternalFrame = jInternalFrameArray[i];
                    }
                    this.addFrame((JVxInternalFrame)jInternalFrameArray[i]);
                }
                if (jInternalFrame != null && (jFrame = this.htFrames.get(jInternalFrame)) != null) {
                    jFrame.toFront();
                }
            }
        }
        this.displayMode = displayMode;
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public boolean isTabMode() {
        return this.tabs != null && this.tabs.getParent() != null;
    }

    public void setTabMode(boolean bl) {
        if (bl) {
            this.setDisplayMode(DisplayMode.Tabset);
        } else {
            this.setDisplayMode(DisplayMode.InternalFrame);
        }
    }

    public void setTabsDragable(boolean bl) {
        this.bDragableTabs = bl;
        if (this.isTabMode()) {
            this.tabs.setDragable(bl);
        }
    }

    public boolean isTabsDragable() {
        return this.bDragableTabs;
    }

    private void setPreferredSizeAnchors(JVxFormLayout.Constraint constraint, boolean bl) {
        constraint.getTopAnchor().setAutoSize(bl);
        constraint.getLeftAnchor().setAutoSize(bl);
        constraint.getBottomAnchor().setAutoSize(bl);
        constraint.getRightAnchor().setAutoSize(bl);
    }

    protected void addTab(JVxInternalFrame jVxInternalFrame) {
        this.addContent(jVxInternalFrame, DisplayMode.Tabset);
    }

    protected void addFrame(JVxInternalFrame jVxInternalFrame) {
        this.addContent(jVxInternalFrame, DisplayMode.Frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addContent(JVxInternalFrame jVxInternalFrame, DisplayMode displayMode) {
        boolean bl;
        JRootPane jRootPane = jVxInternalFrame.getRootPane();
        Container container = new Container();
        JVxFormLayout jVxFormLayout = new JVxFormLayout();
        jVxFormLayout.setMargins(new Insets(0, 0, 0, 0));
        container.setLayout(jVxFormLayout);
        container.add((Component)jRootPane, new JVxFormLayout.Constraint(jVxFormLayout.getTopMarginAnchor(), jVxFormLayout.getLeftMarginAnchor(), jVxFormLayout.getBottomMarginAnchor(), jVxFormLayout.getRightMarginAnchor()));
        this.htFrameContent.put(jVxInternalFrame, container);
        this.htContentFrame.put(container, jVxInternalFrame);
        boolean bl2 = bl = !jVxInternalFrame.isMaximum() && !jVxInternalFrame.isResizable();
        if (bl) {
            ((Component)jRootPane).setPreferredSize(jRootPane.getSize());
        }
        this.setPreferredSizeAnchors(jVxFormLayout.getConstraint(jRootPane), bl);
        switch (displayMode) {
            case Tabset: {
                this.bIgnoreTabFocus = true;
                try {
                    this.tabs.addTab(jVxInternalFrame.getTitle(), jVxInternalFrame.getFrameIcon(), container);
                    int n = this.tabs.getTabCount() - 1;
                    this.tabs.setClosableAt(n, jVxInternalFrame.isClosable());
                    this.tabs.setSelectedIndex(n);
                    this.tabs.setVisible(true);
                    break;
                }
                finally {
                    this.bIgnoreTabFocus = false;
                }
            }
            case Frame: {
                JFrame jFrame = new JFrame(jVxInternalFrame.getTitle());
                jFrame.setDefaultCloseOperation(2);
                ImageIcon imageIcon = (ImageIcon)jVxInternalFrame.getFrameIcon();
                if (imageIcon != null) {
                    jFrame.setIconImage(imageIcon.getImage());
                }
                jFrame.setLayout(new JVxBorderLayout());
                jFrame.setSize(jVxInternalFrame.getWidth(), jVxInternalFrame.getHeight());
                jFrame.setLocation(jVxInternalFrame.getLocationOnScreen());
                jFrame.add(container);
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        Component component = ((JFrame)windowEvent.getWindow()).getContentPane().getComponent(0);
                        JVxInternalFrame jVxInternalFrame = (JVxInternalFrame)JVxDesktopPane.this.htContentFrame.get(component);
                        if (jVxInternalFrame != null) {
                            jVxInternalFrame.doDefaultCloseAction();
                            if (jVxInternalFrame.isClosed()) {
                                JVxDesktopPane.this.htContentFrame.remove(component);
                                JVxDesktopPane.this.htFrameContent.remove(jVxInternalFrame);
                                JVxDesktopPane.this.htFrames.remove(jVxInternalFrame);
                                if (JVxDesktopPane.this.htFrames.isEmpty()) {
                                    JVxDesktopPane.this.htFrames = null;
                                }
                            }
                        }
                    }
                });
                if (this.htFrames == null) {
                    this.htFrames = new Hashtable();
                }
                this.htFrames.put(jVxInternalFrame, jFrame);
                jFrame.setVisible(true);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized display mode: " + (Object)((Object)displayMode));
            }
        }
        ++this.iIgnoreFrameCalls;
        this.iIgnoreToFront += 2;
        try {
            int n;
            InternalFrameListener[] internalFrameListenerArray = jVxInternalFrame.getInternalFrameListeners();
            if (internalFrameListenerArray != null) {
                n = internalFrameListenerArray.length;
                for (int i = 0; i < n; ++i) {
                    jVxInternalFrame.removeInternalFrameListener(internalFrameListenerArray[i]);
                }
            }
            try {
                jVxInternalFrame.setVisible(true);
                jVxInternalFrame.setVisible(false);
            }
            finally {
                if (internalFrameListenerArray != null) {
                    n = internalFrameListenerArray.length;
                    for (int i = 0; i < n; ++i) {
                        jVxInternalFrame.addInternalFrameListener(internalFrameListenerArray[i]);
                    }
                }
            }
        }
        finally {
            this.iIgnoreToFront -= 2;
            --this.iIgnoreFrameCalls;
        }
    }

    private int getTabIndex(JVxInternalFrame jVxInternalFrame) {
        Component component;
        if (this.isTabMode() && (component = this.htFrameContent.get(jVxInternalFrame)) != null) {
            return this.tabs.indexOfComponent(component);
        }
        return -1;
    }

    public JVxTabbedPane getTabbedPane() {
        return this.tabs;
    }

    public void setNavigationKeysEnabled(boolean bl) {
        this.bNavigationKeyEnabled = bl;
    }

    public boolean isNavigationKeysEnabled() {
        return this.bNavigationKeyEnabled;
    }

    void dispose(JVxInternalFrame jVxInternalFrame) {
        this.setVisible(jVxInternalFrame, false);
    }

    boolean isVisible(JVxInternalFrame jVxInternalFrame) {
        return this.iIgnoreFrameCalls == 0 && this.getTabIndex(jVxInternalFrame) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setVisible(JVxInternalFrame jVxInternalFrame, boolean bl) {
        if (this.iIgnoreFrameCalls == 0 && !jVxInternalFrame.isModal()) {
            JFrame jFrame;
            if (this.isTabMode()) {
                if (bl) {
                    Component component = this.htFrameContent.get(jVxInternalFrame);
                    if (component == null) {
                        this.addTab(jVxInternalFrame);
                    }
                    return true;
                }
                Component component = this.htFrameContent.get(jVxInternalFrame);
                if (component != null) {
                    this.bIgnoreTabSelection = true;
                    try {
                        this.tabs.remove(component);
                    }
                    finally {
                        this.bIgnoreTabSelection = false;
                    }
                    if (this.tabs.getTabCount() == 0) {
                        this.tabs.setVisible(false);
                    }
                    jVxInternalFrame.setRootPane((JRootPane)((Container)component).getComponent(0));
                    this.htFrameContent.remove(jVxInternalFrame);
                    this.htContentFrame.remove(component);
                    return true;
                }
            } else if (this.displayMode != DisplayMode.Frame || (jFrame = this.htFrames.get(jVxInternalFrame)) != null) {
                // empty if block
            }
        }
        return false;
    }

    boolean isSelected(JVxInternalFrame jVxInternalFrame) {
        int n = this.getTabIndex(jVxInternalFrame);
        if (n >= 0) {
            return this.tabs.getSelectedIndex() == n;
        }
        return false;
    }

    boolean setSelected(JVxInternalFrame jVxInternalFrame, boolean bl) {
        int n;
        if (this.iIgnoreFrameCalls == 0 && (n = this.getTabIndex(jVxInternalFrame)) >= 0) {
            this.tabs.setSelectedIndex(n);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean toFront(JVxInternalFrame jVxInternalFrame) {
        if (this.isTabMode()) {
            int n = this.getTabIndex(jVxInternalFrame);
            if (this.iIgnoreToFront <= 1 && this.tabs.getSelectedIndex() != n) {
                ++this.iIgnoreToFront;
                try {
                    if (n >= 0) {
                        this.tabs.setSelectedIndex(n);
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    --this.iIgnoreToFront;
                }
            }
        }
        return false;
    }

    void setEnabled(JVxInternalFrame jVxInternalFrame, boolean bl) {
        int n = this.getTabIndex(jVxInternalFrame);
        if (n >= 0) {
            this.tabs.setEnabledAt(n, bl);
        }
    }

    void setResizable(JVxInternalFrame jVxInternalFrame, boolean bl) {
        Container container;
        if (this.isTabMode() && (container = (Container)this.htFrameContent.get(jVxInternalFrame)) != null) {
            JVxFormLayout jVxFormLayout = (JVxFormLayout)container.getLayout();
            this.setPreferredSizeAnchors(jVxFormLayout.getConstraint(container.getComponent(0)), !bl);
            if (bl) {
                jVxFormLayout.setMargins(new Insets(0, 0, 0, 0));
            }
        }
    }

    void setIcon(JVxInternalFrame jVxInternalFrame, Icon icon) {
        int n = this.getTabIndex(jVxInternalFrame);
        if (n >= 0) {
            this.tabs.setIconAt(n, icon);
        }
    }

    void setTitle(JVxInternalFrame jVxInternalFrame, String string) {
        int n = this.getTabIndex(jVxInternalFrame);
        if (n >= 0) {
            this.tabs.setTitleAt(n, string);
        }
    }

    void setClosable(JVxInternalFrame jVxInternalFrame, boolean bl) {
        int n = this.getTabIndex(jVxInternalFrame);
        if (n >= 0) {
            this.tabs.setClosableAt(n, bl);
        }
    }

    private class InternalContentLayout
    implements LayoutManager {
        private Dimension dimDefault = new Dimension(0, 0);

        private InternalContentLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            if (JVxDesktopPane.this.icpContent != null) {
                return JVxDesktopPane.this.icpContent.getPreferredSize();
            }
            return this.dimDefault;
        }

        public void layoutContainer(Container container) {
            if (JVxDesktopPane.this.icpContent != null) {
                JVxDesktopPane.this.icpContent.setBounds(0, 0, container.getWidth(), container.getHeight());
            }
            if (JVxDesktopPane.this.tabs != null) {
                JVxDesktopPane.this.tabs.setBounds(0, 0, container.getWidth(), container.getHeight());
            }
        }
    }

    final class InternalContentPanel
    extends JPanel {
        private InternalContentPanel() {
            this.setLayout(new BorderLayout(0, 0));
        }

        public Color getBackground() {
            return JVxDesktopPane.this.getBackground();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayMode {
        Tabset,
        Frame,
        InternalFrame;

    }
}

