/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.ui;

import com.sibvisions.rad.ui.WebstartImpl;
import java.lang.reflect.Method;
import javax.rad.io.IFileHandle;

public final class Webstart {
    private static boolean bAvailable;

    private Webstart() {
    }

    public static boolean isJnlp() {
        return bAvailable;
    }

    public static boolean showDocument(String string) throws Exception {
        Webstart.checkJNLP();
        return WebstartImpl.showDocument(string);
    }

    public static IFileHandle[] showOpenDialog(boolean bl) throws Exception {
        Webstart.checkJNLP();
        return WebstartImpl.openFileDialog(bl);
    }

    public static void showSaveDialog(IFileHandle iFileHandle) throws Exception {
        Webstart.checkJNLP();
        WebstartImpl.saveFileDialog(iFileHandle);
    }

    public static String getCodeBase() throws Exception {
        Webstart.checkJNLP();
        return WebstartImpl.getCodeBase();
    }

    public static void setClipboard(String string) throws Exception {
        Webstart.checkJNLP();
        WebstartImpl.setClipboard(string);
    }

    public static String getClipboard() throws Exception {
        Webstart.checkJNLP();
        return WebstartImpl.getClipboard();
    }

    public static void setProperty(String string, String string2) {
        if (bAvailable) {
            WebstartImpl.setProperty(string, string2);
        }
    }

    public static String getProperty(String string) {
        if (bAvailable) {
            return WebstartImpl.getProperty(string);
        }
        return null;
    }

    private static void checkJNLP() throws Exception {
        if (!bAvailable) {
            throw new Exception("JNLP services are not available!");
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("javax.jnlp.ServiceManager");
            Method method = clazz.getMethod("lookup", String.class);
            method.invoke(null, "javax.jnlp.BasicService");
            method.invoke(null, "javax.jnlp.FileOpenService");
            method.invoke(null, "javax.jnlp.FileSaveService");
            method.invoke(null, "javax.jnlp.ClipboardService");
            bAvailable = true;
        }
        catch (Throwable throwable) {
            bAvailable = false;
        }
    }
}

