/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringSerializer
extends AbstractSizedSerializer
implements ITypeSerializer<String> {
    private static final int TYPE_STRING_MIN = 99;
    private static final int TYPE_STRING_MAX = 255;
    private static String[] stringCache = new String[256];

    @Override
    public Class<String> getTypeClass() {
        return String.class;
    }

    @Override
    public int getMinValue() {
        return 99;
    }

    @Override
    public int getMaxValue() {
        return 255;
    }

    @Override
    public String read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        int n2 = this.readSize(dataInputStream, n, 99, 255);
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        if (byArray.length < 64) {
            int n3 = Arrays.hashCode(byArray) & 0xFF;
            String string = stringCache[n3];
            if (string == null || !Arrays.equals(byArray, string.getBytes("UTF8"))) {
                StringSerializer.stringCache[n3] = string = new String(byArray, "UTF8");
            }
            return string;
        }
        return new String(byArray, "UTF8");
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, String string, TypeCache typeCache) throws Exception {
        byte[] byArray = string.getBytes("UTF8");
        this.writeSize(dataOutputStream, byArray.length, 99, 255);
        dataOutputStream.write(byArray);
    }
}

