/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.AbstractSizedSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import com.sibvisions.util.ArrayUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListSerializer
extends AbstractSizedSerializer
implements ITypeSerializer<List> {
    private static final int TYPE_LIST_MIN = 42;
    private static final int TYPE_LIST_MAX = 44;
    private ArrayList<Class<? extends List>> registeredLists = new ArrayList();
    private HashMap<Class<? extends List>, Integer> listOrder = new HashMap();

    public ListSerializer() {
        this.registerList(ArrayList.class);
        this.registerList(ArrayUtil.class);
        this.registerList(Vector.class);
    }

    @Override
    public Class<List> getTypeClass() {
        return List.class;
    }

    @Override
    public int getMinValue() {
        return 42;
    }

    @Override
    public int getMaxValue() {
        return 44;
    }

    @Override
    public List read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        List<Object> list;
        int n2 = this.readSize(dataInputStream, n, 42, 44);
        int n3 = dataInputStream.readUnsignedByte();
        try {
            list = this.registeredLists.get(n3).newInstance();
        }
        catch (Exception exception) {
            list = new ArrayList(n2);
        }
        for (int i = 0; i < n2; ++i) {
            list.add(universalSerializer.read(dataInputStream, typeCache));
        }
        return list;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, List list, TypeCache typeCache) throws Exception {
        this.writeSize(dataOutputStream, list.size(), 42, 44);
        Integer n = this.listOrder.get(list.getClass());
        if (n == null) {
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(n);
        }
        for (int i = 0; i < list.size(); ++i) {
            universalSerializer.write(dataOutputStream, list.get(i), typeCache);
        }
    }

    public void registerList(Class<? extends List> clazz) {
        if (this.listOrder.get(clazz) == null) {
            this.listOrder.put(clazz, this.registeredLists.size());
            this.registeredLists.add(clazz);
        }
    }
}

