/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.rad.type.bean.BeanType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSerializer
implements ITypeSerializer<Enum> {
    public static final int TYPE_ENUM = 71;

    @Override
    public Class<Enum> getTypeClass() {
        return Enum.class;
    }

    @Override
    public int getMinValue() {
        return 71;
    }

    @Override
    public int getMaxValue() {
        return 71;
    }

    @Override
    public Enum read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        Object object = universalSerializer.read(dataInputStream, typeCache);
        String string = (String)universalSerializer.read(dataInputStream, typeCache);
        Class<?> clazz = object instanceof BeanType ? ((BeanType)object).getTypeClass() : Class.forName((String)object);
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, string);
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not an enum!");
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, Enum enum_, TypeCache typeCache) throws Exception {
        dataOutputStream.writeByte(71);
        universalSerializer.write(dataOutputStream, BeanType.getBeanType(enum_.getClass()), typeCache);
        universalSerializer.write(dataOutputStream, enum_.name(), typeCache);
    }
}

