/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.remote.serializer;

import com.sibvisions.rad.remote.UniversalSerializer;
import com.sibvisions.rad.remote.serializer.ITypeSerializer;
import com.sibvisions.rad.remote.serializer.TypeCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.rad.type.bean.AbstractBean;
import javax.rad.type.bean.Bean;
import javax.rad.type.bean.BeanType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializer
implements ITypeSerializer<AbstractBean> {
    public static final int TYPE_BEAN = 70;

    @Override
    public Class<AbstractBean> getTypeClass() {
        return AbstractBean.class;
    }

    @Override
    public int getMinValue() {
        return 70;
    }

    @Override
    public int getMaxValue() {
        return 70;
    }

    @Override
    public AbstractBean read(UniversalSerializer universalSerializer, DataInputStream dataInputStream, int n, TypeCache typeCache) throws Exception {
        BeanType beanType = (BeanType)universalSerializer.read(dataInputStream, typeCache);
        int n2 = beanType.getPropertyCount();
        Bean bean = new Bean(beanType);
        for (int i = 0; i < n2; ++i) {
            beanType.put((Object)bean, i, universalSerializer.read(dataInputStream, typeCache));
        }
        return bean;
    }

    @Override
    public void write(UniversalSerializer universalSerializer, DataOutputStream dataOutputStream, AbstractBean abstractBean, TypeCache typeCache) throws Exception {
        BeanType beanType = BeanType.getBeanType(abstractBean);
        int n = beanType.getPropertyCount();
        if (n == 0) {
            throw new IOException("There is no ITypeSerializer registered for Objects of instance " + beanType.getClassName() + "!");
        }
        dataOutputStream.writeByte(70);
        universalSerializer.write(dataOutputStream, beanType, typeCache);
        for (int i = 0; i < n; ++i) {
            universalSerializer.write(dataOutputStream, beanType.get((Object)abstractBean, i), typeCache);
        }
    }
}

