/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model;

import com.sibvisions.rad.model.mem.MemDataBook;
import com.sibvisions.util.ArrayUtil;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.IDataBook;
import javax.rad.model.ModelException;
import javax.rad.model.RowDefinition;
import javax.rad.model.datatype.BigDecimalDataType;
import javax.rad.model.datatype.BinaryDataType;
import javax.rad.model.datatype.BooleanDataType;
import javax.rad.model.datatype.ObjectDataType;
import javax.rad.model.datatype.TimestampDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataBookBuilder {
    private boolean bNumber = false;
    private boolean bString = false;
    private boolean bTimestamp = false;
    private boolean bBoolean = false;
    private boolean bBinary = false;
    private boolean bObject = false;

    private DataBookBuilder() {
    }

    private void checkType(Object object) {
        if (object != null) {
            if (object instanceof String) {
                this.bString = true;
            } else if (object instanceof Number) {
                this.bNumber = true;
            } else if (object instanceof Date) {
                this.bTimestamp = true;
            } else if (object instanceof Boolean) {
                this.bBoolean = true;
            } else if (object instanceof byte[] || object instanceof InputStream) {
                this.bBinary = true;
            } else {
                this.bObject = true;
            }
        }
    }

    private ColumnDefinition createColumnDefinition(String string) {
        boolean[] blArray = new boolean[]{this.bString, this.bNumber, this.bTimestamp, this.bBoolean, this.bBinary, this.bObject};
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        if (n == 1) {
            if (this.bNumber) {
                return new ColumnDefinition(string, new BigDecimalDataType());
            }
            if (this.bTimestamp) {
                return new ColumnDefinition(string, new TimestampDataType());
            }
            if (this.bBoolean) {
                return new ColumnDefinition(string, new BooleanDataType());
            }
            if (this.bBinary) {
                return new ColumnDefinition(string, new BinaryDataType());
            }
            if (this.bObject) {
                return new ColumnDefinition(string, new ObjectDataType());
            }
        }
        return new ColumnDefinition(string);
    }

    public static IDataBook build(Object[] objectArray) throws ModelException {
        return DataBookBuilder.build(objectArray, false);
    }

    public static IDataBook build(Object[] objectArray, boolean bl) throws ModelException {
        DataBookBuilder dataBookBuilder = new DataBookBuilder();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                dataBookBuilder.checkType(objectArray[i]);
            }
        }
        RowDefinition rowDefinition = new RowDefinition();
        rowDefinition.addColumnDefinition(new ColumnDefinition("ID", new BigDecimalDataType()));
        rowDefinition.addColumnDefinition(dataBookBuilder.createColumnDefinition("VALUE"));
        MemDataBook memDataBook = new MemDataBook(rowDefinition);
        memDataBook.setName("arrayOfValues");
        memDataBook.open();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (bl && ArrayUtil.indexOf(objectArray, objectArray[i], 0, i) >= 0) continue;
                memDataBook.insert(false);
                memDataBook.setValues(new String[]{"ID", "VALUE"}, new Object[]{BigDecimal.valueOf(i), objectArray[i]});
            }
        }
        memDataBook.saveAllRows();
        return memDataBook;
    }

    public static IDataBook build(List<Object> list) throws ModelException {
        return DataBookBuilder.build(list, false);
    }

    public static IDataBook build(List<Object> list, boolean bl) throws ModelException {
        Object[] objectArray = list != null ? list.toArray(new Object[list.size()]) : null;
        return DataBookBuilder.build(objectArray, bl);
    }

    public static IDataBook build(Map<?, ?> map) throws ModelException {
        DataBookBuilder dataBookBuilder = new DataBookBuilder();
        DataBookBuilder dataBookBuilder2 = new DataBookBuilder();
        if (map != null) {
            for (Map.Entry object2 : map.entrySet()) {
                dataBookBuilder.checkType(object2.getKey());
                dataBookBuilder2.checkType(object2.getValue());
            }
        }
        RowDefinition rowDefinition = new RowDefinition();
        rowDefinition.addColumnDefinition(dataBookBuilder.createColumnDefinition("ID"));
        rowDefinition.addColumnDefinition(dataBookBuilder2.createColumnDefinition("VALUE"));
        MemDataBook memDataBook = new MemDataBook(rowDefinition);
        memDataBook.setName("mapOfValues");
        memDataBook.open();
        if (map != null) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                memDataBook.insert(false);
                memDataBook.setValues(new String[]{"ID", "VALUE"}, new Object[]{entry.getKey(), entry.getValue()});
            }
        }
        memDataBook.saveAllRows();
        return memDataBook;
    }
}

