/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import com.google.api.gbase.client.DateTimeRange;
import com.google.api.gbase.client.GoogleBaseAttribute;
import com.google.api.gbase.client.GoogleBaseAttributeType;
import com.google.api.gbase.client.Group;
import com.google.api.gbase.client.Location;
import com.google.api.gbase.client.NumberUnit;
import com.google.api.gbase.client.Shipping;
import com.google.api.gbase.client.Tax;
import com.google.common.collect.Multimap;
import com.google.gdata.data.DateTime;
import com.google.gdata.util.common.base.StringUtil;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConversionUtil {
    private static final String LATITUDE_ELEMENT_NAME = "latitude";
    private static final String LONGITUDE_ELEMENT_NAME = "longitude";

    private ConversionUtil() {
    }

    static Float toFloat(String text) {
        if (text == null) {
            return null;
        }
        return new Float(text);
    }

    static Integer toInteger(String text) {
        if (text == null) {
            return null;
        }
        return new Integer(text);
    }

    static Boolean toBoolean(String text) {
        if (text == null) {
            return null;
        }
        return new Boolean(text);
    }

    static DateTime toDateOrDateTime(String text) {
        if (text == null) {
            return null;
        }
        return DateTime.parseDateTimeChoice(text);
    }

    public static NumberUnit<Integer> toIntUnit(String string) {
        if (string == null) {
            return null;
        }
        int firstSpace = ConversionUtil.findFirstSpace(string);
        String beforeSpace = ConversionUtil.beforeSpace(string, firstSpace);
        return new NumberUnit<Integer>(new Integer(beforeSpace), ConversionUtil.parseUnit(string, firstSpace));
    }

    public static NumberUnit<Float> toFloatUnit(String string) {
        if (string == null) {
            return null;
        }
        int firstSpace = ConversionUtil.findFirstSpace(string);
        String beforeSpace = ConversionUtil.beforeSpace(string, firstSpace);
        return new NumberUnit<Float>(new Float(beforeSpace), ConversionUtil.parseUnit(string, firstSpace));
    }

    private static String beforeSpace(String string, int firstSpace) {
        return string.substring(0, firstSpace);
    }

    private static String parseUnit(String string, int firstSpace) {
        return string.substring(firstSpace + 1).trim();
    }

    private static int findFirstSpace(String string) {
        int firstSpace = string.indexOf(" ");
        if (firstSpace == -1 || firstSpace == string.length()) {
            throw new NumberFormatException("missing unit in '" + string + "'");
        }
        return firstSpace;
    }

    public static GoogleBaseAttribute createAttribute(String name, DateTimeRange range) {
        return new GoogleBaseAttribute(name, GoogleBaseAttributeType.DATE_TIME_RANGE, range.toString());
    }

    public static DateTimeRange extractDateTimeRange(GoogleBaseAttribute attribute) {
        String range = attribute.getValueAsString();
        int space = range.indexOf(32);
        if (space == -1) {
            return new DateTimeRange(ConversionUtil.toDateOrDateTime(range));
        }
        String startStr = range.substring(0, space);
        String endStr = range.substring(space + 1);
        return new DateTimeRange(ConversionUtil.toDateOrDateTime(startStr), ConversionUtil.toDateOrDateTime(endStr));
    }

    public static Group extractGroup(GoogleBaseAttribute attribute) {
        return new Group(attribute.getSubAttributes());
    }

    public static GoogleBaseAttribute createAttribute(String name, Group group) {
        GoogleBaseAttribute attribute = new GoogleBaseAttribute(name, GoogleBaseAttributeType.GROUP);
        Multimap<String, GoogleBaseAttribute> subAttributes = group.getAllSubAttributes();
        for (GoogleBaseAttribute attr : subAttributes.values()) {
            GoogleBaseAttributeType type = attr.getType();
            if (GoogleBaseAttributeType.GROUP.equals(type) || GoogleBaseAttributeType.GROUP.equals(type.getSupertype()) || !attr.hasValue() && !attr.hasSubElements()) continue;
            attribute.addSubAttribute(attr);
        }
        return attribute;
    }

    public static Shipping extractShipping(GoogleBaseAttribute attribute) {
        if (attribute.hasSubAttributes()) {
            return ConversionUtil.extractShippingFromAttributes(attribute);
        }
        return ConversionUtil.extractShippingFromElements(attribute);
    }

    private static Shipping extractShippingFromAttributes(GoogleBaseAttribute attribute) {
        NumberUnit<Float> priceUnit = null;
        String country = null;
        ArrayList<String> regions = new ArrayList<String>();
        String service = null;
        for (GoogleBaseAttribute attr : attribute.getSubAttributes()) {
            String name = attr.getName();
            if (ShippingField.Country.getAttrName().equals(name)) {
                country = attr.getValueAsString();
                continue;
            }
            if (ShippingField.Region.getAttrName().equals(name)) {
                regions.add(attr.getValueAsString());
                continue;
            }
            if (ShippingField.Price.getAttrName().equals(name)) {
                String price = attr.getValueAsString();
                try {
                    priceUnit = ConversionUtil.toFloatUnit(price);
                }
                catch (NumberFormatException e) {
                    priceUnit = new NumberUnit<Float>(Float.valueOf(Float.parseFloat(price)), null);
                }
                continue;
            }
            if (ShippingField.Service.getAttrName().equals(name)) {
                service = attr.getValueAsString();
                continue;
            }
            throw new IllegalArgumentException("Sub-attribute " + name + " is not supported in Shipping.");
        }
        if (priceUnit == null) {
            throw new NumberFormatException("missing 'price' element in shipping attribute: " + attribute);
        }
        return new Shipping(country, regions, service, ((Float)priceUnit.getValue()).floatValue(), priceUnit.getUnit());
    }

    private static Shipping extractShippingFromElements(GoogleBaseAttribute attribute) {
        NumberUnit<Float> priceUnit;
        String country = attribute.getSubElementValue(ShippingField.Country.getElemName());
        Collection<String> regions = attribute.getSubElementValues(ShippingField.Region.getElemName());
        String price = attribute.getSubElementValue(ShippingField.Price.getElemName());
        String service = attribute.getSubElementValue(ShippingField.Service.getElemName());
        if (price == null) {
            throw new NumberFormatException("missing 'price' element in shipping attribute: " + attribute);
        }
        try {
            priceUnit = ConversionUtil.toFloatUnit(price);
        }
        catch (NumberFormatException e) {
            priceUnit = new NumberUnit<Float>(Float.valueOf(Float.parseFloat(price)), null);
        }
        return new Shipping(country, regions, service, priceUnit.getValue().floatValue(), priceUnit.getUnit());
    }

    public static GoogleBaseAttribute createAttribute(String name, Shipping shipping) {
        GoogleBaseAttribute attribute = new GoogleBaseAttribute(name, GoogleBaseAttributeType.SHIPPING);
        if (shipping.getCountry() != null) {
            GoogleBaseAttribute countryAttr = new GoogleBaseAttribute(ShippingField.Country.getAttrName(), null, shipping.getCountry());
            attribute.addSubAttribute(countryAttr);
        }
        for (String region : shipping.getRegions()) {
            GoogleBaseAttribute regionAttr = new GoogleBaseAttribute(ShippingField.Region.getAttrName(), null, region);
            attribute.addSubAttribute(regionAttr);
        }
        if (shipping.getService() != null) {
            GoogleBaseAttribute serviceAttr = new GoogleBaseAttribute(ShippingField.Service.getAttrName(), null, shipping.getService());
            attribute.addSubAttribute(serviceAttr);
        }
        String priceWithUnit = Float.toString(shipping.getPrice());
        if (shipping.getCurrency() != null) {
            priceWithUnit = priceWithUnit + " " + shipping.getCurrency();
        }
        GoogleBaseAttribute priceAttr = new GoogleBaseAttribute(ShippingField.Price.getAttrName(), null, priceWithUnit);
        attribute.addSubAttribute(priceAttr);
        return attribute;
    }

    public static Tax extractTax(GoogleBaseAttribute attribute) {
        if (attribute.hasSubAttributes()) {
            return ConversionUtil.extractTaxFromAttributes(attribute);
        }
        return ConversionUtil.extractTaxFromElements(attribute);
    }

    private static Tax extractTaxFromAttributes(GoogleBaseAttribute attribute) {
        String rateString = null;
        String country = null;
        ArrayList<String> regions = new ArrayList<String>();
        Boolean taxShip = null;
        for (GoogleBaseAttribute attr : attribute.getSubAttributes()) {
            String name = attr.getName();
            if (TaxField.Country.getAttrName().equals(name)) {
                country = attr.getValueAsString();
                continue;
            }
            if (TaxField.Region.getAttrName().equals(name)) {
                regions.add(attr.getValueAsString());
                continue;
            }
            if (TaxField.Rate.getAttrName().equals(name)) {
                rateString = attr.getValueAsString();
                continue;
            }
            if (TaxField.TaxShip.getAttrName().equals(name)) {
                String taxShipString = attr.getValueAsString();
                if (taxShipString == null) continue;
                taxShip = Boolean.valueOf(taxShipString);
                continue;
            }
            throw new IllegalArgumentException("Sub-attribute " + name + " is not supported in Tax.");
        }
        if (StringUtil.isEmpty(rateString)) {
            throw new NumberFormatException("missing 'rate' element in tax attribute: " + attribute);
        }
        float rate = Float.valueOf(rateString.trim()).floatValue();
        return new Tax(country, regions, rate, taxShip);
    }

    private static Tax extractTaxFromElements(GoogleBaseAttribute attribute) {
        String country = attribute.getSubElementValue(TaxField.Country.getElemName());
        Collection<String> regions = attribute.getSubElementValues(TaxField.Region.getElemName());
        String rateString = attribute.getSubElementValue(TaxField.Rate.getElemName());
        if (rateString == null) {
            throw new NumberFormatException("missing 'rate' element in tax attribute: " + attribute);
        }
        float rate = Float.valueOf(rateString.trim()).floatValue();
        String taxShipString = attribute.getSubElementValue(TaxField.TaxShip.getElemName());
        Boolean taxShip = null;
        if (taxShipString != null) {
            taxShip = Boolean.valueOf(taxShipString);
        }
        return new Tax(country, regions, rate, taxShip);
    }

    public static GoogleBaseAttribute createAttribute(String name, Tax tax) {
        GoogleBaseAttribute attribute = new GoogleBaseAttribute(name, GoogleBaseAttributeType.TAX);
        GoogleBaseAttribute attr = null;
        if (tax.getCountry() != null) {
            attr = new GoogleBaseAttribute(TaxField.Country.getAttrName(), null, tax.getCountry());
            attribute.addSubAttribute(attr);
        }
        for (String region : tax.getRegions()) {
            attr = new GoogleBaseAttribute(TaxField.Region.getAttrName(), null, region);
            attribute.addSubAttribute(attr);
        }
        attr = new GoogleBaseAttribute(TaxField.Rate.getAttrName(), null, Float.toString(tax.getRate()));
        attribute.addSubAttribute(attr);
        if (tax.getTaxShip() != null) {
            attr = new GoogleBaseAttribute(TaxField.TaxShip.getAttrName(), null, tax.getTaxShip() != false ? "true" : "false");
            attribute.addSubAttribute(attr);
        }
        return attribute;
    }

    public static Location extractLocation(GoogleBaseAttribute attribute) {
        String address = attribute.getValueAsString();
        Location retval = new Location(address);
        String latString = attribute.getSubElementValue(LATITUDE_ELEMENT_NAME);
        String longString = attribute.getSubElementValue(LONGITUDE_ELEMENT_NAME);
        if (latString != null && longString != null) {
            retval.setLatitude(Float.parseFloat(latString));
            retval.setLongitude(Float.parseFloat(longString));
        }
        return retval;
    }

    public static GoogleBaseAttribute createAttribute(String name, Location location) {
        GoogleBaseAttribute attribute = new GoogleBaseAttribute(name, GoogleBaseAttributeType.LOCATION);
        attribute.setValue(location.getAddress());
        if (location.hasCoordinates()) {
            attribute.setSubElement(LATITUDE_ELEMENT_NAME, Float.toString(location.getLatitude()));
            attribute.setSubElement(LONGITUDE_ELEMENT_NAME, Float.toString(location.getLongitude()));
        }
        return attribute;
    }

    public static Number extractNumber(GoogleBaseAttribute attr) {
        if (attr == null) {
            return null;
        }
        if (GoogleBaseAttributeType.FLOAT.equals(attr.getAttributeId().getType())) {
            return ConversionUtil.toFloat(attr.getValueAsString());
        }
        return ConversionUtil.toInteger(attr.getValueAsString());
    }

    public static NumberUnit<? extends Number> extractNumberUnit(GoogleBaseAttribute attr) {
        if (attr == null) {
            return null;
        }
        if (GoogleBaseAttributeType.INT_UNIT.equals(attr.getAttributeId().getType())) {
            return ConversionUtil.toIntUnit(attr.getValueAsString());
        }
        return ConversionUtil.toFloatUnit(attr.getValueAsString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ShippingField {
        Country("country"),
        Region("region"),
        Price("price"),
        Service("service");

        private final String elemName;
        private final String attrName;

        private ShippingField(String elemName) {
            this.elemName = elemName;
            this.attrName = elemName.replace('_', ' ');
        }

        public String getElemName() {
            return this.elemName;
        }

        public String getAttrName() {
            return this.attrName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TaxField {
        Country("country"),
        Region("region"),
        Rate("rate"),
        TaxShip("tax_ship");

        private final String elemName;
        private final String attrName;

        private TaxField(String elemName) {
            this.elemName = elemName;
            this.attrName = elemName.replace('_', ' ');
        }

        public String getElemName() {
            return this.elemName;
        }

        public String getAttrName() {
            return this.attrName;
        }
    }
}

