/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.util.Arrays;
import java.util.List;

public class TestJunction {
    public static void main(String[] args) {
        try {
            String dir = args[0];
            File dirFile = new File(dir);
            List<File> fileNames = Arrays.asList(dirFile.listFiles());
            System.out.println("\n# test for junction");
            fileNames.forEach(file -> {
                try {
                    System.out.format("%15s -> isJunction = %s\n", file.getAbsolutePath(), TestJunction.isJunction(Paths.get(file.getAbsolutePath(), new String[0])));
                    FileChannel fileChannel = FileChannel.open(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);
                    long fileSize = fileChannel.size();
                    System.out.format(String.valueOf(Files.size(Paths.get(file.getAbsolutePath(), new String[0]))) + " The size of the file: %d bytes", fileSize);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            System.out.println("\n# test for symlink");
            fileNames.forEach(file -> System.out.format("%15s -> isSymbolicLink = %s\n", file.getAbsolutePath(), Files.isSymbolicLink(Paths.get(file.getAbsolutePath(), new String[0]))));
            System.out.println("\n# test for regular file");
            fileNames.forEach(file -> System.out.format("%15s -> isRegularFile = %s\n", file.getAbsolutePath(), Files.isRegularFile(Paths.get(file.getAbsolutePath(), new String[0]), new LinkOption[0])));
            System.out.println("\n# test from another code");
            fileNames.forEach(file -> {
                try {
                    BasicFileAttributes attr = Files.readAttributes(Paths.get(file.getAbsolutePath(), new String[0]), BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    boolean isReparsePoint = false;
                    if (DosFileAttributes.class.isInstance(attr)) {
                        try {
                            Method m = attr.getClass().getDeclaredMethod("isReparsePoint", new Class[0]);
                            m.setAccessible(true);
                            isReparsePoint = (Boolean)m.invoke((Object)attr, new Object[0]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    System.out.println("...File Attr..is other:" + attr.isOther() + " ...isRegular:" + attr.isRegularFile() + " ...issymbolic:" + attr.isOther());
                    System.out.format("%15s -> Another code is reparse point = %s\n", file.getAbsolutePath(), isReparsePoint);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isJunction(Path p) {
        boolean isJunction = false;
        try {
            isJunction = p.compareTo(p.toRealPath(new LinkOption[0])) != 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isJunction;
    }
}

