/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;

public class GeoLocation {
    public static final double RADIUS = 3963.1676;
    private double latitude;
    private double longitude;

    public GeoLocation(double theLatitude, double theLongitude) {
        this.latitude = theLatitude;
        this.longitude = theLongitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String toString() {
        return "latitude: " + this.latitude + ", longitude: " + this.longitude;
    }

    public double distanceFrom(GeoLocation other) {
        double lat1 = Math.toRadians(this.latitude);
        double long1 = Math.toRadians(this.longitude);
        double lat2 = Math.toRadians(other.latitude);
        double long2 = Math.toRadians(other.longitude);
        double theCos = Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(long1 - long2);
        double arcLength = Math.acos(theCos);
        return arcLength * 3963.1676;
    }

    public static void main(String[] args) throws IOException {
        GeoLocation geoLocation = new GeoLocation(12.912093299999999, 77.6444473);
        double miles = geoLocation.distanceFrom(new GeoLocation(11.22598745, 78.17908206199391));
        System.out.println("Distance in miles:" + miles);
        System.out.println(String.valueOf(miles * 1.6) + " Kilometers");
    }
}

