/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.bluvault.udc.service.impl;

import com.parablu.bluvault.udc.dto.AuthorizationDeviceTo;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.helper.utils.MD5Generator;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BSDeviceInfoElement;
import com.parablu.paracloud.element.BSPrivacyGatewayElement;
import com.parablu.paracloud.element.BSPrivacyGatewayMappingElement;
import com.parablu.paracloud.element.BackupFolderElement;
import com.parablu.paracloud.element.BluSyncGroupBackupPolicyElement;
import com.parablu.paracloud.element.BluSyncGroupSyncPolicyElement;
import com.parablu.paracloud.element.BluSyncScheduleElement;
import com.parablu.paracloud.element.BluVaultMappingElement;
import com.parablu.paracloud.element.CalloutScriptElement;
import com.parablu.paracloud.element.DeviceContainerElement;
import com.parablu.paracloud.element.DeviceContainerListElement;
import com.parablu.paracloud.element.DeviceElement;
import com.parablu.paracloud.element.EditDeviceContainerElement;
import com.parablu.paracloud.element.EndpointUiDisabledPreferencesElement;
import com.parablu.paracloud.element.EndpointUiPreferencesElement;
import com.parablu.paracloud.element.InclusionFilterElement;
import com.parablu.paracloud.element.NetworkThrottlingElement;
import com.parablu.paracloud.element.ScheduleDaysArrayElement;
import com.parablu.paracloud.element.UserAnouncement;
import com.parablu.paracloud.element.UserDevicesElement;
import com.parablu.paracloud.util.TokenGenerator;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.dao.AuthorizationDao;
import com.parablu.pcbd.dao.BackUpImageDao;
import com.parablu.pcbd.dao.BackupBatchDao;
import com.parablu.pcbd.dao.BackupOverViewDao;
import com.parablu.pcbd.dao.BackupPolicyDao;
import com.parablu.pcbd.dao.BluVaultDao;
import com.parablu.pcbd.dao.DeviceContainerDao;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.dao.ExcludedFoldersDao;
import com.parablu.pcbd.dao.PrivacyGateWayDao;
import com.parablu.pcbd.dao.ReleaseDao;
import com.parablu.pcbd.dao.SearchIndexDao;
import com.parablu.pcbd.dao.UserDao;
import com.parablu.pcbd.dao.UserDefinedFoldersDao;
import com.parablu.pcbd.dao.UserGroupDao;
import com.parablu.pcbd.domain.AuditHistory;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.BackupFolders;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.CalloutScript;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.DeletedSearchIndex;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.DeviceContainer;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.Group;
import com.parablu.pcbd.domain.InclusionFilter;
import com.parablu.pcbd.domain.LatestDeviceBackupInfo;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.NetworkThrottling;
import com.parablu.pcbd.domain.O365BlackListUser;
import com.parablu.pcbd.domain.OdbFolderNameTODeviceUUIDMapping;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PrivacyGateway;
import com.parablu.pcbd.domain.Release;
import com.parablu.pcbd.domain.Schedule;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDefinedFolders;
import com.parablu.pcbd.domain.UserDeviceAccessControl;
import com.parablu.pcsd.domain.SyncPolicy;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bson.types.ObjectId;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class DeviceManagementServiceImpl
implements DeviceManagementService {
    private static Logger logger = LogManager.getLogger(DeviceManagementServiceImpl.class);
    private UserDao userDao;
    private DeviceDao deviceDao;
    private AuditHistoryDao auditHistoryDao;
    private BackupPolicyDao backupPolicyDao;
    private AuthorizationDao authorizationDao;
    private BackupBatchDao backupBatchDao;
    private BackUpImageDao backUpImageDao;
    private ReleaseDao releaseDao;
    private BackupOverViewDao backupOverViewDao;
    @Autowired
    private UserGroupDao userGroupDao;
    @Autowired
    private DeviceContainerDao deviceContainerDao;
    @Resource
    private BluVaultDao bluVaultDao;
    @Resource
    private UserDefinedFoldersDao userDefinedFoldersDao;
    @Resource
    private PrivacyGateWayDao privacyGateWayDao;
    @Resource
    private ExcludedFoldersDao userExcludedFoldersDao;
    private SearchIndexDao searchIndexDao;
    private static final String GATEWAY = "GATEWAY";
    private static final String NO_SUCH_ALOGORITHM_EXCEPTION = " NoSuchAlgorithmException  :";
    private static final String INVLAID_KEY_SPEC_EXCEPTION = " InvalidKeySpecException  :";
    private static final BigInteger NEAGATIVE_ONE = new BigInteger("-1");
    private static final String EXCEPTION = " Exception  :";
    public static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";

    public void setSearchIndexDao(SearchIndexDao searchIndexDao) {
        this.searchIndexDao = searchIndexDao;
    }

    public void setBackupOverViewDao(BackupOverViewDao backupOverViewDao) {
        this.backupOverViewDao = backupOverViewDao;
    }

    public void setReleaseDao(ReleaseDao releaseDao) {
        this.releaseDao = releaseDao;
    }

    public void setBackUpImageDao(BackUpImageDao backUpImageDao) {
        this.backUpImageDao = backUpImageDao;
    }

    public void setBackupBatchDao(BackupBatchDao backupBatchDao) {
        this.backupBatchDao = backupBatchDao;
    }

    public void setAuthorizationDao(AuthorizationDao authorizationDao) {
        this.authorizationDao = authorizationDao;
    }

    public void setAuditHistoryDao(AuditHistoryDao auditHistoryDao) {
        this.auditHistoryDao = auditHistoryDao;
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setDeviceDao(DeviceDao dao) {
        this.deviceDao = dao;
    }

    public void setBackupPolicyDao(BackupPolicyDao backupPolicyDao) {
        this.backupPolicyDao = backupPolicyDao;
    }

    @Override
    public List<DeviceElement> getAllDevices(int cloudId, String cloudName) {
        ArrayList<DeviceElement> devElementList = new ArrayList<DeviceElement>();
        List deviceList = this.deviceDao.getAll(cloudId, cloudName);
        for (Device device : deviceList) {
            DeviceElement ue = new DeviceElement();
            BeanUtils.copyProperties((Object)device, (Object)ue);
            ue.setDeviceId(device.getId().toString());
            ue.setUserId(device.getUserId());
            ue.setUserName(device.getUserName());
            devElementList.add(ue);
        }
        return devElementList;
    }

    @Override
    public AuthorizationDeviceTo registerDevice(int cloudId, String cloudName, DeviceElement deviceElement, AuthorizationTokens authorizationTokens, User user, int clientType) {
        String newToken = TokenGenerator.generateToken();
        AuthorizationDeviceTo authorizationDeviceTo = new AuthorizationDeviceTo();
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, deviceElement.getDeviceUUID());
        if (authorizationTokens != null) {
            logger.debug(" ************* Device Management  registerDevice authorizationTokens not null " + deviceElement.getDeviceUUID());
            if (device == null) {
                throw new BaseException("Bad request, Devic not registered");
            }
            if (device.isBlocked()) {
                return null;
            }
            device.setUserName(user.getUserName());
            device.setUserId(user.getUserId());
            device.setOsType(deviceElement.getOsType());
            device.setOsVersion(deviceElement.getOsVersion());
            Device existingDevice = this.deviceDao.getDeviceByName(cloudId, cloudName, deviceElement.getDeviceName().trim(), user.getUserName(), deviceElement.getDeviceUUID());
            if (existingDevice != null && !existingDevice.getDeviceUUID().equals(deviceElement.getDeviceUUID())) {
                throw new BaseException("Duplicate Device Name", 426);
            }
            if (!device.getDeviceName().equals(deviceElement.getDeviceName())) {
                this.updateDeviceNameAndSaveAudit(cloudId, cloudName, deviceElement, device);
            }
            this.deviceDao.updateDeviceInfo(cloudId, cloudName, device);
            authorizationTokens.setToken(newToken);
            authorizationTokens.setUser(user);
            authorizationTokens.setClientType(clientType);
            authorizationTokens.setModifiedTime(System.currentTimeMillis());
            authorizationTokens.setUniqueId(deviceElement.getDeviceUUID());
            authorizationDeviceTo.setAuthorizationTokens(authorizationTokens);
            authorizationDeviceTo.setDevice(device);
            return authorizationDeviceTo;
        }
        if (this.deviceDao.getDeviceByName(cloudId, cloudName, deviceElement.getDeviceName().trim(), user.getUserName(), deviceElement.getDeviceUUID()) != null) {
            throw new BaseException("Duplicate Device Name", 426);
        }
        if (device == null) {
            boolean success;
            logger.debug(" ************* Device Management  device null " + deviceElement.getDeviceUUID());
            device = new Device();
            BeanUtils.copyProperties((Object)deviceElement, (Object)device);
            String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + device.getDeviceUUID();
            File f = new File(path);
            if (!f.exists() && !(success = f.mkdirs())) {
                throw new BaseException("Failed to create the directory for device.");
            }
            device.setDeviceTempPath(path);
            device.setBlocked(false);
            device.setUserName(user.getUserName());
            device.setUserId(user.getUserId());
            device.setLastModifiedTimestamp(System.currentTimeMillis());
            this.deviceDao.register(cloudId, cloudName, device);
            DeviceBackupOverView overView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceElement.getDeviceUUID());
            if (overView == null) {
                logger.debug(" First time saving device backup ....");
                this.saveDeviceBackupOverView(cloudId, device);
            }
        } else {
            device.setUserName(user.getUserName());
            device.setUserId(user.getUserId());
        }
        if (device.isBlocked()) {
            return null;
        }
        AuthorizationTokens newAuthorizationTokens = new AuthorizationTokens();
        newAuthorizationTokens.setValiditoryPeriod(-10L);
        newAuthorizationTokens.setUniqueId(device.getDeviceUUID());
        newAuthorizationTokens.setModifiedTime(System.currentTimeMillis());
        newAuthorizationTokens.setToken(newToken);
        newAuthorizationTokens.setUser(user);
        newAuthorizationTokens.setClientType(clientType);
        authorizationDeviceTo.setAuthorizationTokens(newAuthorizationTokens);
        authorizationDeviceTo.setDevice(device);
        return authorizationDeviceTo;
    }

    @Override
    public AuthorizationDeviceTo registerDeviceV2(int cloudId, String cloudName, DeviceElement deviceElement, AuthorizationTokens authorizationTokens1, User user, int clientType) {
        boolean success;
        AuthorizationTokens authorizationTokens = authorizationTokens1;
        String newToken = TokenGenerator.generateToken();
        AuthorizationDeviceTo authorizationDeviceTo = new AuthorizationDeviceTo();
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, deviceElement.getDeviceUUID());
        try {
            if (device == null && (device = this.deviceDao.getDeviceByNameAndUser(cloudId, deviceElement.getDeviceName(), user.getUserName())) != null) {
                authorizationTokens = this.authorizationDao.getAuthorizationTokenForDevice(cloudId, cloudName, device.getDeviceUUID());
            }
        }
        catch (Exception e) {
            logger.trace("Exception " + e);
            logger.error("Exception" + e.getMessage());
        }
        if (authorizationTokens != null || device != null) {
            logger.debug(" ************* Device Management  registerDevice authorizationTokens not null " + deviceElement.getDeviceUUID());
            if (device == null) {
                throw new BaseException("Bad request, Devic not registered");
            }
            if (device.isBlocked()) {
                return null;
            }
            device.setUserName(user.getUserName());
            device.setUserId(user.getUserId());
            device.setOsType(deviceElement.getOsType());
            device.setOsVersion(deviceElement.getOsVersion());
            device.setClientVersion(deviceElement.getClientVersion());
            device.setBlocked(false);
            device.setDecoupled(false);
            if (device != null && StringUtils.isEmpty((String)device.getDisplayName())) {
                device.setDisplayName(device.getDeviceName());
            }
            this.deviceDao.updateDeviceInfo(cloudId, cloudName, device);
            DeviceBackupOverView deviceBackupOverView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
            if (deviceBackupOverView != null) {
                this.deviceDao.updatedeviceInfoInDeviceBkpOverview(cloudId, device);
            }
            if (authorizationTokens == null) {
                authorizationTokens = this.createAuthToken(device, clientType, newToken, user);
            } else {
                authorizationTokens.setToken(newToken);
                authorizationTokens.setUser(user);
                authorizationTokens.setClientType(clientType);
                authorizationTokens.setModifiedTime(System.currentTimeMillis());
            }
            authorizationDeviceTo.setAuthorizationTokens(authorizationTokens);
            authorizationDeviceTo.setDevice(device);
            this.deviceDao.blockOldDeviceBkpInfo(cloudId, device.getDeviceUUID());
            this.saveLatestDeviceBkpInfo(cloudId, device.getDeviceUUID());
            DeviceBackupOverView overView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
            if (overView == null) {
                logger.debug(" First time saving device backup ....");
                this.saveDeviceBackupOverView(cloudId, device);
            } else {
                List<DeviceBackupOverView> overViews = this.getAllDeviceBkpOverviewsForDeviceUUID(cloudId, device.getDeviceUUID());
                for (DeviceBackupOverView backupOverView : overViews) {
                    if (backupOverView.getId().toString().equalsIgnoreCase(overView.getId().toString())) continue;
                    this.deviceDao.deleteDeviceBackupOverviewById(cloudId, backupOverView.getId());
                }
            }
            return authorizationDeviceTo;
        }
        logger.debug(" ************* Device Management  device null " + deviceElement.getDeviceUUID());
        device = new Device();
        BeanUtils.copyProperties((Object)deviceElement, (Object)device);
        String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + device.getDeviceUUID();
        logger.debug(" ************* Device Management path " + path);
        File f = new File(path);
        if (!f.exists() && !(success = f.mkdirs())) {
            throw new BaseException("Failed to create the directory for device.");
        }
        device.setDeviceTempPath(path);
        device.setBlocked(false);
        device.setUserName(user.getUserName());
        device.setUserId(user.getUserId());
        device.setLastModifiedTimestamp(System.currentTimeMillis());
        device.setDecoupled(false);
        device.setDeviceType(Device.TYPE.BACKUP.name());
        this.deviceDao.register(cloudId, cloudName, device);
        this.saveLatestDeviceBkpInfo(cloudId, device.getDeviceUUID());
        DeviceBackupOverView overView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
        if (overView == null) {
            logger.debug(" First time saving device backup ....");
            this.saveDeviceBackupOverView(cloudId, device);
        }
        if (device.isBlocked()) {
            return null;
        }
        AuthorizationTokens newAuthorizationTokens = this.createAuthToken(device, clientType, newToken, user);
        authorizationDeviceTo.setAuthorizationTokens(newAuthorizationTokens);
        authorizationDeviceTo.setDevice(device);
        return authorizationDeviceTo;
    }

    private void saveLatestDeviceBkpInfo(int cloudId, String deviceUUID) {
        LatestDeviceBackupInfo deviceBackupInfo = new LatestDeviceBackupInfo();
        deviceBackupInfo.setDecoupled(false);
        deviceBackupInfo.setCreatedTimeStamp(System.currentTimeMillis());
        deviceBackupInfo.setDeviceUUID(deviceUUID);
        this.deviceDao.saveLatestDeviceBkpInfo(cloudId, deviceBackupInfo);
    }

    private AuthorizationTokens createAuthToken(Device device, int clientType, String newToken, User user) {
        AuthorizationTokens newAuthorizationTokens = new AuthorizationTokens();
        newAuthorizationTokens.setValiditoryPeriod(-10L);
        newAuthorizationTokens.setUniqueId(device.getDeviceUUID());
        newAuthorizationTokens.setModifiedTime(System.currentTimeMillis());
        newAuthorizationTokens.setToken(newToken);
        newAuthorizationTokens.setUser(user);
        newAuthorizationTokens.setClientType(clientType);
        return newAuthorizationTokens;
    }

    private void updateDeviceNameAndSaveAudit(int cloudId, String cloudName, DeviceElement deviceElement, Device device) {
        AuditHistory deviceAuditStatistic = new AuditHistory();
        deviceAuditStatistic.setAction("updated the device name from");
        deviceAuditStatistic.setActionByUserName(device.getUserName());
        deviceAuditStatistic.setActionOnObject(device.getDeviceName() + " to " + deviceElement.getDeviceName());
        deviceAuditStatistic.setTimestamp(System.currentTimeMillis());
        deviceAuditStatistic.setActionUsingObject(device.getDeviceName());
        this.auditHistoryDao.saveAudit(cloudId, cloudName, deviceAuditStatistic);
        device.setDeviceName(deviceElement.getDeviceName());
    }

    @Override
    public DeviceElement getDeviceInfo(int cloudId, String cloudName, String devUUID) {
        DeviceElement devElement = new DeviceElement();
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, devUUID);
        if (device == null) {
            throw new BaseException("Device doesn't exists.");
        }
        BeanUtils.copyProperties((Object)device, (Object)devElement);
        devElement.setUserName(device.getUserName());
        try {
            devElement.setDeviceId(device.getId().toString());
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            Date dateD = new Date(Long.parseLong(devElement.getDeviceCreatedDate()));
            devElement.setDeviceCreatedDate(df2.format(dateD));
            devElement.setDeviceCreatedMillis(dateD.getTime());
        }
        catch (NumberFormatException e) {
            logger.trace("NumberFormatException  " + e);
            logger.debug("NumberFormatException  " + e.getMessage());
        }
        return devElement;
    }

    @Override
    public void blockUnblockDevice(int cloudId, String cloudName, Device device, boolean toBlock) {
        if (device == null) {
            throw new BaseException("Device doesn't exists.");
        }
        this.deviceDao.blockUnblockDevice(cloudId, cloudName, device, toBlock);
        this.deviceDao.updateDeviceStatusInOverview(cloudId, device.getDeviceUUID(), toBlock);
        if (toBlock) {
            User user = this.userDao.getUserByName(cloudId, device.getUserName());
            this.authorizationDao.deleteAuthTokenByUserAndUniqueID(cloudId, user, device.getDeviceUUID());
        }
    }

    @Override
    public DeviceElement registerUUID(int cloudId, String cloudName, String uuid) {
        DeviceElement devElement = new DeviceElement();
        Device device = new Device();
        device.setDeviceUUID(uuid);
        device.setLastModifiedTimestamp(System.currentTimeMillis());
        Device d = this.deviceDao.saveUUID(cloudId, cloudName, device);
        if (d == null) {
            throw new BaseException("UUID already exists.");
        }
        BeanUtils.copyProperties((Object)d, (Object)devElement);
        return devElement;
    }

    @Override
    public DeviceElement updateInfo(int cloudId, String cloudName, DeviceElement deviceElement, User user) {
        DeviceElement devElement = new DeviceElement();
        this.deviceDao.blockUnblockDevice(cloudId, cloudName, deviceElement.getDeviceUUID(), deviceElement.isBlocked());
        this.deviceDao.updateDeviceStatusInOverview(cloudId, deviceElement.getDeviceUUID(), deviceElement.isBlocked());
        BeanUtils.copyProperties((Object)deviceElement, (Object)devElement);
        return devElement;
    }

    public static long getDayInMilliSeconds(String createdDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        Date date = null;
        if (createdDate == null || createdDate == "") {
            return System.currentTimeMillis();
        }
        try {
            date = sdf.parse(createdDate);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        if (date != null) {
            return date.getTime();
        }
        return 0L;
    }

    @Override
    public List<DeviceElement> getDevicesForUser(int cloudId, String cloudName, String userName) {
        ArrayList<DeviceElement> deviceElements = new ArrayList<DeviceElement>();
        List devices = this.deviceDao.getAllDeviceByUserName(cloudId, userName);
        if (CollectionUtils.isEmpty((Collection)devices)) {
            logger.debug(" ******* DEVICE DOES NOT EXISTS...");
            return deviceElements;
        }
        for (Device d : devices) {
            DeviceElement deviceElement = new DeviceElement();
            BeanUtils.copyProperties((Object)d, (Object)deviceElement);
            deviceElement.setDeviceId(d.getId().toString());
            deviceElement.setUserName(d.getUserName());
            this.setLastSuccessfullbackup(cloudId, userName, d, deviceElement);
            deviceElement.setDeviceType(d.getDeviceType());
            logger.debug(" ******* ......" + d.isCanAdminRestore());
            deviceElement.setCanAdminRestore(d.isCanAdminRestore());
            deviceElements.add(deviceElement);
        }
        return deviceElements;
    }

    @Override
    public List<Device> getAllDevicesForUser(int cloudId, String cloudName, String userName) {
        List devices = this.deviceDao.getAllActiveDeviceByUserName(cloudId, userName);
        if (devices == null) {
            logger.debug(" ******* DEVICE DOES NOT EXISTS for user ..." + userName);
            return null;
        }
        return devices;
    }

    @Override
    public Device getDeviceProperties(int cloudId, String cloudName, String deviceUUID) {
        return this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, deviceUUID);
    }

    @Override
    public Device getDeviceByObjectId(int cloudId, String cloudName, ObjectId id) {
        return this.deviceDao.getDeviceById(cloudId, id);
    }

    @Override
    public Device getDeviceByDeviceUUID(int cloudId, String cloudName, String deviceUUID) {
        return this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, deviceUUID);
    }

    @Override
    public Device getDeviceByName(int cloudId, String cloudName, String deviceName, String userName, String deviceUUID) {
        return this.deviceDao.getDeviceByName(cloudId, cloudName, deviceName, userName, deviceUUID);
    }

    @Override
    public List<DeviceElement> getDevicesByUser(int cloudId, String cloudName, User user) {
        ArrayList<DeviceElement> deviceElements = new ArrayList<DeviceElement>();
        if (user == null) {
            logger.debug(" ******* user DOES NOT EXISTS...");
            return deviceElements;
        }
        List devices = this.deviceDao.getAllDeviceByUser(cloudId, cloudName, user);
        if (CollectionUtils.isEmpty((Collection)devices)) {
            logger.debug(" ******* DEVICE DOES NOT EXISTS...");
            return deviceElements;
        }
        for (Device d : devices) {
            DeviceElement deviceElement = new DeviceElement();
            BeanUtils.copyProperties((Object)d, (Object)deviceElement);
            deviceElement.setDeviceId(d.getId().toString());
            deviceElement.setUserName(d.getUserName());
            this.setLastSuccessfullbackup(cloudId, user.getUserName(), d, deviceElement);
            deviceElements.add(deviceElement);
        }
        return deviceElements;
    }

    @Override
    public UserAnouncement getDeviceAndClientDetailsForUser(int cloudId, String cloudName, String userName) {
        User user = this.userDao.getUserInfoByName(cloudId, cloudName, userName);
        UserAnouncement userAnouncement = new UserAnouncement();
        if (user == null) {
            throw new BaseException("user not found", 400);
        }
        if (user.isSyncEnabled()) {
            userAnouncement.setSync(1);
        }
        if (user.isBackupEnabled()) {
            userAnouncement.setBackup(1);
        }
        if (this.deviceDao.getDeviceCountOfUser(cloudId, cloudName, user) > 0L) {
            userAnouncement.setClientDownloaded(1);
        }
        return userAnouncement;
    }

    @Override
    public List<Device> getActiveDeviceByName(int cloudId, String cloudName, String deviceName, String userName) {
        return this.deviceDao.getActiveDeviceByName(cloudId, cloudName, deviceName, userName);
    }

    @Override
    public List<Device> getActiveDeviceByNameAndUser(int cloudId, String cloudName, String deviceName, String userName) {
        return this.deviceDao.getActiveDeviceByNameAndUser(cloudId, cloudName, deviceName, userName);
    }

    @Override
    public void updateDeviceDecoupled(int cloudId, String cloudName, String deviceUUID) {
        this.deviceDao.updateDeviceDecoupled(cloudId, cloudName, deviceUUID);
    }

    @Override
    public void updateDeviceName(int cloudId, String deviceUUID, String deviceName) {
        this.deviceDao.updateDeviceName(cloudId, deviceUUID, deviceName);
    }

    @Override
    public Device getDeviceByName(int cloudId, String cloudName, String deviceName) {
        return this.deviceDao.getDeviceByName(cloudId, cloudName, deviceName);
    }

    @Override
    public BSDeviceInfoElement getDeviceInfoForUserAndDeviceUUID(int cloudId, String cloudName, String userName, String deviceUUID, boolean isServiceAcct) {
        LatestDeviceBackupInfo backupInfo;
        BSDeviceInfoElement bsDeviceInfoElement = new BSDeviceInfoElement();
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, deviceUUID);
        DeviceBackupOverView overView = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
        String deviceName = device.getDeviceName();
        User user = this.userDao.getUserByName(cloudId, device.getUserName());
        Object[] arr = this.backupBatchDao.getBSDeviceInfoElement(cloudId, cloudName, device, user);
        if (overView != null && overView.getLastSuccessfulBackupEndTime() > 0L) {
            String lastSuccessfulBkp = this.getDateInFormat(overView.getLastSuccessfulBackupEndTime());
            bsDeviceInfoElement.setLastSuccessBackup(lastSuccessfulBkp);
        }
        if (arr[1] != null) {
            String firstSuccessfulBkp = this.getDateInFormat((Long)arr[1]);
            bsDeviceInfoElement.setDeviceBackedUpFrom(firstSuccessfulBkp);
        }
        long storageUsed = 0L;
        if (arr[2] != null) {
            storageUsed = (Long)arr[2];
        }
        if ((backupInfo = this.deviceDao.getLatestDeviceBkpInfo(cloudId, overView.getDeviceUUID())) != null) {
            bsDeviceInfoElement.setTotalSizeOfDataInCurrentBackupSet(DeviceManagementServiceImpl.formatFileSize(backupInfo.getStorageUtilized()));
            long LatestVersionsSize = 0L;
            List allBackupInfoList = this.deviceDao.getAllLatestDeviceBkpInfo(cloudId, overView.getDeviceUUID());
            for (LatestDeviceBackupInfo bkpInfo : allBackupInfoList) {
                LatestVersionsSize += bkpInfo.getLatestVersionsSize();
            }
            bsDeviceInfoElement.setTotalSizeOfDataInCurrentBackupLatestVersion(DeviceManagementServiceImpl.formatFileSize(LatestVersionsSize));
        }
        bsDeviceInfoElement.setStorageUsedByDevice(DeviceManagementServiceImpl.formatFileSize(storageUsed));
        bsDeviceInfoElement.setDeviceName(deviceName);
        bsDeviceInfoElement.setDeviceId(device.getId().toString());
        bsDeviceInfoElement.setOsType(device.getOsType());
        bsDeviceInfoElement.setDeviceUUID(deviceUUID);
        bsDeviceInfoElement.setOsVersion(device.getOsVersion());
        if (!StringUtils.isEmpty((String)device.getClientVersion())) {
            bsDeviceInfoElement.setProductVersion(device.getClientVersion());
        } else {
            List list = this.releaseDao.getAllCurrentVersions();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                Release release = (Release)list.get(0);
                bsDeviceInfoElement.setProductVersion(release.getProductVersion());
            }
        }
        if (device.getOsType().toLowerCase().contains("window")) {
            bsDeviceInfoElement.setWindowsDevice(true);
        } else {
            bsDeviceInfoElement.setWindowsDevice(false);
        }
        if (arr[3] != null) {
            BackupPolicy backupPolicy = (BackupPolicy)arr[3];
            ArrayList schedules = backupPolicy.getSchedules();
            bsDeviceInfoElement.setNextScheduledBackup(DeviceManagementServiceImpl.getDate(DeviceManagementServiceImpl.getNextScheduledMinute(schedules)));
            bsDeviceInfoElement.setNextPolicyRefresh(backupPolicy.getPolicyRefresh());
        }
        return bsDeviceInfoElement;
    }

    private String getDateInFormat(Long deviceCreatedDate) {
        SimpleDateFormat df2 = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
        Date dateD = new Date(deviceCreatedDate);
        return df2.format(dateD);
    }

    @Override
    public int getUIVersion() {
        return 1;
    }

    private static String getDate(long dateVal) {
        Date date = new Date(dateVal);
        SimpleDateFormat df2 = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
        return df2.format(date);
    }

    public static String formatFileSize(long size) {
        String hrSize;
        double m = (double)size / 1024.0;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        if (t > 1.0) {
            hrSize = dec.format(t).concat(" TB");
        } else if (g > 1.0) {
            hrSize = dec.format(g).concat(" GB");
        } else {
            if (m <= 0.0) {
                m = 0.0;
            }
            hrSize = dec.format(m).concat(" MB");
        }
        return hrSize;
    }

    private static long getNextScheduledMinute(ArrayList<Schedule> list) {
        if (list == null || list.isEmpty()) {
            return 0L;
        }
        TreeSet<Date> dates = new TreeSet<Date>();
        for (Schedule scheduleTO : list) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            try {
                Date date1 = sdf.parse(scheduleTO.getTime());
                Calendar calendar = Calendar.getInstance();
                int dayOfWeek = calendar.get(7);
                calendar.set(13, 0);
                int[] daysArray = DeviceManagementServiceImpl.getArrayInt(scheduleTO.getDayArray());
                for (int i = 0; i < daysArray.length; ++i) {
                    Calendar calendar1 = Calendar.getInstance();
                    if (daysArray[i] > dayOfWeek) {
                        calendar1.add(5, daysArray[i] - dayOfWeek);
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        calendar1.set(13, 0);
                        dates.add(calendar1.getTime());
                        continue;
                    }
                    if (daysArray[i] < dayOfWeek) {
                        calendar1.add(5, 7 - (dayOfWeek - daysArray[i]));
                        calendar1.set(11, date1.getHours());
                        calendar1.set(12, date1.getMinutes());
                        calendar1.set(13, 0);
                        dates.add(calendar1.getTime());
                        continue;
                    }
                    if (daysArray[i] != dayOfWeek) continue;
                    calendar1.set(11, date1.getHours());
                    calendar1.set(12, date1.getMinutes());
                    calendar1.set(13, 0);
                    if (calendar.getTimeInMillis() > calendar1.getTimeInMillis()) {
                        calendar1.add(5, 7 - (dayOfWeek - daysArray[i]));
                    }
                    dates.add(calendar1.getTime());
                }
            }
            catch (ParseException e) {
                logger.trace(" ParseException  :" + e);
                logger.error(" ParseException  :" + e.getMessage());
            }
        }
        Date highestDateUpUntilNow = dates.higher(Calendar.getInstance().getTime());
        Date nextScheduleDate = highestDateUpUntilNow == null ? (Date)Collections.min(dates) : highestDateUpUntilNow;
        Calendar currentTime = Calendar.getInstance();
        currentTime.set(13, 0);
        long timeDiff = nextScheduleDate.getTime() - currentTime.getTime().getTime();
        long nextScheduleMinute = timeDiff <= 0L ? 1440L - TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff)) : TimeUnit.MILLISECONDS.toMinutes(Math.abs(timeDiff));
        if (nextScheduleMinute == 0L) {
            nextScheduleMinute = DeviceManagementServiceImpl.getNextScheduledMinute(list);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, (int)nextScheduleMinute);
        calendar.set(13, 0);
        return calendar.getTimeInMillis();
    }

    private static int[] getArrayInt(List<Integer> list) {
        int[] dayArray = new int[list.size()];
        int i = 0;
        for (Integer arrayElement : list) {
            dayArray[i] = arrayElement;
            ++i;
        }
        return dayArray;
    }

    @Override
    public Device getDeviceByNameForUserId(int cloudId, String cloudName, String deviceName, ObjectId userId, String deviceUUID) {
        return this.deviceDao.getDeviceByNameForUserId(cloudId, cloudName, deviceName, userId, deviceUUID);
    }

    @Override
    public boolean checkDeviceCertAuth(int cloudId, byte[] keyBytes) {
        PublicKey publicKey = this.getKeyFromBytes(keyBytes);
        RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
        String deviceCertPrivKeyPath = "NEED TO CLEAN API";
        PrivateKey privateKey = this.getPrivateKey(deviceCertPrivKeyPath);
        RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
        boolean isDeviceValid = this.validateRSAKeyPair(rsaPrivateCrtKey, rsaPublicKey);
        logger.debug("isDeviceValid....." + isDeviceValid);
        return isDeviceValid;
    }

    private PublicKey getKeyFromBytes(byte[] keyBytes) {
        PublicKey publicKey = null;
        try {
            publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(keyBytes));
        }
        catch (NoSuchAlgorithmException e) {
            logger.trace(NO_SUCH_ALOGORITHM_EXCEPTION + e);
            logger.error(NO_SUCH_ALOGORITHM_EXCEPTION + e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            logger.trace(INVLAID_KEY_SPEC_EXCEPTION + e);
            logger.error(INVLAID_KEY_SPEC_EXCEPTION + e.getMessage());
        }
        return publicKey;
    }

    private PrivateKey getPrivateKey(String privateKeyFilePath) {
        PrivateKey privKey = null;
        byte[] privKeyBytes = null;
        try (DataInputStream dis = new DataInputStream(new FileInputStream(new File(privateKeyFilePath)));){
            privKeyBytes = new byte[(int)new File(privateKeyFilePath).length()];
            dis.read(privKeyBytes);
            dis.close();
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privKeyBytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            privKey = kf.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            logger.trace(INVLAID_KEY_SPEC_EXCEPTION + e);
            logger.error(INVLAID_KEY_SPEC_EXCEPTION + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            logger.trace(NO_SUCH_ALOGORITHM_EXCEPTION + e);
            logger.error(NO_SUCH_ALOGORITHM_EXCEPTION + e.getMessage());
        }
        catch (IOException e1) {
            logger.trace(" IOException  :" + e1);
            logger.error(" IOException  :" + e1.getMessage());
        }
        return privKey;
    }

    private boolean validateRSAKeyPair(RSAPrivateCrtKey privateKey, RSAPublicKey publicKey) {
        BigInteger n = publicKey.getModulus();
        BigInteger e = publicKey.getPublicExponent();
        BigInteger d = privateKey.getPrivateExponent();
        BigInteger p = privateKey.getPrimeP();
        BigInteger q = privateKey.getPrimeQ();
        BigInteger pq = p.multiply(q);
        BigInteger eulerMod = p.add(NEAGATIVE_ONE).multiply(q.add(NEAGATIVE_ONE));
        BigInteger mod = d.multiply(e).mod(eulerMod);
        return n.equals(pq) && BigInteger.ONE.equals(mod);
    }

    @Override
    public List<DeviceElement> getAllDevicesWithPagination(int cloudId, int skipValue, List<String> policyNames) {
        ArrayList<DeviceElement> devElementList = new ArrayList<DeviceElement>();
        List deviceList = this.deviceDao.getAllWithPagination(cloudId, skipValue);
        for (Device device : deviceList) {
            DeviceElement ue = new DeviceElement();
            BeanUtils.copyProperties((Object)device, (Object)ue);
            ue.setDeviceId(device.getId().toString());
            ue.setUserId(device.getUserId());
            ue.setUserName(device.getUserName());
            DeviceBackupOverView backupOverView = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
            boolean isDeviceUnderPolicy = false;
            if (!CollectionUtils.isEmpty(policyNames) && backupOverView != null) {
                if (!StringUtils.isEmpty((String)backupOverView.getPolicyName()) && policyNames.contains(backupOverView.getPolicyName())) {
                    isDeviceUnderPolicy = true;
                }
                if (!StringUtils.isEmpty((String)backupOverView.getOdbPolicyName()) && policyNames.contains(backupOverView.getOdbPolicyName())) {
                    isDeviceUnderPolicy = true;
                }
                if (!isDeviceUnderPolicy) {
                    logger.debug("..isDeviceUnderPolicy false so skip.." + device.getDeviceName());
                    continue;
                }
            }
            List userDeviceAccessControl = this.deviceDao.getUserDeviceAccessControl(cloudId, device.getId());
            List existingOwnersIds = userDeviceAccessControl.stream().filter(line -> Objects.nonNull(line.getUserFK())).map(line -> line.getUserFK().toString()).collect(Collectors.toList());
            List existingOwnerList = this.userDao.getAllUsers(cloudId, "", existingOwnersIds);
            ue.setOwnerList(existingOwnerList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList()));
            devElementList.add(ue);
        }
        return devElementList;
    }

    @Override
    public long getAllDeviceCount(int cloudId) {
        return this.deviceDao.getAllDeviceCount(cloudId);
    }

    @Override
    public List<DeviceElement> getAllDevices(int cloudId, List<String> list) {
        ArrayList<DeviceElement> devElementList = new ArrayList<DeviceElement>();
        List deviceList = this.deviceDao.findDeviceByNames(cloudId, list);
        for (Device device : deviceList) {
            if (device.isDeleted()) continue;
            DeviceElement ue = new DeviceElement();
            BeanUtils.copyProperties((Object)device, (Object)ue);
            ue.setDeviceId(device.getId().toString());
            ue.setUserId(device.getUserId());
            ue.setUserName(device.getUserName());
            List userDeviceAccessControl = this.deviceDao.getUserDeviceAccessControl(cloudId, device.getId());
            List existingOwnersIds = userDeviceAccessControl.stream().filter(line -> Objects.nonNull(line.getUserFK())).map(line -> line.getUserFK().toString()).collect(Collectors.toList());
            List existingOwnerList = this.userDao.getAllUsers(cloudId, "", existingOwnersIds);
            ue.setOwnerList(existingOwnerList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList()));
            devElementList.add(ue);
        }
        return devElementList;
    }

    @Override
    public List<DeviceElement> getDevicesForUser(int cloudId, String userName, List<String> list) {
        ArrayList<DeviceElement> deviceElements = new ArrayList<DeviceElement>();
        List devices = this.deviceDao.getAllDeviceByUserName(cloudId, userName, list);
        if (devices == null) {
            logger.debug(" ******* DEVICE DOES NOT EXISTS...");
            return null;
        }
        for (Device d : devices) {
            DeviceElement deviceElement = new DeviceElement();
            BeanUtils.copyProperties((Object)d, (Object)deviceElement);
            deviceElement.setDeviceId(d.getId().toString());
            deviceElement.setUserName(d.getUserName());
            this.setLastSuccessfullbackup(cloudId, userName, d, deviceElement);
            deviceElements.add(deviceElement);
        }
        return deviceElements;
    }

    private void setLastSuccessfullbackup(int cloudId, String userName, Device d, DeviceElement deviceElement) {
        if (d == null || StringUtils.isEmpty((String)d.getDeviceName())) {
            return;
        }
        BackupBatch backupBatch = this.backupBatchDao.getLastSuccessfullBackup(cloudId, "", userName, d.getDeviceName());
        if (backupBatch == null && (backupBatch = this.backupBatchDao.getLastSuccessfullBackup(cloudId, "", userName, d.getDisplayName())) == null) {
            return;
        }
        deviceElement.setLastSuccessfullBackup(this.getDateInFormat(backupBatch.getBatchEndTimestamp()));
        logger.debug("After getting last successfull backup" + deviceElement.getLastSuccessfullBackup());
    }

    @Override
    public void saveDeviceBackupOverView(int cloudId, Device device) {
        DeviceBackupOverView backupOverView = new DeviceBackupOverView();
        User user = this.userDao.getUserByName(cloudId, device.getUserName());
        ObjectId userId = user.getUserId();
        ObjectId deviceId = device.getId();
        Object[] arr = this.backupBatchDao.getBackupDateHistoryElement(cloudId, "", device.getUserName(), device.getDeviceUUID());
        if (arr[0] != null) {
            String lastSuccessfulBkp = this.getDateInFormat((Long)arr[0]);
            backupOverView.setLastSuccessfulBkp(lastSuccessfulBkp);
        }
        if (arr[1] != null) {
            String firstSuccessfulBkp = this.getDateInFormat((Long)arr[1]);
            backupOverView.setFirstBkpStartTime(firstSuccessfulBkp);
        }
        if (arr[2] != null) {
            backupOverView.setLastBkpStatus(arr[2].toString());
        }
        if (arr[3] != null) {
            backupOverView.setReason(arr[3].toString());
        }
        if (arr[4] != null) {
            backupOverView.setLastBkpStartTime(this.getDateInFormat((Long)arr[4]));
        }
        if (arr[5] != null) {
            backupOverView.setTotalNoOfFiles(arr[5].toString());
        }
        if (arr[6] != null) {
            backupOverView.setNoOfFilesRemaining(arr[6].toString());
            backupOverView.setDecoupled(device.isDecoupled());
        }
        String userName = user.getUserName();
        long storageUsed = this.backUpImageDao.getTotalSizeUsedByUserForDevice(cloudId, userName, deviceId);
        backupOverView.setStorageUtilized(storageUsed);
        Object[] countArr = this.backupBatchDao.getCountForJobType(cloudId, device.getDeviceUUID(), device.getUserName());
        if (countArr[1] != null) {
            Long noOfSuccessfulBackups = (Long)countArr[1];
            logger.debug(" ############### ....  ..... " + noOfSuccessfulBackups);
            backupOverView.setNoOfSuccessfulBackups(noOfSuccessfulBackups.longValue());
        }
        if (countArr[0] != null) {
            Long noOfSuccessfulRestores = (Long)countArr[0];
            logger.debug(" #####@@@@@@######### ....  ..... " + noOfSuccessfulRestores);
            backupOverView.setNoOfSuccessfulRestores(noOfSuccessfulRestores.longValue());
        }
        device.setUserId(user.getUserId());
        device.setUserName(user.getUserName());
        backupOverView.setUserName(user.getUserName());
        backupOverView.setEmailId(user.getEmailId());
        backupOverView.setUserActive(user.isActive());
        backupOverView.setUserDeleted(user.isDeleted());
        backupOverView.setAccountStatus(user.isAccountStatus());
        backupOverView.setLocation(user.getLocation());
        backupOverView.setPolicyName(user.getPolicyName());
        backupOverView.setOdbPolicyName(user.getOdbPolicyName());
        backupOverView.setDeviceBolcked(device.isBlocked());
        backupOverView.setDeviceUUID(device.getDeviceUUID());
        backupOverView.setClientVersion(device.getClientVersion());
        backupOverView.setEpaInstallationDate(device.getDeviceCreatedDate());
        backupOverView.setDeviceName(device.getDeviceName());
        backupOverView.setDeviceDeleted(device.isDeleted());
        backupOverView.setDeviceType(device.getDeviceType());
        backupOverView.setOdbPolicyName(user.getOdbPolicyName());
        backupOverView.setOsType(device.getOsType());
        backupOverView.setOsVersion(device.getOsVersion());
        this.backupOverViewDao.saveDeviceBackupOverView(cloudId, backupOverView);
        this.deviceDao.updateDevice(cloudId, device);
    }

    @Override
    public void updateDeviceBackupOverView(int cloudId, DeviceBackupOverView backupOverView) {
        this.backupOverViewDao.saveDeviceBackupOverView(cloudId, backupOverView);
    }

    @Override
    public List<UserDevicesElement> getAllUserDevices(int cloudId) {
        Map devicesMap = this.deviceDao.getAllDevicesByUser(cloudId);
        ArrayList<UserDevicesElement> list = new ArrayList<UserDevicesElement>();
        for (String userNameKey : devicesMap.keySet()) {
            if (StringUtils.isEmpty((String)userNameKey)) continue;
            List devices = (List)devicesMap.get(userNameKey);
            ArrayList<String> deviceUUIDs = new ArrayList<String>();
            for (Device device : devices) {
                if (device == null) continue;
                deviceUUIDs.add(device.getDeviceUUID());
            }
            UserDevicesElement devicesElement = new UserDevicesElement();
            devicesElement.setUserName(userNameKey);
            devicesElement.setDevices(new ArrayList());
            devicesElement.setDevices(deviceUUIDs);
            list.add(devicesElement);
        }
        return list;
    }

    @Override
    public void updateClientVersion(int cloudId, String productVersion, String deviceUUID, String oldVersion) {
        try {
            this.deviceDao.updateClientVersion(cloudId, productVersion, deviceUUID);
            this.deviceDao.updateClientVersionInOverview(cloudId, deviceUUID, productVersion);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(" Exception in " + e.getMessage());
            this.deviceDao.updateClientVersion(cloudId, oldVersion, deviceUUID);
        }
    }

    @Override
    public void updateDevDisplayName(int cloudId, String displayName, String deviceUUID) {
        try {
            this.deviceDao.updateDevDisplayName(cloudId, displayName, deviceUUID);
            this.deviceDao.updateDevDisplayNameInOverview(cloudId, deviceUUID, displayName);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(" Exception in " + e.getMessage());
        }
    }

    @Override
    public void registerDeviceContainer(DeviceContainerElement deviceContainerElement, int cloudId, String cloudName) {
        DeviceContainer deviceContainer;
        logger.debug("registerDeviceContainer(DeviceContainer deviceContainer, String policyName, String groupName) > BEGIN");
        if (StringUtils.isNotEmpty((String)deviceContainerElement.getId())) {
            ObjectId objectId = new ObjectId(deviceContainerElement.getId());
            deviceContainer = this.deviceContainerDao.getDeviceContainerByID(cloudId, objectId);
        } else {
            deviceContainer = new DeviceContainer();
        }
        deviceContainer.setContainerName(deviceContainerElement.getContainerName());
        deviceContainer.setContainerType(deviceContainerElement.getContainerType());
        deviceContainer.setDbLocation(deviceContainerElement.getContainerLocation());
        deviceContainer.setDeviceUUID(deviceContainerElement.getDeviceUUID());
        deviceContainer.setPassword(deviceContainerElement.getPassword());
        deviceContainer.setUserName(deviceContainerElement.getUsername());
        deviceContainer.setPort(deviceContainerElement.getPort());
        BackupPolicy policy = this.backupPolicyDao.getBackupPolicy(cloudId, cloudName, deviceContainerElement.getBackupPolicyName());
        Group group = this.userGroupDao.getGroupByName(cloudId, deviceContainerElement.getGroupName());
        deviceContainer.setBackupPolicy(policy);
        deviceContainer.setGroup(group);
        this.deviceContainerDao.registerDeviceContainer(deviceContainer, cloudId);
        logger.debug("registerDeviceContainer(DeviceContainer deviceContainer, String policyName, String groupName) > END");
    }

    @Override
    public DeviceContainerListElement getDeviceContainerElements(int cloudId, String deviceUUID) {
        logger.debug("getDeviceContainerElements(int cloudId, String deviceUUID)  > BEGIN");
        List containers = this.deviceContainerDao.getAllDeviceContainers(deviceUUID, cloudId);
        ArrayList<DeviceContainerElement> containerElements = new ArrayList<DeviceContainerElement>();
        for (DeviceContainer deviceContainer : containers) {
            DeviceContainerElement containerElement = new DeviceContainerElement();
            containerElement.setDeviceUUID(deviceContainer.getDeviceUUID());
            containerElement.setContainerType(deviceContainer.getContainerType());
            containerElement.setContainerName(deviceContainer.getContainerName());
            containerElement.setContainerLocation(deviceContainer.getDbLocation());
            containerElement.setUsername(deviceContainer.getUserName());
            containerElement.setPassword(deviceContainer.getPassword());
            containerElement.setPort(deviceContainer.getPort());
            containerElement.setBackupPolicyName(deviceContainer.getBackupPolicy() == null ? "" : deviceContainer.getBackupPolicy().getPolicyName());
            containerElement.setGroupName(deviceContainer.getGroup() == null ? "" : deviceContainer.getGroup().getGroupName());
            containerElements.add(containerElement);
        }
        DeviceContainerListElement containerListElement = new DeviceContainerListElement();
        containerListElement.setDeviceContainerListElement(containerElements);
        logger.debug("getDeviceContainerElements(int cloudId, String deviceUUID)  > BEFORE RETURN");
        return containerListElement;
    }

    @Override
    public List<EditDeviceContainerElement> getAllDeviceContainers(int cloudId, String deviceUUID) {
        logger.debug("List<DeviceContainer> getAllDeviceContainers(int cloudId, String deviceUUID)  > BEGIN");
        List containers = this.deviceContainerDao.getAllDeviceContainers(deviceUUID, cloudId);
        logger.debug("List<DeviceContainer> getAllDeviceContainers(int cloudId, String deviceUUID)  > BEFORE RETURN");
        return this.copyDeviceContainersToDeviceContainerEle(containers, cloudId);
    }

    private List<EditDeviceContainerElement> copyDeviceContainersToDeviceContainerEle(List<DeviceContainer> containers, int cloudId) {
        ArrayList<EditDeviceContainerElement> editList = new ArrayList<EditDeviceContainerElement>();
        for (DeviceContainer deviceContainer : containers) {
            EditDeviceContainerElement editDeviceConatiner = new EditDeviceContainerElement();
            editDeviceConatiner.setId(deviceContainer.getId().toString());
            editDeviceConatiner.setDeviceUUID(deviceContainer.getDeviceUUID());
            editDeviceConatiner.setContainerType(deviceContainer.getContainerType());
            editDeviceConatiner.setContainerName(deviceContainer.getContainerName());
            editDeviceConatiner.setContainerLocation(deviceContainer.getDbLocation());
            editDeviceConatiner.setUsername(deviceContainer.getUserName());
            editDeviceConatiner.setPassword(deviceContainer.getPassword());
            editDeviceConatiner.setPort(deviceContainer.getPort());
            editDeviceConatiner.setBackupPolicyName(deviceContainer.getBackupPolicy() == null ? "" : deviceContainer.getBackupPolicy().getPolicyName());
            editDeviceConatiner.setGroupName(deviceContainer.getGroup() == null ? "" : deviceContainer.getGroup().getGroupName());
            editDeviceConatiner.setPolicies(this.getExistingPolicies(cloudId));
            editDeviceConatiner.setGroups(this.getExistingGroups(cloudId));
            BackupPolicy backupPolicy = deviceContainer.getBackupPolicy();
            ArrayList schedules = backupPolicy.getSchedules();
            logger.debug("getExistingPolicies > BEGIN > getNextScheduledMinute(schedules) : " + DeviceManagementServiceImpl.getNextScheduledMinute(schedules));
            logger.debug("getExistingPolicies > BEGIN > getDate(getNextScheduledMinute(schedules)) : " + DeviceManagementServiceImpl.getDate(DeviceManagementServiceImpl.getNextScheduledMinute(schedules)));
            editDeviceConatiner.setNextScheduledBackup(DeviceManagementServiceImpl.getDate(DeviceManagementServiceImpl.getNextScheduledMinute(schedules)));
            editDeviceConatiner.setNextPolicyRefresh(backupPolicy.getPolicyRefresh());
            editList.add(editDeviceConatiner);
        }
        return editList;
    }

    private List<String> getExistingPolicies(int cloudId) {
        logger.debug("getExistingPolicies > BEGIN > CLOUDID : " + cloudId);
        List backupPolicies = this.backupPolicyDao.getAllBackupPolicies(cloudId);
        ArrayList<String> policies = new ArrayList<String>();
        for (BackupPolicy backupPolicy : backupPolicies) {
            policies.add(backupPolicy.getPolicyName());
        }
        logger.debug("getExistingPolicies > BEFORE RETURN > CLOUDID : " + cloudId);
        return policies;
    }

    private List<String> getExistingGroups(int cloudId) {
        logger.debug("getExistingGroups(int cloudId) > BEGIN > CLOUDID : " + cloudId);
        List userGroups = this.userGroupDao.getAllGroups(cloudId);
        ArrayList<String> groups = new ArrayList<String>();
        for (Group group : userGroups) {
            groups.add(group.getGroupName());
        }
        logger.debug("getExistingGroups(int cloudId) > BEFORE RETURN > CLOUDID : " + cloudId);
        return groups;
    }

    @Override
    public boolean removeContainer(DeviceContainerElement deviceContainerElement, int cloudId, String cloudName) {
        logger.debug("removeContainer(DeviceContainerElement deviceContainerElement, int cloudId, String cloudName) > BEGIN");
        this.deviceContainerDao.deleteContainer(cloudId, deviceContainerElement);
        logger.debug("removeContainer(DeviceContainerElement deviceContainerElement, int cloudId, String cloudName) > END");
        return true;
    }

    @Override
    public List<DeviceElement> getAllDevicesByGroup(int cloudId, Group group) {
        logger.debug("List<DeviceElement> getAllDevicesByGroup(int cloudId, Group group) > BEGIN");
        List deviceConatiners = this.deviceContainerDao.getAllDeviceContainersForGroup(cloudId, group);
        ArrayList<DeviceElement> devElementList = new ArrayList<DeviceElement>();
        for (DeviceContainer deviceContainer : deviceConatiners) {
            DeviceElement ue = new DeviceElement();
            Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, null, deviceContainer.getDeviceUUID());
            BeanUtils.copyProperties((Object)device, (Object)ue);
            ue.setDeviceId(device.getId().toString());
            if (!devElementList.contains(ue)) {
                devElementList.add(ue);
            }
            ue.setUserId(device.getUserId());
            ue.setUserName(device.getUserName());
        }
        logger.debug("List<DeviceElement> getAllDevicesByGroup(int cloudId, Group group) > BEFORE RETURN");
        return devElementList;
    }

    @Override
    public List<EditDeviceContainerElement> getAllDeviceContainersByGroup(int cloudId, String deviceUUID, Group group) {
        logger.debug("List<EditDeviceContainerElement> getAllDeviceContainersByGroup(int cloudId, String deviceUUID, Group group) > BEGIN");
        List deviceConatiners = this.deviceContainerDao.getAllDeviceContainersByGroup(cloudId, deviceUUID, group);
        logger.debug("List<EditDeviceContainerElement> getAllDeviceContainersByGroup(int cloudId, String deviceUUID, Group group) > BEFORE RETURN");
        return this.copyDeviceContainersToDeviceContainerEle(deviceConatiners, cloudId);
    }

    @Override
    public boolean isContainerUnique(int cloudId, DeviceContainerElement deviceContainerElement) {
        logger.debug("boolean isContainerUnique(int cloudId, DeviceContainerElement deviceContainerElement) > BEGIN");
        return this.deviceContainerDao.isContainerUnique(cloudId, deviceContainerElement);
    }

    @Override
    public void deleteDevice(int cloudId, String cloudName, String devUUID, HttpServletResponse response) {
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, devUUID);
        if (device == null) {
            response.setStatus(404);
        } else if (!device.isBlocked()) {
            response.setStatus(403);
        } else {
            device.setDeleted(true);
            logger.debug("before delete device>>>>>>$$$$$$$");
            Device d = this.deviceDao.updateDeviceInfo(cloudId, cloudName, device);
            if (d.getDeviceName().contains("Microsoft OneDrive")) {
                this.userDao.disabledOfficeLicense(cloudId, d.getUserName(), true, false);
            }
            if (d.getDeviceName().contains("Microsoft Exchange")) {
                this.userDao.disabledOfficeLicense(cloudId, d.getUserName(), false, true);
            }
            this.deviceDao.updatedeviceInfoInDeviceBkpOverview(cloudId, device);
            if (d.isDeleted()) {
                DeletedSearchIndex deletedSearchIndex = new DeletedSearchIndex();
                deletedSearchIndex.setId(new ObjectId());
                deletedSearchIndex.setCloudId(cloudId);
                deletedSearchIndex.setCloudName(cloudName);
                deletedSearchIndex.setDeviceDelete(true);
                deletedSearchIndex.setDeviceId(d.getId());
                deletedSearchIndex.setDeviceUUID(d.getDeviceUUID());
                deletedSearchIndex.setUserName(d.getUserName());
                this.searchIndexDao.addDeleteIndex(deletedSearchIndex);
                response.setStatus(200);
            } else {
                response.setStatus(500);
            }
        }
    }

    @Override
    public List<Device> getAllDeletedDevices(int cloudId, String cloudName) {
        return this.deviceDao.getAllDeletedDevices(cloudId, cloudName);
    }

    @Override
    public BluSyncGroupBackupPolicyElement getBluSyncGroupPolicyElement(int cloudId, String cloudName, String userName, String deviceUUID) {
        User user = this.userDao.getUserByName(cloudId, userName);
        BackupPolicy backupPolicy = this.userDao.getBackupPolicyByPolicyName(cloudId, user.getPolicyName());
        BluSyncGroupBackupPolicyElement element = null;
        if (backupPolicy != null) {
            BackupFolderElement backupFolderElement;
            element = new BluSyncGroupBackupPolicyElement();
            BeanUtils.copyProperties((Object)backupPolicy, (Object)element);
            element.setPolicygroupName(backupPolicy.getPolicyName());
            if (backupPolicy.getCrawlLimit() != 0) {
                element.setCrawlLimit(String.valueOf(backupPolicy.getCrawlLimit()));
            }
            if (backupPolicy.getFileChunkableSize() != 0) {
                element.setFileChunkableSize(String.valueOf(backupPolicy.getFileChunkableSize()));
            }
            List filters = backupPolicy.getInclusionFilter();
            element.setInclusionFilterElement(this.getFilter(filters, backupPolicy.getFilterType()));
            List<BluSyncScheduleElement> scheduleElements = this.getScheduleElements(backupPolicy);
            BSPrivacyGatewayMappingElement mappingElement = new BSPrivacyGatewayMappingElement();
            mappingElement.setBsPrivacyGatewayElementsList(new ArrayList());
            if (CollectionUtils.isEmpty((Collection)backupPolicy.getPrivacyGateways())) {
                logger.debug("INSIDE PRIVACY GATEWAY EMPTY WHILE REGIDERING -----------------------");
                List privacygateways = this.privacyGateWayDao.getAllGateways(cloudId);
                Iterator iterator = privacygateways.iterator();
                while (iterator.hasNext()) {
                    PrivacyGateway childPrivacyGateway = (PrivacyGateway)iterator.next();
                    if (!StringUtils.isEmpty((String)childPrivacyGateway.getProductType()) && !"bluvault".equalsIgnoreCase(childPrivacyGateway.getProductType()) && !"both".equalsIgnoreCase(childPrivacyGateway.getProductType())) continue;
                    mappingElement.setGatewayNwThrottlingName(GATEWAY);
                    BSPrivacyGatewayElement pgelement = new BSPrivacyGatewayElement();
                    pgelement.setName(childPrivacyGateway.getGatewayName());
                    pgelement.setType(childPrivacyGateway.getType());
                    mappingElement.getBsPrivacyGatewayElementsList().add(pgelement);
                }
            } else {
                for (PrivacyGateway gateway : backupPolicy.getPrivacyGateways()) {
                    mappingElement.setGatewayNwThrottlingName(GATEWAY);
                    if (gateway == null) continue;
                    BSPrivacyGatewayElement pgelement = new BSPrivacyGatewayElement();
                    pgelement.setName(gateway.getGatewayName());
                    pgelement.setType(gateway.getType());
                    mappingElement.getBsPrivacyGatewayElementsList().add(pgelement);
                }
            }
            element.setBSPrivacyGatewayMappingElement(mappingElement);
            List<BackupFolderElement> backupFolderElements = this.getBackupFolderElements(backupPolicy);
            List userDefinedInclusionFolders = this.userDefinedFoldersDao.getAllUserDefinedInclusionFolders(cloudId, cloudName, deviceUUID, userName);
            ArrayList<ExcludedFolders> excludedFoldersList = new ArrayList<ExcludedFolders>();
            if (!CollectionUtils.isEmpty((Collection)backupPolicy.getExcludedFolders())) {
                excludedFoldersList.addAll(backupPolicy.getExcludedFolders());
            }
            List userDefinedExclusionFolders = this.userDefinedFoldersDao.getAllUserDefinedExclusionFolders(cloudId, cloudName, deviceUUID, userName);
            List<CalloutScriptElement> calloutScriptElements = this.getCalloutScriptElements(backupPolicy);
            if (!CollectionUtils.isEmpty((Collection)userDefinedInclusionFolders)) {
                for (UserDefinedFolders userDefinedFolders : userDefinedInclusionFolders) {
                    backupFolderElement = new BackupFolderElement();
                    backupFolderElement.setFolderPath(userDefinedFolders.getFolderPath());
                    backupFolderElements.add(backupFolderElement);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)userDefinedExclusionFolders)) {
                for (UserDefinedFolders userDefinedFolders : userDefinedExclusionFolders) {
                    if (StringUtils.isEmpty((String)userDefinedFolders.getFolderPath())) continue;
                    ExcludedFolders excludedFolders = new ExcludedFolders();
                    excludedFolders.setFolderPath(userDefinedFolders.getFolderPath());
                    excludedFoldersList.add(excludedFolders);
                }
            }
            if (!CollectionUtils.isEmpty(excludedFoldersList)) {
                element.setExcludedFolderPaths(new ArrayList());
                for (ExcludedFolders userExcludedFolders : excludedFoldersList) {
                    backupFolderElement = new BackupFolderElement();
                    backupFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                    element.getExcludedFolderPaths().add(backupFolderElement);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)backupPolicy.getExceptionsToExclusions())) {
                element.setExceptionsToExclusions(new ArrayList());
                for (ExcludedFolders userExcludedFolders : backupPolicy.getExceptionsToExclusions()) {
                    backupFolderElement = new BackupFolderElement();
                    backupFolderElement.setFolderPath(userExcludedFolders.getFolderPath());
                    element.getExceptionsToExclusions().add(backupFolderElement);
                }
            }
            logger.debug("........set ExceptionsToExclusions...");
            List<NetworkThrottlingElement> networkThrottlingElements = this.getNetworkThrottlingElements(backupPolicy);
            element.setScheduleElements(scheduleElements);
            element.setUiVersion(1);
            element.setStatisticsCollectorEnabled(backupPolicy.isStatisticsCollectorEnabled());
            element.setBackupFolderPaths(backupFolderElements);
            element.setCalloutScriptElements(calloutScriptElements);
            element.setNetworkThrottlingElements(networkThrottlingElements);
            if (backupPolicy.getLastModifiedTimestamp() == 0L) {
                element.setLastModifiedTimestamp(0L);
            } else {
                element.setLastModifiedTimestamp(backupPolicy.getLastModifiedTimestamp());
            }
            element.setPolicyRefresh(backupPolicy.getPolicyRefresh());
            if (!StringUtils.isEmpty((String)backupPolicy.getStatisticsRefresh())) {
                element.setStatisticsRefresh(backupPolicy.getStatisticsRefresh());
            } else {
                element.setStatisticsRefresh(backupPolicy.getPolicyRefresh());
            }
            List ebmsMappingsList = this.bluVaultDao.getAllBluVaults(cloudId, cloudName);
            ArrayList<BluVaultMappingElement> ebmsMappingElements = new ArrayList<BluVaultMappingElement>();
            if (!CollectionUtils.isEmpty((Collection)ebmsMappingsList)) {
                for (Object ebmsMapping : ebmsMappingsList) {
                    BluVaultMappingElement ebmsMappingElement = new BluVaultMappingElement();
                    BeanUtils.copyProperties((Object)ebmsMapping, (Object)ebmsMappingElement);
                    ebmsMappingElements.add(ebmsMappingElement);
                }
                element.setBluVaultMappingElements(ebmsMappingElements);
            }
            element.setFullBackupEnabled(backupPolicy.isFullBackupEnabled());
            element.setFullBackupStartDate(backupPolicy.getFullBackupStartDate());
            ArrayList<EndpointUiPreferencesElement> uiPreferenceElements = new ArrayList<EndpointUiPreferencesElement>();
            if (!CollectionUtils.isEmpty((Collection)backupPolicy.getEndpointUiPreferences())) {
                for (String uiPreference : backupPolicy.getEndpointUiPreferences()) {
                    EndpointUiPreferencesElement endpointUiPreferencesElement = new EndpointUiPreferencesElement();
                    endpointUiPreferencesElement.setEndpointsUiPreferences(uiPreference);
                    uiPreferenceElements.add(endpointUiPreferencesElement);
                }
            }
            element.setEndpointUiPreferencesElementList(uiPreferenceElements);
            ArrayList<EndpointUiDisabledPreferencesElement> uiDisPreferenceElements = new ArrayList<EndpointUiDisabledPreferencesElement>();
            if (!CollectionUtils.isEmpty((Collection)backupPolicy.getEndpointDisabledUiPreferences())) {
                logger.debug("...setting setEndpointUiDisabledPreferencesElementList ");
                for (String uiPreference : backupPolicy.getEndpointDisabledUiPreferences()) {
                    EndpointUiDisabledPreferencesElement endpointUiPreferencesElement = new EndpointUiDisabledPreferencesElement();
                    endpointUiPreferencesElement.setEndpointDisabledUiPreferences(uiPreference);
                    uiDisPreferenceElements.add(endpointUiPreferencesElement);
                }
            }
            element.setEndpointUiDisabledPreferencesElementList(uiDisPreferenceElements);
        }
        return element;
    }

    private InclusionFilterElement getFilter(List<InclusionFilter> filters, String filterType) {
        InclusionFilterElement filterElement = new InclusionFilterElement();
        StringBuilder fileExtensions = new StringBuilder();
        InclusionFilter inclusionFilter = new InclusionFilter();
        inclusionFilter = filters.get(0);
        filterElement.setFilterName(inclusionFilter.getFilterName());
        filterElement.setFilterType(filterType);
        for (InclusionFilter filter : filters) {
            fileExtensions.append(filter.getExtensionName());
            fileExtensions.append(",");
        }
        logger.debug("fileExtensions ......................... " + fileExtensions.toString().replaceAll(",$", ""));
        filterElement.setFilters(fileExtensions.toString().replaceAll(",$", ""));
        return filterElement;
    }

    private List<BluSyncScheduleElement> getScheduleElements(BackupPolicy backupPolicy) {
        ArrayList schedules = backupPolicy.getSchedules();
        ArrayList<BluSyncScheduleElement> scheduleElements = new ArrayList<BluSyncScheduleElement>();
        for (Schedule schedule : schedules) {
            BluSyncScheduleElement scheduleElement = new BluSyncScheduleElement();
            BeanUtils.copyProperties((Object)schedule, (Object)scheduleElement);
            List<ScheduleDaysArrayElement> arrayElements = this.getScheduleDays(schedule, scheduleElement);
            scheduleElement.setDayArray(arrayElements);
            scheduleElement.setBackupType(schedule.getBackupType());
            scheduleElements.add(scheduleElement);
        }
        return scheduleElements;
    }

    private List<BackupFolderElement> getBackupFolderElements(BackupPolicy backupPolicy) {
        ArrayList backupFolders = backupPolicy.getBackupFolders();
        ArrayList<BackupFolderElement> backupFolderElements = new ArrayList<BackupFolderElement>();
        for (BackupFolders folders : backupFolders) {
            BackupFolderElement backupFolderElement = new BackupFolderElement();
            backupFolderElement.setFolderPath(folders.getFolderPath());
            backupFolderElement.setOsType(folders.getOs());
            backupFolderElements.add(backupFolderElement);
        }
        return backupFolderElements;
    }

    private List<CalloutScriptElement> getCalloutScriptElements(BackupPolicy backupPolicy) {
        ArrayList calloutScript = backupPolicy.getCalloutScripts();
        ArrayList<CalloutScriptElement> calloutScriptElements = new ArrayList<CalloutScriptElement>();
        for (CalloutScript script : calloutScript) {
            CalloutScriptElement calloutScriptElement = new CalloutScriptElement();
            calloutScriptElement.setScriptName(script.getScriptName());
            calloutScriptElement.setScriptArgs(script.getScriptArgs());
            calloutScriptElement.setScriptType(script.getScriptType());
            calloutScriptElements.add(calloutScriptElement);
        }
        return calloutScriptElements;
    }

    private List<NetworkThrottlingElement> getNetworkThrottlingElements(BackupPolicy backupPolicy) {
        ArrayList<NetworkThrottlingElement> networkThrottlingElements = new ArrayList<NetworkThrottlingElement>();
        ArrayList networkThrottlings = backupPolicy.getNetworkThrottlings();
        for (NetworkThrottling networkThrottling : networkThrottlings) {
            NetworkThrottlingElement networkThrottlingElement = new NetworkThrottlingElement();
            BeanUtils.copyProperties((Object)networkThrottling, (Object)networkThrottlingElement);
            networkThrottlingElement.setEndTime(networkThrottling.getEndTime());
            networkThrottlingElements.add(networkThrottlingElement);
        }
        return networkThrottlingElements;
    }

    private List<ScheduleDaysArrayElement> getScheduleDays(Schedule schedule, BluSyncScheduleElement scheduleElement) {
        ArrayList<ScheduleDaysArrayElement> scheduleDaysArrayElements = new ArrayList<ScheduleDaysArrayElement>();
        for (Integer dayArray : schedule.getDayArray()) {
            ScheduleDaysArrayElement daysArrayElement = new ScheduleDaysArrayElement();
            daysArrayElement.setDay(dayArray);
            scheduleDaysArrayElements.add(daysArrayElement);
        }
        return scheduleDaysArrayElements;
    }

    @Override
    public BluSyncGroupSyncPolicyElement getBluSyncGroupSyncPolicyElement(int cloudId, String cloudName, String userName, String deviceUUID) {
        User user = this.userDao.getUserByName(cloudId, userName);
        logger.debug("userName : " + userName);
        SyncPolicy syncPolicy = this.userDao.getSyncPolicyByPolicyName(cloudId, user.getSyncPolicyName());
        logger.debug("syncPolicy : :: " + syncPolicy);
        logger.debug("syncPolicy : :: " + syncPolicy.getPolicyName());
        BluSyncGroupSyncPolicyElement element = null;
        if (syncPolicy != null) {
            element = new BluSyncGroupSyncPolicyElement();
            BeanUtils.copyProperties((Object)syncPolicy, (Object)element);
            element.setPolicygroupName(syncPolicy.getPolicyName());
            if (syncPolicy.getFileChunkableSize() != 0) {
                element.setFileChunkableSize(String.valueOf(syncPolicy.getFileChunkableSize()));
            }
            List filters = syncPolicy.getInclusionFilter();
            element.setInclusionFilterElement(this.getFilter(filters, syncPolicy.getFilterType()));
            BSPrivacyGatewayMappingElement mappingElement = new BSPrivacyGatewayMappingElement();
            mappingElement.setBsPrivacyGatewayElementsList(new ArrayList());
            ArrayList defaultPGList = syncPolicy.getPrivacyGateways();
            if (CollectionUtils.isEmpty((Collection)syncPolicy.getPrivacyGateways())) {
                logger.debug("INSIDE PRIVACY GATEWAY EMPTY WHILE REGIDERING FOR SYNC-----------------------");
                List privacygateways = this.privacyGateWayDao.getAllGateways(cloudId);
                Iterator iterator = privacygateways.iterator();
                while (iterator.hasNext()) {
                    PrivacyGateway childPrivacyGateway = (PrivacyGateway)iterator.next();
                    if (!StringUtils.isEmpty((String)childPrivacyGateway.getProductType()) && !"blusync".equalsIgnoreCase(childPrivacyGateway.getProductType()) && !"both".equalsIgnoreCase(childPrivacyGateway.getProductType())) continue;
                    mappingElement.setGatewayNwThrottlingName(GATEWAY);
                    BSPrivacyGatewayElement pgelement = new BSPrivacyGatewayElement();
                    pgelement.setName(childPrivacyGateway.getGatewayName());
                    pgelement.setType(childPrivacyGateway.getType());
                    mappingElement.getBsPrivacyGatewayElementsList().add(pgelement);
                }
            } else {
                for (PrivacyGateway gateway : defaultPGList) {
                    mappingElement.setGatewayNwThrottlingName(GATEWAY);
                    if (gateway == null) continue;
                    BSPrivacyGatewayElement pgelement = new BSPrivacyGatewayElement();
                    pgelement.setName(gateway.getGatewayName());
                    pgelement.setType(gateway.getType());
                    mappingElement.getBsPrivacyGatewayElementsList().add(pgelement);
                }
            }
            element.setBSPrivacyGatewayMappingElement(mappingElement);
            List<NetworkThrottlingElement> networkThrottlingElements = this.getNetworkThrottlingElements(syncPolicy);
            element.setUiVersion(1);
            element.setNetworkThrottlingElements(networkThrottlingElements);
            if (user.getSyncPolicyModifiedTime() == 0L) {
                element.setLastModifiedTimestamp(0L);
            } else {
                element.setLastModifiedTimestamp(user.getSyncPolicyModifiedTime());
            }
            element.setPolicyRefresh(syncPolicy.getPolicyRefresh());
            List ebmsMappingsList = this.bluVaultDao.getAllBluVaults(cloudId, cloudName);
            ArrayList<BluVaultMappingElement> ebmsMappingElements = new ArrayList<BluVaultMappingElement>();
            if (!CollectionUtils.isEmpty((Collection)ebmsMappingsList)) {
                for (Object ebmsMapping : ebmsMappingsList) {
                    BluVaultMappingElement ebmsMappingElement = new BluVaultMappingElement();
                    BeanUtils.copyProperties((Object)ebmsMapping, (Object)ebmsMappingElement);
                    ebmsMappingElements.add(ebmsMappingElement);
                }
                element.setBluVaultMappingElements(ebmsMappingElements);
            }
            element.setSearchAlgoForPg(syncPolicy.getSearchAlgoForPg());
            ArrayList<EndpointUiPreferencesElement> uiPreferenceElements = new ArrayList<EndpointUiPreferencesElement>();
            if (!CollectionUtils.isEmpty((Collection)syncPolicy.getEndpointUiPreferences())) {
                for (String uiPreference : syncPolicy.getEndpointUiPreferences()) {
                    EndpointUiPreferencesElement endpointUiPreferencesElement = new EndpointUiPreferencesElement();
                    endpointUiPreferencesElement.setEndpointsUiPreferences(uiPreference);
                    uiPreferenceElements.add(endpointUiPreferencesElement);
                }
            }
            element.setEndpointUiPreferencesElementList(uiPreferenceElements);
            ArrayList<EndpointUiDisabledPreferencesElement> uiDisPreferenceElements = new ArrayList<EndpointUiDisabledPreferencesElement>();
            if (!CollectionUtils.isEmpty((Collection)syncPolicy.getEndpointDisabledUiPreferences())) {
                logger.debug("...setting setEndpointUiDisabledPreferencesElementList ");
                for (String uiPreference : syncPolicy.getEndpointDisabledUiPreferences()) {
                    EndpointUiDisabledPreferencesElement endpointUiPreferencesElement = new EndpointUiDisabledPreferencesElement();
                    endpointUiPreferencesElement.setEndpointDisabledUiPreferences(uiPreference);
                    uiDisPreferenceElements.add(endpointUiPreferencesElement);
                }
            }
            element.setEndpointUiDisabledPreferencesElementList(uiDisPreferenceElements);
        }
        return element;
    }

    private List<NetworkThrottlingElement> getNetworkThrottlingElements(SyncPolicy syncPolicy) {
        ArrayList<NetworkThrottlingElement> networkThrottlingElements = new ArrayList<NetworkThrottlingElement>();
        ArrayList networkThrottlings = syncPolicy.getNetworkThrottlings();
        for (NetworkThrottling networkThrottling : networkThrottlings) {
            NetworkThrottlingElement networkThrottlingElement = new NetworkThrottlingElement();
            BeanUtils.copyProperties((Object)networkThrottling, (Object)networkThrottlingElement);
            networkThrottlingElement.setEndTime(networkThrottling.getEndTime());
            networkThrottlingElements.add(networkThrottlingElement);
        }
        return networkThrottlingElements;
    }

    @Override
    public List<DeviceElement> getDeviceByDeviceNameAndUserName(int cloudId, String cloudName, List<DeviceElement> userDevicesElementList) throws Exception {
        ArrayList<DeviceElement> devElementList = new ArrayList<DeviceElement>();
        if (CollectionUtils.isEmpty(userDevicesElementList)) {
            return null;
        }
        for (DeviceElement deviceElement : userDevicesElementList) {
            if (deviceElement == null || StringUtils.isEmpty((String)deviceElement.getDeviceName()) || StringUtils.isEmpty((String)deviceElement.getUserName())) {
                return null;
            }
            Device device = this.deviceDao.getDeviceByName(cloudId, cloudName, deviceElement.getDeviceName(), deviceElement.getUserName(), "");
            DeviceElement de = new DeviceElement();
            if (device != null) {
                if (device.isDeleted()) {
                    de.setStatus(PCHelperConstant.DEVICE_STATUS.DELETED.toString());
                } else if (device.isBlocked()) {
                    de.setStatus(PCHelperConstant.DEVICE_STATUS.BLOCKED.toString());
                } else if (device.isDecoupled()) {
                    de.setStatus(PCHelperConstant.DEVICE_STATUS.DECOUPLED.toString());
                } else {
                    de.setStatus(PCHelperConstant.DEVICE_STATUS.ACTIVE.toString());
                }
                de.setDeviceName(device.getDeviceName());
                de.setUserName(deviceElement.getUserName());
                de.setDeviceUUID(device.getDeviceUUID());
                List userDeviceAccessControl = this.deviceDao.getUserDeviceAccessControl(cloudId, device.getId());
                List existingOwnersIds = userDeviceAccessControl.stream().filter(line -> Objects.nonNull(line.getUserFK())).map(line -> line.getUserFK().toString()).collect(Collectors.toList());
                List existingOwnerList = this.userDao.getAllUsers(cloudId, "", existingOwnersIds);
                List owners = existingOwnerList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList());
                for (String user : owners) {
                    logger.debug("device.." + device.getDeviceName() + " user..." + user);
                }
                logger.debug(".............." + owners.size());
                if (owners.size() > 0) {
                    logger.debug(".inside..........." + owners.size());
                    de.setDeviceAssigned(true);
                }
            } else {
                de.setStatus("User or Device does not exist or invalid");
                de.setUserName(deviceElement.getUserName());
                de.setDeviceName(deviceElement.getDeviceName());
            }
            devElementList.add(de);
        }
        if (!CollectionUtils.isEmpty(devElementList)) {
            logger.debug("...userListWithBlockFail is exists..." + devElementList.size());
            this.createUsersExcelBlockFail(cloudId, devElementList);
        }
        Collections.sort(devElementList, new Comparator<DeviceElement>(){

            @Override
            public int compare(DeviceElement d1, DeviceElement d2) {
                return new CompareToBuilder().append((Object)d1.getStatus(), (Object)d2.getStatus()).append((Object)d1.getDeviceName().toLowerCase(), (Object)d2.getDeviceName().toLowerCase()).append((Object)d1.getUserName().toLowerCase(), (Object)d2.getUserName().toLowerCase()).toComparison();
            }
        });
        return devElementList;
    }

    @Override
    public Long getFirstBackupEndDate(int cloudId, String userName, String deviceUUID) {
        return this.backupBatchDao.getFirstBackupEndDate(cloudId, userName, deviceUUID);
    }

    @Override
    public void updateOverviewReport(int cloudId) {
        logger.debug("@@EXCEL Before getAllDevicesByUser .....");
        List deviceList = this.deviceDao.getAll(cloudId, "");
        logger.debug("@@EXCEL After getAllDevicesByUser .....");
        int i = 0;
        int j = 0;
        for (Device device : deviceList) {
            DeviceBackupOverView overView = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
            if (overView != null && overView.getLastSuccessfulBackupStartTime() <= 0L) {
                User user = this.userDao.getUserByName(cloudId, device.getUserName());
                if (user == null) continue;
                BackupBatch prevBackup = this.backupBatchDao.getPrevLastBackup(cloudId, device, user);
                if (prevBackup != null) {
                    overView.setLastSuccessfulBackupStartTime(prevBackup.getBatchStartTimestamp());
                    overView.setLastSuccessfulBackupEndTime(prevBackup.getBatchEndTimestamp());
                    this.updateDeviceBackupOverView(cloudId, overView);
                    logger.debug("...actual update... " + ++j);
                }
            }
            logger.debug("...completed updation for devices ... " + j + "/" + ++i);
        }
    }

    @Override
    public void updateAllDeviceOverviewReport(int cloudId) {
        logger.debug("@@ getAllDevicesByUser .....");
        List deviceList = this.deviceDao.getAll(cloudId, "");
        logger.debug("@@ getAllDevicesByUser .....");
        int i = 0;
        int j = 0;
        for (Device device : deviceList) {
            DeviceBackupOverView overView = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
            if (overView != null) {
                User user = this.userDao.getUserByName(cloudId, device.getUserName());
                if (user == null) continue;
                BackupBatch prevBackup = this.backupBatchDao.getPrevLastBackup(cloudId, device, user);
                if (prevBackup != null && overView.getLastSuccessfulBackupEndTime() != prevBackup.getBatchEndTimestamp()) {
                    logger.debug("[updateWiproOverviewReport][deviceUUID][" + device.getDeviceUUID() + "][overviewbkpEndTime][" + overView.getLastSuccessfulBackupEndTime() + "][batchEndTime][" + prevBackup.getBatchEndTimestamp() + "]");
                    overView.setLastSuccessfulBackupStartTime(prevBackup.getBatchStartTimestamp());
                    overView.setLastSuccessfulBackupEndTime(prevBackup.getBatchEndTimestamp());
                    this.updateDeviceBackupOverView(cloudId, overView);
                    logger.debug("...actual update... " + ++j);
                }
            }
            logger.debug("...completed updation for devices ... " + j + "/" + ++i + " out of deviceCount " + deviceList.size());
        }
    }

    @Override
    public void updateFirstBkpEndTimeOverviewReport(int cloudId) {
        logger.debug("@@EXCEL Before getAllDevicesByUser .....");
        List deviceList = this.deviceDao.getAll(cloudId, "");
        logger.debug("@@EXCEL After getAllDevicesByUser .....");
        int i = 0;
        int j = 0;
        for (Device device : deviceList) {
            Long firstBkpEndTime;
            DeviceBackupOverView overView = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID());
            if (overView != null && StringUtils.isEmpty((String)overView.getFirstBkpEndTime()) && (firstBkpEndTime = this.backupBatchDao.getFirstBackupEndDate(cloudId, device.getUserName(), device.getDeviceUUID())) != null) {
                String endDate = this.getDateInFormat(firstBkpEndTime);
                overView.setFirstBkpEndTime(endDate);
                this.updateDeviceBackupOverView(cloudId, overView);
                logger.debug("...updateFirstBkpEndTimeOverviewReport actual update... " + ++j);
            }
            logger.debug("...completed updation updateFirstBkpEndTimeOverviewReport for devices ... " + j + "/" + ++i);
        }
    }

    @Override
    public void updateLastHeardTime(int cloudId, ObjectId overviewId) {
        this.deviceDao.updateLastHeardTime(cloudId, overviewId);
    }

    @Override
    public void updateLastHeardTimeAndPolicyModifiedTime(int cloudId, ObjectId overviewId, long policyModifiedTime) {
        this.deviceDao.updateLastHeardTimeAndPolicyModifiedTime(cloudId, overviewId, policyModifiedTime);
    }

    @Override
    public void updateClientServiceVersion(int cloudId, String serviceVersion, String deviceUUID) {
        this.deviceDao.updateClientServiceVersion(cloudId, serviceVersion, deviceUUID);
    }

    @Override
    public DeviceBackupOverView getDeviceBkpOverviewForDeviceUUID(int cloudId, String deviceUUID) {
        return this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, deviceUUID);
    }

    @Override
    public List<DeviceBackupOverView> getAllDeviceBkpOverviewsForDeviceUUID(int cloudId, String deviceUUID) {
        return this.deviceDao.getAllDeviceBkpOverviewsForDeviceUUID(cloudId, deviceUUID);
    }

    @Override
    public List<DeviceElement> getDevicesByUserNames(int cloudId, List<String> userNames) {
        ArrayList<DeviceElement> devList = new ArrayList<DeviceElement>();
        List devices = this.deviceDao.findDeviceByUserNames(cloudId, userNames);
        for (Device device : devices) {
            DeviceElement ue = new DeviceElement();
            BeanUtils.copyProperties((Object)device, (Object)ue);
            ue.setDeviceId(device.getId().toString());
            ue.setUserId(device.getUserId());
            ue.setUserName(device.getUserName());
            devList.add(ue);
        }
        return devList;
    }

    @Override
    public List<Device> getDevicesByUserName(int cloudId, String userName) {
        return this.deviceDao.getDevicesByUserName(cloudId, userName);
    }

    @Override
    public boolean createExcelForDevices(int cloudId, List<String> deviceNames) {
        ArrayList<DeviceElement> devicesList = new ArrayList();
        List deviceOverviews = this.deviceDao.getAllOverviews(cloudId);
        if (CollectionUtils.isEmpty(deviceNames)) {
            List<DeviceElement> devicesListFromPagination;
            int i = 0;
            while (!CollectionUtils.isEmpty(devicesListFromPagination = this.getAllDevicesWithPagination(cloudId, i, null))) {
                devicesList.addAll(devicesListFromPagination);
                ++i;
            }
        } else {
            devicesList = this.getAllDevices(cloudId, deviceNames);
        }
        if (CollectionUtils.isEmpty(devicesList)) {
            logger.debug("No Devices found.....");
            return false;
        }
        return this.createExcelForDevicesXlsx(cloudId, devicesList, deviceOverviews);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createExcelForDevicesXlsx(int cloudId, List<DeviceElement> devicesList, List<DeviceBackupOverView> deviceOverviews) {
        if (devicesList.isEmpty()) return false;
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            List<List> recordToAdd = this.updateDeviceElementValuesToExcel(cloudId, devicesList, deviceOverviews);
            this.createExcelForDevicesXlsx(recordToAdd, workbook);
            boolean bl = this.writeExcelForDevicesXlsx(workbook);
            return bl;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return false;
    }

    private List<List> updateDeviceElementValuesToExcel(int cloudId, List<DeviceElement> devicesList, List<DeviceBackupOverView> deviceBkpOverViewList) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        List<String> headerRow = this.createHeaderRowForDevicesXlsx();
        recordToAdd.add(headerRow);
        for (DeviceElement deviceElement : devicesList) {
            DeviceBackupOverView deviceBkpOverView = new DeviceBackupOverView();
            deviceBkpOverView = deviceBkpOverViewList.stream().filter(deviceBkp -> StringUtils.isNotEmpty((String)deviceBkp.getDeviceUUID()) && deviceBkp.getDeviceUUID().equals(deviceElement.getDeviceUUID())).findFirst().orElse(new DeviceBackupOverView());
            String lastTimeHeard = "";
            if (deviceBkpOverView != null) {
                lastTimeHeard = this.getLastHeardTime(deviceBkpOverView);
            }
            if (StringUtils.isEmpty((String)lastTimeHeard)) {
                lastTimeHeard = deviceBkpOverView.getEpaInstallationDate();
            }
            List<String> firstRow = this.loadDataOnRowForDevicesXlsx(cloudId, deviceElement, lastTimeHeard);
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    private String getLastHeardTime(DeviceBackupOverView deviceBkp) {
        String lastHeardDate = "";
        if (deviceBkp.getLastHeardTime() > 0L || StringUtils.isNotEmpty((String)deviceBkp.getLastBkpEndTime()) || deviceBkp.getLastSuccessfulBackupEndTime() != 0L || StringUtils.isNotEmpty((String)deviceBkp.getFirstBkpEndTime())) {
            long lstsuccessBkpEndTime;
            String lastAccessTime = this.getDateInFormat(deviceBkp.getLastHeardTime());
            if (StringUtils.isEmpty((String)deviceBkp.getLastBkpEndTime())) {
                lastHeardDate = lastAccessTime;
            } else if (deviceBkp.getLastHeardTime() <= 0L) {
                lastHeardDate = deviceBkp.getLastBkpEndTime();
            } else {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
                    Date bkpEndTime = sdf.parse(deviceBkp.getLastBkpEndTime());
                    Date lastAgentAccessTime = sdf.parse(lastAccessTime);
                    lastHeardDate = bkpEndTime.compareTo(lastAgentAccessTime) > 0 ? deviceBkp.getLastBkpEndTime() : lastAccessTime;
                }
                catch (Exception e) {
                    logger.error("...unable to process date...... " + e.getMessage());
                    logger.trace(EXCEPTION + e);
                }
            }
            long lastHeardDateTime = DeviceManagementServiceImpl.getTime(lastHeardDate);
            if (deviceBkp.getLastSuccessfulBackupEndTime() != 0L && lastHeardDateTime < (lstsuccessBkpEndTime = deviceBkp.getLastSuccessfulBackupEndTime())) {
                lastHeardDate = this.getDateInFormat(lstsuccessBkpEndTime);
            }
        }
        return lastHeardDate;
    }

    private List<String> loadDataOnRowForDevicesXlsx(int cloudId, DeviceElement deviceElement, String lastTimeHeard) {
        ArrayList<String> firstRow = new ArrayList<String>();
        firstRow.add(deviceElement.getDeviceName());
        String osVersionBits = "";
        if (!StringUtils.isEmpty((String)deviceElement.getOsVersion())) {
            osVersionBits = deviceElement.getOsVersion().contains("(") ? "(" + deviceElement.getOsVersion().substring(deviceElement.getOsVersion().indexOf("(") + 1, deviceElement.getOsVersion().indexOf(")")) + ")" : deviceElement.getOsVersion();
        }
        firstRow.add(deviceElement.getOsType() + osVersionBits);
        try {
            String deviceCreatedDate = deviceElement.getDeviceCreatedDate();
            if (!StringUtils.isEmpty((String)deviceCreatedDate)) {
                long deviceCreatedDateInLong = Long.parseLong(deviceCreatedDate);
                firstRow.add(DeviceManagementServiceImpl.getDate(deviceCreatedDateInLong));
            } else {
                firstRow.add("");
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        if (deviceElement.isDecoupled() && !deviceElement.isBlocked() && !deviceElement.isDeleted()) {
            firstRow.add("Decoupled");
        } else if (deviceElement.isBlocked() && !deviceElement.isDeleted()) {
            firstRow.add("Blocked");
        } else if (deviceElement.isDeleted()) {
            firstRow.add("Deleted");
        } else {
            firstRow.add("Active");
        }
        try {
            firstRow.add(deviceElement.getUserName());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        firstRow.add(deviceElement.getClientVersion());
        if (!StringUtils.isEmpty((String)lastTimeHeard)) {
            firstRow.add(lastTimeHeard);
        } else {
            firstRow.add("");
        }
        return firstRow;
    }

    private List<String> createHeaderRowForDevicesXlsx() {
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("Device Name");
        headerRow.add("Os Type");
        headerRow.add("Device Creation Timestamp");
        headerRow.add("Device Status");
        headerRow.add("User ID");
        headerRow.add("Agent Version");
        headerRow.add("Last Time Heard");
        return headerRow;
    }

    boolean createExcelForDevicesXlsx(List<List> l1, XSSFWorkbook workbook) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet("DEVICE LIST");
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum != 0) continue;
                    XSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    XSSFFont font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
            return true;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean writeExcelForDevicesXlsx(XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/Devices.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
    }

    @Override
    public List<Device> getAllBlockedAndUnblockedDeviceForUser(int cloudId, String cloudName, String userName) {
        List devices = this.deviceDao.getAllDeviceByUserName(cloudId, userName);
        if (devices == null) {
            logger.debug(" ******* DEVICE DOES NOT EXISTS for user ..." + userName);
            return null;
        }
        return devices;
    }

    private static long getTime(String strdate) {
        if (StringUtils.isEmpty((String)strdate)) {
            return 0L;
        }
        long milliseconds = 0L;
        SimpleDateFormat f = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
        try {
            Date d = f.parse(strdate);
            milliseconds = d.getTime();
        }
        catch (ParseException e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return milliseconds;
    }

    @Override
    public boolean remoteWipe(int cloudId, String cloudName, Device device) {
        try {
            device.setBlocked(true);
            device.setRemoteWipeEnabled(true);
            Device deviceDetail = this.deviceDao.updateDeviceInfo(cloudId, cloudName, device);
            this.deviceDao.updatedeviceInfoInDeviceBkpOverview(cloudId, device);
            this.deleteAuthorizationTokenForDeviceUUID(cloudId, cloudName, deviceDetail);
            return true;
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
            return false;
        }
    }

    private void deleteAuthorizationTokenForDeviceUUID(int cloudId, String cloudName, Device device) {
        AuthorizationTokens authorizationTokens = this.authorizationDao.getAuthorizationTokenForDevice(cloudId, cloudName, device.getDeviceUUID());
        logger.debug("@@@@Delete Authorization token Start");
        if (authorizationTokens != null) {
            this.authorizationDao.deleteRowFromTable(cloudId, cloudName, authorizationTokens);
            logger.debug("@@@@Delete Authorization token End");
        }
    }

    @Override
    public boolean registerOneDriveBkpDevice(Cloud cloud, DeviceElement deviceElement) {
        boolean deviceCreated = false;
        try {
            boolean success;
            int cloudId = cloud.getCloudId();
            String cloudName = cloud.getCloudName();
            Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, deviceElement.getDeviceUUID());
            if (device != null && !device.isBlocked()) {
                logger.debug("..... device already exists......");
                return true;
            }
            device = new Device();
            BeanUtils.copyProperties((Object)deviceElement, (Object)device);
            String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + device.getDeviceUUID();
            logger.debug(" ************* Device Management path " + path);
            File f = new File(path);
            if (!f.exists() && !(success = f.mkdirs())) {
                throw new BaseException("Failed to create the directory for device.");
            }
            device.setDeviceTempPath(path);
            device.setBlocked(false);
            device.setLastModifiedTimestamp(System.currentTimeMillis());
            device.setDecoupled(false);
            device.setDeviceType(Device.TYPE.ONEDRIVE.name());
            device.setUserName(deviceElement.getUserName());
            User user = this.userDao.getUserByName(cloudId, deviceElement.getUserName());
            String emailId = user.getEmailId();
            device.setDeviceName(emailId + " (" + deviceElement.getDeviceName() + ")");
            device.setDeviceCreatedDate("" + System.currentTimeMillis());
            device.setOsType(Device.TYPE.ONEDRIVE.name());
            this.deviceDao.register(cloudId, cloudName, device);
            this.deviceDao.removeO365BlackListUser(cloudId, deviceElement.getUserName());
            this.saveLatestDeviceBkpInfo(cloudId, device.getDeviceUUID());
            this.saveDeviceBackupOverView(cloudId, device);
            this.saveOdbFolderNameTODeviceUUIDMapping(cloudId, deviceElement);
            deviceCreated = true;
        }
        catch (Exception e) {
            deviceCreated = false;
            logger.error("...... unable to create device ........");
        }
        return deviceCreated;
    }

    @Override
    public boolean registerOutlookBkpDevice(Cloud cloud, DeviceElement deviceElement) {
        boolean deviceCreated = false;
        try {
            boolean success;
            int cloudId = cloud.getCloudId();
            String cloudName = cloud.getCloudName();
            Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, cloudName, deviceElement.getDeviceUUID());
            if (device != null && !device.isBlocked()) {
                logger.debug("..... device already exists......");
                return true;
            }
            device = new Device();
            BeanUtils.copyProperties((Object)deviceElement, (Object)device);
            String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + device.getDeviceUUID();
            logger.debug(" ************* Device Management path " + path);
            File f = new File(path);
            if (!f.exists() && !(success = f.mkdirs())) {
                throw new BaseException("Failed to create the directory for device.");
            }
            device.setDeviceTempPath(path);
            device.setBlocked(false);
            device.setLastModifiedTimestamp(System.currentTimeMillis());
            device.setDecoupled(false);
            device.setDeviceType(Device.TYPE.OUTLOOK.name());
            device.setUserName(deviceElement.getUserName());
            User user = this.userDao.getUserByName(cloudId, deviceElement.getUserName());
            String emailId = user.getEmailId();
            device.setDeviceName(emailId + " (" + deviceElement.getDeviceName() + ")");
            device.setDeviceCreatedDate("" + System.currentTimeMillis());
            device.setOsType(Device.TYPE.OUTLOOK.name());
            this.deviceDao.register(cloudId, cloudName, device);
            this.deviceDao.removeO365BlackListUser(cloudId, deviceElement.getUserName());
            this.saveLatestDeviceBkpInfo(cloudId, device.getDeviceUUID());
            this.saveDeviceBackupOverView(cloudId, device);
            this.saveOdbFolderNameTODeviceUUIDMapping(cloudId, deviceElement);
            deviceCreated = true;
        }
        catch (Exception e) {
            deviceCreated = false;
            logger.error("...... unable to create device ........");
        }
        return deviceCreated;
    }

    @Override
    public long getDeviceBackupOverviewCountByDeviceUUID(int cloudId, String deviceUUID) {
        return this.deviceDao.getDeviceBackupOverviewCountByDeviceUUID(cloudId, deviceUUID);
    }

    @Override
    public void saveStatisticToDatabase(int cloudId, String cloudName, String action, String actionByUser, String actionOnUser, String actionUsingObject, long timeStamp, int actionType) {
        AuditHistory audit = new AuditHistory();
        audit.setAction(action);
        audit.setActionByUserName(actionByUser);
        audit.setActionOnObject(actionOnUser);
        audit.setTimestamp(timeStamp);
        audit.setActionUsingObject(actionUsingObject);
        audit.setActionType(actionType);
        this.auditHistoryDao.saveAudit(cloudId, cloudName, audit);
    }

    @Override
    public List<DeviceElement> getUsersForDevice(int cloudId, String cloudName, String deviceName) {
        ArrayList<DeviceElement> deviceElements = new ArrayList<DeviceElement>();
        List devices = this.deviceDao.getAllUserByDeviceName(cloudId, deviceName);
        if (CollectionUtils.isEmpty((Collection)devices)) {
            logger.debug(" ******* DEVICE DOES NOT EXISTS...");
            return deviceElements;
        }
        for (Device d : devices) {
            DeviceElement deviceElement = new DeviceElement();
            BeanUtils.copyProperties((Object)d, (Object)deviceElement);
            deviceElement.setDeviceId(d.getId().toString());
            deviceElement.setUserName(d.getUserName());
            deviceElements.add(deviceElement);
        }
        return deviceElements;
    }

    @Override
    public Device getDeviceByUserNameAndDeviceName(int cloudId, String userName, String deviceName) {
        return this.deviceDao.getDeviceByUserNameAndDeviceName(cloudId, userName, deviceName);
    }

    @Override
    public void saveO365BlackListUser(int cloudId, O365BlackListUser o365BlackListUser) {
        this.deviceDao.saveO365BlackListUser(cloudId, o365BlackListUser);
    }

    @Override
    public boolean updateDeviceOwnership(Cloud cloud, String userNames, String deviceUUID, User logedInUser) {
        boolean isAllupdated = true;
        ArrayList<String> newOwners = new ArrayList<String>(Arrays.asList(userNames.toLowerCase().split(",")));
        int cloudId = cloud.getCloudId();
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
        if (device == null) {
            return false;
        }
        List userDeviceAccessControl = this.deviceDao.getUserDeviceAccessControl(cloudId, device.getId());
        long totalDeviceMappingCount = this.deviceDao.getCountDeviceAccessControl(cloudId);
        List existingOwnersIds = userDeviceAccessControl.stream().filter(line -> Objects.nonNull(line.getUserFK())).map(line -> line.getUserFK().toString()).collect(Collectors.toList());
        List existingOwnerList = this.userDao.getAllUsers(cloudId, "", existingOwnersIds);
        List existingOwnerNameList = existingOwnerList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName().toLowerCase()).collect(Collectors.toList());
        ArrayList<String> newAddingUserNames = new ArrayList<String>();
        newAddingUserNames.addAll(newOwners);
        if (!CollectionUtils.isEmpty(existingOwnerNameList)) {
            newAddingUserNames.removeAll(existingOwnerNameList);
        }
        List existingRemovingUserNames = existingOwnerNameList;
        if (!CollectionUtils.isEmpty(newOwners)) {
            existingRemovingUserNames.removeAll(newOwners);
        }
        for (String existingOwner : existingRemovingUserNames) {
            User user = this.userDao.getUserByName(cloudId, existingOwner);
            if (user == null) continue;
            logger.debug("deleting access to " + user.getUserName());
            this.deviceDao.deleteUserDeviceAccess(cloudId, device.getId(), user.getUserId());
            this.saveStatisticToDatabase(cloudId, "", "revoke assigned device", logedInUser.getUserName(), device.getDeviceName() + " to " + user.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.MINI_CLOUD_ASSIGN.getActionTypeValue());
            --totalDeviceMappingCount;
        }
        boolean officeProduct = false;
        if (device.getDeviceName().contains("Microsoft Exchange") || device.getDeviceName().contains("Microsoft OneDrive")) {
            officeProduct = true;
        }
        for (String newOwner : newAddingUserNames) {
            OfficeBackupPolicy policy;
            UserDeviceAccessControl accessControl = new UserDeviceAccessControl();
            User user = this.userDao.getUserByName(cloudId, newOwner);
            if (user == null) continue;
            int noOfDevicesAllowed = 0;
            if (officeProduct) {
                policy = this.userDao.getOfficeBackupPolicyByPolicyName(cloudId, user.getOdbPolicyName());
                if (policy != null) {
                    noOfDevicesAllowed = policy.getNoOfDevicesAllowed();
                }
            } else {
                policy = this.userDao.getBackupPolicyByPolicyName(cloud.getCloudId(), user.getPolicyName());
                if (policy != null) {
                    noOfDevicesAllowed = policy.getNoOfDevicesAllowed();
                }
            }
            logger.debug(officeProduct + "...number of devices allowed ... " + noOfDevicesAllowed);
            List allDeviceByUser = this.deviceDao.getAllBackupDeviceByUserName(cloudId, user.getUserName());
            if (this.checkDeviceOwnershipIsAllowed(cloud, totalDeviceMappingCount)) {
                accessControl.setUserFK(user.getUserId());
                accessControl.setDeviceFK(device.getId());
                logger.debug("creating new access to " + user.getUserName());
                this.deviceDao.saveUserDeviceAccessControl(cloudId, accessControl);
                this.saveStatisticToDatabase(cloudId, "", "assigned device", logedInUser.getUserName(), device.getDeviceName() + " to " + user.getUserName(), "Portal", System.currentTimeMillis(), PCActionTypes.MINI_CLOUD_ASSIGN.getActionTypeValue());
                ++totalDeviceMappingCount;
                continue;
            }
            logger.debug("........device limit reached..........");
            isAllupdated = false;
        }
        return isAllupdated;
    }

    private boolean checkDeviceOwnershipIsAllowed(Cloud cloud, long totalDeviceMappingCount) {
        boolean deviceOwnershipAllowed = false;
        int allowedDeviceOwnershipPer = cloud.getAllowedDeviceOwnershipPer();
        long allDeviceCount = this.deviceDao.getAllDeviceCount(cloud.getCloudId());
        logger.debug("******************  " + allDeviceCount);
        logger.debug("******************  " + totalDeviceMappingCount);
        logger.debug("******************  " + (float)totalDeviceMappingCount / (float)allDeviceCount * 100.0f);
        if (totalDeviceMappingCount == 0L || (float)allowedDeviceOwnershipPer > (float)totalDeviceMappingCount / (float)allDeviceCount * 100.0f) {
            deviceOwnershipAllowed = true;
        }
        return deviceOwnershipAllowed;
    }

    @Override
    public DeviceElement getUserDeviceAccessControl(int cloudId, String deviceUUID) {
        Device device = this.deviceDao.getDeviceInfoByUUID(cloudId, "", deviceUUID);
        List userDeviceAccessControl = this.deviceDao.getUserDeviceAccessControl(cloudId, device.getId());
        List existingOwnersIds = userDeviceAccessControl.stream().filter(line -> Objects.nonNull(line.getUserFK())).map(line -> line.getUserFK().toString()).collect(Collectors.toList());
        List existingOwnerList = this.userDao.getAllUsers(cloudId, "", existingOwnersIds);
        DeviceElement devElement = new DeviceElement();
        BeanUtils.copyProperties((Object)device, (Object)devElement);
        devElement.setOwnerList(existingOwnerList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList()));
        return devElement;
    }

    @Override
    public List<DeviceElement> getUserDeviceAccessControlByUserId(int cloudId, ObjectId userId) {
        ArrayList<DeviceElement> deviceElements = new ArrayList<DeviceElement>();
        List userDeviceAccessControl = this.deviceDao.getUserDeviceAccessControlByUserID(cloudId, userId);
        List existingOwnersIds = userDeviceAccessControl.stream().filter(line -> Objects.nonNull(line.getDeviceFK())).map(line -> line.getDeviceFK().toString()).collect(Collectors.toList());
        List devices = this.deviceDao.getAllDevicesByIds(cloudId, existingOwnersIds);
        for (Device d : devices) {
            DeviceElement deviceElement = new DeviceElement();
            BeanUtils.copyProperties((Object)d, (Object)deviceElement);
            deviceElement.setDeviceId(d.getId().toString());
            deviceElement.setUserName(d.getUserName());
            this.setLastSuccessfullbackup(cloudId, d.getUserName(), d, deviceElement);
            deviceElements.add(deviceElement);
        }
        return deviceElements;
    }

    @Override
    public List<DeviceElement> getUserDeviceAccessControlByUserName(int cloudId, String userName) {
        ArrayList<DeviceElement> deviceElements = new ArrayList<DeviceElement>();
        User user = this.userDao.getUserInfoByName(cloudId, userName.toLowerCase());
        List userDeviceAccessControl = this.deviceDao.getUserDeviceAccessControlByUserID(cloudId, user.getUserId());
        List existingOwnersIds = userDeviceAccessControl.stream().filter(line -> Objects.nonNull(line.getDeviceFK())).map(line -> line.getDeviceFK().toString()).collect(Collectors.toList());
        List devices = this.deviceDao.getAllDevicesByIds(cloudId, existingOwnersIds);
        for (Device d : devices) {
            DeviceElement deviceElement = new DeviceElement();
            BeanUtils.copyProperties((Object)d, (Object)deviceElement);
            deviceElement.setDeviceId(d.getId().toString());
            deviceElement.setUserName(d.getUserName());
            this.setLastSuccessfullbackup(cloudId, d.getUserName(), d, deviceElement);
            DeviceBackupOverView backupOverView = this.deviceDao.getDeviceBkpOverviewForDeviceUUID(cloudId, d.getDeviceUUID());
            deviceElement.setStorageUsedByDevice(DeviceManagementServiceImpl.formatFileSize(backupOverView.getStorageUtilized()));
            deviceElement.setCanAdminRestore(d.isCanAdminRestore());
            deviceElements.add(deviceElement);
        }
        return deviceElements;
    }

    @Override
    public void saveMailBackupBatch(int cloudId, MailBackupBatch backupBatch, EventHub eventHub) {
        this.deviceDao.saveMailBackupBatch(cloudId, backupBatch, eventHub);
    }

    @Override
    public MailBackupBatch getMailBackupBatch(int cloudId, String actionToDeviceUUID) {
        return this.deviceDao.getMailBackupBatch(cloudId, actionToDeviceUUID);
    }

    private void createUsersExcelBlockFail(int cloudId, List<DeviceElement> userList) {
        if (!CollectionUtils.isEmpty(userList)) {
            try (XSSFWorkbook workbook = new XSSFWorkbook();){
                List<List> recordToAdd = this.updateUserElementValuesToExcelForBlockFail(userList);
                this.createExcelForUserXlsx(recordToAdd, workbook);
                this.writeExcelForUserXlsxForBlackFail(workbook);
            }
            catch (Exception e) {
                logger.trace(EXCEPTION + e);
                logger.error(EXCEPTION + e.getMessage());
            }
        }
    }

    void writeExcelForUserXlsxForBlackFail(XSSFWorkbook workbook) {
        try (FileOutputStream fos = new FileOutputStream(new File(PCHelperConstant.getPropertyFileValueParacloudMountPoint() + "/reports/Device_Block_Fail.xlsx"));){
            XSSFCellStyle hsfstyle = workbook.createCellStyle();
            hsfstyle.setBorderBottom((short)1);
            hsfstyle.setFillBackgroundColor((short)245);
            workbook.write((OutputStream)fos);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    private List<List> updateUserElementValuesToExcelForBlockFail(List<DeviceElement> userList) {
        ArrayList<List> recordToAdd = new ArrayList<List>();
        List<String> headerRow = this.createHeaderRowForUserXlsxForBlockFail();
        recordToAdd.add(headerRow);
        for (DeviceElement userElement : userList) {
            List<String> firstRow = this.loadDataOnRowForUserXlsxForBlackFail(userElement);
            recordToAdd.add(firstRow);
        }
        return recordToAdd;
    }

    List<String> createHeaderRowForUserXlsxForBlockFail() {
        ArrayList<String> headerRow = new ArrayList<String>();
        headerRow.add("Device Name");
        headerRow.add("Reason");
        return headerRow;
    }

    List<String> loadDataOnRowForUserXlsxForBlackFail(DeviceElement userElement) {
        ArrayList<String> firstRow = new ArrayList<String>();
        firstRow.add(userElement.getDeviceName());
        firstRow.add(userElement.getStatus());
        return firstRow;
    }

    void createExcelForUserXlsx(List<List> l1, XSSFWorkbook workbook) throws Exception {
        XSSFSheet firstSheet = workbook.createSheet("FIRST SHEET");
        int rownum = 0;
        try {
            for (int j = 0; j < l1.size(); ++j) {
                XSSFRow row = firstSheet.createRow(rownum);
                List l2 = l1.get(j);
                for (int k = 0; k < l2.size(); ++k) {
                    Cell cell = row.createCell(k);
                    cell.setCellValue((String)l2.get(k));
                    if (rownum != 0) continue;
                    XSSFCellStyle cellStyle = workbook.createCellStyle();
                    cellStyle.setFillForegroundColor((short)51);
                    cellStyle.setFillPattern((short)1);
                    XSSFFont font = workbook.createFont();
                    font.setFontName("Arial");
                    font.setFontHeightInPoints((short)10);
                    font.setBoldweight((short)10);
                    cellStyle.setFont((Font)font);
                    cell.setCellStyle((CellStyle)cellStyle);
                }
                ++rownum;
            }
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
    }

    @Override
    public List<DeviceElement> getAllUserDeviceAccessControl(int cloudId) {
        ArrayList<DeviceElement> deviceElements = new ArrayList<DeviceElement>();
        List devices = this.deviceDao.getAllUserDeviceAccessControl(cloudId);
        if (!CollectionUtils.isEmpty((Collection)devices)) {
            for (Device d : devices) {
                DeviceElement deviceElement = new DeviceElement();
                BeanUtils.copyProperties((Object)d, (Object)deviceElement);
                deviceElement.setDeviceId(d.getId().toString());
                deviceElement.setUserName(d.getUserName());
                this.setLastSuccessfullbackup(cloudId, d.getUserName(), d, deviceElement);
                deviceElements.add(deviceElement);
            }
        }
        return deviceElements;
    }

    @Override
    public List<DeviceElement> getAllDevicesForReadOnlyWithPagination(int cloudId, int pagNum, List<String> policyNames) {
        ArrayList<DeviceElement> devElementList = new ArrayList<DeviceElement>();
        ArrayList deviceList = new ArrayList();
        List deviceOverViewList = this.deviceDao.getAllOverViewWithPagination(cloudId, pagNum, policyNames);
        for (DeviceBackupOverView deviceBackupOverView : deviceOverViewList) {
            List allDevicesByUUID = this.deviceDao.getAllDevicesByUUID(cloudId, "", deviceBackupOverView.getDeviceUUID());
            deviceList.addAll(allDevicesByUUID);
        }
        for (Device device : deviceList) {
            DeviceElement ue = new DeviceElement();
            BeanUtils.copyProperties((Object)device, (Object)ue);
            ue.setDeviceId(device.getId().toString());
            ue.setUserId(device.getUserId());
            ue.setUserName(device.getUserName());
            List userDeviceAccessControl = this.deviceDao.getUserDeviceAccessControl(cloudId, device.getId());
            List existingOwnersIds = userDeviceAccessControl.stream().filter(line -> Objects.nonNull(line.getUserFK())).map(line -> line.getUserFK().toString()).collect(Collectors.toList());
            List existingOwnerList = this.userDao.getAllUsers(cloudId, "", existingOwnersIds);
            ue.setOwnerList(existingOwnerList.stream().filter(line -> Objects.nonNull(line.getUserName())).map(line -> line.getUserName()).collect(Collectors.toList()));
            devElementList.add(ue);
        }
        return devElementList;
    }

    @Override
    public long getAllReadOnlyAdminDeviceCount(int cloudId, List<String> policyNames) {
        return this.deviceDao.getCountAllOverviews(cloudId, policyNames);
    }

    @Override
    public void updateDevice(int cloudId, Device device) {
        this.deviceDao.updateDevice(cloudId, device);
    }

    @Override
    public void saveOdbFolderNameTODeviceUUIDMapping(int cloudId, DeviceElement deviceElement) {
        OdbFolderNameTODeviceUUIDMapping odb = new OdbFolderNameTODeviceUUIDMapping();
        odb.setDeviceUUID(deviceElement.getDeviceUUID());
        odb.setUserName(deviceElement.getUserName());
        odb.setOdbFolderName(DeviceManagementServiceImpl.getUniqueODUserFolder(deviceElement.getDeviceUUID()));
        this.deviceDao.saveOdbFolderNameTODeviceUUIDMapping(cloudId, odb);
    }

    private static String getUniqueODUserFolder(String deviceUUID) {
        String convertedString = "";
        if (!StringUtils.isEmpty((String)deviceUUID)) {
            String md5Val = MD5Generator.generateMD5OfString((String)deviceUUID);
            Long l = ByteBuffer.wrap(md5Val.toString().getBytes()).getLong();
            convertedString = Long.toString(l, 36);
        }
        return convertedString;
    }
}

