/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.UserDefinedFoldersDao;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDefinedFolders;
import java.util.List;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class UserDefinedFoldersDaoImpl
implements UserDefinedFoldersDao {
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String USER_NAME = "userName";
    private static final String FOLDER_TYPE = "folderType";

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveUserDefinedFolders(int cloudId, String cloudName, UserDefinedFolders userDefinedFolders) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)userDefinedFolders);
        this.updateBackupPolicy(cloudId, cloudName, userDefinedFolders.getUserName());
    }

    public void updateBackupPolicy(int cloudId, String cloudName, String userName) {
        User user = this.getUser(cloudId, userName);
        if (user != null) {
            user.setPolicyModifiedTime(System.currentTimeMillis());
            this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)user);
        }
    }

    @Override
    public List<UserDefinedFolders> getAllUserDefinedInclusionFolders(int cloudId, String cloudName, String deviceUUID, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)FOLDER_TYPE).is((Object)PCHelperConstant.FOLDER_TYPE.INCLUSION.toString())});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, UserDefinedFolders.class);
    }

    @Override
    public List<UserDefinedFolders> getAllUserDefinedExclusionFolders(int cloudId, String cloudName, String deviceUUID, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)FOLDER_TYPE).is((Object)PCHelperConstant.FOLDER_TYPE.EXCLUSION.toString())});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, UserDefinedFolders.class);
    }

    private User getUser(int cloudId, String userName) {
        Criteria criteria = Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i");
        Query query = new Query((CriteriaDefinition)criteria);
        return (User)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public void deleteUserDefinedFolder(int cloudId, String cloudName, String folderPath, String deviceUUID, String userName, String folderType) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"deviceUUID").is((Object)deviceUUID), Criteria.where((String)"folderPath").is((Object)folderPath), Criteria.where((String)FOLDER_TYPE).is((Object)folderType)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAndRemove(query, UserDefinedFolders.class);
        this.updateBackupPolicy(cloudId, cloudName, userName);
    }

    @Override
    public void deleteUserDefinedFoldersForUser(int cloudId, String cloudName, String userName, String folderType) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i")});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, UserDefinedFolders.class);
    }

    @Override
    public List<UserDefinedFolders> getAllUserDefinedFolders(int cloudId, String cloudName, String deviceUUID, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)"deviceUUID").is((Object)deviceUUID)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, UserDefinedFolders.class);
    }
}

