/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.ReportSchedulerDao;
import com.parablu.pcbd.dao.impl.ReportConfigDaoImpl;
import com.parablu.pcbd.domain.ReportScheduler;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class ReportSchedulerDaoImpl
implements ReportSchedulerDao {
    private ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static Logger logger = LogManager.getLogger(ReportConfigDaoImpl.class);

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public List<ReportScheduler> getReportScheduler(int cloudId, String schedulerName) {
        try {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"schedulerName").is((Object)schedulerName)});
            Query query = new Query((CriteriaDefinition)criteria);
            return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, ReportScheduler.class);
        }
        catch (Exception e) {
            logger.trace("EXCEPTION" + e);
            logger.error("EXCEPTION" + e.getMessage());
            return null;
        }
    }

    @Override
    public List<ReportScheduler> getReportSchedulerNames(int cloudId, List<String> schedulerNames) {
        try {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"schedulerName").in(schedulerNames)});
            Query query = new Query((CriteriaDefinition)criteria);
            return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, ReportScheduler.class);
        }
        catch (Exception e) {
            logger.trace("EXCEPTION" + e);
            logger.error("EXCEPTION" + e.getMessage());
            return null;
        }
    }

    @Override
    public void saveReportScheduler(int cloudId, ReportScheduler reportScheduler) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)reportScheduler);
    }

    @Override
    public ReportScheduler getReportSchedulerById(int cloudId, ObjectId objectId) {
        try {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)objectId)});
            Query query = new Query((CriteriaDefinition)criteria);
            return (ReportScheduler)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, ReportScheduler.class);
        }
        catch (Exception e) {
            logger.trace("EXCEPTION" + e);
            logger.error("EXCEPTION" + e.getMessage());
            return null;
        }
    }

    @Override
    public void deleteReportSchedulerById(int cloudId, ObjectId objectId) {
        try {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)objectId)});
            Query query = new Query((CriteriaDefinition)criteria);
            this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAndRemove(query, ReportScheduler.class);
        }
        catch (Exception e) {
            logger.trace("EXCEPTION" + e);
            logger.error("EXCEPTION" + e.getMessage());
        }
    }

    @Override
    public List<ReportScheduler> getAllReportScheduler(int cloudId) {
        try {
            Criteria criteria = new Criteria();
            Query query = new Query((CriteriaDefinition)criteria);
            return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, ReportScheduler.class);
        }
        catch (Exception e) {
            logger.trace("EXCEPTION" + e);
            logger.error("EXCEPTION" + e.getMessage());
            return null;
        }
    }

    @Override
    public ReportScheduler getReportSchedulerByDisplyName(int cloudId, String schedulerName, String displayName) {
        try {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"schedulerName").is((Object)schedulerName), Criteria.where((String)"displayName").is((Object)displayName)});
            Query query = new Query((CriteriaDefinition)criteria);
            return (ReportScheduler)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, ReportScheduler.class);
        }
        catch (Exception e) {
            logger.trace("EXCEPTION" + e);
            logger.error("EXCEPTION" + e.getMessage());
            return null;
        }
    }
}

