/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.pcbd.dao.ReleaseDao;
import com.parablu.pcbd.domain.Release;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class ReleaseDaoImpl
implements ReleaseDao {
    Logger logger = LogManager.getLogger(ReleaseDaoImpl.class);
    private MongoOperations mongoOps;

    public MongoOperations getMongoOps() {
        return this.mongoOps;
    }

    public void setMongoOps(MongoOperations mongoOps) {
        this.mongoOps = mongoOps;
    }

    @Override
    public void updateRelease(Release release) {
        this.mongoOps.save((Object)release);
    }

    @Override
    public void saveRelease(Release release) {
        this.mongoOps.save((Object)release);
    }

    @Override
    public List<Release> getAllCurrentVersions() {
        return this.mongoOps.findAll(Release.class);
    }

    @Override
    public Release getReleaseFromReleaseMinorVersion(String minorVersion) {
        return (Release)this.mongoOps.findOne(new Query((CriteriaDefinition)Criteria.where((String)"productMinorGroup").is((Object)minorVersion)), Release.class);
    }

    @Override
    public void updateServerUpgradeVersion(String productVersion, String productMinorVersion) {
        this.logger.debug(" inside updte release table  .............................................................. ");
        Criteria criteria = Criteria.where((String)"productMinorGroup").is((Object)productMinorVersion);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("productVersion", (Object)productVersion);
        this.mongoOps.updateFirst(query, update, Release.class);
    }

    @Override
    public void saveProductTable(Release productElement) {
        this.logger.debug("inside update product table.......");
        Criteria criteria = Criteria.where((String)"productMinorGroup").is((Object)productElement.getProductMinorGroup());
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        if (!StringUtils.isEmpty((String)productElement.getProductVersion())) {
            update.set("productVersion", (Object)productElement.getProductVersion());
        }
        if (!StringUtils.isEmpty((String)productElement.getProductMinorGroup())) {
            update.set("productMinorGroup", (Object)productElement.getProductMinorGroup());
        }
        if (!StringUtils.isEmpty((String)String.valueOf(productElement.isUpdateAgent()))) {
            update.set("updateAgent", (Object)productElement.isUpdateAgent());
        }
        update.set("downloadAgent", (Object)productElement.isDownloadAgent());
        this.mongoOps.upsert(query, update, Release.class);
    }
}

