/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.element.PGInfoElement;
import com.parablu.pcbd.dao.PGInfoDao;
import com.parablu.pcbd.domain.PGInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;

public class PGInfoDaoImpl
implements PGInfoDao {
    private static Logger logger = LogManager.getLogger(PGInfoDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String TIME_STAMP = "timeStamp";
    private static final String GATEWAY_NAME = "gatewayName";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public List<PGInfo> getPGInfo(int cloudId, String cloudName, long startTime, long endTime) {
        ArrayList<PGInfo> pgInfo = new ArrayList<PGInfo>();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String dbName = "pginfo_trends";
        dbName = PGInfoDaoImpl.getConvertDBCharacters(dbName).toUpperCase();
        MongoCollection coll = mongoTemplate.getCollection(dbName);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)TIME_STAMP, (Object)new Document("$gte", (Object)startTime).append("$lte", (Object)endTime))});
        MongoCursor iterator = coll.find(matchQuery).iterator();
        while (iterator.hasNext()) {
            PGInfo info = (PGInfo)mongoTemplate.getConverter().read(PGInfo.class, iterator.next());
            pgInfo.add(info);
        }
        return pgInfo;
    }

    @Override
    public PGInfo getTotalStoragePerPg(int cloudId, String cloudName, String gatewayName) {
        PGInfo pgInfo = new PGInfo();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        float totalSizeUsed = 0.0f;
        Criteria criteria = Criteria.where((String)GATEWAY_NAME).is((Object)gatewayName);
        String dbName = "pginfo_trends";
        dbName = PGInfoDaoImpl.getConvertDBCharacters(dbName).toUpperCase();
        logger.debug(" DB NAME ..... " + dbName);
        TypedAggregation aggregation = Aggregation.newAggregation(PGInfoElement.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{GATEWAY_NAME}).sum("sizeInMB").as("size"), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{GATEWAY_NAME}), Aggregation.project((String[])new String[]{"size", GATEWAY_NAME}), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{GATEWAY_NAME})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, dbName, BasicDBObject.class);
        List stateStatsList = result.getMappedResults();
        for (BasicDBObject dbObject : stateStatsList) {
            logger.debug("&&&&&&Instance");
            totalSizeUsed = (float)dbObject.getDouble("size");
        }
        pgInfo.setSizeInMB(totalSizeUsed);
        pgInfo.setGatewayName(gatewayName);
        logger.debug(" SDASSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS     .............. " + totalSizeUsed);
        return pgInfo;
    }

    private static String getConvertDBCharacters(String dbName) {
        String replacedDbName = dbName.replace(".", "_");
        replacedDbName = replacedDbName.replace("@", "_");
        return replacedDbName;
    }

    @Override
    public List<PGInfo> getODInfo(int cloudId, String cloudName, long startTime, long endTime) {
        ArrayList<PGInfo> pgInfo = new ArrayList<PGInfo>();
        logger.debug("Start time..:" + startTime + "endTime" + endTime);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String dbName = "odinfo_trends";
        dbName = PGInfoDaoImpl.getConvertDBCharacters(dbName).toUpperCase();
        MongoCollection coll = mongoTemplate.getCollection(dbName);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)TIME_STAMP, (Object)new Document("$gte", (Object)startTime).append("$lte", (Object)endTime))});
        MongoCursor iterator = coll.find(matchQuery).iterator();
        while (iterator.hasNext()) {
            PGInfo info = (PGInfo)mongoTemplate.getConverter().read(PGInfo.class, iterator.next());
            pgInfo.add(info);
            logger.debug("Size..:" + info.getSizeInMB());
        }
        return pgInfo;
    }

    @Override
    public List<PGInfo> getBlobStorageInfo(int cloudId, String cloudName, long startTime, long endTime) {
        logger.debug("Start time..:" + startTime + "endTime" + endTime);
        ArrayList<PGInfo> pgInfo = new ArrayList<PGInfo>();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String dbName = "blobinfo_trends";
        dbName = PGInfoDaoImpl.getConvertDBCharacters(dbName).toUpperCase();
        MongoCollection coll = mongoTemplate.getCollection(dbName);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)TIME_STAMP, (Object)new Document("$gte", (Object)startTime).append("$lte", (Object)endTime))});
        MongoCursor iterator = coll.find(matchQuery).iterator();
        while (iterator.hasNext()) {
            PGInfo info = (PGInfo)mongoTemplate.getConverter().read(PGInfo.class, iterator.next());
            pgInfo.add(info);
            logger.debug("Size..:" + info.getSizeInMB());
        }
        return pgInfo;
    }

    @Override
    public void savePGInfo(int cloudId, String tableName1, PGInfoElement pgInfoElement) {
        String tableName = tableName1;
        try {
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            tableName = tableName.toUpperCase();
            if (!mongoTemplate.collectionExists(tableName)) {
                mongoTemplate.createCollection(tableName);
            }
            mongoTemplate.insert((Object)pgInfoElement, tableName);
        }
        catch (Exception e) {
            logger.trace(" Exception  :" + e);
            logger.error(" Exception  :" + e.getMessage());
        }
    }
}

