/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.OfficeBackupPolicyDao;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.MSAppBluKrypt;
import com.parablu.pcbd.domain.OPWS;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.PrivacyGatewayBackupPolicyMapping;
import com.parablu.pcsd.domain.SyncPolicy;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class OfficeBackupPolicyDaoImpl
implements OfficeBackupPolicyDao {
    private static Logger logger = LogManager.getLogger(OfficeBackupPolicyDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String POLICY_NAME = "policyName";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveOfficeBackupPolicy(int cloudId, OfficeBackupPolicy backupPolicy) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backupPolicy);
    }

    @Override
    public OfficeBackupPolicy getOfficeBackupPolicy(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (OfficeBackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), OfficeBackupPolicy.class);
    }

    @Override
    public List<OfficeBackupPolicy> loadAllOneDriveBackupPolicies(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, OfficeBackupPolicy.class);
    }

    @Override
    public BackupPolicy getBackupPolicyForDevice(int cloudId, String cloudName, String deviceUUID) {
        return null;
    }

    @Override
    public Boolean getBackupPolicy(int cloudId, String cloudName, String policyName, long lastModifiedTime) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName), Criteria.where((String)"lastModifiedTimestamp").is((Object)lastModifiedTime)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        BackupPolicy backupPolicy = (BackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
        if (backupPolicy != null) {
            return true;
        }
        return false;
    }

    @Override
    public void deletePGNWTMappings(int cloudId, String cloudName, List<Integer> existIdList) {
    }

    @Override
    public List<PrivacyGatewayBackupPolicyMapping> getPrivGatewayBackupPolicyMappings(int cloudId, String cloudName, Long backupPolicyId) {
        return null;
    }

    @Override
    public List<BackupPolicy> getBackupPolicyForFilterId(int cloudId, String cloudName, ObjectId id) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"inclusionFilter.$id").is((Object)id)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
    }

    @Override
    public void saveOPWS(int cloudId, String cloudName, OPWS opws) {
        List list;
        String tableName = "opws_" + cloudName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        if (!CollectionUtils.isEmpty((Collection)(list = mongoTemplate.findAll(OPWS.class, tableName)))) {
            Query query = new Query();
            Update update = new Update();
            update.set("threadSize", (Object)opws.getThreadSize());
            mongoTemplate.updateFirst(query, update, OPWS.class, tableName);
        } else {
            mongoTemplate.insert((Object)opws, tableName);
        }
    }

    @Override
    public long getThreadSize(int cloudId, String cloudName) {
        Query query;
        OPWS opws;
        String tableName = "opws_" + cloudName;
        tableName = tableName.toUpperCase();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (!mongoTemplate.collectionExists(tableName)) {
            mongoTemplate.createCollection(tableName);
        }
        if ((opws = (OPWS)mongoTemplate.findOne(query = new Query(), OPWS.class, tableName)) != null) {
            return opws.getThreadSize();
        }
        return 0L;
    }

    @Override
    public List<BackupPolicy> getAllLegalHoldBackupPolicies(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"legalHoldEnabled").is((Object)true)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), BackupPolicy.class);
    }

    @Override
    public void updatePolicyModifiedTime(int cloudId, ObjectId objectId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)objectId)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndModify(query, update, BackupPolicy.class);
    }

    @Override
    public boolean checkIfBackupPolicyNameExists(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)POLICY_NAME).is((Object)policyName)});
        Query query = new Query((CriteriaDefinition)criteria);
        List list = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, BackupPolicy.class);
        return !CollectionUtils.isEmpty((Collection)list);
    }

    @Override
    public void blockPolicy(int cloudId, String policyName, String policyType) {
        Criteria criteria = Criteria.where((String)POLICY_NAME).is((Object)policyName);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("isBlocked", (Object)true);
        update.set("lastModifiedTimestamp", (Object)System.currentTimeMillis());
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if ("backupPolicy".equalsIgnoreCase(policyType)) {
            paracloudMongoTemplate.updateFirst(query, update, BackupPolicy.class);
        } else {
            paracloudMongoTemplate.updateFirst(query, update, SyncPolicy.class);
        }
    }

    @Override
    public List<BackupPolicy> loadAllBackupPolicies(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.fields().include("id");
        query.fields().include(POLICY_NAME);
        query.fields().include("maxVersions");
        query.fields().include("schedules");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, BackupPolicy.class);
    }

    @Override
    public MSAppBluKrypt getMSAppBluKrypt(int cloudId, String msAppBluKrypt) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"name").is((Object)msAppBluKrypt)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(new Query((CriteriaDefinition)criteria), MSAppBluKrypt.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return (MSAppBluKrypt)list.get(0);
        }
        return null;
    }

    @Override
    public List<OfficeBackupPolicy> getAllOfficePoliciesWithPagination(int cloudId, int pagNum) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (pagNum != 0) {
            query.skip((long)(pagNum * PCHelperConstant.getReportDisplayRecords()));
        }
        if (PCHelperConstant.getReportDisplayRecords() != 0) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        MongoTemplate mongotemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongotemplate.find(query, OfficeBackupPolicy.class);
    }

    @Override
    public long getOfficeBkpPoliciesCount(int cloudId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, OfficeBackupPolicy.class);
    }

    @Override
    public long getOfficeBkpPoliciesCount(int cloudId, List<String> policyNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false), Criteria.where((String)POLICY_NAME).in(policyNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, OfficeBackupPolicy.class);
    }

    @Override
    public List<OfficeBackupPolicy> getAllOfficePoliciesWithPagination(int cloudId, List<String> policyNames, int pagNum) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isBlocked").is((Object)false), Criteria.where((String)POLICY_NAME).in(policyNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        if (pagNum != 0) {
            query.skip((long)(pagNum * PCHelperConstant.getReportDisplayRecords()));
        }
        if (PCHelperConstant.getReportDisplayRecords() != 0) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        MongoTemplate mongotemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongotemplate.find(query, OfficeBackupPolicy.class);
    }
}

