/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.NotificationsDao;
import com.parablu.pcbd.domain.Notifications;
import com.parablu.pcbd.domain.NotificationsType;
import java.util.List;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class NotificationsDaoImpl
implements NotificationsDao {
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveNotificationsType(int cloudId, String cloudName, NotificationsType notificationsType) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)notificationsType);
    }

    @Override
    public NotificationsType getNotifications(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List notificationsTypes = mongoTemplate.findAll(NotificationsType.class);
        if (!notificationsTypes.isEmpty()) {
            return (NotificationsType)notificationsTypes.get(0);
        }
        return null;
    }

    @Override
    public void saveNotifications(int cloudId, String cloudName, Notifications notifications) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)notifications);
    }

    @Override
    public List<Notifications> getSavedNotifications(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(Notifications.class);
    }

    @Override
    public void updateNotification(int cloudId, String cloudName, String notificationId, Notifications notifications) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)notificationId)});
        Query query = new Query((CriteriaDefinition)criteria);
        Update updateObj = new Update();
        updateObj.set("notificationsType", notifications.getNotificationsType());
        updateObj.set("policyNames", notifications.getPolicyNames());
        updateObj.set("userNames", notifications.getUserNames());
        updateObj.set("timeStamp", (Object)notifications.getTimeStamp());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, updateObj, Notifications.class);
    }

    @Override
    public void deleteNotification(int cloudId, String cloudName, String notificationId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)notificationId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, Notifications.class);
    }

    @Override
    public Notifications getSavedNotificationsForId(int cloudId, String cloudName, String id) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (Notifications)mongoTemplate.findOne(query, Notifications.class);
    }
}

