/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.pcbd.dao.MediaImageDao;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.MediaImage;
import java.util.List;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MediaImageDaoImpl
implements MediaImageDao {
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveImage(int cloudId, String cloudName, MediaImage mediaImage) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)mediaImage);
    }

    @Override
    public List<MediaImage> getFilesAlreadyPresentFromUploadList(int cloudId, String cloudName, List<String> fileName) {
        String namedQuery = "from MediaImage mediaImage where (mediaImage.fileName) in (:fileNameList)";
        org.hibernate.Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery(namedQuery);
        query.setParameterList("fileNameList", fileName);
        return query.list();
    }

    @Override
    public List<MediaImage> getAllMediaForDevice(int cloudId, String cloudName, Device deivce) {
        String namedQuery = "from MediaImage mediaImage where mediaImage.device.deviceId=:device";
        org.hibernate.Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery(namedQuery);
        return query.list();
    }

    @Override
    public List<MediaImage> getAllMediaForMediaType(int cloudId, String cloudName, String mediaType) {
        String namedQuery = "from MediaImage mediaImage where mediaImage.mediaType=:mediaType";
        org.hibernate.Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery(namedQuery);
        query.setParameter("mediaType", (Object)mediaType);
        return query.list();
    }

    @Override
    public List<MediaImage> getAllMediaForMediaTypeAndGroup(int cloudId, String cloudName, String mediaType, String mediaGroup) {
        String namedQuery = "from MediaImage mediaImage where mediaImage.mediaType=:mediaType and mediaImage.metaData=:mediaGroup";
        org.hibernate.Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery(namedQuery);
        query.setParameter("mediaType", (Object)mediaType);
        query.setParameter("mediaGroup", (Object)mediaGroup);
        return query.list();
    }

    @Override
    public MediaImage getMediaImageForFile(int cloudId, String cloudName, String fileName) {
        String namedQuery = "from MediaImage mediaImage where mediaImage.fileName=:fileName";
        org.hibernate.Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery(namedQuery);
        query.setParameter("fileName", (Object)fileName);
        return (MediaImage)query.uniqueResult();
    }

    @Override
    public void removeEntryFromTable(int cloudId, String cloudName, MediaImage mediaImage) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove((Object)mediaImage);
    }

    @Override
    public Double getTotalSizeUsed(int cloudId, String cloudName) {
        Criteria criteria = Criteria.where((String)"size").gt((Object)0);
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long count = mongoTemplate.count(query, MediaImage.class);
        return new Double(count);
    }
}

