/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.LocalFileSystemDao;
import com.parablu.pcbd.domain.LocalFileSystem;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class LocalFileSystemDaoImpl
implements LocalFileSystemDao {
    Logger logger = LogManager.getLogger(LocalFileSystemDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveLocalFileSystemDetails(int cloudId, LocalFileSystem localFileSystem) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List localFileSystems = mongoTemplate.findAll(LocalFileSystem.class);
        if (localFileSystems.isEmpty()) {
            mongoTemplate.save((Object)localFileSystem);
        } else if (!localFileSystems.isEmpty()) {
            LocalFileSystem fileSystem = (LocalFileSystem)localFileSystems.get(0);
            ObjectId id = fileSystem.getId();
            Criteria criteria = Criteria.where((String)"id").is((Object)id);
            Query query = new Query((CriteriaDefinition)criteria);
            Update update = new Update();
            this.logger.debug("fileServerPath" + localFileSystem.getFileServerPath());
            update.set("fileServerPath", (Object)localFileSystem.getFileServerPath());
            update.set("fileServerUserName", (Object)localFileSystem.getFileServerUserName());
            update.set("fileServerPassword", (Object)localFileSystem.getFileServerPassword());
            mongoTemplate.updateFirst(query, update, LocalFileSystem.class);
        }
    }

    @Override
    public LocalFileSystem getLocalFileSystemDetails(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List localFileSystems = mongoTemplate.findAll(LocalFileSystem.class);
        return (LocalFileSystem)localFileSystems.get(0);
    }
}

