/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.DBRef;
import com.mongodb.ReadPreference;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Sorts;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.pcbd.dao.FileRevisionDao;
import com.parablu.pcbd.domain.BackupFile;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.DailySyncOverView;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.SyncOverView;
import com.parablu.pcbd.domain.User;
import com.parablu.pcsd.domain.SyncPolicy;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class FileRevisionDaoImpl
implements FileRevisionDao {
    Logger logger = LogManager.getLogger(FileRevisionDaoImpl.class);
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String CONSOLIDATED_IMAGE_ID = "consolidatedImage.$id";
    private static final String LAST_MODIFIED_TIME = "lastModifiedTime";
    private static final String STATUS = "status";
    private static final String DELETED = "DELETED";
    private static final String DOLLAR_MATCH = "$match";
    private static final String REVISIONS = "REVISIONS";
    private static final String DOLLAR_CONSOLIDATED_IMAGE = "$consolidatedImage";
    private static final String DOC_ID = "docId";
    private static final String DOLLAR_LAST = "$last";
    private static final String DOLLLAR_LAST_MODIFIED_TIME = "$lastModifiedTime";
    private static final String DOLLAR_GROUP = "$group";
    private static final String DOLAR_SORT = "$sort";
    private static final String DOLLAR_ID = "$docId";
    private static final String CONSOLIDATED_IMAGE = "consolidatedImage";
    private static final String DOLLAR_PROJECT = "$project";
    private static final String DEVICE_PATH = "devicePath";
    private static final String MODIFIED_TIME = "modifiedTime";
    private static final String USER_NAME = "userName";
    private static final String GROUP_BY_CONSOLIDATED_IMAGE_FK_RAMX = "group by CONSOLIDATED_IMAGE_FK) rmax ";
    private static final String ON_R_CONSOLIDATED_IMAGE_FK_RMAX_CONSOLIDATED_IMAGE_FK = "on r.CONSOLIDATED_IMAGE_FK=rmax.CONSOLIDATED_IMAGE_FK ";
    private static final String F_SPATH = "fSPath";
    private static final String MAX_LAST_MODIFIED_TIME_STAMP = "max(LAST_MODIFIED_TIMESTAMP)";
    private static final String FOLDER = "folder";
    private static final String PRIVACY_GATEWAY_SYNC = "privacy_gateway_sync_";
    private static final String PRESENT = "present";
    private static final String FILE_NAME = "fileName";
    public static final String CHUNK_DETAIL = "CHUNK_DETAIL";
    public static final int CHUNK_TOTAL_DB_COUNT = PCHelperConstant.getChunkTotalBuckets();

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public FileRevision getLatestRevision(int cloudId, String cloudName, ObjectId consolidateImageId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public FileRevision getLatestPresentRevision(int cloudId, String cloudName, ObjectId consolidateImageId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId), Criteria.where((String)STATUS).ne((Object)PCHelperConstant.REVISION_STATUS.DELETED.toString())});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public List<FileRevision> getAllRevisions(int cloudId, String cloudName, ObjectId consolidateImageId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public void saveRevision(int cloudId, String cloudName, FileRevision fileRevision) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)fileRevision);
    }

    @Override
    public List<FileRevision> getLatestByRevisionsByConsoIds(int cloudId, String cloudName, List<ObjectId> consoIdList, String userName) {
        this.logger.debug("...latest mongo4..........");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("RESTORED");
        statusList.add(DELETED);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)CONSOLIDATED_IMAGE_ID, (Object)new Document("$in", consoIdList)), Filters.eq((String)STATUS, (Object)new Document("$nin", statusList))});
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS);
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)DOLLAR_CONSOLIDATED_IMAGE), (BsonField[])new BsonField[]{new BsonField(DOC_ID, (Bson)new Document(DOLLAR_LAST, (Object)"$_id")), new BsonField(LAST_MODIFIED_TIME, (Bson)new Document(DOLLAR_LAST, (Object)DOLLLAR_LAST_MODIFIED_TIME))}));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{LAST_MODIFIED_TIME})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append("_id", (Object)DOLLAR_ID).append(CONSOLIDATED_IMAGE, (Object)"$_id").append(LAST_MODIFIED_TIME, (Object)DOLLLAR_LAST_MODIFIED_TIME)));
        AggregateIterable documents = collection.aggregate(pipeline);
        ArrayList<ObjectId> listOfRevisionIds = new ArrayList<ObjectId>();
        for (Document next : documents) {
            Object revisionId = next.get((Object)"_id");
            listOfRevisionIds.add(new ObjectId(revisionId.toString()));
        }
        List<FileRevision> revisionList = this.getAllLatestRevision((MongoOperations)mongoTemplate, listOfRevisionIds);
        this.logger.debug(" SIZE OF NEW LIST " + revisionList.size());
        return revisionList;
    }

    private List<FileRevision> getAllLatestRevision(MongoOperations mongoTemplate, List<ObjectId> revisionIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(revisionIds)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public List<FileRevision> getAllRevisionsImagesByPathAndStatus(int cloudId, String cloudName, String path, long timestamp, String status) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(path);
        criteria.andOperator(new Criteria[]{pathLikeCriteria, Criteria.where((String)STATUS).is((Object)status), Criteria.where((String)LAST_MODIFIED_TIME).gt((Object)timestamp)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public List<FileRevision> getAllRevisionsImagesByPathAndStatusForMC(int cloudId, String cloudName, String path, long timestamp, String status) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(path);
        criteria.andOperator(new Criteria[]{pathLikeCriteria, Criteria.where((String)STATUS).is((Object)status), Criteria.where((String)LAST_MODIFIED_TIME).gt((Object)timestamp)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, FileRevision.class);
        ArrayList<FileRevision> minicloudList = new ArrayList<FileRevision>();
        for (FileRevision revision : list) {
            if (!revision.getConsolidatedImage().isMiniCloud()) continue;
            minicloudList.add(revision);
        }
        return minicloudList;
    }

    @Override
    public List<FileRevision> getAllRevisionsImagesByPath(int cloudId, String cloudName, String path, long timestamp) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(path);
        criteria.andOperator(new Criteria[]{pathLikeCriteria, Criteria.where((String)LAST_MODIFIED_TIME).gt((Object)timestamp)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public Long getCountOfAllFileRevisionsHavingStatus(int cloudId, String cloudName, String status) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)STATUS, (Object)status)});
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS);
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)DOLLAR_CONSOLIDATED_IMAGE), (BsonField[])new BsonField[]{new BsonField(DOC_ID, (Bson)new Document(DOLLAR_LAST, (Object)"$_id")), new BsonField(LAST_MODIFIED_TIME, (Bson)new Document(DOLLAR_LAST, (Object)DOLLLAR_LAST_MODIFIED_TIME))}));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{LAST_MODIFIED_TIME})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append("_id", (Object)DOLLAR_ID).append(CONSOLIDATED_IMAGE, (Object)"$_id").append(LAST_MODIFIED_TIME, (Object)DOLLLAR_LAST_MODIFIED_TIME)));
        AggregateIterable documents = collection.aggregate(pipeline);
        ArrayList<ObjectId> listOfRevisionIds = new ArrayList<ObjectId>();
        for (Document next : documents) {
            Object revisionId = next.get((Object)"_id");
            listOfRevisionIds.add(new ObjectId(revisionId.toString()));
        }
        List<FileRevision> revisionList = this.getAllLatestRevision((MongoOperations)mongoTemplate, listOfRevisionIds);
        if (revisionList != null) {
            int size = revisionList.size();
            return size;
        }
        return 0L;
    }

    @Override
    public List<ObjectId> getLatestFileRevisionConsolidatedIds(int cloudId, String cloudName, String status, int offset, int rows) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)STATUS, (Object)status)});
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS);
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)DOLLAR_CONSOLIDATED_IMAGE), (BsonField[])new BsonField[]{new BsonField(DOC_ID, (Bson)new Document(DOLLAR_LAST, (Object)"$_id")), new BsonField(LAST_MODIFIED_TIME, (Bson)new Document(DOLLAR_LAST, (Object)DOLLLAR_LAST_MODIFIED_TIME))}));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{LAST_MODIFIED_TIME})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append("_id", (Object)DOLLAR_ID).append(CONSOLIDATED_IMAGE, (Object)"$_id").append(LAST_MODIFIED_TIME, (Object)DOLLLAR_LAST_MODIFIED_TIME)));
        AggregateIterable documents = collection.aggregate(pipeline);
        ArrayList<ObjectId> listOfConsIds = new ArrayList<ObjectId>();
        for (Document next : documents) {
            DBRef dbRef = (DBRef)next.get((Object)CONSOLIDATED_IMAGE);
            listOfConsIds.add(new ObjectId(dbRef.getId().toString()));
        }
        return listOfConsIds;
    }

    @Override
    public List<FileRevision> getAllFileRevisionsForIds(int cloudId, String cloudName, List<ObjectId> consoIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).in(consoIds)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public FileRevision getAllFileRevisionsForConsoId(int cloudId, String cloudName, ObjectId consoId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consoId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public List<FileRevision> getAllLatestFileRevisionsImagesByIndexes(int cloudId, String cloudName, String status, long timestamp, int offset, int rows) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)STATUS, (Object)status), Filters.eq((String)LAST_MODIFIED_TIME, (Object)new Document("$gt", (Object)timestamp))});
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS);
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)DOLLAR_CONSOLIDATED_IMAGE), (BsonField[])new BsonField[]{new BsonField(DOC_ID, (Bson)new Document(DOLLAR_LAST, (Object)"$_id")), new BsonField(LAST_MODIFIED_TIME, (Bson)new Document(DOLLAR_LAST, (Object)DOLLLAR_LAST_MODIFIED_TIME))}));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{LAST_MODIFIED_TIME})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append("_id", (Object)DOLLAR_ID).append(CONSOLIDATED_IMAGE, (Object)"$_id").append(LAST_MODIFIED_TIME, (Object)DOLLLAR_LAST_MODIFIED_TIME)));
        AggregateIterable documents = collection.aggregate(pipeline);
        ArrayList<ObjectId> listOfRevisionIds = new ArrayList<ObjectId>();
        for (Document next : documents) {
            Object revisionId = next.get((Object)"_id");
            listOfRevisionIds.add(new ObjectId(revisionId.toString()));
        }
        return this.getAllLatestRevision((MongoOperations)mongoTemplate, listOfRevisionIds);
    }

    @Override
    public List<FileRevision> getAllLatestFileRevisionsImagesByIndexesForUser(int cloudId, String cloudName, String status, long timestamp, int offset, int rows, String userName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)STATUS, (Object)status), Filters.eq((String)USER_NAME, (Object)userName), Filters.eq((String)LAST_MODIFIED_TIME, (Object)new Document("$gt", (Object)timestamp))});
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS);
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)DOLLAR_CONSOLIDATED_IMAGE), (BsonField[])new BsonField[]{new BsonField(DOC_ID, (Bson)new Document(DOLLAR_LAST, (Object)"$_id")), new BsonField(LAST_MODIFIED_TIME, (Bson)new Document(DOLLAR_LAST, (Object)DOLLLAR_LAST_MODIFIED_TIME))}));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{LAST_MODIFIED_TIME})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append("_id", (Object)DOLLAR_ID).append(CONSOLIDATED_IMAGE, (Object)"$_id").append(LAST_MODIFIED_TIME, (Object)DOLLLAR_LAST_MODIFIED_TIME)));
        AggregateIterable documents = collection.aggregate(pipeline);
        ArrayList<ObjectId> listOfRevisionIds = new ArrayList<ObjectId>();
        for (Document next : documents) {
            Object revisionId = next.get((Object)"_id");
            listOfRevisionIds.add(new ObjectId(revisionId.toString()));
        }
        return this.getAllLatestRevision((MongoOperations)mongoTemplate, listOfRevisionIds);
    }

    @Override
    public Double getTotalSumOfFileSize(int cloudId, String cloudName) {
        Criteria criteria = Criteria.where((String)STATUS).ne((Object)DELETED);
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long count = mongoTemplate.count(query, FileRevision.class);
        return new Double(count);
    }

    @Override
    public List<FileRevision> getAllOlderRevisionsExcludingCurrentRevision(int cloudId, String cloudName, String deletedStatus, long timestamp) {
        String sql = "select r.REVISION_ID from REVISIONS r INNER JOIN (select CONSOLIDATED_IMAGE_FK,STATUS,max(LAST_MODIFIED_TIMESTAMP) as MAX_SERVER_TIMESTAMP from REVISIONS group by CONSOLIDATED_IMAGE_FK) rmax on r.CONSOLIDATED_IMAGE_FK=rmax.CONSOLIDATED_IMAGE_FK  and r.LAST_MODIFIED_TIMESTAMP != rmax.MAX_SERVER_TIMESTAMP   and r.LAST_MODIFIED_TIMESTAMP <:timestamp ;";
        SQLQuery query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createSQLQuery(sql).addEntity(FileRevision.class);
        query.setParameter("timestamp", (Object)timestamp);
        return query.list();
    }

    @Override
    public List<String> getRevisionsAccordingToFilePath(int cloudId, String cloudName, List<String> fsPaths, long timestamp) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)F_SPATH, (Object)new Document("$in", fsPaths)), Filters.eq((String)LAST_MODIFIED_TIME, (Object)new Document("$gt", (Object)timestamp))});
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)"$fSPath"), (BsonField[])new BsonField[0]));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{"lastServerModifiedTime"})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append(F_SPATH, (Object)"$fSPath")));
        return this.getFSPAths((MongoOperations)mongoTemplate, pipeline);
    }

    private List<String> getFSPAths(MongoOperations mongoTemplate, List<Bson> pipeline) {
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS);
        ArrayList<String> listOfBackupIds = new ArrayList<String>();
        try {
            AggregateIterable aggregate = collection.aggregate(pipeline);
            for (Document obj : aggregate) {
                this.logger.debug(obj.get((Object)F_SPATH) + " ##### " + obj);
                Object object = obj.get((Object)F_SPATH);
                if (object == null) continue;
                listOfBackupIds.add(object.toString());
            }
        }
        catch (Exception e) {
            this.logger.trace(" Exception  :" + e);
            this.logger.error(" Exception  :" + e.getMessage());
        }
        return listOfBackupIds;
    }

    @Override
    public List<String> getRevisionsAccordingToFilePath(int cloudId, String cloudName, List<String> fsPaths, List<ObjectId> revisionIds) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)F_SPATH, (Object)new Document("$in", fsPaths)), Filters.eq((String)"id", (Object)new Document("$nin", revisionIds))});
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{LAST_MODIFIED_TIME})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append(F_SPATH, (Object)"$fSPath")));
        return this.getFSPAths((MongoOperations)mongoTemplate, pipeline);
    }

    @Override
    public List<String> getRevisionAccordingToFilePathExcludingCurrentRevision(int cloudId, String cloudName, String fsPath, long timestamp, long revisionId) {
        Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery("select fr.fSPath from FileRevision fr where fr.fSPath Like :fSPath and fr.lastModifiedTime > :lastModifiedTime and fr.id!=:id");
        query.setParameter(F_SPATH, (Object)fsPath);
        query.setParameter(LAST_MODIFIED_TIME, (Object)timestamp);
        query.setParameter("id", (Object)revisionId);
        return query.list();
    }

    @Override
    public List<String> getRevisionsAccordingToFilePathExcludingMiniCloud(int cloudId, String cloudName, List<String> fsPaths, long timestamp, String miniCloudPath) {
        Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery("select fr.fSPath from FileRevision fr where (fr.consolidatedImage.consolidatedImageUQ.devicePath NOT like :path AND fr.consolidatedImage.consolidatedImageUQ.devicePath !=:exactPath) and fr.fSPath in (:fSPath) and fr.lastModifiedTime >:lastModifiedTime");
        query.setParameter("path", (Object)(miniCloudPath + "/%"));
        query.setParameter("exactPath", (Object)miniCloudPath);
        query.setParameterList(F_SPATH, fsPaths);
        query.setParameter(LAST_MODIFIED_TIME, (Object)timestamp);
        return query.list();
    }

    @Override
    public List<FileRevision> getAllRevisionsAccordingToFilePath(int cloudId, String cloudName, String path) {
        List<FileRevision> revisionList = new ArrayList<FileRevision>();
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).regex("^" + path + "/", "i"), Criteria.where((String)DEVICE_PATH).is((Object)path)});
        this.logger.debug(" OR  CRITERIA****************** ");
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, ConsolidatedImage.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<ObjectId> consIds = new ArrayList<ObjectId>();
            for (ConsolidatedImage image : list) {
                consIds.add(image.getId());
            }
            if (!CollectionUtils.isEmpty(consIds)) {
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).in(consIds)});
                query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
                revisionList = mongoTemplate.find(query, FileRevision.class);
            }
        }
        return revisionList;
    }

    @Override
    public void deleteRevision(int cloudId, String cloudName, FileRevision fileRevision) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove((Object)fileRevision);
    }

    @Override
    public long getRevisionCountOfFilePathExcludingCurrentRevision(int cloudId, String cloudName, String fsPath, long timestamp, ObjectId revisionId) {
        Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery("select fr.fSPath from FileRevision fr where fr.fSPath Like :fSPath and fr.lastModifiedTime > :lastModifiedTime and fr.id!=:id");
        query.setParameter(F_SPATH, (Object)fsPath);
        query.setParameter(LAST_MODIFIED_TIME, (Object)timestamp);
        query.setParameter("id", (Object)revisionId);
        return (Long)query.uniqueResult();
    }

    @Override
    public FileRevision getPresentRevisionByRevisionNumber(int cloudId, String cloudName, ObjectId consolidateImageId, int revisionNumber) {
        String status = PCHelperConstant.REVISION_STATUS.DELETED.toString();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId), Criteria.where((String)STATUS).ne((Object)status)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public FileRevision getFirstOldRevisionByRevisionNumber(int cloudId, ObjectId consolidateImageId, int revisionNumber) {
        String status = PCHelperConstant.REVISION_STATUS.DELETED.toString();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId), Criteria.where((String)STATUS).ne((Object)status)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.ASC, new String[]{LAST_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public Long getCountOfAllLatestFileRevisions(int cloudId, String cloudName, String status, long revisionCount) {
        String sql = "select count(*) from REVISIONS r INNER JOIN (select REVISION_ID,CONSOLIDATED_IMAGE_FK,max(LAST_MODIFIED_TIMESTAMP) as MAX_SERVER_TIMESTAMP,count(REVISION_ID) as REVISION_COUNT from REVISIONS where STATUS!=:status group by CONSOLIDATED_IMAGE_FK) rmax on r.CONSOLIDATED_IMAGE_FK=rmax.CONSOLIDATED_IMAGE_FK  and r.LAST_MODIFIED_TIMESTAMP = rmax.MAX_SERVER_TIMESTAMP and rmax.REVISION_COUNT>:revisionCount";
        SQLQuery query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createSQLQuery(sql);
        query.setParameter(STATUS, (Object)status);
        query.setParameter("revisionCount", (Object)revisionCount);
        return ((BigInteger)query.uniqueResult()).longValue();
    }

    @Override
    public List<FileRevision> getAllLatestFileRevisions(int cloudId, String cloudName) {
        String sql = "select r.* from REVISIONS r INNER JOIN (select CONSOLIDATED_IMAGE_FK,max(LAST_MODIFIED_TIMESTAMP) as MAX_SERVER_TIMESTAMP from REVISIONS group by CONSOLIDATED_IMAGE_FK) rmax on r.CONSOLIDATED_IMAGE_FK=rmax.CONSOLIDATED_IMAGE_FK  and r.LAST_MODIFIED_TIMESTAMP = rmax.MAX_SERVER_TIMESTAMP  ;";
        SQLQuery query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createSQLQuery(sql).addEntity(FileRevision.class);
        return query.list();
    }

    @Override
    public List<FileRevision> getAllLatestFileRevisions(int cloudId, String cloudName, String status, long revisionCount, int offset, int limit) {
        String sql = "select r.* from REVISIONS r INNER JOIN (select REVISION_ID,CONSOLIDATED_IMAGE_FK,max(LAST_MODIFIED_TIMESTAMP) as MAX_SERVER_TIMESTAMP,count(REVISION_ID) as REVISION_COUNT from REVISIONS where STATUS!=:status group by CONSOLIDATED_IMAGE_FK) rmax on r.CONSOLIDATED_IMAGE_FK=rmax.CONSOLIDATED_IMAGE_FK  and r.LAST_MODIFIED_TIMESTAMP = rmax.MAX_SERVER_TIMESTAMP and rmax.REVISION_COUNT>:revisionCount";
        SQLQuery query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createSQLQuery(sql).addEntity(FileRevision.class);
        query.setParameter(STATUS, (Object)status);
        query.setParameter("revisionCount", (Object)revisionCount);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.list();
    }

    @Override
    public List<Object[]> getAllRevisionsExcludingStatusStartingFrom(int cloudId, String cloudName, List<ObjectId> consolidateImageIds, String status, int offset) {
        String sql = "select b.REVISION_ID, (CASE b.CONSOLIDATED_IMAGE_FK when @consoId THEN @curRev|=@curRev + 1 ELSE @curRev |= 1 AND @consoId |=b.CONSOLIDATED_IMAGE_FK END ) AS RANK from REVISIONS b,(SELECT @curRev |= 0) a  where b.CONSOLIDATED_IMAGE_FK in (:consoIdList) and b.STATUS!=:status order by b.CONSOLIDATED_IMAGE_FK,b.REVISION_ID desc";
        SQLQuery query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createSQLQuery(sql);
        query.setParameterList("consoIdList", consolidateImageIds);
        query.setParameter(STATUS, (Object)status);
        return query.list();
    }

    @Override
    public List<Object[]> getAllRevisionsWithStatusStartingFrom(int cloudId, String cloudName, List<ObjectId> consolidateImageIds, String status, int offset) {
        String sql = "select REVISION_ID, (CASE CONSOLIDATED_IMAGE_FK when @consoId THEN @curRev|=@curRev + 1 ELSE @curRev |= 1 AND @consoId |=CONSOLIDATED_IMAGE_FK END ) AS RANK from REVISIONS b,(SELECT @curRev |= 0) a where CONSOLIDATED_IMAGE_FK in (:consoIdList) and STATUS=:status order by CONSOLIDATED_IMAGE_FK,REVISION_ID desc ";
        SQLQuery query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createSQLQuery(sql);
        query.setParameterList("consoIdList", consolidateImageIds);
        query.setParameter(STATUS, (Object)status);
        return query.list();
    }

    @Override
    public List<FileRevision> getAllRevisions(int cloudId, String cloudName, List<Long> revisionIds) {
        Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery("from FileRevision fr where fr.id in (:revisionIds)");
        query.setParameterList("revisionIds", revisionIds);
        return query.list();
    }

    @Override
    public List<FileRevision> getAllRevisions(int cloudId, String cloudName, ObjectId consolidateImageId, int noOfRevisions) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_MODIFIED_TIME}));
        if (noOfRevisions != -1) {
            query.limit(noOfRevisions);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public FileRevision getRevision(int cloudId, String cloudName, String revisionId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)revisionId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public void updateExternalStorageStatusOfFile(int cloudId, String cloudName, ObjectId syncRevisionId, String storagePlace) {
        org.springframework.data.mongodb.core.query.Query query;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        FileRevision fileRevision = (FileRevision)mongoTemplate.findOne(query = this.criteriaForRevision(syncRevisionId), FileRevision.class);
        if (fileRevision != null && fileRevision.getConsolidatedImage() != null) {
            ConsolidatedImage consolidatedImage = fileRevision.getConsolidatedImage();
            this.updateRevision(storagePlace, mongoTemplate, query);
            query = this.criteriaForRevision(consolidatedImage.getId());
            this.updateConsolidatedImage(storagePlace, mongoTemplate, query);
        }
    }

    private void updateRevision(String storagePlace, MongoTemplate mongoTemplate, org.springframework.data.mongodb.core.query.Query query) {
        Update update = new Update();
        update.set("storagePlace", (Object)storagePlace);
        mongoTemplate.updateFirst(query, update, FileRevision.class);
    }

    private void updateConsolidatedImage(String storagePlace, MongoTemplate mongoTemplate, org.springframework.data.mongodb.core.query.Query query) {
        Update update = new Update();
        update.set("crawlStartTimestamp", (Object)System.currentTimeMillis());
        update.set(MODIFIED_TIME, (Object)Long.toString(System.currentTimeMillis()));
        mongoTemplate.updateFirst(query, update, ConsolidatedImage.class);
    }

    private org.springframework.data.mongodb.core.query.Query criteriaForRevision(ObjectId syncRevisionId) {
        Criteria criteria = Criteria.where((String)"id").is((Object)syncRevisionId);
        return new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
    }

    @Override
    public FileRevision getLatestRevisionForDownload(int cloudId, String cloudName, ObjectId consolidateImageId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public List<FileRevision> getLatestMCByRevisionsByConsoIds(int cloudId, String cloudName, List<ObjectId> consoIdList, String userName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Bson matchQuery = Filters.and((Bson[])new Bson[]{Filters.eq((String)CONSOLIDATED_IMAGE_ID, (Object)new Document("$in", consoIdList)), Filters.eq((String)USER_NAME, (Object)new Document("$ne", (Object)userName))});
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS);
        ArrayList<Bson> pipeline = new ArrayList<Bson>(4);
        pipeline.add(Aggregates.match((Bson)matchQuery));
        pipeline.add(Aggregates.group((Object)new Document().append("_id", (Object)DOLLAR_CONSOLIDATED_IMAGE), (BsonField[])new BsonField[]{new BsonField(DOC_ID, (Bson)new Document(DOLLAR_LAST, (Object)"$_id")), new BsonField(LAST_MODIFIED_TIME, (Bson)new Document(DOLLAR_LAST, (Object)DOLLLAR_LAST_MODIFIED_TIME))}));
        pipeline.add(Aggregates.sort((Bson)Sorts.descending((String[])new String[]{LAST_MODIFIED_TIME})));
        pipeline.add(Aggregates.project((Bson)new Document().append("_id", (Object)0).append("_id", (Object)DOLLAR_ID).append(CONSOLIDATED_IMAGE, (Object)"$_id").append(LAST_MODIFIED_TIME, (Object)DOLLLAR_LAST_MODIFIED_TIME)));
        AggregateIterable documents = collection.aggregate(pipeline);
        ArrayList<ObjectId> listOfRevisionIds = new ArrayList<ObjectId>();
        for (Document next : documents) {
            Object revisionId = next.get((Object)"_id");
            listOfRevisionIds.add(new ObjectId(revisionId.toString()));
        }
        List<FileRevision> revisionList = this.getAllLatestRevision((MongoOperations)mongoTemplate, listOfRevisionIds);
        this.logger.debug(" SIZE OF NEW LIST " + revisionList.size());
        return revisionList;
    }

    @Override
    public void deleteAllRevisionsAccordingToFilePath(int cloudId, String path) {
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).regex("^" + path + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)path)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, ConsolidatedImage.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<ObjectId> consIds = new ArrayList<ObjectId>();
            for (ConsolidatedImage image : list) {
                consIds.add(image.getId());
            }
            if (!CollectionUtils.isEmpty(consIds)) {
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).in(consIds)});
                query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
                mongoTemplate.findAndRemove(query, FileRevision.class);
            }
        }
        for (ConsolidatedImage consolidatedImage : list) {
            mongoTemplate.remove((Object)consolidatedImage);
        }
    }

    @Override
    public boolean isFilesInBlukrypt(int cloudId, String userName, String path, String fileName) {
        Criteria criteria = new Criteria();
        Criteria andCriteria = new Criteria();
        Criteria folderFalseCriteria = Criteria.where((String)FOLDER).is((Object)false);
        if (!StringUtils.isEmpty((String)fileName)) {
            this.logger.debug("File name>>>>>>>>>>>" + fileName + "File Path>>>>>>" + path);
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)path), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            this.logger.debug(" NO Filename ........... ");
            criteria.orOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).regex("^" + path + "/", "i"), Criteria.where((String)DEVICE_PATH).is((Object)path)});
        }
        if (!StringUtils.isEmpty((String)userName)) {
            andCriteria.andOperator(new Criteria[]{folderFalseCriteria, criteria, Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i")});
        } else {
            andCriteria.andOperator(new Criteria[]{folderFalseCriteria, criteria});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)andCriteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, ConsolidatedImage.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            ArrayList<ObjectId> consIds = new ArrayList<ObjectId>();
            for (ConsolidatedImage image : list) {
                consIds.add(image.getId());
            }
            if (!CollectionUtils.isEmpty(consIds)) {
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).in(consIds), Criteria.where((String)"storagePlace").exists(false), folderFalseCriteria, Criteria.where((String)STATUS).ne((Object)DELETED)});
                query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
                long count = mongoTemplate.count(query, FileRevision.class);
                if (count > 0L) {
                    this.logger.debug(" Files in Blukrypt........." + count);
                    this.logger.debug(path + " Files in Blukrypt........." + userName);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public long getCountOfVersionsForFile(int cloudId, ObjectId consId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consId), Criteria.where((String)STATUS).ne((Object)DELETED)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return mongoTemplate.count(query, FileRevision.class);
    }

    @Override
    public List<FileRevision> getAllFilesTobeDeleted(int cloudId, long filesExpiredDate) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)LAST_MODIFIED_TIME).lt((Object)filesExpiredDate)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, FileRevision.class);
    }

    @Override
    public void saveSyncOverview(int cloudId, SyncOverView syncOverview) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)syncOverview);
    }

    @Override
    public SyncOverView getSyncOverview(int cloudId) {
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (SyncOverView)mongoTemplate.findOne(query, SyncOverView.class);
    }

    @Override
    public void saveDailySyncOverview(int cloudId, DailySyncOverView dailySyncOverView) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)dailySyncOverView);
    }

    @Override
    public DailySyncOverView getDailySyncOverview(int cloudId, long currentMillisSeconds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"overViewDate").is((Object)currentMillisSeconds)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (DailySyncOverView)mongoTemplate.findOne(query, DailySyncOverView.class);
    }

    @Override
    public void deleteOldSyncOverView(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug(" no of months old record to delete ......... " + PCHelperConstant.getNoOfMonthsOldRecordToDelete());
        long fromDayToDelete = FileRevisionDaoImpl.getDayToDelete(PCHelperConstant.getNoOfMonthsOldRecordToDelete());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"overViewDate").lte((Object)fromDayToDelete)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        mongoTemplate.findAndRemove(query, DailySyncOverView.class);
    }

    private static long getDayToDelete(int noOfMonths) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(11, 0);
        calendar.set(2, calendar.get(2) - noOfMonths);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    @Override
    public List<ObjectId> getLatestFileRevisionConsolidatedIds(int cloudId, String cloudName, String status, String userName, int offset, int rows) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug("...vlue..getLatestFileRevisionConsolidatedIds new.. ");
        MongoCollection collection = mongoTemplate.getCollection(REVISIONS);
        Document matchquery = new Document(DOLLAR_MATCH, (Object)new Document(STATUS, (Object)status));
        if (!StringUtils.isEmpty((String)userName)) {
            matchquery = new Document(DOLLAR_MATCH, (Object)new Document(STATUS, (Object)status).append(USER_NAME, (Object)userName));
        }
        AggregateIterable output = collection.aggregate(Arrays.asList(matchquery, new Document(DOLLAR_GROUP, (Object)new Document("_id", (Object)DOLLAR_CONSOLIDATED_IMAGE).append(DOC_ID, (Object)new Document(DOLLAR_LAST, (Object)"$_id")).append(LAST_MODIFIED_TIME, (Object)new Document(DOLLAR_LAST, (Object)DOLLLAR_LAST_MODIFIED_TIME))), new Document(DOLAR_SORT, (Object)new Document(LAST_MODIFIED_TIME, (Object)-1)), new Document("$limit", (Object)200), new Document(DOLLAR_PROJECT, (Object)new Document("_id", (Object)0).append("_id", (Object)DOLLAR_ID).append(CONSOLIDATED_IMAGE, (Object)"$_id").append(LAST_MODIFIED_TIME, (Object)DOLLLAR_LAST_MODIFIED_TIME))));
        ArrayList listOfRevisionIds = new ArrayList();
        MongoCursor iterator = output.iterator();
        ArrayList<ObjectId> listOfConsIds = new ArrayList<ObjectId>();
        while (iterator.hasNext()) {
            Document next = (Document)iterator.next();
            DBRef dbRef = (DBRef)next.get((Object)CONSOLIDATED_IMAGE);
            listOfConsIds.add(new ObjectId(dbRef.getId().toString()));
        }
        this.logger.debug("...consoid... " + listOfConsIds.size());
        return listOfConsIds;
    }

    @Override
    public BackupFile getSyncFile(int cloudId, String cloudName, String id) {
        BackupFile backupFile = null;
        try {
            String tableName = PRIVACY_GATEWAY_SYNC + cloudName;
            tableName = tableName.toUpperCase();
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
            mongoTemplate.setReadPreference(ReadPreference.secondary());
            backupFile = (BackupFile)mongoTemplate.findOne(query, BackupFile.class, tableName);
        }
        catch (Exception e) {
            this.logger.error("get sync file:" + e);
        }
        return backupFile;
    }

    @Override
    public ChunkDetail getChunkDetailForSyncFiles(int cloudId, String md5, String dedupType, String userName) {
        String dest;
        if (!StringUtils.isEmpty((String)dedupType) && dedupType.equalsIgnoreCase(DEDUP.DISABLED.toString())) {
            return null;
        }
        String dedupTypeVal = StringUtils.isEmpty((String)dedupType) ? DEDUP.GLOBAL.toString() : dedupType;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        if (DEDUP.USER.toString().equalsIgnoreCase(dedupTypeVal)) {
            this.logger.debug(".................Inside new chunk query with userName case insensitive..........");
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        }
        if (DEDUP.GLOBAL.toString().equalsIgnoreCase(dedupTypeVal)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)md5)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        List<String> queryTablesList = this.getChunkDetailCollections(md5);
        ChunkDetail chunkDetail = null;
        Iterator<String> iterator = queryTablesList.iterator();
        while (iterator.hasNext() && (chunkDetail = (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, dest = iterator.next())) == null) {
        }
        return chunkDetail;
    }

    private List<String> getChunkDetailCollections(String md5) {
        ArrayList<String> queryTablesList = new ArrayList<String>();
        int hashCode = Arrays.hashCode(md5.getBytes());
        int chunkDetailDest = Math.abs(hashCode % CHUNK_TOTAL_DB_COUNT);
        queryTablesList.add("CHUNK_DETAIL_" + chunkDetailDest);
        if (PCHelperConstant.isChunkCollectionQueryRequired()) {
            queryTablesList.add(CHUNK_DETAIL);
        }
        return queryTablesList;
    }

    @Override
    public void saveChunkDetail(int cloudId, ChunkDetail chunkDetail) {
        this.logger.debug("@@@@@Before saving chunk details@@@");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        String collectionName = "";
        if (chunkDetail.getId() != null) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"md5").is((Object)chunkDetail.getMd5())});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            ChunkDetail chunkDetailObj = (ChunkDetail)mongoTemplate.findOne(query, ChunkDetail.class, CHUNK_DETAIL);
            if (chunkDetailObj != null) {
                collectionName = CHUNK_DETAIL;
            }
        }
        if (StringUtils.isEmpty((String)collectionName)) {
            collectionName = this.getChunkNewCollectionName(chunkDetail.getMd5());
            this.createChunkIndex(mongoTemplate, collectionName);
        }
        mongoTemplate.save((Object)chunkDetail, collectionName);
        this.logger.debug("@@@@@After saving chunk details@@@");
    }

    private void createChunkIndex(MongoTemplate mongoTemplate, String collectionName) {
        MongoCollection chunkCollection = mongoTemplate.getCollection(collectionName);
        chunkCollection.createIndex(Indexes.ascending((String[])new String[]{"md5"}));
    }

    private String getChunkNewCollectionName(String md5) {
        int hashCode = Arrays.hashCode(md5.getBytes());
        int chunkDetailDest = Math.abs(hashCode % CHUNK_TOTAL_DB_COUNT);
        return "CHUNK_DETAIL_" + chunkDetailDest;
    }

    private String getDedupValue(int cloudId, String userName) {
        String dedupVal = null;
        User user = this.getUser(cloudId, userName);
        if (user != null) {
            SyncPolicy syncPolicy = this.getSyncPolicy(cloudId, user.getSyncPolicyName());
            dedupVal = syncPolicy.getDedup();
        }
        return dedupVal;
    }

    public SyncPolicy getSyncPolicy(int cloudId, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (SyncPolicy)mongoTemplate.findOne(new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria), SyncPolicy.class);
    }

    private User getUser(int cloudId, String userName) {
        Criteria criteria = Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i");
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return (User)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    @Override
    public void derefrenaceChunks(String cloudName, Cloud cloud, FileRevision fileRevision) {
        this.logger.debug("....inside file derefrenaceChunks for revision delete......");
        BackupFile backupFile = this.getSyncFile(cloud.getCloudId(), cloudName, fileRevision.getId().toString());
        if (backupFile != null && !CollectionUtils.isEmpty(backupFile.getChunkFiles())) {
            List<ChunkFile> chunkFiles = backupFile.getChunkFiles();
            block4: for (ChunkFile chunkFile : chunkFiles) {
                String dedupVal = this.getDedupValue(cloud.getCloudId(), fileRevision.getUserName());
                ChunkDetail chunkDetail = this.getChunkDetailForSyncFiles(1, chunkFile.getMd5(), dedupVal, fileRevision.getUserName());
                if (chunkDetail == null) continue;
                try {
                    chunkDetail.setRefCount(chunkDetail.getRefCount() - 1);
                    this.saveChunkDetail(1, chunkDetail);
                    this.logger.debug(" Chunk updated succcessfully ..........");
                }
                catch (OptimisticLockingFailureException e) {
                    this.logger.trace("" + (Object)((Object)e));
                    this.logger.error("Exception while handling versioning :" + (Object)((Object)e));
                    int count = 0;
                    int maxTries = PCHelperConstant.getMaxRetryForChunkUpdate();
                    while (true) {
                        try {
                            this.logger.debug(" retry chunk update ..............." + chunkFile.getMd5());
                            ChunkDetail chunkDetailObj = this.getChunkDetailForSyncFiles(1, chunkFile.getMd5(), dedupVal, fileRevision.getUserName());
                            chunkDetailObj.setRefCount(chunkDetailObj.getRefCount() - 1);
                            this.logger.debug(chunkFile.getMd5() + " @@@@@@ ................ retry count " + count);
                            this.saveChunkDetail(1, chunkDetailObj);
                            continue block4;
                        }
                        catch (Exception ex) {
                            this.logger.trace("" + ex);
                            this.logger.error(" ex ..." + ex.getMessage());
                            if (++count != maxTries) continue;
                        }
                        break;
                    }
                }
            }
        }
    }

    @Override
    public FileRevision getLatestAddedStateRevision(int cloudId, String cloudName, ObjectId consolidateImageId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consolidateImageId), Criteria.where((String)STATUS).is((Object)"ADDED")});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{LAST_MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (FileRevision)mongoTemplate.findOne(query, FileRevision.class);
    }

    @Override
    public void removeRevisionsByConsId(int cloudId, String consId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).is((Object)consId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, FileRevision.class);
    }

    @Override
    public void removeRevisionsByUserName(int cloudId, String userName, List<ObjectId> sharedIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"id").nin(sharedIds)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, FileRevision.class);
    }

    @Override
    public void removeConsolidatedImagebyId(int cloudId, String consId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)consId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndRemove(query, ConsolidatedImage.class);
    }

    @Override
    public void removeConsolidatedImagebyUserName(int cloudId, String userName, List<ObjectId> sharedIds) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"id").nin(sharedIds)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllMySharedFiles(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"sharedBy").exists(true), Criteria.where((String)"sharedBy").is((Object)userName), Criteria.where((String)PRESENT).is((Object)true)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getConsolidatedImageForMC(int cloudId, String miniCloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)"ParaBlu"), Criteria.where((String)FILE_NAME).is((Object)miniCloudName), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    public ConsolidatedImage getMiniCloudRecordIfExistsWithoutRegex(int cloudId, String fileName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)"ParaBlu"), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllChildFilesOfFolder(int cloudId, String userName, String filePath, boolean isFolder) {
        List<ConsolidatedImage> consolidatedImages = new ArrayList<ConsolidatedImage>();
        try {
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            if (StringUtils.isEmpty((String)userName)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)filePath), Criteria.where((String)FOLDER).is((Object)isFolder), Criteria.where((String)PRESENT).is((Object)true)});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)filePath), Criteria.where((String)FOLDER).is((Object)isFolder), Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)PRESENT).is((Object)true)});
            }
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            mongoTemplate.setReadPreference(ReadPreference.secondary());
            consolidatedImages = mongoTemplate.find(query, ConsolidatedImage.class);
        }
        catch (Exception e) {
            this.logger.error("get All sync folder:" + e);
        }
        return consolidatedImages;
    }

    @Override
    public List<ConsolidatedImage> getAllChildFilesOfFolderMC(int cloudId, String userName, String filePath, boolean isFolder) {
        List<ConsolidatedImage> consolidatedImages = new ArrayList<ConsolidatedImage>();
        try {
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            if (StringUtils.isEmpty((String)userName)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)filePath), Criteria.where((String)FOLDER).is((Object)isFolder), Criteria.where((String)PRESENT).is((Object)true)});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)filePath), Criteria.where((String)FOLDER).is((Object)isFolder), Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)PRESENT).is((Object)true)});
            }
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            mongoTemplate.setReadPreference(ReadPreference.secondary());
            consolidatedImages = mongoTemplate.find(query, ConsolidatedImage.class);
        }
        catch (Exception e) {
            this.logger.error("get All sync folder:" + e);
        }
        return consolidatedImages;
    }

    static enum DEDUP {
        DISABLED,
        USER,
        GLOBAL;

    }
}

