/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.pcbd.dao.ExcludedFoldersDao;
import com.parablu.pcbd.domain.ExceptionsToExclusionsFolders;
import com.parablu.pcbd.domain.ExcludedFolders;
import com.parablu.pcbd.domain.GlobalExcludedFolders;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class ExcludedFoldersDaoImpl
implements ExcludedFoldersDao {
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveExcludedFolders(int cloudId, ExcludedFolders userExcludedFolders) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)userExcludedFolders);
    }

    @Override
    public void saveExceptionsToExclusionsFolders(int cloudId, ExceptionsToExclusionsFolders exceptionsToExclusion) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)exceptionsToExclusion);
    }

    @Override
    public List<ExcludedFolders> getAllExcludedFolders(int cloudId) {
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findAll(ExcludedFolders.class);
    }

    @Override
    public ExcludedFolders getExcludedFoldersByPath(int cloudId, String path) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"folderPath").is((Object)path));
        return (ExcludedFolders)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, ExcludedFolders.class);
    }

    @Override
    public ExceptionsToExclusionsFolders getExceptionsToExclusions(int cloudId, String path) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"folderPath").is((Object)path));
        return (ExceptionsToExclusionsFolders)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, ExceptionsToExclusionsFolders.class);
    }

    @Override
    public void deleteExcludedFolder(int cloudId, List<ObjectId> idList) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").in(idList)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(new Query((CriteriaDefinition)criteria), ExcludedFolders.class);
    }

    @Override
    public List<GlobalExcludedFolders> getAllGlobalExcludedFolders(int cloudId) {
        Query query = new Query();
        return this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, GlobalExcludedFolders.class);
    }
}

