/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import com.mongodb.ReadPreference;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Indexes;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BackupOverviewElement;
import com.parablu.pcbd.dao.DeviceDao;
import com.parablu.pcbd.domain.BackupBatch;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.LatestDeviceBackupInfo;
import com.parablu.pcbd.domain.MailBackupBatch;
import com.parablu.pcbd.domain.O365BlackListUser;
import com.parablu.pcbd.domain.OdbFolderNameTODeviceUUIDMapping;
import com.parablu.pcbd.domain.ReportQueryElement;
import com.parablu.pcbd.domain.User;
import com.parablu.pcbd.domain.UserDeviceAccessControl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.hibernate.Query;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.beans.BeanUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class DeviceDaoImpl
implements DeviceDao {
    public static final String IS_DEVICE_BOLCKED = "isDeviceBolcked";
    public static final String ID = "id";
    private static final String USER_ID = "userId";
    Logger logger = LogManager.getLogger(DeviceDaoImpl.class);
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String DEVICE_UUID = "deviceUUID";
    private static final String BLOCKED = "blocked";
    private static final String USER_NAME = "userName";
    private static final String DEVICE_NAME = "deviceName";
    private static final String COUNT = "count";
    private static final String DELETED = "deleted";
    public static final String DD_MMM_YYYY_HH_MM_SS = "dd-MMM-yyyy HH:mm:ss";

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public List<Device> getAll(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.logger.debug(" ...device getALL..... ");
        return mongoTemplate.findAll(Device.class);
    }

    @Override
    public Device register(int cloudId, String cloudName, Device device) {
        String destCollectionName;
        long devicesAllowed;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        long deviceCount = mongoTemplate.count(new org.springframework.data.mongodb.core.query.Query(), Device.class);
        long currentBkpCollection = deviceCount / (devicesAllowed = PCHelperConstant.getDevicesAllowedPerCollection());
        if (currentBkpCollection == 0L) {
            currentBkpCollection = 1L;
        }
        long destCollectionCount = currentBkpCollection;
        boolean checkCollectionForDevice = true;
        do {
            destCollectionName = "BACKUP_" + ++destCollectionCount;
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)Criteria.where((String)"destCollection").is((Object)destCollectionName));
            long verifiedDeviceCountPerCollection = mongoTemplate.count(query, Device.class);
            if (verifiedDeviceCountPerCollection > devicesAllowed) continue;
            checkCollectionForDevice = false;
        } while (checkCollectionForDevice);
        device.setDestCollection(destCollectionName);
        if (StringUtils.isEmpty((String)device.getDisplayName())) {
            device.setDisplayName(device.getDeviceName());
        }
        this.createIndexForDevice(mongoTemplate, destCollectionName);
        mongoTemplate.save((Object)device);
        return device;
    }

    private void createIndexForDevice(MongoTemplate mongoTemplate, String destCollectionName) {
        try {
            MongoCollection bkpCollection = mongoTemplate.getCollection(destCollectionName);
            BasicDBObject obj = new BasicDBObject();
            obj.put((Object)DEVICE_UUID, (Object)1);
            obj.put((Object)"devicePath", (Object)1);
            obj.put((Object)"fileName", (Object)1);
            bkpCollection.createIndex((Bson)obj);
            bkpCollection.createIndex(Indexes.ascending((String[])new String[]{"lastServerModifiedTime"}));
            bkpCollection.createIndex(Indexes.ascending((String[])new String[]{"name"}));
            bkpCollection.createIndex(Indexes.ascending((String[])new String[]{"md5Checksum"}));
            bkpCollection.createIndex(Indexes.ascending((String[])new String[]{USER_NAME}));
            bkpCollection.createIndex(Indexes.ascending((String[])new String[]{"sharedBy"}));
            bkpCollection.createIndex(Indexes.ascending((String[])new String[]{"sentDate"}));
            bkpCollection.createIndex(Indexes.ascending((String[])new String[]{"odItemId"}));
            this.logger.debug("....completed creating index for ... " + destCollectionName);
        }
        catch (Exception e) {
            this.logger.error(" Exception  :" + e);
            this.logger.debug(" Exception  :" + e.getMessage());
        }
    }

    @Override
    public Device blockUnblockDevice(int cloudId, String cloudName, Device device, boolean isBlocked) {
        device.setBlocked(isBlocked);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)device);
        this.updateDeviceStatusInOverview(cloudId, device.getDeviceUUID(), !device.isBlocked());
        return this.getDeviceFormDisplayName(device);
    }

    private Device getDeviceFormDisplayName(Device device) {
        if (device != null && StringUtils.isNotEmpty((String)device.getDisplayName())) {
            String displayName = device.getDisplayName();
            device.setDisplayName(device.getDeviceName());
            device.setDeviceName(displayName);
        }
        return device;
    }

    private List<Device> getDevicesFormDisplayName(List<Device> devices) {
        ArrayList<Device> devs = new ArrayList<Device>();
        devs.addAll(devices);
        for (Device dev : devices) {
            if (dev == null || !StringUtils.isNotEmpty((String)dev.getDisplayName())) continue;
            devs.remove(dev);
            devs.add(this.getDeviceFormDisplayName(dev));
        }
        return devs;
    }

    private DeviceBackupOverView getDeviceBkpOverviewFormDisplayName(DeviceBackupOverView devicebkp) {
        if (devicebkp != null && StringUtils.isNotEmpty((String)devicebkp.getDeviceDisplayName())) {
            devicebkp.setDeviceName(devicebkp.getDeviceDisplayName());
        }
        return devicebkp;
    }

    private List<DeviceBackupOverView> getDeviceBkpOverviewsFormDisplayName(List<DeviceBackupOverView> deviceBkpOverviews) {
        ArrayList<DeviceBackupOverView> devs = new ArrayList<DeviceBackupOverView>();
        devs.addAll(deviceBkpOverviews);
        for (DeviceBackupOverView dev : deviceBkpOverviews) {
            if (dev == null || !StringUtils.isNotEmpty((String)dev.getDeviceDisplayName())) continue;
            devs.remove(dev);
            devs.add(this.getDeviceBkpOverviewFormDisplayName(dev));
        }
        return devs;
    }

    @Override
    public Device updateDeviceInfo(int cloudId, String cloudName, Device device) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (device != null && StringUtils.isEmpty((String)device.getDisplayName())) {
            device.setDisplayName(device.getDeviceName());
        }
        mongoTemplate.save((Object)device);
        return this.getDeviceFormDisplayName(device);
    }

    @Override
    public Device saveUUID(int cloudId, String cloudName, Device device) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (device != null && StringUtils.isEmpty((String)device.getDisplayName())) {
            device.setDisplayName(device.getDeviceName());
        }
        mongoTemplate.save((Object)device);
        return device;
    }

    @Override
    public Device getDeviceInfoByUUID(int cloudId, String cloudName, String deviceUUID) {
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceFormDisplayName((Device)mongoTemplate.findOne(query, Device.class));
    }

    @Override
    public List<Device> getAllDevicesByUUID(int cloudId, String cloudName, String deviceUUID) {
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
    }

    @Override
    public long getDeviceCount(int cloudId, String cloudName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, Device.class);
    }

    @Override
    public List<Device> getAllSinceTimeStamp(int cloudId, String cloudName, long timeStamp) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"lastModifiedTimestamp").gt((Object)timeStamp)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
    }

    @Override
    public long getDeviceCount(int cloudId, String cloudName, boolean blocked) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)blocked), Criteria.where((String)"deviceType").is((Object)"BACKUP")});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, Device.class);
    }

    @Override
    public void deleteAllDeviceByUser(int cloudId, String cloudName, User user) {
        this.deleteAllDeviceOverViewByUser(cloudId, cloudName, user);
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)user.getUserName()), criteria1});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, Device.class);
    }

    @Override
    public List<Device> getAllDeviceByUser(int cloudId, String cloudName, User user) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)user.getUserName()), criteria1});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
    }

    @Override
    public List<Device> getAllDeviceByUserName(int cloudId, String userName) {
        List<Device> list = new ArrayList<Device>();
        if (StringUtils.isNotEmpty((String)userName)) {
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            Criteria criteria1 = new Criteria();
            criteria1.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), criteria1});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            list = mongoTemplate.find(query, Device.class);
        }
        return this.getDevicesFormDisplayName(list);
    }

    @Override
    public Map<String, List<Device>> getAllDeviceByUser(int cloudId, List<User> users) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        HashMap<String, List<Device>> userAndDevices = new HashMap<String, List<Device>>();
        ArrayList<String> userNameList = new ArrayList<String>();
        for (User user : users) {
            if (user == null) continue;
            userNameList.add(user.getUserName());
        }
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false), Criteria.where((String)USER_NAME).in(userNameList)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        List<Device> list = this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
        for (Device device : list) {
            if (device == null) continue;
            DeviceDaoImpl.addValues(device.getUserName(), device, userAndDevices);
        }
        return userAndDevices;
    }

    @Override
    public Map<String, List<Device>> getAllDevicesByUser(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        HashMap<String, List<Device>> userAndDevices = new HashMap<String, List<Device>>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        List list = mongoTemplate.find(query, Device.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.logger.debug(" getAllDevicesByUser ........ " + list.size());
        }
        for (Device device : list) {
            if (device == null) continue;
            DeviceDaoImpl.addValues(device.getUserName(), this.getDeviceFormDisplayName(device), userAndDevices);
        }
        return userAndDevices;
    }

    public static void addValues(String key, Device device, Map<String, List<Device>> hashMap) {
        List<Object> tempList;
        if (hashMap.containsKey(key)) {
            tempList = hashMap.get(key);
            if (tempList == null) {
                tempList = new ArrayList();
            }
            tempList.add(device);
        } else {
            tempList = new ArrayList();
            tempList.add(device);
        }
        hashMap.put(key, tempList);
    }

    @Override
    public Device getDeviceByName(int cloudId, String cloudName, String deviceName, String userName, String deviceUUID) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).is((Object)deviceName), Criteria.where((String)USER_NAME).is((Object)userName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(1);
        List list = mongoTemplate.find(query, Device.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return this.getDeviceFormDisplayName((Device)list.get(0));
        }
        return null;
    }

    @Override
    public Device getDeviceByNameForUserId(int cloudId, String cloudName, String deviceName, ObjectId userId, String deviceUUID) {
        org.springframework.data.mongodb.core.query.Query query1 = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)Criteria.where((String)USER_ID).is((Object)userId));
        MongoTemplate mongoTemplate1 = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)mongoTemplate1.findOne(query1, User.class);
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)deviceUUID)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).is((Object)deviceName), Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, Device.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return this.getDeviceFormDisplayName((Device)list.get(0));
        }
        return null;
    }

    @Override
    public List<Device> getDeviceByNameForBackup(int cloudId, String cloudName, String deviceName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).is((Object)deviceName), Criteria.where((String)USER_NAME).is((Object)userName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
    }

    @Override
    public long getDeviceCountOfUser(int cloudId, String cloudName, User user) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)user.getUserName());
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, Device.class);
    }

    @Override
    public List<Device> getActiveDeviceByName(int cloudId, String cloudName, String deviceName, String userName) {
        Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery("from Device d where d.deviceName=:deviceName and d.userName!=:userName and d.blocked=:blocked");
        query.setParameter(DEVICE_NAME, (Object)deviceName);
        query.setParameter(USER_NAME, (Object)userName);
        query.setParameter(BLOCKED, (Object)false);
        return this.getDevicesFormDisplayName(query.list());
    }

    @Override
    public List<Device> getActiveDeviceByNameAndUser(int cloudId, String cloudName, String deviceName, String userName) {
        Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery("from Device d where d.deviceName!=:deviceName and d.userName=:userName and d.blocked=:blocked");
        query.setParameter(DEVICE_NAME, (Object)deviceName);
        query.setParameter(USER_NAME, (Object)userName);
        query.setParameter(BLOCKED, (Object)false);
        return this.getDevicesFormDisplayName(query.list());
    }

    @Override
    public void updateDeviceDecoupled(int cloudId, String cloudName, String deviceUUID) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("decoupled", (Object)true);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, Device.class);
        mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
    }

    @Override
    public void updateDeviceName(int cloudId, String deviceUUID, String deviceName) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(DEVICE_NAME, (Object)deviceName);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, Device.class);
    }

    @Override
    public List<Device> getActiveDevicesForNoBackup(int cloudId, String cloudName, int skipValue) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DistinctIterable list = mongoTemplate.getCollection("BACKUP_BATCH").distinct("device.$id", ObjectId.class);
        ArrayList<ObjectId> listofDeviceIds = new ArrayList<ObjectId>();
        for (ObjectId objectId : list) {
            listofDeviceIds.add(objectId);
        }
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ID).nin(listofDeviceIds), Criteria.where((String)BLOCKED).is((Object)false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
    }

    @Override
    public List<Device> getActiveDevicesForNoBackup(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        DistinctIterable list = mongoTemplate.getCollection("BACKUP_BATCH").distinct("device.$id", ObjectId.class);
        ArrayList<ObjectId> listofDeviceIds = new ArrayList<ObjectId>();
        for (ObjectId objectId : list) {
            listofDeviceIds.add(objectId);
        }
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ID).nin(listofDeviceIds), Criteria.where((String)BLOCKED).is((Object)false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
    }

    @Override
    public Device getDeviceByName(int cloudId, String cloudName, String deviceName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).is((Object)deviceName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, Device.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return this.getDeviceFormDisplayName((Device)list.get(0));
        }
        return null;
    }

    @Override
    public Device getDeviceByNameAndUser(int cloudId, String deviceName, String userName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        if (StringUtils.isNotEmpty((String)userName)) {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).is((Object)deviceName), Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)BLOCKED).is((Object)false)});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            query.limit(1);
            List list1 = mongoTemplate.find(query, Device.class);
            if (!CollectionUtils.isEmpty((Collection)list1)) {
                return this.getDeviceFormDisplayName((Device)list1.get(0));
            }
        }
        return null;
    }

    @Override
    public void blockUnblockDevice(int cloudId, String cloudName, String deviceUUID, boolean toBlock) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(BLOCKED, (Object)toBlock);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, Device.class);
        this.updateDeviceStatusInOverview(cloudId, deviceUUID, !toBlock);
    }

    @Override
    public List<Device> getAllWithPagination(int cloudId, int skipValue) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        this.logger.debug(" No of records ... " + PCHelperConstant.getReportDisplayRecords());
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
    }

    @Override
    public long getAllDeviceCount(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return mongoTemplate.count(query, Device.class);
    }

    @Override
    public List<Device> findDeviceByNames(int cloudId, List<String> list) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Device> devList = new ArrayList<Device>();
        for (String deviceName : list) {
            String devName = deviceName.trim();
            this.logger.debug("....device name vaa....." + devName);
            devName = devName.replaceAll("\\(", "\\\\(");
            devName = devName.replaceAll("\\)", "\\\\)");
            this.logger.debug("....device name vaa after....." + devName);
            Criteria criteriaForDeviceName = new Criteria();
            criteriaForDeviceName.orOperator(new Criteria[]{Criteria.where((String)"displayName").regex(Pattern.compile(devName, 2)), Criteria.where((String)DEVICE_NAME).regex(Pattern.compile(devName, 2))});
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{criteriaForDeviceName});
            List devicelist = mongoTemplate.find(org.springframework.data.mongodb.core.query.Query.query((CriteriaDefinition)criteria), Device.class);
            if (devicelist == null) continue;
            for (Device deviceObj : devicelist) {
                devList.add(deviceObj);
            }
        }
        return this.getDevicesFormDisplayName(devList);
    }

    @Override
    public List<Device> getAllDeviceByUserName(int cloudId, String userName, List<String> list) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ArrayList<Device> devList = new ArrayList<Device>();
        if (StringUtils.isNotEmpty((String)userName)) {
            for (String deviceName : list) {
                String devName = deviceName.trim();
                this.logger.debug(userName + " dev name in dao ... " + devName);
                Criteria criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).regex(Pattern.compile("^" + devName, 2)), Criteria.where((String)USER_NAME).is((Object)userName)});
                org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
                List devicelist = mongoTemplate.find(query, Device.class);
                if (devicelist == null) continue;
                for (Device deviceObj : devicelist) {
                    devList.add(deviceObj);
                }
            }
        }
        return this.getDevicesFormDisplayName(devList);
    }

    @Override
    public void updateDevice(int cloudId, Device device) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)device);
    }

    @Override
    public Map<String, List<Device>> getAllDevicesByUser(int cloudId, int skipValue) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        HashMap<String, List<Device>> userAndDevices = new HashMap<String, List<Device>>();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        List list = mongoTemplate.find(query, Device.class);
        for (Device device : list) {
            if (device == null) continue;
            DeviceDaoImpl.addValues(device.getUserName(), this.getDeviceFormDisplayName(device), userAndDevices);
        }
        return userAndDevices;
    }

    @Override
    public Object[] getCloudOverView(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        long noOfRestoresDone = 0L;
        long noOfBackupsDone = 0L;
        long noOfFullBackupsDone = 0L;
        long totalDiskSpaceUsed = 0L;
        long totalActualSpaceUsed = 0L;
        long currentlyRunningBackupCount = 0L;
        Object[] arr = new Object[10];
        List overViewList = mongoTemplate.findAll(DeviceBackupOverView.class);
        ArrayList<BackupOverviewElement> backupOverviewElementsList = new ArrayList<BackupOverviewElement>();
        for (DeviceBackupOverView deviceBackupOverView : overViewList) {
            if (StringUtils.isNotEmpty((String)deviceBackupOverView.getDeviceType()) && (deviceBackupOverView.getDeviceType().equals(Device.TYPE.ONEDRIVE.toString()) || deviceBackupOverView.getDeviceType().equals(Device.TYPE.OUTLOOK.toString()))) continue;
            totalDiskSpaceUsed += deviceBackupOverView.getStorageUtilized();
            totalActualSpaceUsed += deviceBackupOverView.getStorageUtilizedInCloud() + deviceBackupOverView.getStorageUtilizedInPg();
            noOfBackupsDone += deviceBackupOverView.getNoOfSuccessfulBackups();
            noOfRestoresDone += deviceBackupOverView.getNoOfSuccessfulRestores();
            if (!StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime()) || !StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) {
                ++noOfFullBackupsDone;
            }
            if (StringUtils.isNotEmpty((String)deviceBackupOverView.getLastBkpStatus()) && !deviceBackupOverView.isDeviceBolcked() && (deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase("STARTED") || deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase("SCANNING"))) {
                ++currentlyRunningBackupCount;
            }
            BackupOverviewElement element = new BackupOverviewElement();
            BeanUtils.copyProperties((Object)deviceBackupOverView, (Object)element);
            element.setUserId(deviceBackupOverView.getUserName());
            element.setDeviceActive(!deviceBackupOverView.isDeviceBolcked());
            element.setCurrentBkpStartTime(deviceBackupOverView.getLastBkpStartTime());
            backupOverviewElementsList.add(element);
        }
        Object[] usrAndDevArr = this.getNoOfUsersProtected(backupOverviewElementsList);
        if (!CollectionUtils.isEmpty((Collection)overViewList)) {
            arr[0] = totalDiskSpaceUsed;
            arr[1] = noOfBackupsDone;
            arr[2] = noOfRestoresDone;
            arr[3] = this.getDeviceCount(cloudId, "", false);
            arr[4] = noOfFullBackupsDone;
            arr[5] = totalActualSpaceUsed;
            arr[6] = currentlyRunningBackupCount;
            arr[7] = usrAndDevArr[0];
            arr[8] = usrAndDevArr[1];
            arr[9] = usrAndDevArr[2];
        } else {
            arr[0] = 0;
            arr[1] = 0;
            arr[2] = 0;
            arr[3] = 0;
            arr[4] = 0;
            arr[5] = 0;
            arr[6] = 0;
            arr[7] = 0;
            arr[8] = 0;
            arr[9] = 0;
        }
        return arr;
    }

    private Object[] getNoOfUsersProtected(List<BackupOverviewElement> backupOverviewElementsList) {
        long noOfUsersProtected = 0L;
        int noOfDays = 7;
        long noOfDevicesNotProtected = 0L;
        long totalNoOfDeviceBkpOverviews = 0L;
        Object[] arr = new Object[3];
        try {
            HashSet<String> usersSet = new HashSet<String>();
            for (BackupOverviewElement element : backupOverviewElementsList) {
                SimpleDateFormat format = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
                DateTime dt1 = null;
                DateTime dt2 = new DateTime();
                Date yourDate = null;
                int daysDifferenceCurr = 999;
                int lastBkpEndDiff = 999;
                int firstBkpEndDiff = 999;
                if (!StringUtils.isEmpty((String)element.getLastBkpStatus()) && "INTERRUPTED".equals(element.getLastBkpStatus()) && !StringUtils.isEmpty((String)element.getReason()) && "543".equals(element.getReason()) || !element.isDeviceActive()) continue;
                ++totalNoOfDeviceBkpOverviews;
                if (!StringUtils.isEmpty((String)element.getCurrentBkpStartTime())) {
                    String currentBkpStarted = element.getCurrentBkpStartTime();
                    yourDate = DeviceDaoImpl.getDateByString(currentBkpStarted);
                    dt1 = new DateTime((Object)yourDate);
                    daysDifferenceCurr = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                }
                if (!StringUtils.isEmpty((String)element.getLastBkpEndTime())) {
                    yourDate = DeviceDaoImpl.getDateByString(element.getLastBkpEndTime());
                    dt1 = new DateTime((Object)yourDate);
                    lastBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                }
                if (!StringUtils.isEmpty((String)element.getFirstBkpEndTime())) {
                    yourDate = DeviceDaoImpl.getDateByString(element.getFirstBkpEndTime());
                    dt1 = new DateTime((Object)yourDate);
                    firstBkpEndDiff = Days.daysBetween((ReadableInstant)dt1, (ReadableInstant)dt2).getDays();
                }
                if (daysDifferenceCurr == 999 && lastBkpEndDiff == 999 && firstBkpEndDiff == 999) {
                    ++noOfDevicesNotProtected;
                    continue;
                }
                if (daysDifferenceCurr < noOfDays || lastBkpEndDiff < noOfDays || firstBkpEndDiff < noOfDays) {
                    if (usersSet.contains(element.getUserId())) continue;
                    ++noOfUsersProtected;
                    usersSet.add(element.getUserId());
                    continue;
                }
                ++noOfDevicesNotProtected;
            }
        }
        catch (Exception e) {
            this.logger.debug("Exception......", (Throwable)e);
            this.logger.trace(" Exception :" + e);
            this.logger.error("Exception while getting " + e.getMessage());
        }
        arr[0] = noOfUsersProtected;
        arr[1] = noOfDevicesNotProtected;
        arr[2] = totalNoOfDeviceBkpOverviews;
        return arr;
    }

    private static Date getDateByString(String currentBkpStarted) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(DD_MMM_YYYY_HH_MM_SS);
        Date yourDate = format.parse(currentBkpStarted);
        yourDate.setHours(0);
        yourDate.setMinutes(0);
        return yourDate;
    }

    public Object[] getBackupRestoreCount(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Object[] arr = new Object[2];
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"status").is((Object)"COMPLETED")});
        TypedAggregation aggregation = Aggregation.newAggregation(BackupBatch.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"jobType"}).count().as(COUNT), Aggregation.project((String[])new String[]{COUNT, "jobType"})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List countDetailList = result.getMappedResults();
        if (!CollectionUtils.isEmpty((Collection)countDetailList)) {
            for (BasicDBObject dbObject : countDetailList) {
                String jobType = (String)dbObject.get("_id");
                if ("RESTORE".equalsIgnoreCase(jobType)) {
                    arr[0] = Long.valueOf(dbObject.get(COUNT).toString());
                }
                if (!"BACKUP".equalsIgnoreCase(jobType)) continue;
                arr[1] = Long.valueOf(dbObject.get(COUNT).toString());
            }
        } else {
            arr[0] = 0;
            arr[1] = 0;
        }
        return arr;
    }

    @Override
    public List<Device> getAllActiveDevices(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
    }

    @Override
    public List<Device> getAllDevices(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
    }

    public List<Device> getDevices(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        TypedAggregation aggregation = Aggregation.newAggregation(Device.class, (AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)BLOCKED).is((Object)false)), Aggregation.group((String[])new String[]{BLOCKED, "user"}), Aggregation.project((String[])new String[]{BLOCKED, "user"})});
        AggregationResults result = mongoTemplate.aggregate(aggregation, BasicDBObject.class);
        List overViewList = result.getMappedResults();
        int i = 0;
        for (BasicDBObject dbObject : overViewList) {
            this.logger.debug("  **************  " + dbObject);
            DBRef dbRef = (DBRef)dbObject.get("user");
            if (dbRef != null) continue;
            ++i;
        }
        this.logger.debug(i + " ***************** #$@#$@#$@# ************* " + overViewList.size());
        return new ArrayList<Device>();
    }

    @Override
    public void updateClientVersion(int cloudId, String productVersion, String deviceUUID) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("clientVersion", (Object)productVersion);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.upsert(query, update, Device.class);
    }

    @Override
    public void updateDevDisplayName(int cloudId, String displayName, String deviceUUID) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("displayName", (Object)displayName);
        this.logger.debug("....displayName...." + displayName);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.upsert(query, update, Device.class);
    }

    @Override
    public List<Device> getAllDevicesByName(int cloudId, String deviceName) {
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)Criteria.where((String)DEVICE_NAME).is((Object)deviceName));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, Device.class);
        return this.getDevicesFormDisplayName(list);
    }

    @Override
    public List<Device> getAllActiveDevices(int cloudId, int skipValue) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        this.logger.debug("   Skip value in getDevicesElement ...... " + skipValue);
        if (skipValue != -99) {
            query.limit(PCHelperConstant.getReportDisplayRecords());
        }
        if (skipValue != 0 && skipValue != -99) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
    }

    public void deleteAllDeviceOverViewByUser(int cloudId, String cloudName, User user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List devices = mongoTemplate.find(query, Device.class);
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
        for (Device device : devices) {
            DeviceBackupOverView deviceBackupOverView;
            if (device == null || (deviceBackupOverView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID())) == null) continue;
            objectIds.add(deviceBackupOverView.getId());
        }
        Criteria criteria1 = new Criteria();
        criteria1.andOperator(new Criteria[]{Criteria.where((String)ID).in(objectIds)});
        org.springframework.data.mongodb.core.query.Query query1 = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria1);
        mongoTemplate.remove(query1, DeviceBackupOverView.class);
    }

    @Override
    public Map<String, List<Device>> getAllDevicesByUserName(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        HashMap<String, List<Device>> userAndDevices = new HashMap<String, List<Device>>();
        List list = mongoTemplate.findAll(Device.class);
        if (list != null) {
            this.logger.debug(" getAllDevicesByUserName ........ " + list.size());
        }
        for (Device device : list) {
            if (device == null) continue;
            DeviceDaoImpl.addValues(device.getUserName(), this.getDeviceFormDisplayName(device), userAndDevices);
        }
        return userAndDevices;
    }

    @Override
    public void markAllDevicesAsInActiveForUser(int cloudId, String cloudName, User user) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)user.getUserName());
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(BLOCKED, (Object)true);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateMulti(query, update, Device.class);
    }

    @Override
    public void markAllDevicesAsDeletedForUser(int cloudId, String cloudName, User user) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)user.getUserName());
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(BLOCKED, (Object)true);
        update.set(DELETED, (Object)true);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateMulti(query, update, Device.class);
    }

    @Override
    public void deleteAllDeviceByUserName(int cloudId, String cloudName, String userName) {
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        User user = (User)mongoTemplate.findOne(query, User.class);
        this.deleteAllDeviceOverViewByUser(cloudId, cloudName, user);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
        org.springframework.data.mongodb.core.query.Query query1 = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query1, Device.class);
    }

    @Override
    public Device getDeviceById(int cloudId, ObjectId deviceId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ID).is((Object)deviceId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        List list = mongoTemplate.find(query, Device.class);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return this.getDeviceFormDisplayName((Device)list.get(0));
        }
        return null;
    }

    @Override
    public List<Device> getAllDevicesByUser(int cloudId, User user) {
        Criteria criteria = Criteria.where((String)USER_NAME).is((Object)user.getUserName());
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
    }

    @Override
    public void deleteDeviceByDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        this.deleteDeviceBackupOverViewByDeviceUUID(cloudId, query, mongoTemplate);
        mongoTemplate.remove(query, Device.class);
    }

    private void deleteDeviceBackupOverViewByDeviceUUID(int cloudId, org.springframework.data.mongodb.core.query.Query query, MongoTemplate mongoTemplate) {
        DeviceBackupOverView deviceBackupOverView;
        Device device = (Device)mongoTemplate.findOne(query, Device.class);
        if (device != null && (deviceBackupOverView = this.getDeviceBkpOverviewForDeviceUUID(cloudId, device.getDeviceUUID())) != null) {
            this.deleteDeviceBackupOverviewById(cloudId, deviceBackupOverView.getId());
        }
    }

    @Override
    public void deleteDeviceBackupOverviewById(int cloudId, ObjectId objectId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"_id").is((Object)objectId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, DeviceBackupOverView.class);
    }

    @Override
    public List<Device> getAllDeletedDevices(int cloudId, String cloudName) {
        Criteria criteria = Criteria.where((String)DELETED).is((Object)true);
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
    }

    @Override
    public void updateClientServiceVersion(int cloudId, String serviceVersion, String deviceUUID) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("clientServiceVersion", (Object)serviceVersion);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.upsert(query, update, Device.class);
    }

    @Override
    public void updateLastHeardTime(int cloudId, ObjectId overviewId) {
        Criteria criteria = Criteria.where((String)ID).is((Object)overviewId);
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("lastHeardTime", (Object)System.currentTimeMillis());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
    }

    @Override
    public void updateLastHeardTimeAndPolicyModifiedTime(int cloudId, ObjectId overviewId, long policyModifiedTime) {
        Criteria criteria = Criteria.where((String)ID).is((Object)overviewId);
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("lastHeardTime", (Object)System.currentTimeMillis());
        update.set("policyUpdatedTime", (Object)policyModifiedTime);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
    }

    @Override
    public DeviceBackupOverView getDeviceBkpOverviewForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceBkpOverviewFormDisplayName((DeviceBackupOverView)mongoTemplate.findOne(query, DeviceBackupOverView.class));
    }

    @Override
    public void updateUserInfoInDeviceBkpOverview(int cloudId, User user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set("isUserActive", (Object)user.isActive());
        update.set("isUserDeleted", (Object)user.isDeleted());
        update.set("emailId", (Object)user.getEmailId());
        update.set("location", (Object)user.getLocation());
        update.set("department", (Object)user.getDepartment());
        update.set("accountStatus", (Object)user.isAccountStatus());
        update.set("policyName", (Object)user.getPolicyName());
        update.set("odbPolicyName", (Object)user.getOdbPolicyName());
        mongoTemplate.updateMulti(query, update, DeviceBackupOverView.class);
    }

    @Override
    public void updatePolicyNameInDeviceBkpOverview(int cloudId, String userName, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set("policyName", (Object)policyName);
        mongoTemplate.updateMulti(query, update, DeviceBackupOverView.class);
    }

    @Override
    public void updatedeviceInfoInDeviceBkpOverview(int cloudId, Device device) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)device.getDeviceUUID())});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("clientVersion", (Object)device.getClientVersion());
        update.set(IS_DEVICE_BOLCKED, (Object)device.isBlocked());
        update.set("isDeviceDeleted", (Object)device.isDeleted());
        update.set("decoupled", (Object)device.isDecoupled());
        update.set("deviceDisplayName", (Object)device.getDisplayName());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateMulti(query, update, DeviceBackupOverView.class);
    }

    @Override
    public void deleteAllDeviceBkpoverviewByUser(int cloudId, User user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, DeviceBackupOverView.class);
    }

    @Override
    public List<DeviceBackupOverView> getAllOverviews(int cloudId, int skipValue, int limit) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserDeleted = Criteria.where((String)"isUserDeleted").is((Object)false);
        Criteria criteriaDeviceDeleted = Criteria.where((String)"isDeviceDeleted").is((Object)false);
        criteria.andOperator(new Criteria[]{criteriaUserDeleted, criteriaDeviceDeleted});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        this.logger.debug(" SKIP VALUE .... " + skipValue);
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceBkpOverviewsFormDisplayName(mongoTemplate.find(query, DeviceBackupOverView.class));
    }

    @Override
    public long getCountAllOverviews(int cloudId, List<String> policyNames) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserDeleted = Criteria.where((String)"isUserDeleted").is((Object)false);
        Criteria criteriaDeviceDeleted = Criteria.where((String)"isDeviceDeleted").is((Object)false);
        if (!CollectionUtils.isEmpty(policyNames)) {
            Criteria criteriaForPolicyName = new Criteria();
            criteriaForPolicyName.orOperator(new Criteria[]{Criteria.where((String)"policyName").in(policyNames), Criteria.where((String)"odbPolicyName").in(policyNames)});
            criteria.andOperator(new Criteria[]{criteriaUserDeleted, criteriaDeviceDeleted, criteriaForPolicyName});
        } else {
            criteria.andOperator(new Criteria[]{criteriaUserDeleted, criteriaDeviceDeleted});
        }
        this.logger.debug("...criteria..." + criteria.toString());
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        this.logger.debug("...query..." + query.toString());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, DeviceBackupOverView.class);
    }

    @Override
    public List<DeviceBackupOverView> getAllOverviews(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceBkpOverviewsFormDisplayName(mongoTemplate.findAll(DeviceBackupOverView.class));
    }

    @Override
    public List<DeviceBackupOverView> getAllOverviews(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceBkpOverviewsFormDisplayName(mongoTemplate.find(query, DeviceBackupOverView.class));
    }

    @Override
    public void markUserAndDeviceAsDeleteInDeviceBkpOverview(int cloudId, User user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set(IS_DEVICE_BOLCKED, (Object)true);
        update.set("isUserActive", (Object)false);
        update.set("isUserDeleted", (Object)true);
        mongoTemplate.updateMulti(query, update, DeviceBackupOverView.class);
    }

    @Override
    public List<DeviceBackupOverView> getAllOverviews(int cloudId, int skipValue) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        this.logger.debug(PCHelperConstant.getReportDisplayRecords() + "   Skip value in getDeviceBackupOverViewElement ...... " + skipValue);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue > 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        return this.getDeviceBkpOverviewsFormDisplayName(mongoTemplate.find(query, DeviceBackupOverView.class));
    }

    @Override
    public void updateDeviceStatusInOverview(int cloudId, String deviceUUID, boolean isDeviceActive) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(IS_DEVICE_BOLCKED, (Object)isDeviceActive);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateMulti(query, update, DeviceBackupOverView.class);
    }

    @Override
    public List<DeviceBackupOverView> getDeviceBkpOverviewForUserName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceBkpOverviewsFormDisplayName(mongoTemplate.find(query, DeviceBackupOverView.class));
    }

    @Override
    public void updateClientVersionInOverview(int cloudId, String deviceUUID, String productVersion) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("clientVersion", (Object)productVersion);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateMulti(query, update, DeviceBackupOverView.class);
    }

    @Override
    public void updateDevDisplayNameInOverview(int cloudId, String deviceUUID, String displayName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("deviceDisplayName", (Object)displayName);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateMulti(query, update, DeviceBackupOverView.class);
    }

    @Override
    public List<DeviceBackupOverView> getDeviceBkpOverviewForUserNameAndDeviceName(int cloudId, String userName, String deviceName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)DEVICE_NAME).is((Object)deviceName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceBkpOverviewsFormDisplayName(mongoTemplate.find(query, DeviceBackupOverView.class));
    }

    @Override
    public List<DeviceBackupOverView> getDeviceBkpOverviewForPolicyNames(int cloudId, List<String> policyNames, boolean isODBBackupEnabled, String productType) {
        Criteria criteria = new Criteria();
        Criteria productCriteria = null;
        if (!StringUtils.isEmpty((String)productType)) {
            productCriteria = new Criteria();
            if ("office".equals(productType)) {
                productCriteria.orOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)"ONEDRIVE"), Criteria.where((String)"deviceType").is((Object)"OUTLOOK")});
            } else {
                productCriteria.andOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)"BACKUP")});
            }
        }
        if (isODBBackupEnabled) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"policyName").in(policyNames), Criteria.where((String)"odbPolicyName").in(policyNames)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").in(policyNames)});
        }
        Criteria criteria1 = new Criteria();
        Criteria criteriaUserDeleted = Criteria.where((String)"isUserDeleted").is((Object)false);
        Criteria criteriaDeviceDeleted = Criteria.where((String)"isDeviceDeleted").is((Object)false);
        if (productCriteria == null) {
            criteria1.andOperator(new Criteria[]{criteriaUserDeleted, criteriaDeviceDeleted, criteria1});
        } else {
            criteria1.andOperator(new Criteria[]{criteriaUserDeleted, criteriaDeviceDeleted, criteria1, productCriteria});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceBkpOverviewsFormDisplayName(mongoTemplate.find(query, DeviceBackupOverView.class));
    }

    @Override
    public List<DeviceBackupOverView> getDeviceBkpOverviewForPolicyNames(int cloudId, List<String> policyNames, boolean isODBBackupEnabled, int skipValue, int limit) {
        Criteria criteria = new Criteria();
        if (isODBBackupEnabled) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"policyName").in(policyNames), Criteria.where((String)"odbPolicyName").in(policyNames)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").in(policyNames)});
        }
        Criteria criteria1 = new Criteria();
        Criteria criteriaUserDeleted = Criteria.where((String)"isUserDeleted").is((Object)false);
        Criteria criteriaDeviceDeleted = Criteria.where((String)"isDeviceDeleted").is((Object)false);
        criteria1.andOperator(new Criteria[]{criteriaUserDeleted, criteriaDeviceDeleted, criteria1});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        this.logger.debug(" SKIP VALUE .... " + skipValue);
        if (skipValue > 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceBkpOverviewsFormDisplayName(mongoTemplate.find(query, DeviceBackupOverView.class));
    }

    @Override
    public List<DeviceBackupOverView> getDeviceBkpOverviewForUserNames(int cloudId, List<String> userNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).in(userNames)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceBkpOverviewsFormDisplayName(mongoTemplate.find(query, DeviceBackupOverView.class));
    }

    @Override
    public long getDeviceBkpOverviewCountForUserNames(int cloudId, List<String> userNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).in(userNames)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, DeviceBackupOverView.class);
    }

    @Override
    public List<Device> getAllActiveDeviceByUserName(int cloudId, String userName) {
        List<Device> list = new ArrayList<Device>();
        if (StringUtils.isNotEmpty((String)userName)) {
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            Criteria criteria1 = new Criteria();
            criteria1.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)BLOCKED).is((Object)false), criteria1});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            list = mongoTemplate.find(query, Device.class);
        }
        return this.getDevicesFormDisplayName(list);
    }

    @Override
    public List<Device> getDeviceByUserName(int cloudId, String userName) {
        List<Device> list = new ArrayList<Device>();
        if (StringUtils.isNotEmpty((String)userName)) {
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            list = mongoTemplate.find(query, Device.class);
        }
        return this.getDevicesFormDisplayName(list);
    }

    @Override
    public List<Device> findDeviceByUserNames(int cloudId, List<String> userNames) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).in(userNames), Criteria.where((String)DELETED).is((Object)false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDevicesFormDisplayName(mongoTemplate.find(query, Device.class));
    }

    @Override
    public void blockOldDeviceBkpInfo(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set("isDecoupled", (Object)true);
        mongoTemplate.updateMulti(query, update, LatestDeviceBackupInfo.class);
    }

    @Override
    public void saveLatestDeviceBkpInfo(int cloudId, LatestDeviceBackupInfo latestDeviceBackupInfo) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)latestDeviceBackupInfo);
    }

    @Override
    public LatestDeviceBackupInfo getLatestDeviceBkpInfo(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)"isDecoupled").is((Object)false)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (LatestDeviceBackupInfo)mongoTemplate.findOne(query, LatestDeviceBackupInfo.class);
    }

    @Override
    public List<LatestDeviceBackupInfo> getAllLatestDeviceBkpInfo(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, LatestDeviceBackupInfo.class);
    }

    @Override
    public void deleteLatestBkpInfoBuDeviceUUID(int cloudId, String deviceUUID) {
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)Criteria.where((String)DEVICE_UUID).regex(deviceUUID));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, LatestDeviceBackupInfo.class);
    }

    @Override
    public Device getOneDriveDeviceforUser(int cloudId, String userName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"deviceType").is((Object)"ONEDRIVE")});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Device device = (Device)mongoTemplate.findOne(query, Device.class);
        return device;
    }

    @Override
    public Object[] getODBCloudOverView(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.setReadPreference(ReadPreference.secondaryPreferred());
        long noOfRestoresDone = 0L;
        long noOfBackupsDone = 0L;
        long noOfFullBackupsDone = 0L;
        long totalDiskSpaceUsed = 0L;
        long totalActualSpaceUsed = 0L;
        long currentlyRunningBackupCount = 0L;
        Object[] arr = new Object[10];
        List overViewList = mongoTemplate.findAll(DeviceBackupOverView.class);
        ArrayList<BackupOverviewElement> backupOverviewElementsList = new ArrayList<BackupOverviewElement>();
        for (DeviceBackupOverView deviceBackupOverView : overViewList) {
            if (!StringUtils.isNotEmpty((String)deviceBackupOverView.getDeviceType()) || !deviceBackupOverView.getDeviceType().equals(Device.TYPE.ONEDRIVE.toString()) && !deviceBackupOverView.getDeviceType().equals(Device.TYPE.OUTLOOK.toString())) continue;
            totalDiskSpaceUsed += deviceBackupOverView.getStorageUtilized();
            totalActualSpaceUsed += deviceBackupOverView.getStorageUtilizedInCloud() + deviceBackupOverView.getStorageUtilizedInPg();
            noOfBackupsDone += deviceBackupOverView.getNoOfSuccessfulBackups();
            noOfRestoresDone += deviceBackupOverView.getNoOfSuccessfulRestores();
            if (!StringUtils.isEmpty((String)deviceBackupOverView.getFirstBkpEndTime()) || !StringUtils.isEmpty((String)deviceBackupOverView.getLastSuccessfulBkp())) {
                ++noOfFullBackupsDone;
            }
            if (StringUtils.isNotEmpty((String)deviceBackupOverView.getLastBkpStatus()) && (deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase("STARTED") || deviceBackupOverView.getLastBkpStatus().equalsIgnoreCase("STARTED"))) {
                ++currentlyRunningBackupCount;
            }
            BackupOverviewElement element = new BackupOverviewElement();
            BeanUtils.copyProperties((Object)deviceBackupOverView, (Object)element);
            element.setUserId(deviceBackupOverView.getUserName());
            element.setDeviceActive(!deviceBackupOverView.isDeviceBolcked());
            element.setCurrentBkpStartTime(deviceBackupOverView.getLastBkpStartTime());
            backupOverviewElementsList.add(element);
        }
        Object[] usrAndDev = this.getNoOfUsersProtected(backupOverviewElementsList);
        if (!CollectionUtils.isEmpty((Collection)overViewList)) {
            this.logger.debug(totalActualSpaceUsed + "..sissszzeees ..." + totalDiskSpaceUsed);
            arr[0] = totalDiskSpaceUsed;
            arr[1] = noOfBackupsDone;
            arr[2] = noOfRestoresDone;
            arr[3] = this.getODBDeviceCount(cloudId, false);
            arr[4] = noOfFullBackupsDone;
            arr[5] = totalActualSpaceUsed;
            arr[6] = currentlyRunningBackupCount;
            arr[7] = usrAndDev[0];
            arr[8] = usrAndDev[1];
            arr[9] = usrAndDev[2];
        } else {
            arr[0] = 0;
            arr[1] = 0;
            arr[2] = 0;
            arr[3] = 0;
            arr[4] = 0;
            arr[5] = 0;
            arr[6] = 0;
            arr[7] = 0;
            arr[8] = 0;
            arr[9] = 0;
        }
        return arr;
    }

    public long getODBDeviceCount(int cloudId, boolean blocked) {
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)"ONEDRIVE"), Criteria.where((String)"deviceType").is((Object)"OUTLOOK")});
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)BLOCKED).is((Object)blocked), criteria1});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, Device.class);
    }

    @Override
    public long getDeviceBackupOverviewCountByDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).in(new Object[]{deviceUUID})});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, DeviceBackupOverView.class);
    }

    @Override
    public void updateODBPolicyNameInDeviceBkpOverview(int cloudId, String userName, String policyName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set("odbPolicyName", (Object)policyName);
        mongoTemplate.updateMulti(query, update, DeviceBackupOverView.class);
    }

    @Override
    public List<Device> getAllUserByDeviceName(int cloudId, String deviceName) {
        List<Device> list = new ArrayList<Device>();
        if (StringUtils.isNotEmpty((String)deviceName)) {
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            Criteria criteria1 = new Criteria();
            criteria1.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).is((Object)deviceName), criteria1});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            list = mongoTemplate.find(query, Device.class);
        }
        return this.getDevicesFormDisplayName(list);
    }

    @Override
    public Device getDeviceByUserNameAndDeviceName(int cloudId, String userName, String deviceName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_NAME).regex(Pattern.compile("^" + deviceName, 2)), Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName, 2))});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceFormDisplayName((Device)mongoTemplate.findOne(query, Device.class));
    }

    @Override
    public void saveO365BlackListUser(int cloudId, O365BlackListUser o365BlackListUser) {
        this.removeO365BlackListUser(cloudId, o365BlackListUser.getUserName());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)o365BlackListUser);
    }

    @Override
    public void removeO365BlackListUser(int cloudId, String userName) {
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)Criteria.where((String)USER_NAME).is((Object)userName));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, O365BlackListUser.class);
    }

    @Override
    public List<UserDeviceAccessControl> getUserDeviceAccessControl(int cloudId, ObjectId deviceID) {
        MongoTemplate paracloudMongoTemplate;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceFK").is((Object)deviceID)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoForCloud = paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoForCloud.find(query, UserDeviceAccessControl.class);
    }

    @Override
    public long getCountDeviceAccessControl(int cloudId) {
        MongoTemplate paracloudMongoTemplate;
        Criteria criteria = new Criteria();
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoForCloud = paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoForCloud.count(query, UserDeviceAccessControl.class);
    }

    @Override
    public List<UserDeviceAccessControl> getUserDeviceAccessControlByUserID(int cloudId, ObjectId userId) {
        MongoTemplate paracloudMongoTemplate;
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"userFK").is((Object)userId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoForCloud = paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoForCloud.find(query, UserDeviceAccessControl.class);
    }

    @Override
    public void saveUserDeviceAccessControl(int cloudId, UserDeviceAccessControl accessControl) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)accessControl);
    }

    @Override
    public void deleteUserDeviceAccess(int cloudId, ObjectId deviceId, ObjectId userId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceFK").is((Object)deviceId), Criteria.where((String)"userFK").is((Object)userId)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, UserDeviceAccessControl.class);
    }

    @Override
    public List<Device> getAllDevicesByIds(int cloudId, List<String> deviceIdlist) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ID).in(deviceIdlist), criteria.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)})});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return this.getDevicesFormDisplayName(this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).find(query, Device.class));
    }

    @Override
    public List<Device> getDevicesByUserName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, Device.class);
    }

    @Override
    public Device getUsersWithoutOutlookDevices(int cloudId, String userName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)"deviceType").is((Object)"OUTLOOK")});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Device device = (Device)mongoTemplate.findOne(query, Device.class);
        return device;
    }

    @Override
    public List<DeviceBackupOverView> getAllODBOverviews(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria1 = new Criteria();
        criteria1.orOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)"ONEDRIVE"), Criteria.where((String)"deviceType").is((Object)"OUTLOOK")});
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false), criteria1});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        List overViewList = mongoTemplate.find(query, DeviceBackupOverView.class);
        if (CollectionUtils.isEmpty((Collection)overViewList)) {
            return new ArrayList<DeviceBackupOverView>();
        }
        return overViewList;
    }

    @Override
    public void updateSizeDeviceBackupOverView(int cloudId, String deviceUUID, Long storageUtilized, Long latestVersionChange) {
        if (storageUtilized != null) {
            Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            Update update = new Update();
            if (storageUtilized != null) {
                update.inc("storageUtilized", (Number)storageUtilized);
            }
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)"isDecoupled").is((Object)false)});
            query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            if (latestVersionChange != null) {
                update.inc("latestVersionsSize", (Number)latestVersionChange);
            }
            mongoTemplate.updateFirst(query, update, LatestDeviceBackupInfo.class);
        }
    }

    @Override
    public void updateSizeDeviceBackupOverView(int cloudId, String deviceUUID, Long storageInPG, Long sizeInCloud, Long latestVersionChange, Long pgCompressedSize) {
        if (storageInPG != null || sizeInCloud != null || latestVersionChange != null || pgCompressedSize != null) {
            Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            Update update = new Update();
            if (storageInPG != null) {
                update.inc("storageUtilized", (Number)storageInPG);
            }
            if (sizeInCloud != null) {
                update.inc("storageUtilizedInCloud", (Number)sizeInCloud);
            }
            if (pgCompressedSize != null) {
                update.inc("storageUtilizedInPg", (Number)pgCompressedSize);
            }
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            mongoTemplate.updateFirst(query, update, DeviceBackupOverView.class);
            criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID), Criteria.where((String)"isDecoupled").is((Object)false)});
            query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            if (latestVersionChange != null) {
                update.inc("latestVersionsSize", (Number)latestVersionChange);
            }
            mongoTemplate.updateFirst(query, update, LatestDeviceBackupInfo.class);
        }
    }

    @Override
    public List<Device> getAllBackupDeviceByUserName(int cloudId, String userName) {
        List<Device> list = new ArrayList<Device>();
        if (StringUtils.isNotEmpty((String)userName)) {
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            Criteria criteria1 = new Criteria();
            Criteria criteria2 = new Criteria();
            criteria1.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
            criteria2.andOperator(new Criteria[]{criteria1, Criteria.where((String)"deviceType").ne((Object)Device.TYPE.ONEDRIVE.name()), Criteria.where((String)"deviceType").ne((Object)Device.TYPE.OUTLOOK.name())});
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), criteria2});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            list = mongoTemplate.find(query, Device.class);
        }
        return list;
    }

    @Override
    public List<Device> getAllOfficeDevicesByUserName(int cloudId, String userName) {
        List<Device> list = new ArrayList<Device>();
        if (!StringUtils.isEmpty((String)userName)) {
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            Criteria criteria1 = new Criteria();
            Criteria criteria2 = new Criteria();
            criteria1.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
            Criteria criteria3 = new Criteria();
            criteria3.orOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)Device.TYPE.ONEDRIVE.name()), Criteria.where((String)"deviceType").is((Object)Device.TYPE.OUTLOOK.name())});
            criteria2.andOperator(new Criteria[]{criteria1, criteria3});
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), criteria2});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            list = mongoTemplate.find(query, Device.class);
        }
        return list;
    }

    @Override
    public void saveMailBackupBatch(int cloudId, MailBackupBatch backupBatch, EventHub eventHub) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backupBatch);
        mongoTemplate.save((Object)eventHub);
    }

    @Override
    public MailBackupBatch getMailBackupBatch(int cloudId, String actionToDeviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)actionToDeviceUUID), Criteria.where((String)"status").is((Object)"STARTED")});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (MailBackupBatch)mongoTemplate.findOne(new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria), MailBackupBatch.class);
    }

    @Override
    public List<Device> getAllOneDriveDeviceByUserName(int cloudId, String userName) {
        List<Device> list = new ArrayList<Device>();
        if (StringUtils.isNotEmpty((String)userName)) {
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            Criteria criteria = new Criteria();
            Criteria criteria1 = new Criteria();
            Criteria criteria2 = new Criteria();
            criteria1.orOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)DELETED).exists(false)});
            criteria2.andOperator(new Criteria[]{criteria1, Criteria.where((String)"deviceType").is((Object)Device.TYPE.ONEDRIVE.name())});
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), criteria2});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            list = mongoTemplate.find(query, Device.class);
        }
        return list;
    }

    @Override
    public List<ObjectId> loadAllDeviceUserIds(int cloudId, boolean showBlockedDevicesBol) {
        ArrayList<ObjectId> userIds = new ArrayList<ObjectId>();
        try {
            Criteria criteria = new Criteria();
            if (showBlockedDevicesBol) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false), Criteria.where((String)BLOCKED).is((Object)showBlockedDevicesBol)});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)DELETED).is((Object)false)});
            }
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            DistinctIterable distStr = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).getCollection("DEVICE").distinct(USER_ID, (Bson)query.getQueryObject(), ObjectId.class);
            List<ObjectId> userNames = new ArrayList();
            if (distStr != null) {
                userNames = IteratorUtils.toList((Iterator)distStr.iterator());
            }
            this.logger.debug(distStr + "..... " + userNames.size());
            return userNames;
        }
        catch (Exception e) {
            this.logger.trace("Error failed to loadAllUsersEmailIds ..." + e);
            this.logger.error("Error failed to loadAllUsersEmailIds  ..." + e.getMessage());
            return userIds;
        }
    }

    @Override
    public List<String> getUniqueUserNamesInDevice(int cloudId, List<String> policyNameList) {
        List<String> userNames = new ArrayList<String>();
        try {
            Criteria criteria = new Criteria();
            if (CollectionUtils.isEmpty(policyNameList)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false)});
            } else {
                Criteria orCriteria = new Criteria();
                orCriteria.orOperator(new Criteria[]{Criteria.where((String)"policyName").in(policyNameList), Criteria.where((String)"odbPolicyName").in(policyNameList)});
                criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false), orCriteria});
            }
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            DistinctIterable distStr = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).getCollection("DEVICE_BACKUP_OVERVIEW").distinct(USER_NAME, (Bson)query.getQueryObject(), String.class);
            if (distStr != null) {
                userNames = IteratorUtils.toList((Iterator)distStr.iterator());
            }
            this.logger.debug(distStr + "..or... " + userNames.size());
            return userNames;
        }
        catch (Exception e) {
            this.logger.trace("Error failed to loadAllUsersEmailIds ..." + e);
            this.logger.error("Error failed to loadAllUsersEmailIds  ..." + e.getMessage());
            return userNames;
        }
    }

    @Override
    public List<String> getUniqueUserNamesInDevice(int cloudId) {
        List<String> userNames = new ArrayList<String>();
        try {
            Criteria criteria = new Criteria();
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false)});
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            DistinctIterable distStr = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).getCollection("DEVICE_BACKUP_OVERVIEW").distinct(USER_NAME, (Bson)query.getQueryObject(), String.class);
            if (distStr != null) {
                userNames = IteratorUtils.toList((Iterator)distStr.iterator());
            }
            this.logger.debug(distStr + "..... " + userNames.size());
            return userNames;
        }
        catch (Exception e) {
            this.logger.trace("Error failed to loadAllUsersEmailIds ..." + e);
            this.logger.error("Error failed to loadAllUsersEmailIds  ..." + e.getMessage());
            return userNames;
        }
    }

    @Override
    public long getCountFullBkpCompleted(int cloudId, List<String> policyNameList) {
        try {
            Criteria criteria = new Criteria();
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{Criteria.where((String)"firstBkpEndTime").ne(null), Criteria.where((String)"lastSuccessfulBackupEndTime").ne((Object)0L)});
            if (CollectionUtils.isEmpty(policyNameList)) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false), orCriteria});
            } else {
                orCriteria = new Criteria();
                orCriteria.orOperator(new Criteria[]{Criteria.where((String)"policyName").in(policyNameList), Criteria.where((String)"odbPolicyName").in(policyNameList)});
                criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false), orCriteria, orCriteria});
            }
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            List overViews = mongoTemplate.find(query, DeviceBackupOverView.class);
            HashSet<String> userSet = new HashSet<String>();
            for (DeviceBackupOverView overView : overViews) {
                userSet.add(overView.getUserName());
            }
            return userSet.size();
        }
        catch (Exception e) {
            this.logger.trace("Error failed to loadAllUsersEmailIds ..." + e);
            this.logger.error("Error failed to loadAllUsersEmailIds  ..." + e.getMessage());
            return 0L;
        }
    }

    @Override
    public List<DeviceBackupOverView> getAllBkpOverviews(int cloudId) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceType").ne((Object)"ONEDRIVE")});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, DeviceBackupOverView.class);
    }

    @Override
    public List<DeviceBackupOverView> getDeviceBackupOVerviewList(int cloudId, ReportQueryElement reportQueryElement) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        List<String> policyNames = reportQueryElement.getPolicyNames();
        if (!CollectionUtils.isEmpty(policyNames)) {
            this.logger.debug("........policymnames.....");
            Criteria criteria1 = new Criteria();
            criteria1.orOperator(new Criteria[]{Criteria.where((String)"policyName").in(policyNames), Criteria.where((String)"odbPolicyName").in(policyNames)});
            criteria.andOperator(new Criteria[]{criteria1});
        } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName()) && !StringUtils.isEmpty((String)reportQueryElement.getDeviceName())) {
            this.logger.debug("........username and devicename....." + reportQueryElement.getUserName() + "...dev.." + reportQueryElement.getDeviceName());
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)reportQueryElement.getUserName()), Criteria.where((String)DEVICE_NAME).is((Object)reportQueryElement.getDeviceName())});
        } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName()) && StringUtils.isEmpty((String)reportQueryElement.getDeviceName())) {
            this.logger.debug("........username only ....." + reportQueryElement.getUserName());
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)reportQueryElement.getUserName())});
        } else {
            this.logger.debug("........all users .....");
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isUserActive").is((Object)true)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (reportQueryElement.getSkipValue() != 0) {
            query.skip((long)(reportQueryElement.getSkipValue() * PCHelperConstant.getReportDisplayRecords()));
        }
        return mongoTemplate.find(query, DeviceBackupOverView.class);
    }

    @Override
    public List<DeviceBackupOverView> getDeviceBkpOverviewForUserNameAndDeviceName(int cloudId, String userName, String deviceName, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName), Criteria.where((String)DEVICE_NAME).is((Object)deviceName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceBkpOverviewsFormDisplayName(mongoTemplate.find(query, DeviceBackupOverView.class));
    }

    @Override
    public List<DeviceBackupOverView> getDeviceBkpOverviewForUserName(int cloudId, String userName, int skipValue) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)userName)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue != 0) {
            query.skip((long)skipValue);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceBkpOverviewsFormDisplayName(mongoTemplate.find(query, DeviceBackupOverView.class));
    }

    @Override
    public List<DeviceBackupOverView> getLastAgentHeardDeviceBkpOverviews(int cloudId, ReportQueryElement reportQueryElement) {
        Criteria searchcriteria = new Criteria();
        Criteria criteriaUserDeleted = Criteria.where((String)"isUserDeleted").is((Object)false);
        Criteria criteriaDeviceDeleted = Criteria.where((String)"isDeviceDeleted").is((Object)false);
        if (!CollectionUtils.isEmpty(reportQueryElement.getPolicyNames())) {
            Criteria criteriaForPolicyName = new Criteria();
            criteriaForPolicyName.orOperator(new Criteria[]{Criteria.where((String)"policyName").in(reportQueryElement.getPolicyNames()), Criteria.where((String)"odbPolicyName").in(reportQueryElement.getPolicyNames())});
            searchcriteria.andOperator(new Criteria[]{criteriaUserDeleted, criteriaDeviceDeleted, criteriaForPolicyName, Criteria.where((String)"deviceType").ne((Object)"ONEDRIVE"), Criteria.where((String)"deviceType").ne((Object)"OUTLOOK")});
        } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName())) {
            if (StringUtils.isNotEmpty((String)reportQueryElement.getDeviceName())) {
                searchcriteria.andOperator(new Criteria[]{criteriaUserDeleted, criteriaDeviceDeleted, Criteria.where((String)USER_NAME).is((Object)reportQueryElement.getUserName()), Criteria.where((String)DEVICE_NAME).is((Object)reportQueryElement.getDeviceName()), Criteria.where((String)"deviceType").ne((Object)"ONEDRIVE"), Criteria.where((String)"deviceType").ne((Object)"OUTLOOK")});
            } else {
                searchcriteria.andOperator(new Criteria[]{criteriaUserDeleted, criteriaDeviceDeleted, Criteria.where((String)USER_NAME).is((Object)reportQueryElement.getUserName()), Criteria.where((String)"deviceType").ne((Object)"ONEDRIVE"), Criteria.where((String)"deviceType").ne((Object)"OUTLOOK")});
            }
        } else {
            searchcriteria.andOperator(new Criteria[]{criteriaUserDeleted, criteriaDeviceDeleted, Criteria.where((String)"deviceType").ne((Object)"ONEDRIVE"), Criteria.where((String)"deviceType").ne((Object)"OUTLOOK")});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)searchcriteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return this.getDeviceBkpOverviewsFormDisplayName(mongoTemplate.find(query, DeviceBackupOverView.class));
    }

    @Override
    public List<DeviceBackupOverView> getAllDeviceBackupOVerviewList(int cloudId, ReportQueryElement reportQueryElement) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        List<String> policyNames = reportQueryElement.getPolicyNames();
        if (!CollectionUtils.isEmpty(policyNames)) {
            this.logger.debug("........policymnames.....");
            Criteria criteria1 = new Criteria();
            criteria1.orOperator(new Criteria[]{Criteria.where((String)"policyName").in(policyNames), Criteria.where((String)"odbPolicyName").in(policyNames)});
            criteria.andOperator(new Criteria[]{criteria1});
        } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName()) && !StringUtils.isEmpty((String)reportQueryElement.getDeviceName())) {
            this.logger.debug("........username and devicename....." + reportQueryElement.getUserName() + "...dev.." + reportQueryElement.getDeviceName());
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)reportQueryElement.getUserName()), Criteria.where((String)DEVICE_NAME).is((Object)reportQueryElement.getDeviceName())});
        } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName()) && StringUtils.isEmpty((String)reportQueryElement.getDeviceName())) {
            this.logger.debug("........username only ....." + reportQueryElement.getUserName());
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)reportQueryElement.getUserName())});
        } else {
            this.logger.debug("........all users .....");
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isUserActive").is((Object)true)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return mongoTemplate.find(query, DeviceBackupOverView.class);
    }

    @Override
    public long getCountStorageUtilizeReport(int cloudId, ReportQueryElement reportQueryElement) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        List<String> policyNames = reportQueryElement.getPolicyNames();
        if (!CollectionUtils.isEmpty(policyNames)) {
            this.logger.debug("........policymnames.....");
            Criteria criteria1 = new Criteria();
            criteria1.orOperator(new Criteria[]{Criteria.where((String)"policyName").in(policyNames), Criteria.where((String)"odbPolicyName").in(policyNames)});
            criteria.andOperator(new Criteria[]{criteria1});
        } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName()) && !StringUtils.isEmpty((String)reportQueryElement.getDeviceName())) {
            this.logger.debug("........username and devicename....." + reportQueryElement.getUserName() + "...dev.." + reportQueryElement.getDeviceName());
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)reportQueryElement.getUserName()), Criteria.where((String)DEVICE_NAME).is((Object)reportQueryElement.getDeviceName())});
        } else if (!StringUtils.isEmpty((String)reportQueryElement.getUserName()) && StringUtils.isEmpty((String)reportQueryElement.getDeviceName())) {
            this.logger.debug("........username only ....." + reportQueryElement.getUserName());
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)reportQueryElement.getUserName())});
        } else {
            this.logger.debug("........all users .....");
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isUserActive").is((Object)true)});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        return mongoTemplate.count(query, DeviceBackupOverView.class);
    }

    @Override
    public List<DeviceBackupOverView> getAllDeviceBkpOverviewsForDeviceUUID(int cloudId, String deviceUUID) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID)});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, DeviceBackupOverView.class);
    }

    public User getUserInfo(int cloudId, String userId) {
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)Criteria.where((String)USER_ID).is((Object)userId));
        return (User)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, User.class);
    }

    public User getUserByName(int cloudId, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex(Pattern.compile("^" + userName + "$", 2))});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (User)paracloudMongoTemplate.findOne(query, User.class);
    }

    @Override
    public List<Device> getAllUserDeviceAccessControl(int cloudId) {
        MongoTemplate paracloudMongoTemplate;
        MongoTemplate mongoForCloud = paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List findAll = mongoForCloud.findAll(UserDeviceAccessControl.class);
        HashMap<String, Device> map = new HashMap<String, Device>();
        if (CollectionUtils.isEmpty((Collection)findAll)) {
            return new ArrayList<Device>();
        }
        for (UserDeviceAccessControl userDeviceAccessControl : findAll) {
            Device device = this.getDeviceById(cloudId, userDeviceAccessControl.getDeviceFK());
            if (device == null || !device.isBlocked()) continue;
            this.logger.debug(device.isBlocked() + "....device assigned.... " + device.getUserName() + "....." + device.getDeviceName());
            User user = this.getUserByName(cloudId, device.getUserName());
            if (user == null || user.isActive() || device == null) continue;
            map.put(device.getId().toString(), device);
        }
        return new ArrayList<Device>(map.values());
    }

    @Override
    public void updateUserStatusInDeviceBkpOverview(int cloudId, User user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).is((Object)user.getUserName())});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Update update = new Update();
        update.set("isUserActive", (Object)user.isActive());
        mongoTemplate.updateMulti(query, update, DeviceBackupOverView.class);
    }

    @Override
    public List<DeviceBackupOverView> getAllOverViewWithPagination(int cloudId, int skipValue, List<String> policyNames) {
        Criteria criteria = new Criteria();
        Criteria criteriaUserDeleted = Criteria.where((String)"isUserDeleted").is((Object)false);
        Criteria criteriaDeviceDeleted = Criteria.where((String)"isDeviceDeleted").is((Object)false);
        if (!CollectionUtils.isEmpty(policyNames)) {
            Criteria criteriaForPolicyName = new Criteria();
            criteriaForPolicyName.orOperator(new Criteria[]{Criteria.where((String)"policyName").in(policyNames), Criteria.where((String)"odbPolicyName").in(policyNames)});
            criteria.andOperator(new Criteria[]{criteriaUserDeleted, criteriaDeviceDeleted, criteriaForPolicyName});
        } else {
            criteria.andOperator(new Criteria[]{criteriaUserDeleted, criteriaDeviceDeleted});
        }
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        this.logger.debug(" No of records ... " + PCHelperConstant.getReportDisplayRecords());
        query.limit(PCHelperConstant.getReportDisplayRecords());
        if (skipValue != 0) {
            query.skip((long)(skipValue * PCHelperConstant.getReportDisplayRecords()));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, DeviceBackupOverView.class);
    }

    @Override
    public void saveOdbFolderNameTODeviceUUIDMapping(int cloudId, OdbFolderNameTODeviceUUIDMapping odb) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_UUID).is((Object)odb.getDeviceUUID())});
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        OdbFolderNameTODeviceUUIDMapping deviceUUIDMapping = (OdbFolderNameTODeviceUUIDMapping)mongoTemplate.findOne(query, OdbFolderNameTODeviceUUIDMapping.class);
        if (deviceUUIDMapping == null) {
            mongoTemplate.save((Object)odb);
        }
    }

    @Override
    public List<String> getUniqueUserNamesInDeviceByProductType(int cloudId, String productType) {
        List<String> userNames = new ArrayList<String>();
        try {
            Criteria productCriteria = null;
            if (!StringUtils.isEmpty((String)productType)) {
                productCriteria = new Criteria();
                if ("office".equals(productType)) {
                    productCriteria.orOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)"ONEDRIVE"), Criteria.where((String)"deviceType").is((Object)"OUTLOOK")});
                } else {
                    productCriteria.andOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)"BACKUP")});
                }
            }
            Criteria criteria = new Criteria();
            if (productCriteria == null) {
                criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false)});
            } else {
                criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false), productCriteria});
            }
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            DistinctIterable distStr = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).getCollection("DEVICE_BACKUP_OVERVIEW").distinct(USER_NAME, (Bson)query.getQueryObject(), String.class);
            if (distStr != null) {
                userNames = IteratorUtils.toList((Iterator)distStr.iterator());
            }
            this.logger.debug(distStr + "..... " + userNames.size());
            return userNames;
        }
        catch (Exception e) {
            this.logger.trace("Error failed to loadAllUsersEmailIds ..." + e);
            this.logger.error("Error failed to loadAllUsersEmailIds  ..." + e.getMessage());
            return userNames;
        }
    }

    @Override
    public List<String> getUniqueUserNamesInDeviceByProductType(int cloudId, List<String> policyNameList, String productType) {
        List<String> userNames = new ArrayList<String>();
        try {
            Criteria productCriteria = null;
            if (!StringUtils.isEmpty((String)productType)) {
                productCriteria = new Criteria();
                if ("office".equals(productType)) {
                    productCriteria.orOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)"ONEDRIVE"), Criteria.where((String)"deviceType").is((Object)"OUTLOOK")});
                } else {
                    productCriteria.andOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)"BACKUP")});
                }
            }
            Criteria criteria = new Criteria();
            if (CollectionUtils.isEmpty(policyNameList)) {
                if (productCriteria == null) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false)});
                } else {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false), productCriteria});
                }
            } else {
                Criteria orCriteria = new Criteria();
                orCriteria.orOperator(new Criteria[]{Criteria.where((String)"policyName").in(policyNameList), Criteria.where((String)"odbPolicyName").in(policyNameList)});
                if (productCriteria == null) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false), orCriteria});
                } else {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false), orCriteria, productCriteria});
                }
            }
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            DistinctIterable distStr = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).getCollection("DEVICE_BACKUP_OVERVIEW").distinct(USER_NAME, (Bson)query.getQueryObject(), String.class);
            if (distStr != null) {
                userNames = IteratorUtils.toList((Iterator)distStr.iterator());
            }
            this.logger.debug(distStr + "..or... " + userNames.size());
            return userNames;
        }
        catch (Exception e) {
            this.logger.trace("Error failed to loadAllUsersEmailIds ..." + e);
            this.logger.error("Error failed to loadAllUsersEmailIds  ..." + e.getMessage());
            return userNames;
        }
    }

    @Override
    public long getCountFullBkpCompletedByProductType(int cloudId, List<String> policyNameList, String productType) {
        try {
            Criteria productCriteria = null;
            if (!StringUtils.isEmpty((String)productType)) {
                productCriteria = new Criteria();
                if ("office".equals(productType)) {
                    productCriteria.orOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)"ONEDRIVE"), Criteria.where((String)"deviceType").is((Object)"OUTLOOK")});
                } else {
                    productCriteria.andOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)"BACKUP")});
                }
            }
            Criteria criteria = new Criteria();
            Criteria orCriteria = new Criteria();
            orCriteria.orOperator(new Criteria[]{Criteria.where((String)"firstBkpEndTime").ne(null), Criteria.where((String)"lastSuccessfulBackupEndTime").ne((Object)0L)});
            if (CollectionUtils.isEmpty(policyNameList)) {
                if (productCriteria == null) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false), orCriteria});
                } else {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false), orCriteria, productCriteria});
                }
            } else {
                orCriteria = new Criteria();
                orCriteria.orOperator(new Criteria[]{Criteria.where((String)"policyName").in(policyNameList), Criteria.where((String)"odbPolicyName").in(policyNameList)});
                criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false), orCriteria, orCriteria});
                if (productCriteria == null) {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false), orCriteria, orCriteria});
                } else {
                    criteria.andOperator(new Criteria[]{Criteria.where((String)"isDeviceDeleted").is((Object)false), Criteria.where((String)"isUserActive").is((Object)true), Criteria.where((String)IS_DEVICE_BOLCKED).is((Object)false), orCriteria, orCriteria, productCriteria});
                }
            }
            org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
            MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
            List overViews = mongoTemplate.find(query, DeviceBackupOverView.class);
            HashSet<String> userSet = new HashSet<String>();
            for (DeviceBackupOverView overView : overViews) {
                userSet.add(overView.getUserName());
            }
            return userSet.size();
        }
        catch (Exception e) {
            this.logger.trace("Error failed to loadAllUsersEmailIds ..." + e);
            this.logger.error("Error failed to loadAllUsersEmailIds  ..." + e.getMessage());
            return 0L;
        }
    }

    @Override
    public List<DeviceBackupOverView> getAllOverviewsBasedOnProductType(int cloudId, String productType) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria productCriteria = null;
        List overviews = new ArrayList();
        if (!StringUtils.isEmpty((String)productType)) {
            productCriteria = new Criteria();
            if ("office".equals(productType)) {
                productCriteria.orOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)"ONEDRIVE"), Criteria.where((String)"deviceType").is((Object)"OUTLOOK")});
            } else {
                productCriteria.andOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)"BACKUP")});
            }
            overviews = mongoTemplate.find(new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)productCriteria), DeviceBackupOverView.class);
        } else {
            overviews = mongoTemplate.findAll(DeviceBackupOverView.class);
        }
        return this.getDeviceBkpOverviewsFormDisplayName(overviews);
    }

    @Override
    public void updatedeviceToken(int cloudId, String deviceUUID) {
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID);
        org.springframework.data.mongodb.core.query.Query query = new org.springframework.data.mongodb.core.query.Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("deltaToken", (Object)"");
        update.set("prevDeltaToken", (Object)"");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, Device.class);
    }
}

