/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.element.DeviceContainerElement;
import com.parablu.pcbd.dao.DeviceContainerDao;
import com.parablu.pcbd.domain.DeviceContainer;
import com.parablu.pcbd.domain.Group;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DeviceContainerDaoImpl
implements DeviceContainerDao {
    Logger logger = LogManager.getLogger(DeviceContainerDaoImpl.class);
    private static final String DEVICE_UUID = "deviceUUID";
    @Resource
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void registerDeviceContainer(DeviceContainer deviceContainer, int cloudId) {
        this.logger.debug("registerDeviceContainer(DeviceContainer deviceContainer, int cloudId) > BEGIN");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)deviceContainer);
        this.logger.debug("registerDeviceContainer(DeviceContainer deviceContainer, int cloudId) > END");
    }

    @Override
    public List<DeviceContainer> getAllDeviceContainers(String deviceUUID, int cloudId) {
        this.logger.debug("List<DeviceContainer> getAllDeviceContainers(String deviceUUID, int cloudId) > BEGIN");
        Query query = new Query((CriteriaDefinition)Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List deviceContainers = mongoTemplate.find(query, DeviceContainer.class);
        this.logger.debug("List<DeviceContainer> getAllDeviceContainers(String deviceUUID, int cloudId) > BEFORE RETURN >" + deviceContainers.size());
        return deviceContainers;
    }

    @Override
    public DeviceContainer getDeviceContainer(int cloudId, String deviceUUID, String containerName, String containerType) {
        this.logger.debug("DeviceContainer getDeviceContainer(int cloudId, String deviceUUID, String containerName,\tString containerType) > BEGIN");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID).and("containerName").is((Object)containerName).and("containerType").is((Object)containerType);
        Query query = new Query((CriteriaDefinition)criteria);
        DeviceContainer deviceContainer = (DeviceContainer)mongoTemplate.findOne(query, DeviceContainer.class);
        this.logger.debug("DeviceContainer getDeviceContainer(int cloudId, String deviceUUID, String containerName,\tString containerType) > BEFORE RETURN");
        return deviceContainer;
    }

    @Override
    public boolean deleteContainer(int cloudId, DeviceContainerElement deviceContainerElement) {
        this.logger.debug("boolean deleteContainer(int cloudId, String deviceUUID, String containerName, String containerType) > BEGIN");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ObjectId id = new ObjectId(deviceContainerElement.getId());
        Criteria criteria = Criteria.where((String)"id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.remove(query, DeviceContainer.class);
        return true;
    }

    @Override
    public List<DeviceContainer> getAllDeviceContainersForGroup(int cloudId, Group group) {
        this.logger.debug("List<DeviceContainer> getAllDeviceContainersForGroup(int cloudId, Group group) > BEGIN");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"group").is((Object)group);
        Query query = new Query((CriteriaDefinition)criteria);
        List containers = mongoTemplate.find(query, DeviceContainer.class);
        this.logger.debug("List<DeviceContainer> getAllDeviceContainersForGroup(int cloudId, Group group) > BEFORE RETURN");
        return containers;
    }

    @Override
    public List<DeviceContainer> getAllDeviceContainersByGroup(int cloudId, String deviceUUID, Group group) {
        this.logger.debug("List<DeviceContainer> getAllDeviceContainersByGroup(int cloudId, String deviceUUID, Group group) > BEGIN");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)DEVICE_UUID).is((Object)deviceUUID).and("group").is((Object)group);
        Query query = new Query((CriteriaDefinition)criteria);
        List deviceContainers = mongoTemplate.find(query, DeviceContainer.class);
        this.logger.debug("List<DeviceContainer> getAllDeviceContainersByGroup(int cloudId, String deviceUUID, Group group) > BEFORE RETURN");
        return deviceContainers;
    }

    @Override
    public DeviceContainer getDeviceContainerByID(int cloudId, ObjectId objectId) {
        this.logger.debug("DeviceContainer getDeviceContainerByID(int cloudId, ObjectId objectId) > BEGIN");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"id").is((Object)objectId);
        Query query = new Query((CriteriaDefinition)criteria);
        DeviceContainer container = (DeviceContainer)mongoTemplate.findOne(query, DeviceContainer.class);
        this.logger.debug("DeviceContainer getDeviceContainerByID(int cloudId, ObjectId objectId) > BEFORE RETURN");
        return container;
    }

    @Override
    public boolean isContainerUnique(int cloudId, DeviceContainerElement deviceContainerElement) {
        Query query;
        DeviceContainer dc;
        this.logger.debug("DeviceContainer isContainerUnique(int cloudId, ObjectId objectId) > BEGIN");
        boolean isContainerUnique = true;
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Criteria criteria = Criteria.where((String)"containerName").is((Object)deviceContainerElement.getContainerName()).and("containerType").is((Object)deviceContainerElement.getContainerType());
        if (StringUtils.isNotEmpty((String)deviceContainerElement.getId())) {
            ObjectId oid = new ObjectId(deviceContainerElement.getId());
            criteria.and("id").ne((Object)oid);
        }
        if ((dc = (DeviceContainer)mongoTemplate.findOne(query = new Query((CriteriaDefinition)criteria), DeviceContainer.class)) != null) {
            isContainerUnique = false;
        }
        this.logger.debug("DeviceContainer isContainerUnique(int cloudId, ObjectId objectId) > END > isContainerUnique > " + isContainerUnique);
        return isContainerUnique;
    }
}

