/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.DeviceBackupPolicyMappingDao;
import com.parablu.pcbd.domain.Device;
import com.parablu.pcbd.domain.DeviceBackupPolicyMapping;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DeviceBackupPolicyMappingDaoImpl
implements DeviceBackupPolicyMappingDao {
    private static Logger logger = LogManager.getLogger(DeviceBackupPolicyMappingDaoImpl.class);
    @Resource
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    @Override
    public void saveDeviceBackupPolicyMapping(int cloudId, DeviceBackupPolicyMapping deviceBackupPolicyMapping) {
        logger.debug("saveDeviceBackupPolicyMapping > BEGIN");
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)deviceBackupPolicyMapping);
        logger.debug("saveDeviceBackupPolicyMapping > END");
    }

    @Override
    public DeviceBackupPolicyMapping getDevicePolicyMap(int cloudId, Device device) {
        logger.debug("getDevicePolicyMap > BEGIN");
        Criteria criteria = Criteria.where((String)"device").is((Object)device);
        Query query = new Query((CriteriaDefinition)criteria);
        DeviceBackupPolicyMapping devicePolicyMap = (DeviceBackupPolicyMapping)this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).findOne(query, DeviceBackupPolicyMapping.class);
        logger.debug("getDevicePolicyMap > queried and returning devicePolicyMap > " + devicePolicyMap);
        return devicePolicyMap;
    }

    @Override
    public List<DeviceBackupPolicyMapping> getAllDeviceBackupPolicyMapings(int cloudId) {
        logger.debug("getAllDeviceBackupPolicyMapings > BEGIN > cloudId : " + cloudId);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List userBackupPolicyMappingList = mongoTemplate.findAll(DeviceBackupPolicyMapping.class);
        logger.debug("getAllDeviceBackupPolicyMapings > END > returning DeviceBackupPolicyMapping size : " + userBackupPolicyMappingList.size());
        return userBackupPolicyMappingList;
    }
}

