/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.pcbd.dao.CrawlStatisticDao;
import com.parablu.pcbd.domain.CrawlStatistic;
import java.util.List;
import org.hibernate.Query;

public class CrawlStatisticDaoImpl
implements CrawlStatisticDao {
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public long getCountSinceTimeStamp(int cloudId, String cloudName, long prevTimeStamp, int requestType) {
        String namedQuery = "select count(*) from CrawlStatistic cs where cs.requestType=:requestType and cs.timeOfRequest>:timeOfRequest";
        Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery(namedQuery);
        query.setParameter("requestType", (Object)requestType);
        query.setParameter("timeOfRequest", (Object)prevTimeStamp);
        return (Long)query.uniqueResult();
    }

    @Override
    public List<String> getDescFilesTypeList(int cloudId, String cloudName) {
        String namedQuery = "select DISTINCT cs.fileType from CrawlStatistic cs where cs.fileType not like :folder and cs.fileType not like :deletedFile";
        Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery(namedQuery);
        query.setParameter("folder", (Object)"folder");
        query.setParameter("deletedFile", (Object)"deletedFile");
        return query.list();
    }

    @Override
    public void saveEntry(int cloudId, String cloudName, CrawlStatistic crawlStatistic) {
        this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId).save((Object)crawlStatistic);
    }

    @Override
    public List<CrawlStatistic> getAllStatisticsByDesc(int cloudId, String cloudName) {
        Query query = this.paracloudSessionFactoryUtils.getParacloudSession(cloudId).getCurrentSession().createQuery("from CrawlStatistic cs order by cs.timeOfRequest Desc");
        return query.list();
    }
}

