/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.mongodb.client.result.UpdateResult;
import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.paracloud.element.MiniCloudElement;
import com.parablu.paracloud.element.MiniCloudElementList;
import com.parablu.pcbd.dao.ConsolidatedImageDao;
import com.parablu.pcbd.domain.ConsolidatedImage;
import com.parablu.pcbd.domain.DailySyncOverView;
import com.parablu.pcbd.domain.FileRevision;
import com.parablu.pcbd.domain.SyncOverView;
import com.parablu.pcbd.domain.UsersSharedFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.CollectionUtils;

public class ConsolidatedImageDaoImpl
implements ConsolidatedImageDao {
    Logger logger = LogManager.getLogger(ConsolidatedImageDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String DEVICE_PATH = "devicePath";
    private static final String FILE_NAME = "fileName";
    private static final String USER_NAME = "userName";
    private static final String MODIFIED_TIME = "modifiedTime";
    private static final String FOLDER = "folder";
    private static final String PRESENT = "present";
    private static final String MINI_CLOUD = "miniCloud";
    private static final String CRAWL_START_TIME_STAMP = "crawlStartTimestamp";
    private static final String REG_ID = "regID";
    private static final String CONSOLIDATED_IMAGE_ID = "consolidatedImage.$id";

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveToConsolidatedImageDB(int cloudId, String cloudName, ConsolidatedImage consolidatedImage) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)consolidatedImage);
    }

    @Override
    public ConsolidatedImage getConsolidatedImageDBRecordByDevicePath(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getConsolidatedImageDBRecordByOnlyDevicePath(int cloudId, String userName, String cloudName, String devicePath) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getConsolidatedImageDBRecordByDevicePathWithoutRegex(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)USER_NAME).is((Object)userName)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getMiniCloudRecordIfExists(int cloudId, String fileName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i"), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getMiniCloudRecordIfExistsWithoutRegex(int cloudId, String fileName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)FOLDER).is((Object)true), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getConsolidatedImageDBRecordByDevicePathForRestore(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)MINI_CLOUD).is((Object)false), Criteria.where((String)PRESENT).is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)MINI_CLOUD).is((Object)false), Criteria.where((String)PRESENT).is((Object)false)});
        }
        criteria.orOperator(new Criteria[]{Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i"), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getConsolidatedImageDBRecordByDevicePathForDeletedRecord(int cloudId, String userName, String cloudName, String devicePath, String fileName, boolean present) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)present)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)present)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getConsolidatedImageDBRecordByDevicePathForPresentRecord(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getExistingConsolidatedImageDBRecordByDevicePath(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getRecordsBetweenTimeStampsForFolder(int cloudId, String userName, String cloudName, long startTimeStamp, long endTimeStamp, String regID, String folderToSyncList, boolean exists) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = new Criteria();
        pathLikeCriteria.orOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderToSyncList), Criteria.where((String)DEVICE_PATH).regex("^" + folderToSyncList + "/", "i")});
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)startTimeStamp), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)endTimeStamp), Criteria.where((String)REG_ID).ne((Object)regID), Criteria.where((String)PRESENT).is((Object)exists), pathLikeCriteria});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)startTimeStamp), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)endTimeStamp), Criteria.where((String)REG_ID).ne((Object)regID), Criteria.where((String)PRESENT).is((Object)exists), pathLikeCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getRecordsBetweenTimeStampsForFolderForSync(int cloudId, String userName, String cloudName, long startTimeStamp, long endTimeStamp, String regID, String folderToSyncList, boolean exists) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = new Criteria();
        pathLikeCriteria.orOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderToSyncList), Criteria.where((String)DEVICE_PATH).regex("^" + folderToSyncList + "/", "i")});
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)REG_ID).ne((Object)regID), Criteria.where((String)PRESENT).is((Object)exists), pathLikeCriteria});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)REG_ID).ne((Object)regID), Criteria.where((String)PRESENT).is((Object)exists), pathLikeCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getRecordsBetweenTimeStampsForFolderForMC(int cloudId, long startTimeStamp, long endTimeStamp, String regID, String folderToSyncList, boolean exists) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(folderToSyncList);
        criteria.andOperator(new Criteria[]{Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)startTimeStamp), Criteria.where((String)MINI_CLOUD).is((Object)true), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)endTimeStamp), Criteria.where((String)REG_ID).ne((Object)regID), Criteria.where((String)PRESENT).is((Object)exists), pathLikeCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllRecordsBeforeCurrentTimeStamp(int cloudId, String userName, String cloudName, long curTimeStamp, String folderPath) {
        Criteria criteria = new Criteria();
        Criteria pathcriteria = Criteria.where((String)DEVICE_PATH).is((Object)folderPath);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), pathcriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllRecordsBeforeCurrentTimeStampForPath(int cloudId, String userName, String cloudName, long curTimeStamp, String folderPath) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(folderPath);
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), pathLikeCriteria});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), pathLikeCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getConsolidatedImageDBRecordByDevicePathForMiniCloud(int cloudId, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)MINI_CLOUD).is((Object)true)});
        criteria.orOperator(new Criteria[]{Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i"), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getConsolidatedImageDBRecordByDevicePathForMiniCloudWithOutRegex(int cloudId, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)MINI_CLOUD).is((Object)true)});
        criteria.orOperator(new Criteria[]{Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getRecordsBetweenTimeStampsExceptFolder(int cloudId, String userName, String cloudName, long startTimeStamp, long endTimeStamp, String regID, String folderToSyncList) {
        Criteria criteria = new Criteria();
        Criteria pathcriteria = Criteria.where((String)DEVICE_PATH).ne((Object)folderToSyncList);
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).not().regex(folderToSyncList);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)startTimeStamp), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)startTimeStamp), Criteria.where((String)REG_ID).ne((Object)regID), pathcriteria.orOperator(new Criteria[]{pathLikeCriteria})});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    public ConsolidatedImage getConsolidatedImageDBRecordByDevicePath(int cloudId, String userName, String cloudName, String relativedevicePathAndFileNameAppended) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)"concat(devicePath,fileName)").is((Object)relativedevicePathAndFileNameAppended)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ConsolidatedImage image = (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
        this.logger.debug(relativedevicePathAndFileNameAppended + " ^^^^^^^^^^^^^^^^^^^^^^^^^^^^   " + image);
        return image;
    }

    @Override
    public List<ConsolidatedImage> getAllPresentRecordsWithGivenFileName(int cloudId, String userName, String cloudName, String fileName, boolean isPresent) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)PRESENT).is((Object)isPresent), Criteria.where((String)FILE_NAME).regex(fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllDeletedFilesBetweenTimeStamps(int cloudId, String userName, String cloudName, long lastSuccessfulDeleteTimeStamp, long currentDeleteTimeStamp) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)PRESENT).is((Object)false), Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)lastSuccessfulDeleteTimeStamp), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)currentDeleteTimeStamp)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllExistingFileRecordsBeforeCurrentTimeStamp(int cloudId, String userName, String cloudName, long curTimeStamp, String folderPath) {
        Criteria criteria = new Criteria();
        Criteria pathcriteria = Criteria.where((String)DEVICE_PATH).is((Object)folderPath);
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(folderPath);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), pathcriteria.orOperator(new Criteria[]{pathLikeCriteria})});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public double getTotalSizeByPath(int cloudId, String userName, String cloudName, String path) {
        return 0.0;
    }

    @Override
    public long getFileCountOfFileType(int cloudId, String cloudName, String fileType) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)FILE_NAME).regex(fileType)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getChildrenByFolder(int cloudId, String userName, String cloudName, String folderPath) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllExistingRecordsBeforeCurrentTimeStamp(int cloudId, String userName, String cloudName, long curTimeStamp, String folderPath) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = new Criteria();
        pathLikeCriteria.orOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)DEVICE_PATH).regex("^" + folderPath + "/", "i")});
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), pathLikeCriteria});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), pathLikeCriteria});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getExistingDBRecordByDevicePath(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllConsolidatedImageDBRecordByDevicePaths(int cloudId, String userName, String cloudName, List<String> completePathList) {
        return null;
    }

    @Override
    public List<ConsolidatedImage> getRecordsBetweenTimeStampsByPath(int cloudId, String userName, String cloudName, long startTimeStamp, long endTimeStamp, boolean present, String folderPath) {
        Criteria criteria = new Criteria();
        Criteria pathcriteria = Criteria.where((String)DEVICE_PATH).is((Object)folderPath);
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(folderPath);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)startTimeStamp), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)endTimeStamp), Criteria.where((String)PRESENT).is((Object)present), pathcriteria.orOperator(new Criteria[]{pathLikeCriteria})});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllPresentRecords(int cloudId, String userName, String cloudName, long curTimeStamp) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllPresentRecordsForBasePath(int cloudId, String userName, String cloudName, long curTimeStamp, String folderPath) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)DEVICE_PATH).regex(folderPath)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)DEVICE_PATH).regex(folderPath)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllPresentRecordsForBasePathExceptMiniclouds(int cloudId, String userName, String cloudName, long curTimeStamp, String folderPath, List<String> miniclouds) {
        Criteria criteria = new Criteria();
        Criteria andCriteria = new Criteria();
        Criteria pathLikeCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FILE_NAME).nin(miniclouds)});
        pathLikeCriteria.orOperator(new Criteria[]{andCriteria, Criteria.where((String)DEVICE_PATH).regex("^" + folderPath + "/", "i")});
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)MINI_CLOUD).is((Object)false), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)curTimeStamp), pathLikeCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getRecordsBetweenTimeStampsForFolderExceptMiniclouds(int cloudId, String userName, String cloudName, long startTimeStamp, long endTimeStamp, String regID, String folderToSyncList, List<String> miniclouds, boolean exist) {
        Criteria criteria = new Criteria();
        Criteria andCriteria = new Criteria();
        Criteria pathLikeCriteria = new Criteria();
        andCriteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderToSyncList), Criteria.where((String)FILE_NAME).nin(miniclouds)});
        pathLikeCriteria.orOperator(new Criteria[]{andCriteria, Criteria.where((String)DEVICE_PATH).regex("^" + folderToSyncList + "/", "i")});
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)PRESENT).is((Object)exist), Criteria.where((String)CRAWL_START_TIME_STAMP).gt((Object)startTimeStamp), Criteria.where((String)CRAWL_START_TIME_STAMP).lt((Object)endTimeStamp), Criteria.where((String)MINI_CLOUD).is((Object)false), Criteria.where((String)REG_ID).ne((Object)regID), pathLikeCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getSearchResultForFile(int cloudId, String userName, String cloudName, String fileName, String filePath, int start, int rows, MiniCloudElementList cloudElementList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select * from CONSOLIDATED_IMAGE c where c.IS_PRESENT=:present and (c.DEVICE_PATH like :filePath or c.DEVICE_PATH like :filePaths ) and (c.FILE_NAME like :fileName) ");
        for (MiniCloudElement miniCloudElement : cloudElementList.getMiniClouds()) {
            stringBuilder.append(" AND (c.DEVICE_PATH not like :minicloudPath" + miniCloudElement.getId() + " or c.DEVICE_PATH not like :minicloudPaths" + miniCloudElement.getId()).append(")");
        }
        return null;
    }

    @Override
    public List<ObjectId> getSearchResultIdsForFile(int cloudId, String userName, String cloudName, String fileName, String filePath, int start, int rows, MiniCloudElementList cloudElementList) {
        this.logger.debug(filePath + " $%@#$%@#%#%@#%@#@# inside search filter ...." + fileName);
        ArrayList<ObjectId> objectIdList = new ArrayList<ObjectId>();
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(filePath);
        Criteria fileNameLikeCriteria = Criteria.where((String)FILE_NAME).regex(fileName);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)PRESENT).is((Object)true), pathLikeCriteria, fileNameLikeCriteria});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(Query.query((CriteriaDefinition)criteria), ConsolidatedImage.class);
        for (ConsolidatedImage consolidatedImage : list) {
            this.logger.debug(consolidatedImage.getId() + " output list  ... " + consolidatedImage.getFileName());
            objectIdList.add(consolidatedImage.getId());
        }
        this.logger.debug("END OF  $%@#$%@#%#%@#%@#@# inside search filter ...." + objectIdList.size());
        return objectIdList;
    }

    @Override
    public List<ConsolidatedImage> getAllSharedFilesByDevicePath(int cloudId, String userName, String cloudName, String folderPath, boolean sharedByMe) {
        Criteria criteria = new Criteria();
        Criteria pathLikeCriteria = Criteria.where((String)DEVICE_PATH).regex(folderPath);
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)"sharedTimeStamp").exists(true), Criteria.where((String)PRESENT).is((Object)true), pathLikeCriteria});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllSharedFilesInBaseFolder(int cloudId, String userName, String cloudName, String folderPath) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)FOLDER).is((Object)false), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ObjectId> getChildrenIdByFolder(int cloudId, String userName, String cloudName, String folderPath, int skip) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME, DEVICE_PATH, FILE_NAME}));
        query.limit(5000);
        if (skip != 0) {
            query.skip((long)(skip * 5000));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, ConsolidatedImage.class);
        ArrayList<ObjectId> consolidatedList = new ArrayList<ObjectId>();
        ArrayList<ObjectId> deleteconsolidatedList = new ArrayList<ObjectId>();
        HashedMap consMap = new HashedMap();
        this.logger.debug(userName + "...." + folderPath + ".....getChildrenIdByFolder..." + list.size());
        for (ConsolidatedImage consolidatedImage : list) {
            String uniqueUserPath = consolidatedImage.getUserName() + consolidatedImage.getDevicePath() + consolidatedImage.getFileName();
            if (consMap.containsValue(uniqueUserPath)) {
                deleteconsolidatedList.add(consolidatedImage.getId());
                continue;
            }
            consMap.put(consolidatedImage.getId(), uniqueUserPath);
            consolidatedList.add(consolidatedImage.getId());
        }
        if (!CollectionUtils.isEmpty(deleteconsolidatedList)) {
            for (ObjectId cc : deleteconsolidatedList) {
                this.logger.debug("....delete id..... " + cc);
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)CONSOLIDATED_IMAGE_ID).in(new Object[]{cc})});
                query = new Query((CriteriaDefinition)criteria);
                mongoTemplate.findAndRemove(query, FileRevision.class);
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(new Object[]{cc})});
                query = new Query((CriteriaDefinition)criteria);
                mongoTemplate.findAndRemove(query, ConsolidatedImage.class);
            }
        }
        return consolidatedList;
    }

    @Override
    public List<ConsolidatedImage> getDeletedChildrenByFolder(int cloudId, String userName, String cloudName, String folderPath) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).regex(folderPath), Criteria.where((String)PRESENT).is((Object)false)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).regex(folderPath), Criteria.where((String)PRESENT).is((Object)false)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public Boolean isDestinationPathExists(int cloudId, String userName, String cloudName, String path) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)DEVICE_PATH).is((Object)path)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)DEVICE_PATH).is((Object)path)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ConsolidatedImage consolidatedImage = (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
        if (consolidatedImage != null) {
            return true;
        }
        return false;
    }

    @Override
    public ConsolidatedImage getConsolidatedImageDBRecordByDevicePathISPresent(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllMySharedFiles(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"sharedBy").exists(true), Criteria.where((String)"sharedBy").is((Object)userName), Criteria.where((String)PRESENT).is((Object)true)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public List<ObjectId> getChildrenIdByFolder(int cloudId, String userName, String cloudName, String folderPath, List<String> miniCloudNames, int skip) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)FILE_NAME).in(miniCloudNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(5000);
        if (skip != 0) {
            this.logger.debug(" check skip is working");
            query.skip((long)(skip * 5000));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, ConsolidatedImage.class);
        ArrayList<ObjectId> consolidatedList = new ArrayList<ObjectId>();
        for (ConsolidatedImage consolidatedImage : list) {
            consolidatedList.add(consolidatedImage.getId());
        }
        return consolidatedList;
    }

    @Override
    public List<ObjectId> getChildrenIdByFolderForMC(int cloudId, String cloudName, String folderPath, List<String> miniCloudNames, int skip) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)folderPath), Criteria.where((String)PRESENT).is((Object)true), Criteria.where((String)FILE_NAME).in(miniCloudNames)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(5000);
        if (skip != 0) {
            this.logger.debug(" check skip is working");
            query.skip((long)(skip * 5000));
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List list = mongoTemplate.find(query, ConsolidatedImage.class);
        ArrayList<ObjectId> consolidatedList = new ArrayList<ObjectId>();
        for (ConsolidatedImage consolidatedImage : list) {
            consolidatedList.add(consolidatedImage.getId());
        }
        return consolidatedList;
    }

    @Override
    public void deleteConsolidatedImage(int cloudId, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)MINI_CLOUD).is((Object)true)});
        criteria.orOperator(new Criteria[]{Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i"), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAndRemove(query, ConsolidatedImage.class);
    }

    @Override
    public void deleteConsolidatedImage(int cloudId, ConsolidatedImage consolidatedImage) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove((Object)consolidatedImage);
    }

    @Override
    public boolean isPathMiniCloud(int cloudId, String fileName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)"ParaBlu"), Criteria.where((String)MINI_CLOUD).is((Object)true)});
        criteria.orOperator(new Criteria[]{Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i"), Criteria.where((String)FILE_NAME).is((Object)fileName)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        ConsolidatedImage consolidatedImage = (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
        return consolidatedImage != null;
    }

    @Override
    public void deleteUserSharedFileImage(int cloudId, String fileName, String devicePath) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)FILE_NAME).is((Object)fileName), Criteria.where((String)DEVICE_PATH).is((Object)devicePath)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        Query query = new Query((CriteriaDefinition)criteria);
        List fileImages = mongoTemplate.find(query, ConsolidatedImage.class);
        HashSet<ObjectId> imageObjectIds = new HashSet<ObjectId>();
        for (ConsolidatedImage fileImage : fileImages) {
            imageObjectIds.add(fileImage.getId());
        }
        this.logger.debug(" deleteUserSharedFileImages .............. " + imageObjectIds.size());
        if (!CollectionUtils.isEmpty(imageObjectIds)) {
            try {
                criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)"consolidatedImageId").in(imageObjectIds)});
                query = new Query((CriteriaDefinition)criteria);
                mongoTemplate.remove(query, UsersSharedFile.class);
            }
            catch (Exception e) {
                this.logger.trace(" Exception  :" + e);
                this.logger.error(" Exception  :" + e.getMessage());
            }
        }
    }

    @Override
    public SyncOverView getSyncOverview(int cloudId) {
        Query query = new Query();
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (SyncOverView)mongoTemplate.findOne(query, SyncOverView.class);
    }

    @Override
    public void saveSyncOverview(int cloudId, SyncOverView syncOverview) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)syncOverview);
    }

    @Override
    public List<DailySyncOverView> getDailySyncOverView(int cloudId, Long fromDate, Long endDate) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"overViewDate").gte((Object)fromDate), Criteria.where((String)"overViewDate").lte((Object)endDate)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, DailySyncOverView.class);
    }

    @Override
    public ConsolidatedImage getExistingConsolidatedImageDBRecordByDevicePathForFolder(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i"), Criteria.where((String)PRESENT).is((Object)true)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i"), Criteria.where((String)PRESENT).is((Object)true)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public List<ConsolidatedImage> getAllConsolidatedImages(int cloudId, List<ObjectId> consIdList) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(consIdList)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getAllConsolidatedImageById(int cloudId, ObjectId consId) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)consId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public ConsolidatedImage getExistingConsolidatedImageDBRecordByDevicePathForFolderLatest(int cloudId, String userName, String cloudName, String devicePath, String fileName) {
        Criteria criteria = new Criteria();
        if (StringUtils.isEmpty((String)userName)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i")});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)USER_NAME).regex("^" + userName + "$", "i"), Criteria.where((String)DEVICE_PATH).is((Object)devicePath), Criteria.where((String)FILE_NAME).regex("^" + fileName + "$", "i")});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{MODIFIED_TIME}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (ConsolidatedImage)mongoTemplate.findOne(query, ConsolidatedImage.class);
    }

    @Override
    public void updateDeletedFolder(int cloudId, ObjectId consId) {
        Criteria criteria = Criteria.where((String)"id").is((Object)consId);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set(PRESENT, (Object)true);
        MongoTemplate paracloudMongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        UpdateResult updateFirst = paracloudMongoTemplate.updateFirst(query, update, ConsolidatedImage.class);
        this.logger.debug("... updateDeletedFolder .... " + updateFirst.getModifiedCount() + "...." + updateFirst.wasAcknowledged());
    }
}

