/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.BackupFoldersDao;
import com.parablu.pcbd.domain.BackupFolders;
import java.util.List;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class BackupFoldersDaoImpl
implements BackupFoldersDao {
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public void saveBackupFolders(int cloudId, String cloudName, BackupFolders backupFolders) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)backupFolders);
    }

    @Override
    public BackupFolders getBackupFolders(int cloudId, String cloudName, String folderPath) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"folderPath").is((Object)folderPath)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (BackupFolders)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), BackupFolders.class);
    }

    @Override
    public List<BackupFolders> getAllBackupFolders(int cloudId, String cloudName) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(BackupFolders.class);
    }

    @Override
    public List<BackupFolders> getBackupFolderPaths(int cloudId, String cloudName, List<String> folderPaths) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"folderPath").in(folderPaths)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), BackupFolders.class);
    }

    @Override
    public void deleteBackupFoldersForPolicyId(int cloudId, String cloudName, List<ObjectId> idList) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"backupFolderId").in(idList)});
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(new Query((CriteriaDefinition)criteria), BackupFolders.class);
    }
}

