/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.factory.ParacloudSessionFactoryUtils;
import com.parablu.pcbd.dao.AuditHistoryDao;
import com.parablu.pcbd.domain.AuditHistory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class AuditHistoryImpl
implements AuditHistoryDao {
    private static Logger logger = LogManager.getLogger(AuditHistoryImpl.class);
    ParacloudSessionFactoryUtils paracloudSessionFactoryUtils;
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;
    private static final String MM_DD_YYY = "MM/dd/yyyy";
    private static final String TIME_STAMP = "timestamp";
    private static final String ACTION_BY_USER_NAME = "actionByUserName";
    private static final String ACTIONUSINGOBJECT = "actionUsingObject";
    private static final String ACTION = "action";

    public ParacloudSessionFactoryUtils getParacloudSessionFactoryUtils() {
        return this.paracloudSessionFactoryUtils;
    }

    public void setParacloudSessionFactoryUtils(ParacloudSessionFactoryUtils paracloudSessionFactoryUtils) {
        this.paracloudSessionFactoryUtils = paracloudSessionFactoryUtils;
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public List<AuditHistory> getAllAuditsInDesc(int cloudId, String cloudName) {
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public void saveAudit(int cloudId, String cloudName, AuditHistory audit) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)audit);
    }

    @Override
    public void deleteRecordsBasedOnTimeStamp(int cloudId, String cloudName, long timeStamp) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)TIME_STAMP).lt((Object)timeStamp));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, AuditHistory.class);
    }

    @Override
    public List<AuditHistory> getAuditsByIndex(int cloudId, String cloudName, int offset, int rows) {
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public List<AuditHistory> getAllAuditsByUser(int cloudId, String cloudName, String user, int offset, int rows) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user));
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public List<AuditHistory> getAllAuditsByDevice(int cloudId, String cloudName, String device, int offset, int rows) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ACTIONUSINGOBJECT).is((Object)device));
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public List<AuditHistory> getAllAuditsByDeviceAndUser(int cloudId, String cloudName, String device, String user, int offset, int rows) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user), Criteria.where((String)ACTIONUSINGOBJECT).is((Object)device)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public List<AuditHistory> getAuditsByDeviceAndUserForSyncFailedFiles(int cloudId, String cloudName, String device, String user, int offset, int rows) {
        Criteria criteria1 = new Criteria();
        Criteria criteria = new Criteria();
        if (StringUtils.isNotEmpty((String)device)) {
            criteria1.orOperator(new Criteria[]{Criteria.where((String)ACTIONUSINGOBJECT).is((Object)device), Criteria.where((String)ACTIONUSINGOBJECT).is((Object)"PORTAL")});
        }
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user), Criteria.where((String)ACTION).is((Object)"Failed to upload"), criteria1});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public Long getLatestTimeStampEntry(int cloudId, String cloudName) {
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        query.limit(1);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        List ahList = mongoTemplate.find(query, AuditHistory.class);
        if (!CollectionUtils.isEmpty((Collection)ahList)) {
            AuditHistory auditHistory = (AuditHistory)ahList.get(0);
            return auditHistory.getTimestamp();
        }
        return null;
    }

    @Override
    public void deleteRecordsForUser(int cloudId, String cloudName, String userName) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_BY_USER_NAME).is((Object)userName)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.remove(query, AuditHistory.class);
    }

    @Override
    public List<AuditHistory> getAllAuditsForUsersAndDuration(int cloudId, String user, long startDate, long endDate, int skipValue) {
        ArrayList<AuditHistory> audits = new ArrayList<AuditHistory>();
        ArrayList<Criteria> list = new ArrayList<Criteria>();
        list.add(Criteria.where((String)ACTION_BY_USER_NAME).regex("^" + user + "$", "i"));
        list.add(Criteria.where((String)TIME_STAMP).gte((Object)startDate));
        list.add(Criteria.where((String)TIME_STAMP).lte((Object)endDate));
        Criteria criteria = new Criteria();
        criteria.andOperator(list.toArray(new Criteria[list.size()]));
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        logger.debug("skip value>>>>>>>>>>" + skipValue);
        if (skipValue != 0) {
            query.skip((long)(skipValue * 1000));
            query.limit(1000);
        } else {
            query.limit(1000);
        }
        List queryList = mongoTemplate.find(query, AuditHistory.class);
        audits.addAll(queryList);
        return audits;
    }

    @Override
    public long getAllAuditsCountByDeviceAndUser(int cloudId, String cloudName, String device, String user) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user), Criteria.where((String)ACTIONUSINGOBJECT).is((Object)device)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    @Override
    public long getAuditHistoryTotalCountForSyncFailedFiles(int cloudId, String cloudName, String device, String user) {
        Criteria criteria = new Criteria();
        Criteria criteria1 = new Criteria();
        if (StringUtils.isNotEmpty((String)device)) {
            criteria1.orOperator(new Criteria[]{Criteria.where((String)ACTIONUSINGOBJECT).is((Object)device), Criteria.where((String)ACTIONUSINGOBJECT).is((Object)"PORTAL")});
        }
        criteria.andOperator(new Criteria[]{Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user), Criteria.where((String)ACTION).is((Object)"Failed to upload"), criteria1});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    @Override
    public long getAllAuditsCountByUser(int cloudId, String cloudName, String user) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ACTION_BY_USER_NAME).is((Object)user));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    @Override
    public long getAllAuditsCountByDevice(int cloudId, String cloudName, String device) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)ACTIONUSINGOBJECT).is((Object)device));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    @Override
    public long getAuditsCountByIndex(int cloudId, String cloudName) {
        Query query = new Query();
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    @Override
    public void saveAuditHistory(int cloudId, AuditHistory audit) {
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)audit);
    }

    @Override
    public List<AuditHistory> getAllAuditsByMC(int cloudId, List<String> mcList, String startDate, String toDate, int offset, int rows) {
        Criteria criteria = new Criteria();
        long startDateMills = AuditHistoryImpl.getStartDateNew(startDate);
        long endDateMills = AuditHistoryImpl.getEndOfDayNew(toDate);
        if (!CollectionUtils.isEmpty(mcList)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"mcName").in(mcList), Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public List<AuditHistory> getAuditsByMCIndex(int cloudId, String startDate, String toDate, int offset, int rows) {
        long startDateMills = AuditHistoryImpl.getStartDateNew(startDate);
        long endDateMills = AuditHistoryImpl.getEndOfDayNew(toDate);
        Criteria criteria = new Criteria();
        logger.debug(offset + "..." + rows + "...start and end..." + startDateMills + ".." + endDateMills);
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        if (offset > 0) {
            query.skip((long)offset);
        }
        if (rows > 0) {
            query.limit(rows);
        }
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }

    @Override
    public long getAllAuditsCountByMC(int cloudId, List<String> mcList, String startDate, String toDate) {
        Criteria criteria = new Criteria();
        long startDateMills = AuditHistoryImpl.getStartDateNew(startDate);
        long endDateMills = AuditHistoryImpl.getEndOfDayNew(toDate);
        if (!CollectionUtils.isEmpty(mcList)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"mcName").in(mcList), Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    @Override
    public long getAuditsCountByMCIndex(int cloudId, String startDate, String toDate) {
        long startDateMills = AuditHistoryImpl.getStartDateNew(startDate);
        long endDateMills = AuditHistoryImpl.getEndOfDayNew(toDate);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.count(query, AuditHistory.class);
    }

    public static Date atEndOfDay(Date date) {
        return DateUtils.addMilliseconds((Date)DateUtils.ceiling((Date)date, (int)5), (int)-1);
    }

    public static Date atStartOfDay(Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    public static long getEndOfDayNew(String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYY);
        Date date = null;
        try {
            date = sdf.parse(endDate);
        }
        catch (ParseException e) {
            logger.debug("........." + e.getMessage());
        }
        Date atEndOfDay = AuditHistoryImpl.atEndOfDay(date);
        logger.debug(atEndOfDay + "...enddate..." + atEndOfDay.getTime());
        return atEndOfDay.getTime();
    }

    public static long getStartDateNew(String startDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(MM_DD_YYY);
        Date date = null;
        try {
            date = sdf.parse(startDate);
        }
        catch (ParseException e) {
            logger.debug("........." + e.getMessage());
        }
        Date atStartOfDay = AuditHistoryImpl.atStartOfDay(date);
        logger.debug(atStartOfDay + ".....startdate..." + atStartOfDay.getTime());
        return atStartOfDay.getTime();
    }

    @Override
    public List<AuditHistory> getAllMCAuditHistory(int cloudId, List<String> mcList, String fromDate, String toDate) {
        Criteria criteria = new Criteria();
        long startDateMills = AuditHistoryImpl.getStartDateNew(fromDate);
        long endDateMills = AuditHistoryImpl.getEndOfDayNew(toDate);
        if (!CollectionUtils.isEmpty(mcList)) {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"mcName").in(mcList), Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        } else {
            criteria.andOperator(new Criteria[]{Criteria.where((String)"isMiniCloud").is((Object)true), Criteria.where((String)TIME_STAMP).gte((Object)startDateMills), Criteria.where((String)TIME_STAMP).lte((Object)endDateMills)});
        }
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(new Sort(Sort.Direction.DESC, new String[]{TIME_STAMP}));
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.find(query, AuditHistory.class);
    }
}

