/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pcbd.dao.impl;

import com.parablu.factory.ParacloudMongoFactoryUtils;
import com.parablu.pcbd.dao.AADDao;
import com.parablu.pcbd.domain.AADAuthorizationToken;
import com.parablu.pcbd.domain.AADCredentials;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class AADDaoImpl
implements AADDao {
    private static Logger logger = LogManager.getLogger(AADDaoImpl.class);
    ParacloudMongoFactoryUtils paracloudMongoFactoryUtils;

    @Override
    public AADCredentials getAADCredentials(int cloudId) {
        logger.debug("......................getAADCredentials.................");
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        AADCredentials aadCredentials = (AADCredentials)mongoTemplate.findOne(query, AADCredentials.class);
        if (aadCredentials != null) {
            HashMap<String, String> groupConfig = new HashMap<String, String>();
            Map<String, String> groupConfig2 = aadCredentials.getGroupConfig();
            for (Map.Entry<String, String> entry : groupConfig2.entrySet()) {
                groupConfig.put(entry.getKey().replace("#", "."), entry.getValue());
            }
            aadCredentials.setGroupConfig(groupConfig);
        }
        return aadCredentials;
    }

    @Override
    public void removeAADCredentials(int cloudId) {
        logger.debug("......................removeAADCredentials.................");
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, AADCredentials.class);
    }

    @Override
    public void saveAADCredentials(int cloudId, AADCredentials aadCredentials) {
        logger.debug("......................saveAADCredentials.................");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)aadCredentials);
    }

    @Override
    public void saveAADAuthorizationtoken(int cloudId, AADAuthorizationToken aadAuthorizationToken) {
        logger.debug("......................saveAADAuthorizationtoken................." + aadAuthorizationToken.toString());
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.save((Object)aadAuthorizationToken);
    }

    @Override
    public AADAuthorizationToken getAADAuthorizationtoken(int cloudId) {
        logger.debug("......................getAADAuthorizationtoken.................");
        Criteria criteria = new Criteria();
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return (AADAuthorizationToken)mongoTemplate.findOne(query, AADAuthorizationToken.class);
    }

    @Override
    public void updateRefreshToken(int cloudId, String refreshToken, String accessToken) {
        logger.debug("......................updateRefreshToken.................");
        Query query = new Query();
        Update update = new Update();
        update.set("access_token", (Object)accessToken);
        update.set("refresh_token", (Object)refreshToken);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, AADAuthorizationToken.class);
    }

    @Override
    public void updateGroupDeltaNextLink(int cloudId, String groupDeltaNextLink) {
        logger.debug("......................updateGroupDeletLink.................");
        Query query = new Query();
        Update update = new Update();
        update.set("groupDeltaNextLink", (Object)groupDeltaNextLink);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.updateFirst(query, update, AADCredentials.class);
    }

    public ParacloudMongoFactoryUtils getParacloudMongoFactoryUtils() {
        return this.paracloudMongoFactoryUtils;
    }

    public void setParacloudMongoFactoryUtils(ParacloudMongoFactoryUtils paracloudMongoFactoryUtils) {
        this.paracloudMongoFactoryUtils = paracloudMongoFactoryUtils;
    }

    @Override
    public List<AADCredentials> getAllAADCredentials(int cloudId) {
        logger.debug("......................getAllAADCredentials.................");
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        return mongoTemplate.findAll(AADCredentials.class);
    }

    @Override
    public void removeAADCredentials(int cloudId, ObjectId id) {
        logger.debug("......................removeAADCredentials................." + id);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, AADCredentials.class);
    }

    @Override
    public AADCredentials getAADCredentials(int cloudId, String aadCredId) {
        logger.debug("......................getAADCredentials................." + aadCredId);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)aadCredId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        AADCredentials aadCredentials = (AADCredentials)mongoTemplate.findOne(query, AADCredentials.class);
        if (aadCredentials != null) {
            HashMap<String, String> groupConfig = new HashMap<String, String>();
            Map<String, String> groupConfig2 = aadCredentials.getGroupConfig();
            for (Map.Entry<String, String> entry : groupConfig2.entrySet()) {
                groupConfig.put(entry.getKey().replace("#", "."), entry.getValue());
            }
            aadCredentials.setGroupConfig(groupConfig);
        }
        return aadCredentials;
    }

    @Override
    public void deleteAADCredentials(int cloudId, String aadCredId) {
        logger.debug("......................deleteAADCredentials.................");
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)aadCredId)});
        Query query = new Query((CriteriaDefinition)criteria);
        MongoTemplate mongoTemplate = this.paracloudMongoFactoryUtils.getParacloudMongoTemplate(cloudId);
        mongoTemplate.findAllAndRemove(query, AADCredentials.class);
        logger.debug("...........end of deleteAADCredentials.................");
    }
}

