/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.sp;

import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.EventHubManagementService;
import com.parablu.bp.service.UserBackupPolicyMappingService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCHelperConstant;
import com.parablu.paracloud.element.BluSyncGroupSyncPolicyElement;
import com.parablu.paracloud.element.SyncPolicyElement;
import com.parablu.paracloud.element.bp.EditUserBackupPolicyMappingElement;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.EventHub;
import com.parablu.pcbd.domain.User;
import com.parablu.sp.service.SyncPolicyService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class UserSyncPolicyMappingController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(UserSyncPolicyMappingController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private UserBackupPolicyMappingService userBackupPolicyMappingService;
    @Autowired
    private EventHubManagementService eventHubManagementService;
    @Autowired
    private AuthorizationService authorizationService1;
    @Autowired
    private SyncPolicyService syncPolicyService;
    private static final String ERROR_FAILED_TO_LOAD_ALL_USER_SYNC_POLICY_MAPPING = "Error failed to load AllUserSyncPolicyMapping ...";

    @RequestMapping(value={"cloud/{cloudName}/user/edit/syncPolicy/"}, method={RequestMethod.POST})
    public void editSyncPolicyForUser(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling editSyncPolicyForUser ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String userName = request.getHeader("userName");
            String newPolicyName = request.getHeader("newPolicyName");
            String loginUserName = request.getHeader("loginUserName");
            this.userBackupPolicyMappingService.saveUserPolicyMapping(cloudId, cloudName, userName, newPolicyName, loginUserName, "syncPolicy", PCActionTypes.CHANGE_SYNC_POLICY.getActionTypeValue());
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to edit SyncPolicyForUser ..." + (Object)((Object)e));
            logger.error("Error failed to edit SyncPolicyForUser ..." + e.getMessage());
        }
        logger.debug("end of calling editSyncPolicyForUser ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/load/all/userSyncPolicy/"}, method={RequestMethod.GET})
    @ResponseBody
    public Object loadAllUserSyncPolicyMapping(@PathVariable(value="cloudName") String cloudName1, @RequestParam(value="pageNumber", required=false) Integer pageNumberInteger, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load AllUserSyncPolicyMapping ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            int pageNumber = 0;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            int skipValue = 0;
            String token = request.getHeader("token");
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            User user = authorizationTokens.getUser();
            if (pageNumberInteger != null) {
                pageNumber = pageNumberInteger;
                skipValue = pageNumber - 1;
            }
            boolean validAdmin = false;
            if (user != null && user.isReadOnlyAdmin() || user.isAdmin()) {
                validAdmin = true;
            }
            if (!validAdmin) {
                logger.debug("....not admin or readonly admin...." + user.getUserName());
                response.setStatus(500);
                return this.toJSON(400);
            }
            int recordsCount = PCHelperConstant.getReportDisplayRecords();
            EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = this.userBackupPolicyMappingService.getPolicyElements(cloudId, skipValue, recordsCount, "syncPolicy", user);
            modelAndView.addObject((Object)editUserBackupPolicyMappingElement);
            response.setStatus(200);
            Map paramSet = request.getParameterMap();
            ArrayList<String> policyNames = new ArrayList<String>();
            if (user != null && user.isReadOnlyAdmin()) {
                logger.debug("...user is read only admin.....");
                if (!CollectionUtils.isEmpty((Collection)user.getSyncPoliciesAdmin())) {
                    policyNames.addAll(user.getSyncPoliciesAdmin());
                }
            }
            long totalRecordsCount = 0L;
            totalRecordsCount = user.isReadOnlyAdmin() ? this.userBackupPolicyMappingService.loadAllSyncPoliciesMappingCount(cloudId, policyNames) : this.userBackupPolicyMappingService.getTotalMapping(cl.getCloud(), "syncPolicy");
            logger.debug(recordsCount + "end of loading AllUserSyncPolicyMapping ..." + totalRecordsCount);
            return this.toJSON(200, this.getMetadataElement(recordsCount, pageNumber, totalRecordsCount, request.getRequestURI(), paramSet), editUserBackupPolicyMappingElement);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_ALL_USER_SYNC_POLICY_MAPPING + e);
            logger.error(ERROR_FAILED_TO_LOAD_ALL_USER_SYNC_POLICY_MAPPING + e.getMessage());
            return this.toJSON(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/load/userSyncPolicy/users/"}, method={RequestMethod.GET})
    @ResponseBody
    public Object loadAllUsersBackupPolicyMapping(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load /userSyncPolicy/users ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            String userNames = request.getHeader("userNames");
            logger.debug(" user names .....................  " + userNames);
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(userNames.split(",")));
            HashSet<String> removeSet = new HashSet<String>();
            removeSet.addAll(list);
            list.clear();
            list.addAll(removeSet);
            String token = request.getHeader("token");
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            User user = authorizationTokens.getUser();
            EditUserBackupPolicyMappingElement editUserBackupPolicyMappingElement = this.userBackupPolicyMappingService.getBackupPolicyElements(cloudId, list, "syncPolicy", user);
            return this.toJSON(200, editUserBackupPolicyMappingElement);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to load AllUserBackupPolicyMapping ..." + (Object)((Object)e));
            logger.error("Error failed to load AllUserBackupPolicyMapping ..." + e.getMessage());
            return this.toJSON(500);
        }
    }

    @RequestMapping(value={"cloud/{cloudName}/update/userSyncPolicy/users/"}, method={RequestMethod.GET})
    public void bulkUserPolicyUpdate(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling update /update/userSyncPolicy/users/ ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            String loginUserName = request.getHeader("loginUserName");
            String userNames = request.getHeader("userNames");
            String policyName = request.getHeader("policyName");
            logger.debug(" user names .....................  " + userNames);
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(userNames.split(",")));
            HashSet<String> removeSet = new HashSet<String>();
            removeSet.addAll(list);
            list.clear();
            list.addAll(removeSet);
            String unAssignedUsers = this.userBackupPolicyMappingService.updateUserPolicys(cloudId, list, policyName, loginUserName, "syncPolicy", PCActionTypes.SYNC_POLICY_UPDATE.getActionTypeValue());
            response.setHeader("unAssignedUsers", unAssignedUsers);
            if (StringUtils.isEmpty((String)unAssignedUsers)) {
                response.setStatus(200);
            } else {
                response.setStatus(409);
            }
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_ALL_USER_SYNC_POLICY_MAPPING + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_ALL_USER_SYNC_POLICY_MAPPING + e.getMessage());
        }
        logger.debug("end of  /update/userSyncPolicy/users/ ......");
    }

    @RequestMapping(value={"cloud/{cloudName}/groupSyncPolicy"}, method={RequestMethod.GET})
    public ModelAndView getGroupPolicyDetails(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load groupSyncPolicyElement ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("xmlview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            cloudName = cl.getCloud().getCloudName();
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                logger.error("License failed in load groupSyncPolicyElement  ...");
                return null;
            }
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            if (StringUtils.isEmpty((String)token)) {
                response.setStatus(400);
                logger.error("Token is empty load groupSyncPolicyElement  ...");
                return null;
            }
            String deviceUUID = request.getHeader("deviceUUID");
            String userName = request.getHeader("userName");
            AuthorizationTokens authorizationTokens = this.authorizationService1.getTokenDetailsForToken(cloudId, cloudName, token);
            if (authorizationTokens == null) {
                response.setStatus(400);
                logger.error(deviceUUID + "authorizationTokens null failed in load groupPolicyElement  ..." + userName);
                logger.error("TOKEN from Client ............. " + token);
                return null;
            }
            BluSyncGroupSyncPolicyElement groupSyncPolicyElement = this.syncPolicyService.getBluSyncGroupSyncPolicyElement(cloudId, cloudName, userName, deviceUUID);
            SyncPolicyElement syncPolicy = this.syncPolicyService.getSyncPolicy(cloudId, cloudName, groupSyncPolicyElement.getPolicygroupName());
            if (groupSyncPolicyElement != null) {
                long cpuUtil = groupSyncPolicyElement.getCpuUtilization();
                groupSyncPolicyElement.setCpuUtilization(groupSyncPolicyElement.getMemoryUtilization());
                groupSyncPolicyElement.setMemoryUtilization(Long.valueOf(cpuUtil));
                groupSyncPolicyElement.setSearchAlgoForPg(syncPolicy.getSearchAlgoForPg());
            }
            String fileChunkableSize = String.valueOf(PCHelperConstant.getFileChunkableSize());
            if (syncPolicy.getFileChunkableSize() != 0) {
                fileChunkableSize = String.valueOf(syncPolicy.getFileChunkableSize());
            }
            modelAndView.addObject((Object)groupSyncPolicyElement);
            response.setHeader("fileChunkableSize", fileChunkableSize);
            response.setStatus(200);
            EventHub eventHub = new EventHub();
            eventHub.setActionToUserName(userName);
            eventHub.setActionToDeviceUUID(deviceUUID);
            eventHub.setAction(PCHelperConstant.EVENTHUB_ACTION.SYNCPOLICY_REFRESH.toString());
            this.eventHubManagementService.deleteAction(cloudId, cloudName, eventHub);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace("Error failed to load groupSyncPolicyElement  ..." + e);
            logger.error("Error failed to load groupSyncPolicyElement  ..." + e.getMessage());
        }
        logger.debug("end of load groupSyncPolicyElement ...");
        return modelAndView;
    }
}

