/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.cd;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.PciAuthorizationTokensService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.cloud.security.service.AuthorizationService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.mt.service.LdapService;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.constant.PCClientTypes;
import com.parablu.pcbd.domain.User;
import com.parablu.psc.service.UserAndDeviceStatisticService;
import java.math.BigInteger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PMSUserManagementController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(PMSUserManagementController.class);
    @Autowired
    private UserManagementService managementService;
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private UserAndDeviceStatisticService userAndDeviceStatisticService;
    @Autowired
    private AuthorizationService authorizationService1;
    @Autowired
    private DeviceManagementService deviceManagementService;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private PciAuthorizationTokensService pciAuthorizationTokensService;
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String POST_GET_OPTIONS_DELETE = "POST, GET, OPTIONS, DELETE";
    private static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    private static final String X_REQUESTED_WITH_FIRSTLOGIN_TOKEN = "x-requested-with, firstLogin, token";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    private static final String USER_NAME = "userName";
    private static final String PORTAL = "portal";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATION_EXCEPTION = "@@@ Inside authenticate DataIntegrityViolationException...";
    private static final String INSIDE_AUTHENTICATE_DATA_ACCESS_EXCEPTION = "@@@ Inside authenticate DataAccessException...";
    private static final String INSIDE_AUTHENTICATE_BASE_EXCEPTION = "@@@ Inside authenticate BaseException...";
    private static final String EXCEPTION = "Exception  :";

    @RequestMapping(value={"cloud/{cloudName}/pmsauthenticate"}, method={RequestMethod.GET})
    public ModelAndView authenticate(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = null;
        logger.debug("calling /authenticate ...");
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, POST_GET_OPTIONS_DELETE);
        response.setHeader(ACCESS_CONTROL_MAX_AGE, "3600");
        response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, X_REQUESTED_WITH_FIRSTLOGIN_TOKEN);
        try {
            String userName = request.getHeader(USER_NAME);
            String password = request.getHeader("password");
            String deviceName = request.getHeader("deviceName");
            String client = request.getHeader("clientType");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug("@@@ Inside authenticate invalid license ...");
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int clientType = 1;
            if (client != null) {
                logger.debug("@@@ Inside client selection ..." + client);
                clientType = PCClientTypes.getClientType((String)client);
            }
            int cloudId = cl.getCloud().getCloudId();
            logger.debug(cloudName + "   calling /authenticate1 ...  " + cloudId);
            logger.debug(userName + "   calling /authenticate2 ...  " + password);
            User u = this.managementService.authenticate(cloudId, cloudName, userName, password);
            if (client != null) {
                client = StringUtils.isEmpty((String)client) || client.equalsIgnoreCase(PORTAL) ? PORTAL : client.toLowerCase();
            }
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "logged into " + client, userName, "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            UUID uuid = UUID.randomUUID();
            String token = String.valueOf(uuid);
            this.authorizationService1.addTokenByUser(cloudId, cloudName, token, userName, clientType);
            if (u.isSyncEnabled() || u.isBackupEnabled()) {
                List devices = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, userName);
                if (devices != null && devices.isEmpty()) {
                    response.setHeader("has-connected-clients", TRUE);
                } else {
                    response.setHeader("has-connected-clients", FALSE);
                }
            }
            if (u.isFirstLogin()) {
                response.setHeader("firstLogin", TRUE);
                u.setFirstLogin(false);
                this.managementService.updateUserInfo(cloudId, cloudName, u);
            } else {
                response.setHeader("firstLogin", FALSE);
            }
            response.setHeader("token", token);
            response.setStatus(202);
        }
        catch (DataIntegrityViolationException e) {
            logger.trace(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
            logger.error(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
            response.setStatus(401);
        }
        catch (DataAccessException e) {
            logger.trace(INSIDE_AUTHENTICATE_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(INSIDE_AUTHENTICATE_DATA_ACCESS_EXCEPTION + e.getMessage());
            response.setStatus(401);
        }
        catch (BaseException e) {
            logger.trace(INSIDE_AUTHENTICATE_BASE_EXCEPTION + (Object)((Object)e));
            logger.error(INSIDE_AUTHENTICATE_BASE_EXCEPTION + e.getMessage());
            response.setStatus(e.getErrorStatus());
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/pms/adauthenticate"}, method={RequestMethod.GET})
    public ModelAndView adAuthenticate(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = null;
        logger.debug("calling /adauthenticate ...");
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, POST_GET_OPTIONS_DELETE);
        response.setHeader(ACCESS_CONTROL_MAX_AGE, "3600");
        response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, X_REQUESTED_WITH_FIRSTLOGIN_TOKEN);
        try {
            Object[] objArr;
            boolean isAuthenticated;
            String userName = request.getHeader(USER_NAME);
            String deviceName = request.getHeader("deviceName");
            String client = request.getHeader("clientType");
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.debug("@@@ Inside authenticate invalid license ...");
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int clientType = 1;
            if (client != null) {
                logger.debug("@@@ Inside client selection ..." + client);
                clientType = PCClientTypes.getClientType((String)client);
            }
            int cloudId = cl.getCloud().getCloudId();
            String ldapPwdEnc = request.getHeader("ldapPwdEnc");
            String decryptedPwd = null;
            if (!StringUtils.isEmpty((String)ldapPwdEnc)) {
                try {
                    decryptedPwd = this.decrypt(ldapPwdEnc, "26ac50996c66634c", "a9985ebcae81");
                }
                catch (Exception e) {
                    logger.debug("ERROR in decryption ... " + e);
                    logger.error("ERROR in decryption ... " + e.getMessage());
                }
            }
            if (!(isAuthenticated = ((Boolean)(objArr = this.ldapService.authenticate(userName, decryptedPwd))[0]).booleanValue())) {
                logger.debug("NOTINSIDEAUTHENTICATE LDAP ENABLED .............." + decryptedPwd);
                response.setStatus(400);
                return null;
            }
            User u = this.managementService.getUserDetails(cloudId, cloudName, userName);
            client = StringUtils.isEmpty((String)client) || client.equalsIgnoreCase(PORTAL) ? PORTAL : client.toLowerCase();
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "logged into " + client, userName, "", deviceName, System.currentTimeMillis(), PCActionTypes.LOGIN.getActionTypeValue());
            UUID uuid = UUID.randomUUID();
            String token = String.valueOf(uuid);
            this.authorizationService1.addTokenByUser(cloudId, cloudName, token, userName, clientType);
            if (u.isSyncEnabled() || u.isBackupEnabled()) {
                List devices = this.deviceManagementService.getDevicesForUser(cloudId, cloudName, userName);
                if (devices != null && devices.isEmpty()) {
                    response.setHeader("has-connected-clients", TRUE);
                } else {
                    response.setHeader("has-connected-clients", FALSE);
                }
            }
            if (u.isFirstLogin()) {
                response.setHeader("firstLogin", TRUE);
                u.setFirstLogin(false);
                this.managementService.updateUserInfo(cloudId, cloudName, u);
            } else {
                response.setHeader("firstLogin", FALSE);
            }
            response.setHeader("token", token);
            response.setStatus(202);
        }
        catch (DataIntegrityViolationException e) {
            logger.trace(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATION_EXCEPTION + (Object)((Object)e));
            logger.error(INSIDE_AUTHENTICATE_DATA_INTEGRITY_VIOLATION_EXCEPTION + e.getMessage());
            response.setStatus(401);
        }
        catch (DataAccessException e) {
            logger.trace(INSIDE_AUTHENTICATE_DATA_ACCESS_EXCEPTION + (Object)((Object)e));
            logger.error(INSIDE_AUTHENTICATE_DATA_ACCESS_EXCEPTION + e.getMessage());
            response.setStatus(401);
        }
        catch (BaseException e) {
            logger.trace(INSIDE_AUTHENTICATE_BASE_EXCEPTION + (Object)((Object)e));
            logger.error(INSIDE_AUTHENTICATE_BASE_EXCEPTION + e.getMessage());
            response.setStatus(e.getErrorStatus());
        }
        catch (Exception e) {
            logger.trace("Exception   :" + e);
            logger.error("Exception   :" + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/pms/adauthenticated"}, method={RequestMethod.GET})
    public ModelAndView adAuthenticated(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = null;
        logger.debug("calling /adauthenticate ...");
        response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
        response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, POST_GET_OPTIONS_DELETE);
        response.setHeader(ACCESS_CONTROL_MAX_AGE, "3600");
        response.setHeader(ACCESS_CONTROL_ALLOW_HEADERS, X_REQUESTED_WITH_FIRSTLOGIN_TOKEN);
        try {
            String userName = request.getHeader(USER_NAME);
            String ldapPwdEnc = request.getHeader("ldapPwdEnc");
            Object[] objArr = this.ldapService.authenticate(userName, ldapPwdEnc);
            boolean isAuthenticated = (Boolean)objArr[0];
            if (!isAuthenticated) {
                logger.debug("NOTINSIDEAUTHENTICATE LDAP ENABLED .............." + ldapPwdEnc);
                response.setStatus(400);
                return null;
            }
            logger.debug(" AUTHENTICATE LDAP ENABLED .............." + ldapPwdEnc);
            response.setStatus(202);
        }
        catch (Exception e) {
            logger.trace(EXCEPTION + e);
            logger.error(EXCEPTION + e.getMessage());
        }
        return modelAndView;
    }

    @RequestMapping(value={"/pms/ping/"}, method={RequestMethod.GET})
    public synchronized void testping(HttpServletRequest request, HttpServletResponse response) {
        logger.debug(" Inside privacy gateway ....");
        response.setStatus(200);
    }

    public static String md5(String input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] messageDigest = md.digest(input.getBytes());
        BigInteger number = new BigInteger(1, messageDigest);
        return number.toString(16);
    }

    public String decrypt(String encryptedData, String initialVectorString, String secretKey) {
        String decryptedData = null;
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(PMSUserManagementController.md5(secretKey).getBytes(), "AES");
            IvParameterSpec initialVector = new IvParameterSpec(initialVectorString.getBytes());
            Cipher cipher = Cipher.getInstance("AES/CFB8/NoPadding");
            cipher.init(2, (Key)skeySpec, initialVector);
            byte[] encryptedByteArray = new Base64().decode(encryptedData.getBytes());
            byte[] decryptedByteArray = cipher.doFinal(encryptedByteArray);
            decryptedData = new String(decryptedByteArray, "UTF8");
        }
        catch (Exception e) {
            logger.trace("Problem decrypting the data", (Throwable)e);
        }
        return decryptedData;
    }

    @RequestMapping(value={"cloud/{cloudName}/update/user/pcitoken"}, method={RequestMethod.POST})
    public void updateUserPciToken(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                logger.error("INVALID CLOUD LICENSE .... ");
                return;
            }
            int cloudId = cl.getCloud().getCloudId();
            this.pciAuthorizationTokensService.updateAllUserTokens(cloudId, cloudName);
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace("error trying to load elements  ..........." + e);
            logger.error("error trying to load elements  ..........." + e.getMessage());
        }
    }
}

