/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.pc.controller.bp;

import com.parablu.bluvault.ah.service.AuditHistoryService;
import com.parablu.bluvault.udc.controller.BaseController;
import com.parablu.bluvault.udc.service.DeviceManagementService;
import com.parablu.bluvault.udc.service.UserManagementService;
import com.parablu.bp.service.BackupPolicyService;
import com.parablu.bp.service.UserDefinedFolderService;
import com.parablu.cloud.security.service.LicenseService;
import com.parablu.cloud.security.to.CloudLicenseTo;
import com.parablu.helper.exceptions.BaseException;
import com.parablu.paracloud.constant.PCActionTypes;
import com.parablu.paracloud.element.BluSyncPortalBackupPolicyElement;
import com.parablu.paracloud.element.UserDefinedFolderElement;
import com.parablu.paracloud.element.UserElement;
import com.parablu.pcbd.domain.AuthorizationTokens;
import com.parablu.pcbd.domain.BackupPolicy;
import com.parablu.pcbd.domain.Device;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class UserDefinedFolderController
extends BaseController {
    private static Logger logger = LoggerFactory.getLogger(UserDefinedFolderController.class);
    @Autowired
    private LicenseService licenseService;
    @Autowired
    private UserDefinedFolderService userDefinedFolderService;
    @Autowired
    private BackupPolicyService backupPolicyService;
    @Autowired
    private UserManagementService userManagementService;
    @Autowired
    private AuditHistoryService auditHistoryService;
    @Autowired
    private DeviceManagementService deviceManagementService;
    private static final String DEVICE_UUID = "deviceUUID";
    private static final String USER_NAME = "userName";
    private static final String FOLDER_TYPE = "folderType";
    private static final String ERROR_FAILED_TO_LOAD_ALL_BACKUPFOLDERS = "Error failed to load all BackupFolders  ...";

    @RequestMapping(value={"cloud/{cloudName}/userBackupFolder/save"}, method={RequestMethod.POST})
    public void saveUserDefinedFolder(@PathVariable(value="cloudName") String cloudName1, @RequestBody UserDefinedFolderElement folderElement, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling saveUserDefinedFolder ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String actionBy = request.getHeader(USER_NAME);
            actionBy = this.decodeBase64UTFString(actionBy);
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            Device device = this.deviceManagementService.getDeviceByDeviceUUID(cloudId, cloudName, folderElement.getDeviceUUID());
            if (device == null) {
                return;
            }
            logger.debug(">>>>>>>>>>>>" + folderElement.getFolderType() + "----" + folderElement.getDeviceUUID() + " " + folderElement.getUserName());
            this.userDefinedFolderService.saveUserDefinedFolders(cloudId, cloudName, folderElement);
            this.auditHistoryService.saveStatisticToDatabase(cloudId, cloudName, "added device level " + folderElement.getFolderType().toLowerCase() + " " + folderElement.getFolderPath() + " to the Device " + device.getDeviceName(), actionBy, "", "Portal", System.currentTimeMillis(), PCActionTypes.ALLOW_ADMINISTRATOR_TO_VIEW_RESTORE.getActionTypeValue());
            response.setStatus(200);
        }
        catch (Exception e) {
            response.setStatus(500);
            logger.trace("Error failed to save UserDefinedFolder ..." + e);
            logger.error("Error failed to save UserDefinedFolder ..." + e.getMessage());
        }
        logger.debug("end of calling saveUserDefinedFolder ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/userBackupFolder/load/all"}, method={RequestMethod.GET})
    public ModelAndView getAllBackupFolders(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling load all userBackupFolder ...");
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                response.setStatus(400);
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String deviceUUID = request.getHeader(DEVICE_UUID);
            String userName = request.getHeader(USER_NAME);
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return null;
            }
            List<UserDefinedFolderElement> backupFolderElementElements = this.userDefinedFolderService.getAllUserDefinedFolders(cloudId, cloudName, deviceUUID, userName);
            if (backupFolderElementElements.isEmpty()) {
                backupFolderElementElements = new ArrayList<UserDefinedFolderElement>();
            }
            modelAndView.addObject(backupFolderElementElements);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace(ERROR_FAILED_TO_LOAD_ALL_BACKUPFOLDERS + (Object)((Object)e));
            logger.error(ERROR_FAILED_TO_LOAD_ALL_BACKUPFOLDERS + e.getMessage());
        }
        logger.debug("end of load all userBackupFolder ...");
        return modelAndView;
    }

    @RequestMapping(value={"cloud/{cloudName}/userBackupFolder/delete"}, method={RequestMethod.POST})
    public void saveUserDefinedFolder(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        logger.debug("calling deleteUserDefinedFolder ...");
        String cloudName = cloudName1;
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String deviceUUID = request.getHeader(DEVICE_UUID);
            String userName = request.getHeader(USER_NAME);
            String folderPath = request.getHeader("folderPath");
            String folderType = request.getHeader(FOLDER_TYPE);
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            logger.debug("folderPath ...." + folderPath + " .....deviceUUID..." + deviceUUID + ".....userName....." + userName + ".........folderType......" + folderType);
            this.userDefinedFolderService.deleteUserDefinedFolder(cloudId, cloudName, folderPath, deviceUUID, userName, folderType);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to deleteUserDefinedFolder ..." + (Object)((Object)e));
            logger.error("Error failed to deleteUserDefinedFolder ..." + e.getMessage());
        }
        logger.debug("end of calling deleteUserDefinedFolder ...");
    }

    @RequestMapping(value={"cloud/{cloudName}/bsportal/policy/info"}, method={RequestMethod.GET})
    public ModelAndView getPolicyInfo(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("jsonview");
        logger.debug("calling bsportal/policy/info ...");
        try {
            String token;
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return null;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            if (!this.performAuthorization(cloudId, cloudName, token = request.getHeader("token"), response)) {
                return null;
            }
            AuthorizationTokens authorizationTokens = this.authorizationService.getTokenDetailsForToken(cloudId, cloudName, token);
            if (!this.checkIfUserIsValid(authorizationTokens.getUser(), 0, response)) {
                return null;
            }
            String deviceUUID = request.getHeader(DEVICE_UUID);
            BluSyncPortalBackupPolicyElement bsDeviceInfoElement = this.userDefinedFolderService.getBluSyncPortalBackupPolicy(cloudId, cloudName, deviceUUID);
            try {
                String maxSizeAllowed = bsDeviceInfoElement.getMaxSizeAllowed();
                long size = Long.parseLong(maxSizeAllowed);
                String formatFileSize = UserDefinedFolderController.formatFileSize(size);
                bsDeviceInfoElement.setMaxSizeAllowed(formatFileSize);
            }
            catch (Exception e) {
                logger.trace("BaseException   :" + e);
                logger.error("BaseException   :" + e.getMessage());
                return null;
            }
            modelAndView.addObject((Object)bsDeviceInfoElement);
            response.setStatus(200);
        }
        catch (BaseException e) {
            logger.trace("BaseException   :" + (Object)((Object)e));
            logger.error("BaseException   :" + e.getMessage());
            response.setStatus(e.getErrorStatus());
            return null;
        }
        catch (Exception e) {
            logger.trace("Exception   :" + e);
            logger.error("Exception   :" + e.getMessage());
            response.setStatus(500);
            return null;
        }
        return modelAndView;
    }

    public static String formatFileSize(long size) {
        double m = size;
        double g = (double)size / 1024.0 / 1024.0;
        double t = (double)size / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat dec = new DecimalFormat("0.00");
        String hrSize = t > 1.0 ? dec.format(t).concat(" TB") : (g > 1.0 ? dec.format(g).concat(" GB") : dec.format(m).concat(" MB"));
        return hrSize;
    }

    @RequestMapping(value={"cloud/{cloudName}/userExcludedFolder/delete"}, method={RequestMethod.POST})
    public void saveUserExcludedFolder(@PathVariable(value="cloudName") String cloudName1, HttpServletRequest request, HttpServletResponse response) {
        String cloudName = cloudName1;
        logger.debug("calling deleteUserExcludedFolder ...");
        try {
            CloudLicenseTo cl = this.licenseService.validateLicense(cloudName);
            if (!this.checkLicense(cl, response)) {
                return;
            }
            cloudName = cl.getCloud().getCloudName();
            int cloudId = cl.getCloud().getCloudId();
            String token = request.getHeader("token");
            String deviceUUID = request.getHeader(DEVICE_UUID);
            String userName = request.getHeader(USER_NAME);
            String folderPath = request.getHeader("folderPath");
            String folderType = request.getHeader(FOLDER_TYPE);
            if (!this.performAuthorization(cloudId, cloudName, token, response)) {
                return;
            }
            UserElement userByUserNameOrEmail = this.userManagementService.getUserByUserNameOrEmail(cl.getCloud(), userName);
            BackupPolicy backupPolicy = this.backupPolicyService.getBackupPolicy(cloudId, userByUserNameOrEmail.getPolicyName());
            logger.debug(userByUserNameOrEmail.getPolicyName() + " POLICY NAME........... " + userName);
            logger.debug(" POLICY NAME. legalhold flag......... " + backupPolicy.isLegalHoldEnabled());
            if (backupPolicy.isLegalHoldEnabled()) {
                logger.debug("User cannot be admin He/She is under legal hold .......");
                response.setStatus(447);
                return;
            }
            this.userDefinedFolderService.deleteUserDefinedFolder(cloudId, cloudName, folderPath, deviceUUID, userName, folderType);
            response.setStatus(200);
        }
        catch (BaseException e) {
            response.setStatus(500);
            logger.trace("Error failed to deleteUserExcludedFolder ..." + (Object)((Object)e));
            logger.error("Error failed to deleteUserExcludedFolder ..." + e.getMessage());
        }
        logger.debug("end of calling deleteUserExcludedFolder ...");
    }
}

